/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.view.MultipleRegexesOptionsPanel;

public class SessionExcludeFromSpiderPanel
extends AbstractParamPanel {
    public static final String PANEL_NAME = Constant.messages.getString("session.spider.exclude.title");
    private static final long serialVersionUID = -8337361808959321380L;
    private JPanel panelSession = null;
    private MultipleRegexesOptionsPanel regexesPanel;

    public SessionExcludeFromSpiderPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(PANEL_NAME);
        this.regexesPanel = new MultipleRegexesOptionsPanel(View.getSingleton().getSessionDialog());
        this.add((Component)this.getPanelSession(), this.getPanelSession().getName());
    }

    private JPanel getPanelSession() {
        if (this.panelSession == null) {
            this.panelSession = new JPanel();
            this.panelSession.setLayout(new GridBagLayout());
            this.panelSession.setName("Ignorespider");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            JLabel jLabel = new JLabel();
            jLabel.setText(Constant.messages.getString("session.spider.label.ignore"));
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.gridheight = 1;
            gridBagConstraints1.insets = new Insets(10, 0, 5, 0);
            gridBagConstraints1.anchor = 18;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.weightx = 0.0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.ipadx = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.anchor = 18;
            JLabel noteLabel = new JLabel();
            noteLabel.setText(Constant.messages.getString("options.globalexcludeurl.seeglobalconfig"));
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.gridheight = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.ipadx = 0;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints3.anchor = 15;
            this.panelSession.add((Component)jLabel, gridBagConstraints1);
            this.panelSession.add((Component)this.regexesPanel, gridBagConstraints2);
            this.panelSession.add((Component)noteLabel, gridBagConstraints3);
        }
        return this.panelSession;
    }

    @Override
    public void initParam(Object obj) {
        Session session = (Session)obj;
        this.regexesPanel.setRegexes(session.getExcludeFromSpiderRegexs());
        this.regexesPanel.setRemoveWithoutConfirmation(!Model.getSingleton().getOptionsParam().getViewParam().isConfirmRemoveSpiderExcludeRegex());
    }

    @Override
    public void validateParam(Object obj) {
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        Session session = (Session)obj;
        session.setExcludeFromSpiderRegexs(this.regexesPanel.getRegexes());
        Model.getSingleton().getOptionsParam().getViewParam().setConfirmRemoveSpiderExcludeRegex(!this.regexesPanel.isRemoveWithoutConfirmation());
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.sessprop";
    }
}

