/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

public class HirshbergMatcher {
    public static final double MIN_RATIO = 0.0;
    public static final double MAX_RATIO = 1.0;

    private static int[] algB(int m, int n, String a, String b) {
        int[][] k = new int[2][n + 1];
        for (int j = 0; j <= n; ++j) {
            k[1][j] = 0;
        }
        for (int i = 1; i <= m; ++i) {
            int j;
            for (j = 0; j <= n; ++j) {
                k[0][j] = k[1][j];
            }
            for (j = 1; j <= n; ++j) {
                k[1][j] = a.charAt(i - 1) == b.charAt(j - 1) ? k[0][j - 1] + 1 : HirshbergMatcher.max(k[1][j - 1], k[0][j]);
            }
        }
        return k[1];
    }

    private static int max(int x, int y) {
        return x > y ? x : y;
    }

    private static void algC(StringBuilder sb, int m, int n, String a, String b) {
        if (n != 0) {
            if (m == 1) {
                for (int j = 0; j < n; ++j) {
                    if (a.charAt(0) != b.charAt(j)) continue;
                    sb.append(a.charAt(0));
                    break;
                }
            } else {
                int i = (int)Math.floor((double)m / 2.0);
                int[] l1 = HirshbergMatcher.algB(i, n, a.substring(0, i), b);
                int[] l2 = HirshbergMatcher.algB(m - i, n, HirshbergMatcher.reverseString(a.substring(i)), HirshbergMatcher.reverseString(b));
                int k = HirshbergMatcher.findK(l1, l2, n);
                HirshbergMatcher.algC(sb, i, k, a.substring(0, i), b.substring(0, k));
                HirshbergMatcher.algC(sb, m - i, n - k, a.substring(i), b.substring(k));
            }
        }
    }

    private static String reverseString(String in) {
        StringBuilder out = new StringBuilder(in).reverse();
        return out.toString();
    }

    private static int findK(int[] l1, int[] l2, int n) {
        int m = 0;
        int k = 0;
        for (int j = 0; j <= n; ++j) {
            if (m >= l1[j] + l2[n - j]) continue;
            m = l1[j] + l2[n - j];
            k = j;
        }
        return k;
    }

    public String getLCS(String strA, String strB) {
        if ("".equals(strA)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        HirshbergMatcher.algC(sb, strA.length(), strB.length(), strA, strB);
        return sb.toString();
    }

    public double getMatchRatio(String strA, String strB) {
        if (strA == null && strB == null) {
            return 1.0;
        }
        if (strA == null || strB == null) {
            return 0.0;
        }
        if (strA.isEmpty() && strB.isEmpty()) {
            return 1.0;
        }
        if (strA.isEmpty() || strB.isEmpty()) {
            return 0.0;
        }
        return (double)this.getLCS(strA, strB).length() / (double)HirshbergMatcher.max(strA.length(), strB.length());
    }
}

