/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.io.ByteArrayInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.htmlparser.jericho.Source;
import org.parosproxy.paros.network.HttpMessage;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.parser.SpiderParser;
import org.zaproxy.zap.utils.XmlUtils;

public class SpiderSitemapXMLParser
extends SpiderParser {
    private Pattern SITEMAP_XML_FILENAME_PATTERN = Pattern.compile("/sitemap\\.xml$");
    private static final Pattern xmlPattern = Pattern.compile("^<\\?xml\\s+version\\s*=\\s*\"[0-9.]+\"\\s+encoding\\s*=\\s*\"[^\"]+\"\\s*\\?>");
    private SpiderParam params;
    private static DocumentBuilder dBuilder;
    private static XPathExpression xpathLocationExpression;

    public SpiderSitemapXMLParser(SpiderParam params) {
        this.params = params;
    }

    @Override
    public boolean parseResource(HttpMessage message, Source source, int depth) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Parsing a sitemap.xml resource...");
        }
        if (message == null || !this.params.isParseSitemapXml()) {
            return false;
        }
        byte[] response = message.getResponseBody().getBytes();
        String baseURL = message.getRequestHeader().getURI().toString();
        Matcher xmlFormatMatcher = xmlPattern.matcher(new String(response));
        if (xmlFormatMatcher.find()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The format matches XML");
            }
            try {
                Document xmldoc = dBuilder.parse(new InputSource(new ByteArrayInputStream(response)));
                NodeList locationNodes = (NodeList)xpathLocationExpression.evaluate(xmldoc, XPathConstants.NODESET);
                for (int i = 0; i < locationNodes.getLength(); ++i) {
                    String location = locationNodes.item(i).getNodeValue();
                    if (location == null) continue;
                    this.processURL(message, depth, location, baseURL);
                }
            }
            catch (Exception e) {
                log.error((Object)"An error occurred trying to parse sitemap.xml", (Throwable)e);
                return false;
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("The content of the response from '" + baseURL + "' does not match the expected content for a sitemap.xml file. Ignoring it."));
        }
        return false;
    }

    @Override
    public boolean canParseResource(HttpMessage message, String path, boolean wasAlreadyParsed) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("canParseResource called on '" + path + "'"));
        }
        Matcher matcher = this.SITEMAP_XML_FILENAME_PATTERN.matcher(path);
        return matcher.find();
    }

    static {
        try {
            dBuilder = XmlUtils.newXxeDisabledDocumentBuilderFactory().newDocumentBuilder();
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpathLocationExpression = xpath.compile("/urlset/url/loc/text()");
        }
        catch (ParserConfigurationException | XPathExpressionException e) {
            log.error((Object)e);
        }
    }
}

