/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.FormControl;
import net.htmlparser.jericho.FormControlType;
import net.htmlparser.jericho.FormField;
import net.htmlparser.jericho.FormFields;
import net.htmlparser.jericho.Source;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.URLCanonicalizer;
import org.zaproxy.zap.spider.parser.SpiderParser;

public class SpiderHtmlFormParser
extends SpiderParser {
    private static final String ENCODING_TYPE = "UTF-8";
    private static final String DEFAULT_NUMBER_VALUE = "1";
    private static final String DEFAULT_FILE_VALUE = "test_file.txt";
    private static final String DEFAULT_TEXT_VALUE = "ZAP";
    private static final String METHOD_POST = "POST";
    private static final String ATTR_TYPE = "type";
    private static final String DEFAULT_EMPTY_VALUE = "";
    private static final String DEFAULT_PASS_VALUE = "ZAP";
    SpiderParam param;

    public SpiderHtmlFormParser(SpiderParam param) {
        this.param = param;
    }

    @Override
    public boolean parseResource(HttpMessage message, Source source, int depth) {
        log.debug((Object)"Parsing an HTML message for forms...");
        if (!this.param.isProcessForm()) {
            return false;
        }
        if (source == null) {
            source = new Source((CharSequence)message.getResponseBody().toString());
        }
        String baseURL = message == null ? DEFAULT_EMPTY_VALUE : message.getRequestHeader().getURI().toString();
        Element base = source.getFirstElement("base");
        if (base != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Base tag was found in HTML: " + base.getDebugInfo()));
            }
            if (base.getAttributeValue("href") != null) {
                baseURL = base.getAttributeValue("href");
            }
        }
        List forms = source.getAllElements("form");
        for (Element form : forms) {
            String query;
            String method = form.getAttributeValue("method");
            String action = form.getAttributeValue("action");
            log.debug((Object)("Found new form with method: '" + method + "' and action: " + action));
            if (action == null) {
                log.debug((Object)("No form 'action' defined. Using base URL: " + baseURL));
                action = baseURL;
            }
            if (!this.param.isPostForm() && method != null && method.trim().equalsIgnoreCase(METHOD_POST)) {
                log.debug((Object)"Skipping form with POST method because of user settings.");
                continue;
            }
            List<HtmlParameter> formDataSet = this.prepareFormDataSet(form.getFormFields());
            if (method != null && method.trim().equalsIgnoreCase(METHOD_POST)) {
                query = DEFAULT_EMPTY_VALUE;
                query = this.buildEncodedUrlQuery(formDataSet);
                log.debug((Object)("Submiting form with POST method and message body with form parameters (normal encoding): " + query));
                String fullURL = URLCanonicalizer.getCanonicalURL(action, baseURL);
                if (fullURL == null) {
                    return false;
                }
                log.debug((Object)("Canonical URL constructed using '" + action + "': " + fullURL));
                this.notifyListenersPostResourceFound(message, depth + 1, fullURL, query);
                continue;
            }
            query = this.buildEncodedUrlQuery(formDataSet);
            log.debug((Object)("Submiting form with GET method and query with form parameters: " + query));
            if (action.contains("#")) {
                int fs = action.lastIndexOf("#");
                action = action.substring(0, fs);
            }
            if (action.contains("?")) {
                if (action.endsWith("?")) {
                    this.processURL(message, depth, action + query, baseURL);
                    continue;
                }
                this.processURL(message, depth, action + "&" + query, baseURL);
                continue;
            }
            this.processURL(message, depth, action + "?" + query, baseURL);
        }
        return false;
    }

    private List<HtmlParameter> prepareFormDataSet(FormFields form) {
        LinkedList<HtmlParameter> formDataSet = new LinkedList<HtmlParameter>();
        for (FormField field : form) {
            HtmlParameter p;
            if (log.isDebugEnabled()) {
                log.debug((Object)("New form field: " + field.getDebugInfo()));
            }
            List values = field.getValues();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Existing values: " + values));
            }
            if (values.isEmpty() || values.size() == 1 && ((String)values.get(0)).isEmpty()) {
                String finalValue = DEFAULT_EMPTY_VALUE;
                Collection predefValues = field.getPredefinedValues();
                if (!predefValues.isEmpty()) {
                    Iterator iterator = predefValues.iterator();
                    finalValue = (String)iterator.next();
                    if (iterator.hasNext()) {
                        finalValue = (String)iterator.next();
                    }
                } else if (field.getUserValueCount() > 0) {
                    finalValue = this.getDefaultTextValue(field);
                }
                log.debug((Object)("No existing value for field " + field.getName() + ". Generated: " + finalValue));
                p = new HtmlParameter(HtmlParameter.Type.form, field.getName(), finalValue);
                formDataSet.add(p);
                continue;
            }
            for (String v : values) {
                p = new HtmlParameter(HtmlParameter.Type.form, field.getName(), v);
                formDataSet.add(p);
            }
        }
        return formDataSet;
    }

    private String getDefaultTextValue(FormField field) {
        FormControl fc = field.getFormControl();
        if (fc.getFormControlType() == FormControlType.TEXT) {
            String type = (String)fc.getAttributesMap().get(ATTR_TYPE);
            if (type == null || type.equalsIgnoreCase("text")) {
                return "ZAP";
            }
            if (type.equalsIgnoreCase("number") || type.equalsIgnoreCase("range")) {
                String min = (String)fc.getAttributesMap().get("min");
                if (min != null) {
                    return min;
                }
                String max = (String)fc.getAttributesMap().get("min");
                if (max != null) {
                    return max;
                }
                return DEFAULT_NUMBER_VALUE;
            }
            if (type.equalsIgnoreCase("url")) {
                return "http://www.example.com";
            }
            if (type.equalsIgnoreCase("email")) {
                return "foo-bar@example.com";
            }
            if (type.equalsIgnoreCase("color")) {
                return "#ffffff";
            }
            if (type.equalsIgnoreCase("tel")) {
                return "9999999999";
            }
            if (type.equalsIgnoreCase("datetime")) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                return format.format(new Date());
            }
            if (type.equalsIgnoreCase("datetime-local")) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                return format.format(new Date());
            }
            if (type.equalsIgnoreCase("date")) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                return format.format(new Date());
            }
            if (type.equalsIgnoreCase("time")) {
                SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
                return format.format(new Date());
            }
            if (type.equalsIgnoreCase("month")) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
                return format.format(new Date());
            }
            if (type.equalsIgnoreCase("week")) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-'W'ww");
                return format.format(new Date());
            }
        } else {
            if (fc.getFormControlType() == FormControlType.PASSWORD) {
                return "ZAP";
            }
            if (fc.getFormControlType() == FormControlType.FILE) {
                return DEFAULT_FILE_VALUE;
            }
        }
        return DEFAULT_EMPTY_VALUE;
    }

    private String buildEncodedUrlQuery(List<HtmlParameter> formDataSet) {
        StringBuilder request = new StringBuilder();
        for (HtmlParameter p : formDataSet) {
            try {
                String v = URLEncoder.encode(p.getName(), ENCODING_TYPE);
                request.append(v);
                request.append("=");
                v = URLEncoder.encode(p.getValue(), ENCODING_TYPE);
                request.append(v);
            }
            catch (UnsupportedEncodingException e) {
                log.warn((Object)"Error while encoding query for form.", (Throwable)e);
            }
            request.append("&");
        }
        if (request.length() > 0) {
            request.deleteCharAt(request.length() - 1);
        }
        return request.toString();
    }

    @Override
    public boolean canParseResource(HttpMessage message, String path, boolean wasAlreadyConsumed) {
        return !wasAlreadyConsumed && message.getResponseHeader().isHtml();
    }
}

