/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider;

import java.net.CookieManager;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.zaproxy.zap.extension.spider.ExtensionSpider;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.spider.SpiderController;
import org.zaproxy.zap.spider.SpiderListener;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.SpiderTask;
import org.zaproxy.zap.spider.filters.DefaultFetchFilter;
import org.zaproxy.zap.spider.filters.DefaultParseFilter;
import org.zaproxy.zap.spider.filters.FetchFilter;
import org.zaproxy.zap.spider.filters.ParseFilter;
import org.zaproxy.zap.spider.parser.SpiderParser;
import org.zaproxy.zap.users.User;

public class Spider {
    private SpiderParam spiderParam;
    private ConnectionParam connectionParam;
    private Model model;
    private List<SpiderListener> listeners;
    private volatile boolean paused;
    private volatile boolean stopped;
    private ReentrantLock pauseLock = new ReentrantLock();
    private SpiderController controller;
    private Condition pausedCondition = this.pauseLock.newCondition();
    private ExecutorService threadPool;
    private DefaultFetchFilter defaultFetchFilter;
    private LinkedHashSet<URI> seedList;
    private ExtensionSpider extension;
    private static final Logger log = Logger.getLogger(Spider.class);
    private HttpSender httpSender;
    private int tasksDoneCount;
    private int tasksTotalCount;
    private CookieManager cookieManager;
    private Context scanContext;
    private User scanUser;
    private long timeStarted;
    private boolean initialized;
    private static final Pattern svnUrlPattern = Pattern.compile("\\.svn/");
    private static final Pattern gitUrlPattern = Pattern.compile("\\.git/");

    public Spider(ExtensionSpider extension, SpiderParam spiderParam, ConnectionParam connectionParam, Model model, Context scanContext) {
        log.info((Object)"Spider initializing...");
        this.spiderParam = spiderParam;
        this.connectionParam = connectionParam;
        this.model = model;
        this.controller = new SpiderController(this, extension.getCustomParsers());
        this.listeners = new LinkedList<SpiderListener>();
        this.seedList = new LinkedHashSet();
        this.cookieManager = new CookieManager();
        this.scanContext = scanContext;
        this.extension = extension;
        this.init();
    }

    private void init() {
        this.paused = false;
        this.stopped = true;
        this.tasksDoneCount = 0;
        this.tasksTotalCount = 0;
        this.initialized = false;
        this.defaultFetchFilter = new DefaultFetchFilter();
        this.addFetchFilter(this.defaultFetchFilter);
        for (FetchFilter fetchFilter : this.extension.getCustomFetchFilters()) {
            this.addFetchFilter(fetchFilter);
        }
        this.addParseFilter(new DefaultParseFilter());
        for (ParseFilter parseFilter : this.extension.getCustomParseFilters()) {
            this.addParseFilter(parseFilter);
        }
        this.defaultFetchFilter.setScanContext(this.scanContext);
        this.defaultFetchFilter.setDomainsAlwaysInScope(this.spiderParam.getDomainsAlwaysInScopeEnabled());
    }

    public void addSeed(HttpMessage msg) {
        URI uri = msg.getRequestHeader().getURI();
        this.addSeed(uri);
    }

    public void addSeed(URI uri) {
        String host = null;
        try {
            host = uri.getHost();
            this.defaultFetchFilter.addScopeRegex(host);
        }
        catch (URIException e) {
            log.error((Object)("There was an error while adding seed value: " + uri), (Throwable)e);
            return;
        }
        this.seedList.add(uri);
        if (this.getSpiderParam().isParseRobotsTxt()) {
            try {
                URI robotsUri = uri.getPort() == 80 || uri.getPort() == 443 ? new URI(uri.getScheme() + "://" + host + "/robots.txt", true) : new URI(uri.getScheme() + "://" + host + ":" + uri.getPort() + "/robots.txt", true);
                this.seedList.add(robotsUri);
            }
            catch (Exception e) {
                log.warn((Object)("Error while creating URI for robots.txt file for site " + uri), (Throwable)e);
            }
        }
        if (this.getSpiderParam().isParseSitemapXml()) {
            try {
                URI sitemapUri = uri.getPort() == 80 || uri.getPort() == 443 ? new URI(uri.getScheme() + "://" + host + "/sitemap.xml", true) : new URI(uri.getScheme() + "://" + host + ":" + uri.getPort() + "/sitemap.xml", true);
                this.seedList.add(sitemapUri);
            }
            catch (Exception e) {
                log.warn((Object)("Error while creating URI for sitemap.xml file for site " + uri), (Throwable)e);
            }
        }
        if (this.getSpiderParam().isParseSVNEntries()) {
            try {
                Matcher matcherSvnUrl;
                String pathminusfilename;
                String fullpath = uri.getPath();
                String name = uri.getName();
                if (fullpath == null) {
                    fullpath = "";
                }
                if (name == null) {
                    name = "";
                }
                if ((pathminusfilename = fullpath.substring(0, fullpath.lastIndexOf(name))).equals("")) {
                    pathminusfilename = "/";
                }
                if (!(matcherSvnUrl = svnUrlPattern.matcher(pathminusfilename)).find()) {
                    URI svnEntriesURI2;
                    URI svnEntriesURI1;
                    if (uri.getPort() == 80 || uri.getPort() == 443) {
                        svnEntriesURI1 = new URI(uri.getScheme() + "://" + host + pathminusfilename + ".svn/entries", true);
                        svnEntriesURI2 = new URI(uri.getScheme() + "://" + host + pathminusfilename + ".svn/wc.db", true);
                    } else {
                        svnEntriesURI1 = new URI(uri.getScheme() + "://" + host + ":" + uri.getPort() + pathminusfilename + ".svn/entries", true);
                        svnEntriesURI2 = new URI(uri.getScheme() + "://" + host + ":" + uri.getPort() + pathminusfilename + ".svn/wc.db", true);
                    }
                    this.seedList.add(svnEntriesURI1);
                    this.seedList.add(svnEntriesURI2);
                }
            }
            catch (Exception e) {
                log.warn((Object)("Error while creating a seed URI for the SVN files for site " + uri), (Throwable)e);
            }
        }
        if (this.getSpiderParam().isParseGit()) {
            try {
                Matcher matcherGitUrl;
                String pathminusfilename;
                String fullpath = uri.getPath();
                String name = uri.getName();
                if (fullpath == null) {
                    fullpath = "";
                }
                if (name == null) {
                    name = "";
                }
                if ((pathminusfilename = fullpath.substring(0, fullpath.lastIndexOf(name))).equals("")) {
                    pathminusfilename = "/";
                }
                if (!(matcherGitUrl = gitUrlPattern.matcher(pathminusfilename)).find()) {
                    URI gitEntriesURI = uri.getPort() == 80 || uri.getPort() == 443 ? new URI(uri.getScheme() + "://" + host + pathminusfilename + ".git/index", true) : new URI(uri.getScheme() + "://" + host + ":" + uri.getPort() + pathminusfilename + ".git/index", true);
                    this.seedList.add(gitEntriesURI);
                }
            }
            catch (Exception e) {
                log.warn((Object)("Error while creating a seed URI for the Git files for site " + uri), (Throwable)e);
            }
        }
    }

    public void setExcludeList(List<String> excludeList) {
        log.debug((Object)("New Exclude list: " + excludeList));
        this.defaultFetchFilter.setExcludeRegexes(excludeList);
    }

    public void addFetchFilter(FetchFilter filter) {
        this.controller.addFetchFilter(filter);
    }

    public void addParseFilter(ParseFilter filter) {
        this.controller.addParseFilter(filter);
    }

    protected HttpSender getHttpSender() {
        return this.httpSender;
    }

    protected SpiderParam getSpiderParam() {
        return this.spiderParam;
    }

    protected ConnectionParam getConnectionParam() {
        return this.connectionParam;
    }

    protected SpiderController getController() {
        return this.controller;
    }

    protected CookieManager getCookieManager() {
        return this.cookieManager;
    }

    protected Model getModel() {
        return this.model;
    }

    protected synchronized void submitTask(SpiderTask task) {
        block4: {
            if (this.isStopped()) {
                log.debug((Object)("Submitting task skipped (" + task + ") as the Spider process is stopped."));
                return;
            }
            if (this.isTerminated()) {
                log.debug((Object)("Submitting task skipped (" + task + ") as the Spider process is terminated."));
                return;
            }
            ++this.tasksTotalCount;
            try {
                this.threadPool.execute(task);
            }
            catch (RejectedExecutionException e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)("Submitted task was rejected (" + task + "), spider state: [stopped=" + this.isStopped() + ", terminated=" + this.isTerminated() + "]."));
            }
        }
    }

    public void start() {
        log.info((Object)"Starting spider...");
        this.timeStarted = System.currentTimeMillis();
        this.fetchFilterSeeds();
        if (this.seedList == null || this.seedList.isEmpty()) {
            log.warn((Object)"No seeds available for the Spider. Cancelling scan...");
            this.notifyListenersSpiderComplete(false);
            this.notifyListenersSpiderProgress(100, 0, 0);
            return;
        }
        if (this.scanUser != null) {
            log.info((Object)("Scan will be performed from the point of view of User: " + this.scanUser.getName()));
        }
        this.controller.init();
        this.stopped = false;
        this.paused = false;
        this.initialized = false;
        this.threadPool = Executors.newFixedThreadPool(this.spiderParam.getThreadCount());
        this.httpSender = new HttpSender(this.connectionParam, true, 3);
        this.httpSender.setFollowRedirect(false);
        for (URI uri : this.seedList) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding seed for spider: " + uri));
            }
            this.controller.addSeed(uri, "GET");
        }
        this.initialized = true;
    }

    private void fetchFilterSeeds() {
        if (this.seedList == null || this.seedList.isEmpty()) {
            return;
        }
        Iterator it = this.seedList.iterator();
        block0: while (it.hasNext()) {
            URI seed = (URI)it.next();
            for (FetchFilter filter : this.controller.getFetchFilters()) {
                FetchFilter.FetchStatus filterReason = filter.checkFilter(seed);
                if (filterReason == FetchFilter.FetchStatus.VALID) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Seed: " + seed + " was filtered with reason: " + (Object)((Object)filterReason)));
                }
                it.remove();
                continue block0;
            }
        }
    }

    public void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        log.info((Object)"Stopping spidering process by request.");
        if (this.paused) {
            this.resume();
        }
        this.threadPool.shutdown();
        try {
            if (!this.threadPool.awaitTermination(2L, TimeUnit.SECONDS)) {
                log.warn((Object)"Failed to await for all spider threads to stop in the given time (2s)...");
                for (Runnable task : this.threadPool.shutdownNow()) {
                    ((SpiderTask)task).cleanup();
                }
            }
        }
        catch (InterruptedException ignore) {
            log.warn((Object)"Interrupted while awaiting for all spider threads to stop...");
        }
        if (this.httpSender != null) {
            this.getHttpSender().shutdown();
            this.httpSender = null;
        }
        this.controller.reset();
        this.threadPool = null;
        this.notifyListenersSpiderComplete(false);
    }

    private void complete() {
        if (this.stopped) {
            return;
        }
        log.info((Object)"Spidering process is complete. Shutting down...");
        this.stopped = true;
        if (this.httpSender != null) {
            this.getHttpSender().shutdown();
            this.httpSender = null;
        }
        this.controller.reset();
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (Spider.this.threadPool != null) {
                    Spider.this.threadPool.shutdown();
                }
                Spider.this.notifyListenersSpiderComplete(true);
                Spider.this.controller.reset();
                Spider.this.threadPool = null;
            }
        }).start();
    }

    public void pause() {
        this.pauseLock.lock();
        try {
            this.paused = true;
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    public void resume() {
        this.pauseLock.lock();
        try {
            this.paused = false;
            this.pausedCondition.signalAll();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    public void setScanAsUser(User user) {
        this.scanUser = user;
    }

    protected User getScanUser() {
        return this.scanUser;
    }

    protected void preTaskExecution() {
        this.checkPauseAndWait();
    }

    protected void checkPauseAndWait() {
        this.pauseLock.lock();
        try {
            while (this.paused && !this.stopped) {
                this.pausedCondition.await();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    protected synchronized void postTaskExecution() {
        if (this.stopped) {
            return;
        }
        ++this.tasksDoneCount;
        int percentageComplete = this.tasksDoneCount * 100 / this.tasksTotalCount;
        this.notifyListenersSpiderProgress(percentageComplete, this.tasksDoneCount, this.tasksTotalCount - this.tasksDoneCount);
        if (this.tasksDoneCount == this.tasksTotalCount && this.initialized) {
            this.complete();
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isStopped() {
        if (!this.stopped && this.spiderParam.getMaxDuration() > 0 && TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - this.timeStarted) > (long)this.spiderParam.getMaxDuration()) {
            log.info((Object)("Spidering process has exceeded maxDuration of " + this.spiderParam.getMaxDuration() + " minute(s)"));
            this.complete();
        }
        return this.stopped;
    }

    public boolean isTerminated() {
        return this.threadPool.isTerminated();
    }

    public void addSpiderListener(SpiderListener listener) {
        this.listeners.add(listener);
    }

    public void removeSpiderListener(SpiderListener listener) {
        this.listeners.remove(listener);
    }

    protected synchronized void notifyListenersSpiderProgress(int percentageComplete, int numberCrawled, int numberToCrawl) {
        for (SpiderListener l : this.listeners) {
            l.spiderProgress(percentageComplete, numberCrawled, numberToCrawl);
        }
    }

    protected synchronized void notifyListenersFoundURI(String uri, String method, FetchFilter.FetchStatus status) {
        for (SpiderListener l : this.listeners) {
            l.foundURI(uri, method, status);
        }
    }

    protected synchronized void notifyListenersReadURI(HttpMessage msg) {
        for (SpiderListener l : this.listeners) {
            l.readURI(msg);
        }
    }

    protected synchronized void notifyListenersSpiderComplete(boolean successful) {
        for (SpiderListener l : this.listeners) {
            l.spiderComplete(successful);
        }
    }

    public void addCustomParser(SpiderParser sp) {
        this.controller.addSpiderParser(sp);
    }
}

