/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.users;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.authentication.AbstractCredentialsOptionsPanel;
import org.zaproxy.zap.authentication.AuthenticationCredentials;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.AbstractFormDialog;
import org.zaproxy.zap.view.LayoutHelper;

public class DialogAddUser
extends AbstractFormDialog {
    private static final long serialVersionUID = -7210879426146833234L;
    protected static final Logger log = Logger.getLogger(DialogAddUser.class);
    private static final String DIALOG_TITLE = Constant.messages.getString("users.dialog.add.title");
    private static final String CONFIRM_BUTTON_LABEL = Constant.messages.getString("users.dialog.add.button.confirm");
    private JPanel fieldsPanel;
    private AbstractCredentialsOptionsPanel<?> credentialsPanel;
    private ZapTextField nameTextField;
    protected AuthenticationCredentials configuredCredentials;
    private JCheckBox enabledCheckBox;
    protected Context workingContext;
    protected User user;

    public DialogAddUser(Dialog owner, ExtensionUserManagement extension) {
        super(owner, DIALOG_TITLE);
    }

    public DialogAddUser(Dialog owner, ExtensionUserManagement extension, String title) {
        super(owner, title);
    }

    public void setWorkingContext(Context context) {
        this.workingContext = context;
    }

    @Override
    protected void init() {
        if (this.workingContext == null) {
            throw new IllegalStateException("A working Context should be set before setting the 'Add Dialog' visible.");
        }
        this.getEnabledCheckBox().setSelected(true);
        this.configuredCredentials = this.workingContext.getAuthenticationMethod().createAuthenticationCredentials();
        this.initializeCredentialsConfigPanel();
    }

    protected void initializeCredentialsConfigPanel() {
        AuthenticationMethodType type = this.workingContext.getAuthenticationMethod().getType();
        if (type.hasCredentialsOptionsPanel()) {
            this.credentialsPanel = type.buildCredentialsOptionsPanel(this.configuredCredentials, this.workingContext);
            this.fieldsPanel.add(this.credentialsPanel, LayoutHelper.getGBC(0, 3, 2, 1.0, new Insets(4, 8, 2, 4)));
            this.fieldsPanel.revalidate();
            this.pack();
        }
    }

    public void clear() {
        this.user = null;
        this.workingContext = null;
        if (this.credentialsPanel != null) {
            this.getFieldsPanel().remove(this.credentialsPanel);
        }
    }

    @Override
    protected boolean validateFields() {
        return this.credentialsPanel.validateFields();
    }

    @Override
    protected void performAction() {
        this.user = this.user != null ? new User(this.workingContext.getIndex(), this.getNameTextField().getText(), this.user.getId()) : new User(this.workingContext.getIndex(), this.getNameTextField().getText());
        this.user.setEnabled(this.getEnabledCheckBox().isSelected());
        this.credentialsPanel.saveCredentials();
        this.user.setAuthenticationCredentials((AuthenticationCredentials)this.credentialsPanel.getCredentials());
    }

    @Override
    protected void clearFields() {
        this.nameTextField.setText("");
        this.enabledCheckBox.setSelected(true);
        this.setConfirmButtonEnabled(false);
    }

    public User getUser() {
        return this.user;
    }

    @Override
    protected JPanel getFieldsPanel() {
        if (this.fieldsPanel == null) {
            this.fieldsPanel = new JPanel();
            this.fieldsPanel.setLayout(new GridBagLayout());
            this.fieldsPanel.setName("DialogAddUser");
            Insets insets = new Insets(4, 8, 2, 4);
            JLabel nameLabel = new JLabel(Constant.messages.getString("users.dialog.add.field.label.name"));
            JLabel enabledLabel = new JLabel(Constant.messages.getString("users.dialog.add.field.label.enabled"));
            this.fieldsPanel.add((Component)nameLabel, LayoutHelper.getGBC(0, 0, 1, 0.5, insets));
            this.fieldsPanel.add((Component)this.getNameTextField(), LayoutHelper.getGBC(1, 0, 1, 0.5, insets));
            this.fieldsPanel.add((Component)enabledLabel, LayoutHelper.getGBC(0, 1, 1, 0.5, insets));
            this.fieldsPanel.add((Component)this.getEnabledCheckBox(), LayoutHelper.getGBC(1, 1, 1, 0.5, insets));
            this.fieldsPanel.add((Component)new JSeparator(), LayoutHelper.getGBC(0, 2, 2, 0.5, insets));
        }
        return this.fieldsPanel;
    }

    protected ZapTextField getNameTextField() {
        if (this.nameTextField == null) {
            this.nameTextField = new ZapTextField(25);
            this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    DialogAddUser.this.checkValidAndEnableConfirmButton();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    DialogAddUser.this.checkValidAndEnableConfirmButton();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    DialogAddUser.this.checkValidAndEnableConfirmButton();
                }
            });
        }
        return this.nameTextField;
    }

    protected JCheckBox getEnabledCheckBox() {
        if (this.enabledCheckBox == null) {
            this.enabledCheckBox = new JCheckBox();
        }
        return this.enabledCheckBox;
    }

    private void checkValidAndEnableConfirmButton() {
        this.setConfirmButtonEnabled(this.getNameTextField().getDocument().getLength() > 0);
    }

    @Override
    protected String getConfirmButtonLabel() {
        return CONFIRM_BUTTON_LABEL;
    }
}

