/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import java.awt.EventQueue;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.eventBus.Event;
import org.zaproxy.zap.eventBus.EventConsumer;
import org.zaproxy.zap.extension.alert.AlertEventPublisher;
import org.zaproxy.zap.view.table.DefaultHistoryReferencesTableModel;
import org.zaproxy.zap.view.table.HistoryReferencesTableModel;

class SpiderMessagesTableModel
extends DefaultHistoryReferencesTableModel {
    private static final long serialVersionUID = 1093393768186896931L;
    private final ExtensionHistory extensionHistory;
    private AlertEventConsumer alertEventConsumer;

    public SpiderMessagesTableModel() {
        this(true);
    }

    public SpiderMessagesTableModel(boolean createAlertEventConsumer) {
        super(new HistoryReferencesTableModel.Column[]{HistoryReferencesTableModel.Column.HREF_ID, HistoryReferencesTableModel.Column.REQUEST_TIMESTAMP, HistoryReferencesTableModel.Column.RESPONSE_TIMESTAMP, HistoryReferencesTableModel.Column.METHOD, HistoryReferencesTableModel.Column.URL, HistoryReferencesTableModel.Column.STATUS_CODE, HistoryReferencesTableModel.Column.STATUS_REASON, HistoryReferencesTableModel.Column.RTT, HistoryReferencesTableModel.Column.SIZE_REQUEST_HEADER, HistoryReferencesTableModel.Column.SIZE_REQUEST_BODY, HistoryReferencesTableModel.Column.SIZE_RESPONSE_HEADER, HistoryReferencesTableModel.Column.SIZE_RESPONSE_BODY, HistoryReferencesTableModel.Column.HIGHEST_ALERT, HistoryReferencesTableModel.Column.TAGS});
        if (createAlertEventConsumer) {
            this.alertEventConsumer = new AlertEventConsumer();
            this.extensionHistory = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class);
            ZAP.getEventBus().registerConsumer(this.alertEventConsumer, AlertEventPublisher.getPublisher().getPublisherName());
        } else {
            this.alertEventConsumer = null;
            this.extensionHistory = null;
        }
    }

    @Override
    public void addHistoryReference(HistoryReference historyReference) {
        HistoryReference latestHistoryReference = historyReference;
        if (this.extensionHistory != null) {
            latestHistoryReference = this.extensionHistory.getHistoryReference(historyReference.getHistoryId());
        }
        super.addHistoryReference(latestHistoryReference);
    }

    @Override
    public void clear() {
        super.clear();
        if (this.alertEventConsumer != null) {
            ZAP.getEventBus().unregisterConsumer(this.alertEventConsumer, AlertEventPublisher.getPublisher().getPublisherName());
            this.alertEventConsumer = null;
        }
    }

    private class AlertEventConsumer
    implements EventConsumer {
        private AlertEventConsumer() {
        }

        @Override
        public void eventReceived(Event event) {
            switch (event.getEventType()) {
                case "alert.added": 
                case "alert.changed": 
                case "alert.removed": {
                    this.refreshEntry(Integer.valueOf(event.getParameters().get("historyId")));
                    break;
                }
                default: {
                    this.refreshEntries();
                }
            }
        }

        private void refreshEntry(final int id) {
            if (EventQueue.isDispatchThread()) {
                SpiderMessagesTableModel.this.refreshEntryRow(id);
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AlertEventConsumer.this.refreshEntry(id);
                }
            });
        }

        private void refreshEntries() {
            if (EventQueue.isDispatchThread()) {
                SpiderMessagesTableModel.this.refreshEntryRows();
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AlertEventConsumer.this.refreshEntries();
                }
            });
        }
    }
}

