/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.spider.ExtensionSpider;
import org.zaproxy.zap.extension.spider.SpiderResource;
import org.zaproxy.zap.extension.spider.SpiderScan;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.GenericScanner2;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.spider.filters.HttpPrefixFetchFilter;
import org.zaproxy.zap.spider.filters.MaxChildrenFetchFilter;
import org.zaproxy.zap.spider.filters.MaxChildrenParseFilter;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;

public class SpiderAPI
extends ApiImplementor {
    private static final Logger log = Logger.getLogger(SpiderAPI.class);
    private static final String PREFIX = "spider";
    private static final String ACTION_START_SCAN = "scan";
    private static final String ACTION_START_SCAN_AS_USER = "scanAsUser";
    private static final String ACTION_PAUSE_SCAN = "pause";
    private static final String ACTION_RESUME_SCAN = "resume";
    private static final String ACTION_STOP_SCAN = "stop";
    private static final String ACTION_PAUSE_ALL_SCANS = "pauseAllScans";
    private static final String ACTION_RESUME_ALL_SCANS = "resumeAllScans";
    private static final String ACTION_STOP_ALL_SCANS = "stopAllScans";
    private static final String ACTION_REMOVE_SCAN = "removeScan";
    private static final String ACTION_REMOVE_ALL_SCANS = "removeAllScans";
    private static final String VIEW_STATUS = "status";
    private static final String VIEW_RESULTS = "results";
    private static final String VIEW_FULL_RESULTS = "fullResults";
    private static final String VIEW_SCANS = "scans";
    private static final String PARAM_URL = "url";
    private static final String PARAM_USER_ID = "userId";
    private static final String PARAM_CONTEXT_ID = "contextId";
    private static final String PARAM_CONTEXT_NAME = "contextName";
    private static final String PARAM_REGEX = "regex";
    private static final String PARAM_RECURSE = "recurse";
    private static final String PARAM_SCAN_ID = "scanId";
    private static final String PARAM_MAX_CHILDREN = "maxChildren";
    private static final String PARAM_SUBTREE_ONLY = "subtreeOnly";
    private static final String ACTION_EXCLUDE_FROM_SCAN = "excludeFromScan";
    private static final String ACTION_CLEAR_EXCLUDED_FROM_SCAN = "clearExcludedFromScan";
    private static final String VIEW_EXCLUDED_FROM_SCAN = "excludedFromScan";
    private ExtensionSpider extension;

    public SpiderAPI(ExtensionSpider extension) {
        this.extension = extension;
        this.addApiAction(new ApiAction(ACTION_START_SCAN, null, new String[]{PARAM_URL, PARAM_MAX_CHILDREN, PARAM_RECURSE, PARAM_CONTEXT_NAME, PARAM_SUBTREE_ONLY}));
        this.addApiAction(new ApiAction(ACTION_START_SCAN_AS_USER, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID}, new String[]{PARAM_URL, PARAM_MAX_CHILDREN, PARAM_RECURSE, PARAM_SUBTREE_ONLY}));
        this.addApiAction(new ApiAction(ACTION_PAUSE_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_RESUME_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_STOP_SCAN, null, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_REMOVE_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_PAUSE_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_RESUME_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_STOP_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_REMOVE_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_CLEAR_EXCLUDED_FROM_SCAN));
        this.addApiAction(new ApiAction(ACTION_EXCLUDE_FROM_SCAN, new String[]{PARAM_REGEX}));
        this.addApiView(new ApiView(VIEW_STATUS, null, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_RESULTS, null, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_FULL_RESULTS, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_SCANS));
        this.addApiView(new ApiView(VIEW_EXCLUDED_FROM_SCAN));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        log.debug((Object)("Request for handleApiAction: " + name + " (params: " + params.toString() + ")"));
        int maxChildren = -1;
        Context context = null;
        switch (name) {
            case "scan": {
                String contextName;
                String maxChildrenStr;
                String url = ApiUtils.getOptionalStringParam(params, PARAM_URL);
                if (params.containsKey((Object)PARAM_MAX_CHILDREN) && (maxChildrenStr = params.getString(PARAM_MAX_CHILDREN)) != null && maxChildrenStr.length() > 0) {
                    try {
                        maxChildren = Integer.parseInt(maxChildrenStr);
                    }
                    catch (NumberFormatException e) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_MAX_CHILDREN);
                    }
                }
                if (params.containsKey((Object)PARAM_CONTEXT_NAME) && !(contextName = params.getString(PARAM_CONTEXT_NAME)).isEmpty()) {
                    context = ApiUtils.getContextByName(contextName);
                }
                int scanId = this.scanURL(url, null, maxChildren, this.getParam(params, PARAM_RECURSE, true), context, this.getParam(params, PARAM_SUBTREE_ONLY, false));
                return new ApiResponseElement(name, Integer.toString(scanId));
            }
            case "scanAsUser": {
                String maxChildrenStr;
                String urlUserScan = ApiUtils.getOptionalStringParam(params, PARAM_URL);
                int userID = ApiUtils.getIntParam(params, PARAM_USER_ID);
                ExtensionUserManagement usersExtension = (ExtensionUserManagement)Control.getSingleton().getExtensionLoader().getExtension("ExtensionUserManagement");
                if (usersExtension == null) {
                    throw new ApiException(ApiException.Type.NO_IMPLEMENTOR, "ExtensionUserManagement");
                }
                context = ApiUtils.getContextByParamId(params, PARAM_CONTEXT_ID);
                User user = usersExtension.getContextUserAuthManager(context.getIndex()).getUserById(userID);
                if (user == null) {
                    throw new ApiException(ApiException.Type.USER_NOT_FOUND, PARAM_USER_ID);
                }
                if (params.containsKey((Object)PARAM_MAX_CHILDREN) && (maxChildrenStr = params.getString(PARAM_MAX_CHILDREN)) != null && maxChildrenStr.length() > 0) {
                    try {
                        maxChildren = Integer.parseInt(maxChildrenStr);
                    }
                    catch (NumberFormatException e) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_MAX_CHILDREN);
                    }
                }
                int scanId = this.scanURL(urlUserScan, user, maxChildren, this.getParam(params, PARAM_RECURSE, true), context, this.getParam(params, PARAM_SUBTREE_ONLY, false));
                return new ApiResponseElement(name, Integer.toString(scanId));
            }
            case "pause": {
                GenericScanner2 scan = this.getSpiderScan(params);
                if (scan == null) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
                }
                this.extension.pauseScan(scan.getScanId());
                break;
            }
            case "resume": {
                GenericScanner2 scan = this.getSpiderScan(params);
                if (scan == null) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
                }
                this.extension.resumeScan(scan.getScanId());
                break;
            }
            case "stop": {
                GenericScanner2 scan = this.getSpiderScan(params);
                if (scan == null) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
                }
                this.extension.stopScan(scan.getScanId());
                break;
            }
            case "removeScan": {
                GenericScanner2 scan = this.getSpiderScan(params);
                if (scan == null) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
                }
                this.extension.removeScan(scan.getScanId());
                break;
            }
            case "pauseAllScans": {
                this.extension.pauseAllScans();
                break;
            }
            case "resumeAllScans": {
                this.extension.resumeAllScans();
                break;
            }
            case "stopAllScans": {
                this.extension.stopAllScans();
                break;
            }
            case "removeAllScans": {
                this.extension.removeAllScans();
                break;
            }
            case "clearExcludedFromScan": {
                try {
                    Session session = Model.getSingleton().getSession();
                    session.setExcludeFromSpiderRegexs(new ArrayList<String>());
                    break;
                }
                catch (DatabaseException e) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                }
            }
            case "excludeFromScan": {
                String regex = params.getString(PARAM_REGEX);
                try {
                    Session session = Model.getSingleton().getSession();
                    session.addExcludeFromSpiderRegex(regex);
                    break;
                }
                catch (DatabaseException e) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                }
                catch (PatternSyntaxException e) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_REGEX);
                }
            }
            default: {
                throw new ApiException(ApiException.Type.BAD_ACTION);
            }
        }
        return ApiResponseElement.OK;
    }

    private GenericScanner2 getSpiderScan(JSONObject params) throws ApiException {
        int id = this.getParam(params, PARAM_SCAN_ID, -1);
        SpiderScan spiderScan = id == -1 ? this.extension.getLastScan() : this.extension.getScan(id);
        if (spiderScan == null) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
        }
        return spiderScan;
    }

    private int scanURL(String url, User user, int maxChildren, boolean recurse, Context context, boolean subtreeOnly) throws ApiException {
        Target target;
        log.debug((Object)("API Spider scanning url: " + url));
        boolean useUrl = true;
        if (url == null || url.isEmpty()) {
            if (context == null || !context.hasNodesInContextFromSiteTree()) {
                throw new ApiException(ApiException.Type.MISSING_PARAMETER, PARAM_URL);
            }
            useUrl = false;
        } else if (context != null && !context.isInContext(url)) {
            throw new ApiException(ApiException.Type.URL_NOT_IN_CONTEXT, PARAM_URL);
        }
        StructuralNode node = null;
        URI startURI = null;
        if (useUrl) {
            try {
                startURI = new URI(url, true);
            }
            catch (URIException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL);
            }
            String scheme = startURI.getScheme();
            if (scheme == null || !scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL);
            }
            try {
                node = SessionStructure.find(Model.getSingleton().getSession().getSessionId(), new URI(url, false), "GET", "");
            }
            catch (Exception e) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR);
            }
        }
        if (useUrl) {
            target = new Target(node);
            target.setContext(context);
        } else {
            target = new Target(context);
        }
        target.setRecurse(recurse);
        switch (Control.getSingleton().getMode()) {
            case safe: {
                throw new ApiException(ApiException.Type.MODE_VIOLATION);
            }
            case protect: {
                if ((!useUrl || Model.getSingleton().getSession().isInScope(url)) && (context == null || context.isInScope())) break;
                throw new ApiException(ApiException.Type.MODE_VIOLATION);
            }
            case standard: {
                break;
            }
        }
        ArrayList<Object> objs = new ArrayList<Object>(4);
        if (startURI != null) {
            objs.add(startURI);
            if (subtreeOnly) {
                objs.add(new HttpPrefixFetchFilter(startURI));
            }
        }
        if (maxChildren > 0) {
            MaxChildrenFetchFilter maxChildrenFetchFilter = new MaxChildrenFetchFilter();
            maxChildrenFetchFilter.setMaxChildren(maxChildren);
            maxChildrenFetchFilter.setModel(this.extension.getModel());
            MaxChildrenParseFilter maxChildrenParseFilter = new MaxChildrenParseFilter();
            maxChildrenParseFilter.setMaxChildren(maxChildren);
            maxChildrenParseFilter.setModel(this.extension.getModel());
            objs.add(maxChildrenFetchFilter);
            objs.add(maxChildrenParseFilter);
        }
        return this.extension.startScan(target, user, objs.toArray(new Object[objs.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        ApiResponse result;
        if (VIEW_STATUS.equals(name)) {
            SpiderScan scan = (SpiderScan)this.getSpiderScan(params);
            int progress = 0;
            if (scan != null) {
                progress = scan.isStopped() ? 100 : scan.getProgress();
            }
            result = new ApiResponseElement(name, Integer.toString(progress));
        } else if (VIEW_RESULTS.equals(name)) {
            result = new ApiResponseList(name);
            SpiderScan scan = (SpiderScan)this.getSpiderScan(params);
            if (scan != null) {
                Set<String> progress = scan.getResults();
                synchronized (progress) {
                    for (String s : scan.getResults()) {
                        ((ApiResponseList)result).addItem(new ApiResponseElement(PARAM_URL, s));
                    }
                }
            }
        } else if (VIEW_FULL_RESULTS.equals(name)) {
            ApiResponseList resultUrls = new ApiResponseList(name);
            SpiderScan scan = (SpiderScan)this.getSpiderScan(params);
            ApiResponseList apiResponseList = new ApiResponseList("urlsInScope");
            Collection<Object> s = scan.getResourcesFound();
            synchronized (s) {
                for (SpiderResource sr : scan.getResourcesFound()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("messageId", Integer.toString(sr.getHistoryId()));
                    map.put("method", sr.getMethod());
                    map.put(PARAM_URL, sr.getUri());
                    map.put("statusCode", Integer.toString(sr.getStatusCode()));
                    map.put("statusReason", sr.getStatusReason());
                    apiResponseList.addItem(new ApiResponseSet("resource", map));
                }
            }
            resultUrls.addItem(apiResponseList);
            ApiResponseList apiResponseList2 = new ApiResponseList("urlsOutOfScope");
            s = scan.getResultsOutOfScope();
            synchronized (s) {
                for (String url : scan.getResultsOutOfScope()) {
                    apiResponseList2.addItem(new ApiResponseElement(PARAM_URL, url));
                }
            }
            resultUrls.addItem(apiResponseList2);
            result = resultUrls;
        } else if (VIEW_EXCLUDED_FROM_SCAN.equals(name)) {
            result = new ApiResponseList(name);
            Session session = Model.getSingleton().getSession();
            List<String> regexs = session.getExcludeFromSpiderRegexs();
            for (String regex : regexs) {
                ((ApiResponseList)result).addItem(new ApiResponseElement(PARAM_REGEX, regex));
            }
        } else if (VIEW_SCANS.equals(name)) {
            ApiResponseList resultList = new ApiResponseList(name);
            for (GenericScanner2 genericScanner2 : this.extension.getAllScans()) {
                SpiderScan spiderScan = (SpiderScan)genericScanner2;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", Integer.toString(spiderScan.getScanId()));
                map.put("progress", Integer.toString(spiderScan.getProgress()));
                map.put("state", spiderScan.getState());
                resultList.addItem(new ApiResponseSet(ACTION_START_SCAN, map));
            }
            result = resultList;
        } else {
            throw new ApiException(ApiException.Type.BAD_VIEW);
        }
        return result;
    }
}

