/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.parosproxy.paros.core.scanner.Plugin;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.extension.pscan.PassiveScanner;
import org.zaproxy.zap.utils.Enableable;

public abstract class PluginPassiveScanner
extends Enableable
implements PassiveScanner {
    private static final Integer[] DEFAULT_HISTORY_TYPES = new Integer[]{1, 15, 2, 10};
    private static final Set<Integer> DEFAULT_HISTORY_TYPES_SET = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(DEFAULT_HISTORY_TYPES)));
    private Plugin.AlertThreshold level = Plugin.AlertThreshold.DEFAULT;
    private Plugin.AlertThreshold defaultLevel = Plugin.AlertThreshold.MEDIUM;
    private Configuration config = null;
    private AddOn.Status status = AddOn.Status.unknown;

    public void setConfig(Configuration config) {
        this.config = config;
        this.loadFrom(config);
    }

    public void loadFrom(Configuration conf) {
        this.setEnabled(conf.getBoolean("pscans." + this.getClass().getCanonicalName() + ".enabled", true));
        this.setLevel(Plugin.AlertThreshold.valueOf(conf.getString("pscans." + this.getClass().getCanonicalName() + ".level", Plugin.AlertThreshold.DEFAULT.name())));
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void save() {
        this.saveTo(this.getConfig());
    }

    public void saveTo(Configuration conf) {
        conf.setProperty("pscans." + this.getClass().getCanonicalName() + ".enabled", (Object)this.isEnabled());
        conf.setProperty("pscans." + this.getClass().getCanonicalName() + ".level", (Object)this.getLevel(true).name());
    }

    @Override
    public Plugin.AlertThreshold getLevel() {
        if (Plugin.AlertThreshold.DEFAULT.equals((Object)this.level)) {
            return this.defaultLevel;
        }
        return this.level;
    }

    public Plugin.AlertThreshold getLevel(boolean incDefault) {
        return this.level;
    }

    @Override
    public void setLevel(Plugin.AlertThreshold level) {
        this.level = level;
    }

    public void setDefaultLevel(Plugin.AlertThreshold level) {
        this.defaultLevel = level;
    }

    public int getPluginId() {
        return -1;
    }

    public AddOn.Status getStatus() {
        return this.status;
    }

    public void setStatus(AddOn.Status status) {
        this.status = status;
    }

    public static Set<Integer> getDefaultHistoryTypes() {
        return DEFAULT_HISTORY_TYPES_SET;
    }

    @Override
    public boolean appliesToHistoryType(int historyType) {
        return PluginPassiveScanner.getDefaultHistoryTypes().contains(historyType);
    }
}

