/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionLoader;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.control.CoreFunctionality;
import org.zaproxy.zap.control.ExtensionFactory;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.pscan.OptionsPassiveScan;
import org.zaproxy.zap.extension.pscan.PassiveScanAPI;
import org.zaproxy.zap.extension.pscan.PassiveScanParam;
import org.zaproxy.zap.extension.pscan.PassiveScanThread;
import org.zaproxy.zap.extension.pscan.PassiveScanner;
import org.zaproxy.zap.extension.pscan.PassiveScannerList;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;
import org.zaproxy.zap.extension.pscan.PolicyPassiveScanPanel;
import org.zaproxy.zap.extension.pscan.scanner.RegexAutoTagScanner;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptType;

public class ExtensionPassiveScan
extends ExtensionAdaptor
implements SessionChangedListener {
    public static final String NAME = "ExtensionPassiveScan";
    private static final ImageIcon SCRIPT_ICON = new ImageIcon(ZAP.class.getResource("/resource/icon/16/script-pscan.png"));
    public static final String SCRIPT_TYPE_PASSIVE = "passive";
    private static final Logger logger = Logger.getLogger(ExtensionPassiveScan.class);
    private PassiveScannerList scannerList;
    private OptionsPassiveScan optionsPassiveScan = null;
    private PolicyPassiveScanPanel policyPanel = null;
    private PassiveScanThread pst = null;
    private boolean passiveScanEnabled;
    private PassiveScanParam passiveScanParam;
    private static final List<Class<?>> DEPENDENCIES;

    public ExtensionPassiveScan() {
        this.initialize();
    }

    private void initialize() {
        this.setOrder(26);
        this.setName(NAME);
    }

    @Override
    public void init() {
        super.init();
        this.passiveScanEnabled = true;
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        ExtensionScript extScript;
        super.hook(extensionHook);
        extensionHook.addOptionsParamSet(this.getPassiveScanParam());
        extensionHook.addProxyListener(this.getPassiveScanThread());
        extensionHook.addSessionListener(this);
        if (this.getView() != null) {
            extensionHook.getHookView().addOptionPanel(this.getOptionsPassiveScan(this.getPassiveScanThread()));
            extensionHook.getHookView().addOptionPanel(this.getPolicyPanel());
        }
        if ((extScript = (ExtensionScript)Control.getSingleton().getExtensionLoader().getExtension("ExtensionScript")) != null) {
            extScript.registerScriptType(new ScriptType(SCRIPT_TYPE_PASSIVE, "pscan.scripts.type.passive", SCRIPT_ICON, true));
        }
        API.getInstance().registerApiImplementor(new PassiveScanAPI(this));
    }

    @Override
    public void optionsLoaded() {
        this.getPassiveScannerList().setAutoTagScanners(this.getPassiveScanParam().getAutoTagScanners());
    }

    @Deprecated
    public boolean addPassiveScanner(String className) {
        try {
            Class<?> c = ExtensionFactory.getAddOnLoader().loadClass(className);
            this.addPassiveScanner((PluginPassiveScanner)c.newInstance());
            return true;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean removePassiveScanner(String className) {
        PassiveScanner scanner = this.getPassiveScannerList().removeScanner(className);
        if (scanner != null && View.isInitialised() && scanner instanceof PluginPassiveScanner) {
            this.getPolicyPanel().getPassiveScanTableModel().removeScanner((PluginPassiveScanner)scanner);
        }
        return scanner != null;
    }

    public boolean addPassiveScanner(PassiveScanner passiveScanner) {
        if (passiveScanner == null) {
            throw new IllegalArgumentException("Parameter passiveScanner must not be null.");
        }
        if (passiveScanner instanceof PluginPassiveScanner) {
            return this.addPluginPassiveScannerImpl((PluginPassiveScanner)passiveScanner);
        }
        return this.addPassiveScannerImpl(passiveScanner);
    }

    public boolean removePassiveScanner(PassiveScanner passiveScanner) {
        if (passiveScanner == null) {
            throw new IllegalArgumentException("Parameter passiveScanner must not be null.");
        }
        return this.removePassiveScanner(passiveScanner.getClass().getName());
    }

    public boolean addPluginPassiveScanner(PluginPassiveScanner pluginPassiveScanner) {
        if (pluginPassiveScanner == null) {
            throw new IllegalArgumentException("Parameter pluginPassiveScanner must not be null.");
        }
        return this.addPluginPassiveScannerImpl(pluginPassiveScanner);
    }

    public boolean removePluginPassiveScanner(PluginPassiveScanner pluginPassiveScanner) {
        if (pluginPassiveScanner == null) {
            throw new IllegalArgumentException("Parameter pluginPassiveScanner must not be null.");
        }
        return this.removePassiveScanner(pluginPassiveScanner.getClass().getName());
    }

    private boolean addPassiveScannerImpl(PassiveScanner passiveScanner) {
        return this.scannerList.add(passiveScanner);
    }

    private boolean addPluginPassiveScannerImpl(PluginPassiveScanner scanner) {
        if (scanner instanceof RegexAutoTagScanner) {
            return false;
        }
        boolean added = false;
        try {
            FileConfiguration config = this.getModel().getOptionsParam().getConfig();
            scanner.setConfig((Configuration)config);
            added = this.addPassiveScannerImpl(scanner);
            if (View.isInitialised()) {
                this.getPolicyPanel().getPassiveScanTableModel().addScanner(scanner);
            }
            logger.info((Object)("loaded passive scan rule: " + scanner.getName()));
        }
        catch (Exception e) {
            logger.error((Object)("Failed to load passive scanner " + scanner.getName()), (Throwable)e);
        }
        return added;
    }

    private PassiveScannerList getPassiveScannerList() {
        if (this.scannerList == null) {
            this.scannerList = new PassiveScannerList();
            this.scannerList.setAutoTagScanners(this.getPassiveScanParam().getAutoTagScanners());
            ArrayList<PluginPassiveScanner> listTest = new ArrayList<PluginPassiveScanner>(CoreFunctionality.getBuiltInPassiveScanRules());
            listTest.addAll(ExtensionFactory.getAddOnLoader().getPassiveScanRules());
            for (PluginPassiveScanner scanner : listTest) {
                this.addPluginPassiveScannerImpl(scanner);
            }
        }
        return this.scannerList;
    }

    protected List<PluginPassiveScanner> getPluginPassiveScanners() {
        ArrayList<PluginPassiveScanner> pluginPassiveScanners = new ArrayList<PluginPassiveScanner>();
        for (PassiveScanner scanner : this.getPassiveScannerList().list()) {
            if (!(scanner instanceof PluginPassiveScanner) || scanner instanceof RegexAutoTagScanner) continue;
            pluginPassiveScanners.add((PluginPassiveScanner)scanner);
        }
        return pluginPassiveScanners;
    }

    void setAllPluginPassiveScannersEnabled(boolean enabled) {
        for (PluginPassiveScanner scanner : this.getPluginPassiveScanners()) {
            scanner.setEnabled(enabled);
            scanner.save();
        }
    }

    void setPluginPassiveScannerEnabled(int pluginId, boolean enabled) {
        for (PluginPassiveScanner scanner : this.getPluginPassiveScanners()) {
            if (pluginId != scanner.getPluginId()) continue;
            scanner.setEnabled(enabled);
            scanner.save();
        }
    }

    boolean hasPluginPassiveScanner(int pluginId) {
        for (PluginPassiveScanner scanner : this.getPluginPassiveScanners()) {
            if (pluginId != scanner.getPluginId()) continue;
            return true;
        }
        return false;
    }

    void setPluginPassiveScannerAlertThreshold(int pluginId, Plugin.AlertThreshold alertThreshold) {
        for (PluginPassiveScanner scanner : this.getPluginPassiveScanners()) {
            if (pluginId != scanner.getPluginId()) continue;
            scanner.setLevel(alertThreshold);
            scanner.setEnabled(!Plugin.AlertThreshold.OFF.equals((Object)alertThreshold));
            scanner.save();
        }
    }

    public void setAllScannerThreshold(Plugin.AlertThreshold at) {
        for (PluginPassiveScanner test : this.getPluginPassiveScanners()) {
            test.setLevel(at);
            test.setEnabled(!Plugin.AlertThreshold.OFF.equals((Object)at));
            test.save();
        }
    }

    public Plugin.AlertThreshold getAllScannerThreshold() {
        Plugin.AlertThreshold at = null;
        for (PluginPassiveScanner test : this.getPluginPassiveScanners()) {
            if (at == null) {
                at = test.getLevel();
                continue;
            }
            if (at.equals((Object)test.getLevel())) continue;
            return null;
        }
        return at;
    }

    protected PolicyPassiveScanPanel getPolicyPanel() {
        if (this.policyPanel == null) {
            this.policyPanel = new PolicyPassiveScanPanel();
        }
        return this.policyPanel;
    }

    public int getRecordsToScan() {
        if (this.passiveScanEnabled) {
            return this.getPassiveScanThread().getRecordsToScan();
        }
        return 0;
    }

    private PassiveScanThread getPassiveScanThread() {
        if (this.pst == null) {
            ExtensionLoader extensionLoader = Control.getSingleton().getExtensionLoader();
            ExtensionHistory extHist = (ExtensionHistory)extensionLoader.getExtension("ExtensionHistory");
            ExtensionAlert extAlert = (ExtensionAlert)extensionLoader.getExtension("ExtensionAlert");
            this.pst = new PassiveScanThread(this.getPassiveScannerList(), extHist, extAlert);
            this.pst.start();
        }
        return this.pst;
    }

    private PassiveScanParam getPassiveScanParam() {
        if (this.passiveScanParam == null) {
            this.passiveScanParam = new PassiveScanParam();
        }
        return this.passiveScanParam;
    }

    private OptionsPassiveScan getOptionsPassiveScan(PassiveScanThread passiveScanThread) {
        if (this.optionsPassiveScan == null) {
            this.optionsPassiveScan = new OptionsPassiveScan(this.scannerList);
        }
        return this.optionsPassiveScan;
    }

    @Override
    public void sessionAboutToChange(Session session) {
        this.stopPassiveScanThread();
    }

    private void stopPassiveScanThread() {
        if (this.pst != null) {
            this.getPassiveScanThread().shutdown();
            this.pst = null;
        }
    }

    @Override
    public void sessionChanged(Session session) {
        this.startPassiveScanThread();
    }

    private void startPassiveScanThread() {
        if (this.passiveScanEnabled && this.pst == null) {
            this.getPassiveScanThread();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.stopPassiveScanThread();
    }

    @Override
    public List<Class<?>> getDependencies() {
        return DEPENDENCIES;
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("pscan.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    void setPassiveScanEnabled(boolean enabled) {
        if (this.passiveScanEnabled != enabled) {
            this.passiveScanEnabled = enabled;
            if (enabled) {
                this.startPassiveScanThread();
            } else {
                this.stopPassiveScanThread();
            }
        }
    }

    public void saveTo(Configuration conf) {
        for (PassiveScanner scanner : this.getPassiveScannerList().list()) {
            if (!(scanner instanceof PluginPassiveScanner) || scanner instanceof RegexAutoTagScanner) continue;
            ((PluginPassiveScanner)scanner).saveTo(conf);
        }
    }

    public void loadFrom(Configuration conf) {
        for (PassiveScanner scanner : this.getPassiveScannerList().list()) {
            if (!(scanner instanceof PluginPassiveScanner) || scanner instanceof RegexAutoTagScanner) continue;
            ((PluginPassiveScanner)scanner).loadFrom(conf);
        }
    }

    @Override
    public boolean supportsLowMemory() {
        return true;
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    static {
        ArrayList<Class<ExtensionAlert>> dep = new ArrayList<Class<ExtensionAlert>>(1);
        dep.add(ExtensionAlert.class);
        DEPENDENCIES = Collections.unmodifiableList(dep);
    }
}

