/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.utils.LocaleUtils;

public final class LangImporter {
    private static final Logger logger = Logger.getLogger(LangImporter.class);
    private static final String MSG_SUCCESS = "options.lang.importer.dialog.message.success";
    private static final String MSG_ERROR = "options.lang.importer.dialog.message.error";
    private static final String MSG_FILE_NOT_FOUND = "options.lang.importer.dialog.message.filenotfound";

    private LangImporter() {
    }

    public static String importLanguagePack(String languagePack) {
        Pattern includedFilesPattern = LangImporter.createIncludedFilesPattern();
        int langFileCount = 0;
        String message = "";
        File F = new File(languagePack);
        try (ZipFile zipFile = new ZipFile(F.getAbsolutePath());){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) continue;
                BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                Throwable throwable = null;
                try {
                    byte[] buffer = new byte[2048];
                    String name = zipEntry.getName();
                    if (!includedFilesPattern.matcher(name).find()) continue;
                    ++langFileCount;
                    Path outputFile = Paths.get(Constant.getZapInstall(), name);
                    BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(outputFile, new OpenOption[0]), buffer.length);
                    Throwable throwable2 = null;
                    try {
                        int size;
                        while ((size = bis.read(buffer, 0, buffer.length)) != -1) {
                            bos.write(buffer, 0, size);
                        }
                        bos.flush();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (bos == null) continue;
                        if (throwable2 != null) {
                            try {
                                bos.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        bos.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (bis == null) continue;
                    if (throwable != null) {
                        try {
                            bis.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    bis.close();
                }
            }
            message = langFileCount > 0 ? MSG_SUCCESS : MSG_ERROR;
        }
        catch (IOException e) {
            message = MSG_FILE_NOT_FOUND;
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (View.isInitialised()) {
            JOptionPane.showMessageDialog(null, MessageFormat.format(Constant.messages.getString(message), langFileCount), Constant.messages.getString("options.lang.importer.dialog.title"), langFileCount > 0 ? 1 : 0);
        }
        return message;
    }

    static Pattern createIncludedFilesPattern() {
        String messagesFilesRegex = LocaleUtils.createResourceFilesRegex("Messages", ".properties");
        String vulnerabilitiesFilesRegex = LocaleUtils.createResourceFilesRegex("vulnerabilities", ".xml");
        StringBuilder strBuilder = new StringBuilder(messagesFilesRegex.length() + vulnerabilitiesFilesRegex.length() + 1);
        strBuilder.append(messagesFilesRegex).append('|').append(vulnerabilitiesFilesRegex);
        return Pattern.compile(strBuilder.toString());
    }
}

