/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httpsessions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.zaproxy.zap.extension.api.ZapApiIgnore;
import org.zaproxy.zap.extension.httpsessions.HttpSessionToken;

public class HttpSessionsParam
extends AbstractParam {
    private static final String DEFAULT_TOKENS_KEY = "httpsessions.tokens";
    private static final String ALL_DEFAULT_TOKENS_KEY = "httpsessions.tokens.token";
    private static final String TOKEN_NAME_KEY = "name";
    private static final String TOKEN_ENABLED_KEY = "enabled";
    private static final String PROXY_ONLY_KEY = "httpsessions.proxyOnly";
    private static final String CONFIRM_REMOVE_TOKEN_KEY = "httpsessions.confirmRemoveToken";
    private static final String[] DEFAULT_TOKENS = new String[]{"asp.net_sessionid", "aspsessionid", "siteserver", "cfid", "cftoken", "jsessionid", "phpsessid", "sessid", "sid", "viewstate", "zenid"};
    private static final Logger log = Logger.getLogger(HttpSessionsParam.class);
    private List<HttpSessionToken> defaultTokens = null;
    private List<String> defaultTokensEnabled = null;
    private boolean enabledProxyOnly = false;
    private boolean confirmRemove = true;

    @Override
    protected void parse() {
        try {
            List fields = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(ALL_DEFAULT_TOKENS_KEY);
            this.defaultTokens = new ArrayList<HttpSessionToken>(fields.size());
            this.defaultTokensEnabled = new ArrayList<String>(fields.size());
            ArrayList<String> tempTokensNames = new ArrayList<String>(fields.size());
            for (HierarchicalConfiguration sub : fields) {
                String name = sub.getString(TOKEN_NAME_KEY, "");
                if ("".equals(name) || tempTokensNames.contains(name)) continue;
                boolean enabled = sub.getBoolean(TOKEN_ENABLED_KEY, true);
                this.defaultTokens.add(new HttpSessionToken(name, enabled));
                tempTokensNames.add(name);
                if (!enabled) continue;
                this.defaultTokensEnabled.add(name);
            }
        }
        catch (ConversionException e) {
            this.defaultTokens = new ArrayList<HttpSessionToken>(DEFAULT_TOKENS.length);
            log.error((Object)("Error while parsing config file: " + e.getMessage()), (Throwable)e);
        }
        if (this.defaultTokens.size() == 0) {
            for (String tokenName : DEFAULT_TOKENS) {
                this.defaultTokens.add(new HttpSessionToken(tokenName));
                this.defaultTokensEnabled.add(tokenName);
            }
        }
        try {
            this.enabledProxyOnly = this.getConfig().getBoolean(PROXY_ONLY_KEY, false);
        }
        catch (ConversionException e) {
            log.error((Object)("Error while parsing config file: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.confirmRemove = this.getConfig().getBoolean(CONFIRM_REMOVE_TOKEN_KEY, true);
        }
        catch (ConversionException e) {
            log.error((Object)("Error while parsing config file: " + e.getMessage()), (Throwable)e);
        }
    }

    public final List<HttpSessionToken> getDefaultTokens() {
        return Collections.unmodifiableList(this.defaultTokens);
    }

    public final List<String> getDefaultTokensEnabled() {
        return Collections.unmodifiableList(this.defaultTokensEnabled);
    }

    public void setDefaultTokens(List<HttpSessionToken> tokens) {
        this.defaultTokens = tokens;
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_DEFAULT_TOKENS_KEY);
        ArrayList<String> enabledTokens = new ArrayList<String>(tokens.size());
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            String elementBaseKey = "httpsessions.tokens.token(" + i + ").";
            HttpSessionToken token = tokens.get(i);
            this.getConfig().setProperty(elementBaseKey + TOKEN_NAME_KEY, (Object)token.getName());
            this.getConfig().setProperty(elementBaseKey + TOKEN_ENABLED_KEY, (Object)token.isEnabled());
            if (!token.isEnabled()) continue;
            enabledTokens.add(token.getName());
        }
        enabledTokens.trimToSize();
        this.defaultTokensEnabled = enabledTokens;
    }

    public boolean isEnabledProxyOnly() {
        return this.enabledProxyOnly;
    }

    public void setEnabledProxyOnly(boolean enabledProxyOnly) {
        this.enabledProxyOnly = enabledProxyOnly;
        this.getConfig().setProperty(PROXY_ONLY_KEY, (Object)enabledProxyOnly);
    }

    @ZapApiIgnore
    public boolean isConfirmRemoveDefaultToken() {
        return this.confirmRemove;
    }

    @ZapApiIgnore
    public void setConfirmRemoveDefaultToken(boolean confirmRemove) {
        this.confirmRemove = confirmRemove;
        this.getConfig().setProperty(CONFIRM_REMOVE_TOKEN_KEY, (Object)confirmRemove);
    }
}

