/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.components.split.response;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.response.ResponseHeaderStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextView;
import org.zaproxy.zap.extension.search.SearchMatch;

public class HttpResponseHeaderPanelSyntaxHighlightTextView
extends HttpPanelSyntaxHighlightTextView {
    public HttpResponseHeaderPanelSyntaxHighlightTextView(ResponseHeaderStringHttpPanelViewModel model) {
        super(model);
    }

    @Override
    protected HttpPanelSyntaxHighlightTextArea createHttpPanelTextArea() {
        return new HttpResponseHeaderPanelSyntaxHighlightTextArea();
    }

    private static class HttpResponseHeaderPanelSyntaxHighlightTextArea
    extends HttpPanelSyntaxHighlightTextArea {
        private static final long serialVersionUID = 6197189781594557597L;
        private static final Logger log = Logger.getLogger(HttpResponseHeaderPanelSyntaxHighlightTextArea.class);
        private static ResponseHeaderTokenMakerFactory tokenMakerFactory = null;

        @Override
        public void search(Pattern p, List<SearchMatch> matches) {
            Matcher m = p.matcher(this.getText());
            while (m.find()) {
                int start = m.start();
                try {
                    start += this.getLineOfOffset(start);
                }
                catch (BadLocationException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    return;
                }
                int end = m.end();
                try {
                    end += this.getLineOfOffset(end);
                }
                catch (BadLocationException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    return;
                }
                matches.add(new SearchMatch(SearchMatch.Location.REQUEST_HEAD, start, end));
            }
        }

        @Override
        public void highlight(SearchMatch sm) {
            if (!SearchMatch.Location.RESPONSE_HEAD.equals((Object)sm.getLocation())) {
                return;
            }
            int t = 0;
            String header = sm.getMessage().getResponseHeader().toString();
            int pos = 0;
            while ((pos = header.indexOf("\r\n", pos)) != -1 && pos < sm.getStart()) {
                pos += 2;
                ++t;
            }
            int len = this.getText().length();
            if (sm.getStart() - t > len || sm.getEnd() - t > len) {
                return;
            }
            this.highlight(sm.getStart() - t, sm.getEnd() - t);
        }

        @Override
        protected synchronized HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory getTokenMakerFactory() {
            if (tokenMakerFactory == null) {
                tokenMakerFactory = new ResponseHeaderTokenMakerFactory();
            }
            return tokenMakerFactory;
        }

        private static class ResponseHeaderTokenMakerFactory
        extends HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory {
        }
    }
}

