/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.component.split.request;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import org.apache.commons.configuration.FileConfiguration;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.component.HttpPanelComponentInterface;
import org.zaproxy.zap.extension.httppanel.component.HttpPanelComponentViewsManager;
import org.zaproxy.zap.extension.httppanel.component.split.request.HttpRequestBodyPanelTextView;
import org.zaproxy.zap.extension.httppanel.component.split.request.HttpRequestHeaderPanelTextView;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelDefaultViewSelector;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelView;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.request.RequestBodyStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.request.RequestHeaderStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.text.HttpPanelTextView;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.extension.search.SearchableHttpPanelComponent;
import org.zaproxy.zap.model.HttpMessageLocation;
import org.zaproxy.zap.model.MessageLocation;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlighter;

public class RequestSplitComponent<T extends Message>
implements HttpPanelComponentInterface,
SearchableHttpPanelComponent,
MessageLocationHighlighter {
    public static final String NAME = "RequestSplit";
    private static final String DIVIDER_LOCATION_CONFIG_KEY = "dividerLocation";
    private static final String BUTTON_TOOL_TIP = Constant.messages.getString("http.panel.component.split.tooltip");
    private static final String HEADER_LABEL = Constant.messages.getString("http.panel.component.split.header");
    private static final String BODY_LABEL = Constant.messages.getString("http.panel.component.split.body");
    protected JToggleButton buttonShowView;
    protected JPanel panelOptions;
    protected JPanel panelMain;
    protected JSplitPane splitMain;
    protected HttpMessage httpMessage;
    protected boolean isEditable;
    protected HttpPanelComponentViewsManager headerViews = new HttpPanelComponentViewsManager("split.header", HEADER_LABEL);
    protected HttpPanelComponentViewsManager bodyViews = new HttpPanelComponentViewsManager("split.body", BODY_LABEL);
    private String configurationKey = "";

    public RequestSplitComponent() {
        this.initUi();
    }

    protected void initUi() {
        this.buttonShowView = new JToggleButton(new ImageIcon(RequestSplitComponent.class.getResource("/resource/icon/view_split.png")));
        this.buttonShowView.setToolTipText(BUTTON_TOOL_TIP);
        this.panelOptions = new JPanel();
        this.panelOptions.add(this.headerViews.getSelectableViewsComponent());
        this.panelOptions.add(this.bodyViews.getSelectableViewsComponent());
        this.headerViews.addView(this.createHttpPanelHeaderTextView());
        this.splitMain = new JSplitPane();
        this.splitMain.setDividerSize(3);
        this.splitMain.setResizeWeight(0.5);
        this.splitMain.setContinuousLayout(false);
        this.splitMain.setOrientation(0);
        this.splitMain.setTopComponent(this.headerViews.getViewsPanel());
        this.splitMain.setBottomComponent(this.bodyViews.getViewsPanel());
        this.initViews();
        this.panelMain = new JPanel(new BorderLayout());
        this.panelMain.add((Component)this.splitMain, "Center");
        this.setSelected(false);
    }

    @Override
    public JToggleButton getButton() {
        return this.buttonShowView;
    }

    @Override
    public JPanel getOptionsPanel() {
        return this.panelOptions;
    }

    @Override
    public JPanel getMoreOptionsPanel() {
        return null;
    }

    @Override
    public JPanel getMainPanel() {
        return this.panelMain;
    }

    @Override
    public void setSelected(boolean selected) {
        this.buttonShowView.setSelected(selected);
        this.headerViews.setSelected(selected);
    }

    protected HttpPanelTextView createHttpPanelHeaderTextView() {
        return new HttpRequestHeaderPanelTextView(new RequestHeaderStringHttpPanelViewModel());
    }

    protected void initViews() {
        this.bodyViews.addView(new HttpRequestBodyPanelTextView(new RequestBodyStringHttpPanelViewModel()));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getPosition() {
        return 1;
    }

    @Override
    public boolean isEnabled(Message aMessage) {
        if (aMessage == null) {
            return true;
        }
        return aMessage instanceof HttpMessage;
    }

    @Override
    public void setMessage(Message aMessage) {
        this.httpMessage = (HttpMessage)aMessage;
        this.headerViews.setMessage(this.httpMessage);
        this.bodyViews.setMessage(this.httpMessage);
    }

    @Override
    public void save() {
        if (this.httpMessage == null) {
            return;
        }
        this.headerViews.save();
        this.bodyViews.save();
    }

    @Override
    public void addView(HttpPanelView view, Object options, FileConfiguration fileConfiguration) {
        if (options != null) {
            if (ViewComponent.HEADER.equals(options)) {
                this.headerViews.addView(view, fileConfiguration);
            } else if (ViewComponent.BODY.equals(options)) {
                this.bodyViews.addView(view, fileConfiguration);
            }
        }
    }

    @Override
    public void removeView(String viewName, Object options) {
        if (options != null) {
            if (ViewComponent.HEADER.equals(options)) {
                this.headerViews.removeView(viewName);
            } else if (ViewComponent.BODY.equals(options)) {
                this.bodyViews.removeView(viewName);
            }
        }
    }

    @Override
    public void clearView() {
        this.httpMessage = null;
        this.headerViews.clearView();
        this.bodyViews.clearView();
    }

    @Override
    public void clearView(boolean enableViewSelect) {
        this.clearView();
        this.setEnableViewSelect(enableViewSelect);
    }

    @Override
    public void setEnableViewSelect(boolean enableViewSelect) {
        this.headerViews.setEnableViewSelect(enableViewSelect);
        this.bodyViews.setEnableViewSelect(enableViewSelect);
    }

    @Override
    public void addDefaultViewSelector(HttpPanelDefaultViewSelector defaultViewSelector, Object options) {
        if (options != null) {
            if (ViewComponent.HEADER.equals(options)) {
                this.headerViews.addDefaultViewSelector(defaultViewSelector);
            } else if (ViewComponent.BODY.equals(options)) {
                this.bodyViews.addDefaultViewSelector(defaultViewSelector);
            }
        }
    }

    @Override
    public void removeDefaultViewSelector(String defaultViewSelectorName, Object options) {
        if (options != null) {
            if (ViewComponent.HEADER.equals(options)) {
                this.headerViews.removeDefaultViewSelector(defaultViewSelectorName);
            } else if (ViewComponent.BODY.equals(options)) {
                this.bodyViews.removeDefaultViewSelector(defaultViewSelectorName);
            }
        }
    }

    @Override
    public void setParentConfigurationKey(String configurationKey) {
        this.configurationKey = configurationKey;
        this.headerViews.setConfigurationKey(configurationKey);
        this.bodyViews.setConfigurationKey(configurationKey);
    }

    @Override
    public void loadConfig(FileConfiguration fileConfiguration) {
        this.splitMain.setDividerLocation(Model.getSingleton().getOptionsParam().getConfig().getInt(this.configurationKey + DIVIDER_LOCATION_CONFIG_KEY, -1));
        this.headerViews.loadConfig(fileConfiguration);
        this.bodyViews.loadConfig(fileConfiguration);
    }

    @Override
    public void saveConfig(FileConfiguration fileConfiguration) {
        Model.getSingleton().getOptionsParam().getConfig().setProperty(this.configurationKey + DIVIDER_LOCATION_CONFIG_KEY, (Object)this.splitMain.getDividerLocation());
        this.headerViews.saveConfig(fileConfiguration);
        this.bodyViews.saveConfig(fileConfiguration);
    }

    @Override
    public void setEditable(boolean editable) {
        if (this.isEditable != editable) {
            this.isEditable = editable;
            this.headerViews.setEditable(editable);
            this.bodyViews.setEditable(editable);
        }
    }

    @Override
    public void highlightHeader(SearchMatch sm) {
        this.headerViews.highlight(sm);
    }

    @Override
    public void highlightBody(SearchMatch sm) {
        this.bodyViews.highlight(sm);
    }

    @Override
    public void searchHeader(Pattern p, List<SearchMatch> matches) {
        this.headerViews.search(p, matches);
    }

    @Override
    public void searchBody(Pattern p, List<SearchMatch> matches) {
        this.bodyViews.search(p, matches);
    }

    @Override
    public boolean supports(MessageLocation location) {
        if (!(location instanceof HttpMessageLocation)) {
            return false;
        }
        HttpMessageLocation httpMessageLocation = (HttpMessageLocation)location;
        switch (httpMessageLocation.getLocation()) {
            case REQUEST_HEADER: 
            case RESPONSE_HEADER: {
                return this.headerViews.supports(httpMessageLocation);
            }
            case REQUEST_BODY: 
            case RESPONSE_BODY: {
                return this.bodyViews.supports(httpMessageLocation);
            }
        }
        return false;
    }

    @Override
    public boolean supports(Class<? extends MessageLocation> classLocation) {
        return !HttpMessageLocation.class.isAssignableFrom(classLocation);
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation location) {
        if (!(location instanceof HttpMessageLocation)) {
            return null;
        }
        HttpMessageLocation httpMessageLocation = (HttpMessageLocation)location;
        switch (httpMessageLocation.getLocation()) {
            case REQUEST_HEADER: 
            case RESPONSE_HEADER: {
                return this.headerViews.highlight(httpMessageLocation);
            }
            case REQUEST_BODY: 
            case RESPONSE_BODY: {
                return this.bodyViews.highlight(httpMessageLocation);
            }
        }
        return null;
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation location, MessageLocationHighlight highlight) {
        if (!(location instanceof HttpMessageLocation)) {
            return null;
        }
        HttpMessageLocation httpMessageLocation = (HttpMessageLocation)location;
        switch (httpMessageLocation.getLocation()) {
            case REQUEST_HEADER: 
            case RESPONSE_HEADER: {
                return this.headerViews.highlight(httpMessageLocation, highlight);
            }
            case REQUEST_BODY: 
            case RESPONSE_BODY: {
                return this.bodyViews.highlight(httpMessageLocation, highlight);
            }
        }
        return null;
    }

    @Override
    public void removeHighlight(MessageLocation location, MessageLocationHighlight highlightReference) {
        if (!(location instanceof HttpMessageLocation)) {
            return;
        }
        HttpMessageLocation httpMessageLocation = (HttpMessageLocation)location;
        switch (httpMessageLocation.getLocation()) {
            case REQUEST_HEADER: 
            case RESPONSE_HEADER: {
                this.headerViews.removeHighlight(httpMessageLocation, highlightReference);
                break;
            }
            case REQUEST_BODY: 
            case RESPONSE_BODY: {
                this.bodyViews.removeHighlight(httpMessageLocation, highlightReference);
                break;
            }
        }
    }

    @Override
    public HttpPanelView setSelectedView(String viewName) {
        HttpPanelView selectedView = this.headerViews.setSelectedView(viewName);
        if (selectedView != null) {
            return selectedView;
        }
        return this.bodyViews.setSelectedView(viewName);
    }

    public static enum ViewComponent {
        HEADER,
        BODY;

    }
}

