/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.component.split.request;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.request.RequestHeaderStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.text.HttpPanelTextArea;
import org.zaproxy.zap.extension.httppanel.view.text.HttpPanelTextView;
import org.zaproxy.zap.extension.search.SearchMatch;

public class HttpRequestHeaderPanelTextView
extends HttpPanelTextView {
    private static final Logger log = Logger.getLogger(HttpRequestHeaderPanelTextView.class);

    public HttpRequestHeaderPanelTextView(RequestHeaderStringHttpPanelViewModel model) {
        super(model);
    }

    @Override
    protected HttpPanelTextArea createHttpPanelTextArea() {
        return new HttpRequestHeaderPanelTextArea();
    }

    private static class HttpRequestHeaderPanelTextArea
    extends HttpPanelTextArea {
        private static final long serialVersionUID = 985537589818833350L;

        private HttpRequestHeaderPanelTextArea() {
        }

        @Override
        public void search(Pattern p, List<SearchMatch> matches) {
            Matcher m = p.matcher(this.getText());
            while (m.find()) {
                int start = m.start();
                try {
                    start += this.getLineOfOffset(start);
                }
                catch (BadLocationException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    return;
                }
                int end = m.end();
                try {
                    end += this.getLineOfOffset(end);
                }
                catch (BadLocationException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    return;
                }
                matches.add(new SearchMatch(SearchMatch.Location.REQUEST_HEAD, start, end));
            }
        }

        @Override
        public void highlight(SearchMatch sm) {
            if (!SearchMatch.Location.REQUEST_HEAD.equals((Object)sm.getLocation())) {
                return;
            }
            int t = 0;
            String header = sm.getMessage().getRequestHeader().toString();
            int pos = 0;
            while ((pos = header.indexOf("\r\n", pos)) != -1 && pos < sm.getStart()) {
                pos += 2;
                ++t;
            }
            int len = this.getText().length();
            if (sm.getStart() - t > len || sm.getEnd() - t > len) {
                return;
            }
            this.highlight(sm.getStart() - t, sm.getEnd() - t);
        }
    }
}

