/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.history;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.JFileChooser;
import javax.swing.JTree;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;

public class PopupMenuExportURLs
extends ExtensionPopupMenuItem {
    private static final long serialVersionUID = 1L;
    private static final String CRLF = "\r\n";
    private ExtensionHistory extension = null;
    private static Logger log = Logger.getLogger(PopupMenuExportURLs.class);

    public PopupMenuExportURLs() {
        this.initialize();
    }

    public PopupMenuExportURLs(String label) {
        super(label);
    }

    private void initialize() {
        this.setText(Constant.messages.getString("exportUrls.popup"));
        this.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                JTree site = PopupMenuExportURLs.this.extension.getView().getSiteTreePanel().getTreeSite();
                File file = PopupMenuExportURLs.this.getOutputFile();
                if (file == null) {
                    return;
                }
                boolean isAppend = true;
                if (file.exists()) {
                    int rc = PopupMenuExportURLs.this.extension.getView().showYesNoCancelDialog(Constant.messages.getString("file.overwrite.warning"));
                    if (rc == 2) {
                        return;
                    }
                    if (rc == 0) {
                        isAppend = false;
                    }
                }
                boolean html = file.getName().toLowerCase().endsWith(".htm") || file.getName().toLowerCase().endsWith(".html");
                BufferedWriter fw = null;
                try {
                    fw = new BufferedWriter(new FileWriter(file, isAppend));
                    PopupMenuExportURLs.this.exportURLs((SiteNode)site.getModel().getRoot(), fw, html);
                }
                catch (Exception e1) {
                    log.warn((Object)e1.getStackTrace(), (Throwable)e1);
                    PopupMenuExportURLs.this.extension.getView().showWarningDialog(Constant.messages.getString("file.save.error") + file.getAbsolutePath());
                }
                finally {
                    try {
                        fw.close();
                    }
                    catch (Exception e2) {
                        log.warn((Object)e2.getStackTrace(), (Throwable)e2);
                    }
                }
            }
        });
    }

    public void setExtension(ExtensionHistory extension) {
        this.extension = extension;
    }

    private void exportURLs(SiteNode node, BufferedWriter writer, boolean html) {
        if (node == null) {
            return;
        }
        try {
            HttpMessage msg;
            if (node.getHistoryReference() != null && (node.getHistoryReference().getHistoryType() == 1 || node.getHistoryReference().getHistoryType() == 15 || node.getHistoryReference().getHistoryType() == 2) && (msg = node.getHistoryReference().getHttpMessage()) != null && msg.getRequestHeader().getURI() != null) {
                writer.write(msg.getRequestHeader().getMethod());
                writer.write("\t");
                if (html) {
                    writer.write("<a href=\"");
                    writer.write(msg.getRequestHeader().getURI().toString());
                    writer.write("\">");
                    writer.write(msg.getRequestHeader().getURI().toString());
                    writer.write("</a><br>");
                } else {
                    writer.write(msg.getRequestHeader().getURI().toString());
                }
                writer.write(CRLF);
            }
        }
        catch (HttpMalformedHeaderException e) {
            log.warn((Object)e.getStackTrace(), (Throwable)e);
        }
        catch (IOException e) {
            log.warn((Object)e.getStackTrace(), (Throwable)e);
        }
        catch (DatabaseException e) {
            log.warn((Object)e.getStackTrace(), (Throwable)e);
        }
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            this.exportURLs((SiteNode)en.nextElement(), writer, html);
        }
    }

    private File getOutputFile() {
        JFileChooser chooser = new JFileChooser(this.extension.getModel().getOptionsParam().getUserDirectory());
        FileNameExtensionFilter textFilesFilter = new FileNameExtensionFilter(Constant.messages.getString("file.format.ascii"), "txt");
        FileNameExtensionFilter htmlFilesFilter = new FileNameExtensionFilter(Constant.messages.getString("file.format.html"), "html", "htm");
        chooser.addChoosableFileFilter(textFilesFilter);
        chooser.addChoosableFileFilter(htmlFilesFilter);
        chooser.setFileFilter(textFilesFilter);
        File file = null;
        int rc = chooser.showSaveDialog(this.extension.getView().getMainFrame());
        if (rc == 0) {
            file = chooser.getSelectedFile();
            if (file == null) {
                return file;
            }
            this.extension.getModel().getOptionsParam().setUserDirectory(chooser.getCurrentDirectory());
            String fileNameLc = file.getAbsolutePath().toLowerCase();
            if (!(fileNameLc.endsWith(".txt") || fileNameLc.endsWith(".htm") || fileNameLc.endsWith(".html"))) {
                String ext = htmlFilesFilter.equals(chooser.getFileFilter()) ? ".html" : ".txt";
                file = new File(file.getAbsolutePath() + ext);
            }
            return file;
        }
        return file;
    }
}

