/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.IconHighlighter;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.IconAware;
import org.jdesktop.swingx.renderer.IconValues;
import org.jdesktop.swingx.renderer.MappedValue;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.AbstractFrame;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnCollection;
import org.zaproxy.zap.extension.autoupdate.AddOnDependencyChecker;
import org.zaproxy.zap.extension.autoupdate.AddOnWrapper;
import org.zaproxy.zap.extension.autoupdate.CheckForUpdateCallback;
import org.zaproxy.zap.extension.autoupdate.ExtensionAutoUpdate;
import org.zaproxy.zap.extension.autoupdate.InstalledAddOnsTableModel;
import org.zaproxy.zap.extension.autoupdate.UninstalledAddOnsTableModel;
import org.zaproxy.zap.utils.DesktopUtils;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.view.LayoutHelper;

public class ManageAddOnsDialog
extends AbstractFrame
implements CheckForUpdateCallback {
    static final Icon ICON_ADD_ON_ISSUES = new ImageIcon(InstalledAddOnsTableModel.class.getResource("/resource/icon/16/050.png"));
    static final Icon ICON_ADD_ON_EXTENSION_ISSUES = new ImageIcon(InstalledAddOnsTableModel.class.getResource("/resource/icon/fugue/information-white.png"));
    private static final Logger logger = Logger.getLogger(ManageAddOnsDialog.class);
    private static final long serialVersionUID = 1L;
    private JTabbedPane jTabbed = null;
    private JPanel topPanel = null;
    private JPanel installedPanel = null;
    private JPanel browsePanel = null;
    private JPanel corePanel = null;
    private JPanel installedAddOnsPanel = null;
    private JPanel uninstalledAddOnsPanel = null;
    private JPanel retrievePanel = null;
    private JScrollPane marketPlaceScrollPane = null;
    private JButton addOnInfoButton = null;
    private JButton coreNotesButton = null;
    private JButton downloadZapButton = null;
    private JButton checkForUpdatesButton = null;
    private JButton updateButton = null;
    private JButton updateAllButton = null;
    private JButton uninstallButton = null;
    private JButton installButton = null;
    private JButton close1Button = null;
    private JButton close2Button = null;
    private JLabel downloadProgress = null;
    private JLabel updatesMessage = null;
    private JXTable installedAddOnsTable = null;
    private JXTable uninstalledAddOnsTable = null;
    private String currentVersion = null;
    private AddOnCollection latestInfo = null;
    private AddOnCollection prevInfo = null;
    private ExtensionAutoUpdate extension = null;
    private AddOnCollection installedAddOns;
    private final InstalledAddOnsTableModel installedAddOnsModel;
    private final UninstalledAddOnsTableModel uninstalledAddOnsModel;
    private State state = null;

    public ManageAddOnsDialog(ExtensionAutoUpdate ext, String currentVersion, AddOnCollection installedAddOns) throws HeadlessException {
        this.extension = ext;
        this.currentVersion = currentVersion;
        this.installedAddOns = installedAddOns;
        this.installedAddOnsModel = new InstalledAddOnsTableModel(installedAddOns);
        this.uninstalledAddOnsModel = new UninstalledAddOnsTableModel(installedAddOns);
        this.initialize();
    }

    private void initialize() {
        this.setTitle(Constant.messages.getString("cfu.manage.title"));
        this.setContentPane(this.getTopPanel());
        this.pack();
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(700, 500);
        }
        this.state = State.IDLE;
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new GridBagLayout());
            this.topPanel.add((Component)this.getJTabbed(), LayoutHelper.getGBC(0, 0, 1, 1.0, 1.0));
            this.topPanel.add((Component)this.getUpdatesMessage(), LayoutHelper.getGBC(0, 2, 1, 1.0));
        }
        return this.topPanel;
    }

    private JTabbedPane getJTabbed() {
        if (this.jTabbed == null) {
            this.jTabbed = new JTabbedPane();
            this.jTabbed.addTab(Constant.messages.getString("cfu.tab.installed"), this.getInstalledPanel());
            this.jTabbed.addTab(Constant.messages.getString("cfu.tab.browse"), this.getBrowsePanel());
        }
        return this.jTabbed;
    }

    protected void selectMarketplaceTab() {
        this.getJTabbed().setSelectedIndex(1);
    }

    private JPanel getInstalledPanel() {
        if (this.installedPanel == null) {
            this.installedPanel = new JPanel();
            this.installedPanel.setLayout(new GridBagLayout());
            this.installedPanel.add((Component)this.getCorePanel(true), LayoutHelper.getGBC(0, 0, 1, 1.0, 0.0));
            this.installedPanel.add((Component)this.getInstalledAddOnsPanel(), LayoutHelper.getGBC(0, 1, 1, 1.0, 1.0));
        }
        return this.installedPanel;
    }

    private JPanel getBrowsePanel() {
        if (this.browsePanel == null) {
            this.browsePanel = new JPanel();
            this.browsePanel.setLayout(new GridBagLayout());
            this.browsePanel.add((Component)this.getUninstalledAddOnsPanel(), LayoutHelper.getGBC(0, 0, 1, 1.0, 1.0));
        }
        return this.browsePanel;
    }

    private JPanel getCorePanel(boolean update) {
        if (this.corePanel == null) {
            this.corePanel = new JPanel();
            this.corePanel.setLayout(new GridBagLayout());
            this.corePanel.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("cfu.label.zap.border"), 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
            if (this.latestInfo == null || this.latestInfo.getZapRelease() == null) {
                this.corePanel.add((Component)new JLabel(this.currentVersion), LayoutHelper.getGBC(0, 0, 1, 0.0));
                this.corePanel.add((Component)new JLabel(""), LayoutHelper.getGBC(1, 0, 1, 1.0));
                this.corePanel.add((Component)this.getCheckForUpdatesButton(), LayoutHelper.getGBC(2, 0, 1, 0.0));
            } else if (this.latestInfo.getZapRelease().isNewerThan(this.currentVersion)) {
                this.corePanel.add((Component)new JLabel(Constant.messages.getString("cfu.check.zap.newer")), LayoutHelper.getGBC(0, 0, 1, 0.0));
                this.corePanel.add((Component)new JLabel(this.latestInfo.getZapRelease().getVersion()), LayoutHelper.getGBC(1, 0, 1, 0.1));
                this.corePanel.add((Component)new JLabel(""), LayoutHelper.getGBC(2, 0, 1, 0.8));
                this.corePanel.add((Component)this.getDownloadProgress(), LayoutHelper.getGBC(3, 0, 1, 0.2));
                this.corePanel.add((Component)this.getCoreNotesButton(), LayoutHelper.getGBC(4, 0, 1, 0.0));
                this.corePanel.add((Component)this.getDownloadZapButton(), LayoutHelper.getGBC(5, 0, 1, 0.0));
            } else {
                this.corePanel.add((Component)new JLabel(this.currentVersion + " : " + Constant.messages.getString("cfu.check.zap.latest")), LayoutHelper.getGBC(0, 0, 1, 1.0));
            }
        } else if (update && this.latestInfo != null && this.latestInfo.getZapRelease() != null) {
            this.corePanel.removeAll();
            if (this.latestInfo.getZapRelease().isNewerThan(this.currentVersion)) {
                this.corePanel.add((Component)new JLabel(Constant.messages.getString("cfu.check.zap.newer")), LayoutHelper.getGBC(0, 0, 1, 0.0));
                this.corePanel.add((Component)new JLabel(this.latestInfo.getZapRelease().getVersion()), LayoutHelper.getGBC(1, 0, 1, 0.1));
                this.corePanel.add((Component)new JLabel(""), LayoutHelper.getGBC(2, 0, 1, 0.8));
                this.corePanel.add((Component)this.getDownloadProgress(), LayoutHelper.getGBC(3, 0, 1, 0.2));
                this.corePanel.add((Component)this.getCoreNotesButton(), LayoutHelper.getGBC(4, 0, 1, 0.0));
                this.corePanel.add((Component)this.getDownloadZapButton(), LayoutHelper.getGBC(5, 0, 1, 0.0));
            } else {
                this.corePanel.add((Component)new JLabel(this.currentVersion + " : " + Constant.messages.getString("cfu.check.zap.latest")), LayoutHelper.getGBC(0, 0, 1, 1.0));
            }
            this.installedPanel.validate();
        }
        return this.corePanel;
    }

    private JPanel getInstalledAddOnsPanel() {
        if (this.installedAddOnsPanel == null) {
            this.installedAddOnsPanel = new JPanel();
            this.installedAddOnsPanel.setLayout(new GridBagLayout());
            this.installedAddOnsPanel.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("cfu.label.addons.border"), 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
            this.getInstalledAddOnsTable();
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setHorizontalScrollBarPolicy(31);
            scrollPane.setViewportView((Component)this.getInstalledAddOnsTable());
            int row = 0;
            this.installedAddOnsPanel.add((Component)scrollPane, LayoutHelper.getGBC(0, row++, 5, 1.0, 1.0));
            this.installedAddOnsPanel.add((Component)new JLabel(""), LayoutHelper.getGBC(0, row, 1, 1.0));
            this.installedAddOnsPanel.add((Component)this.getUninstallButton(), LayoutHelper.getGBC(1, row, 1, 0.0));
            this.installedAddOnsPanel.add((Component)this.getUpdateButton(), LayoutHelper.getGBC(2, row, 1, 0.0));
            this.installedAddOnsPanel.add((Component)this.getUpdateAllButton(), LayoutHelper.getGBC(3, row, 1, 0.0));
            this.installedAddOnsPanel.add((Component)this.getClose1Button(), LayoutHelper.getGBC(4, row, 1, 0.0));
        }
        return this.installedAddOnsPanel;
    }

    private JPanel getUninstalledAddOnsPanel() {
        if (this.uninstalledAddOnsPanel == null) {
            this.uninstalledAddOnsPanel = new JPanel();
            this.uninstalledAddOnsPanel.setLayout(new GridBagLayout());
            this.uninstalledAddOnsPanel.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("cfu.label.addons.border"), 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
            if (this.latestInfo == null) {
                this.getUninstalledAddOnsTable();
                this.getMarketPlaceScrollPane().setViewportView(this.getRetrievePanel());
            } else {
                this.getMarketPlaceScrollPane().setViewportView((Component)this.getUninstalledAddOnsTable());
            }
            int row = 0;
            this.uninstalledAddOnsPanel.add((Component)this.getMarketPlaceScrollPane(), LayoutHelper.getGBC(0, row++, 4, 1.0, 1.0));
            this.uninstalledAddOnsPanel.add((Component)new JLabel(""), LayoutHelper.getGBC(0, row, 1, 1.0));
            this.uninstalledAddOnsPanel.add((Component)this.getInstallButton(), LayoutHelper.getGBC(1, row, 1, 0.0));
            this.uninstalledAddOnsPanel.add((Component)this.getAddOnInfoButton(), LayoutHelper.getGBC(2, row, 1, 0.0));
            this.uninstalledAddOnsPanel.add((Component)this.getClose2Button(), LayoutHelper.getGBC(3, row, 1, 0.0));
        }
        return this.uninstalledAddOnsPanel;
    }

    private JScrollPane getMarketPlaceScrollPane() {
        if (this.marketPlaceScrollPane == null) {
            this.marketPlaceScrollPane = new JScrollPane();
            this.marketPlaceScrollPane.setHorizontalScrollBarPolicy(31);
        }
        return this.marketPlaceScrollPane;
    }

    private JPanel getRetrievePanel() {
        if (this.retrievePanel == null) {
            this.retrievePanel = new JPanel();
            this.retrievePanel.setLayout(new GridBagLayout());
            JButton retrieveButton = new JButton();
            retrieveButton.setText(Constant.messages.getString("cfu.button.checkForUpdates"));
            retrieveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManageAddOnsDialog.this.checkForUpdates();
                }
            });
            this.retrievePanel.add((Component)new JLabel(""), LayoutHelper.getGBC(0, 0, 1, 1.0));
            this.retrievePanel.add((Component)retrieveButton, LayoutHelper.getGBC(1, 0, 1, 0.0));
            this.retrievePanel.add((Component)new JLabel(""), LayoutHelper.getGBC(2, 0, 1, 1.0));
            this.retrievePanel.add((Component)new JLabel(""), LayoutHelper.getGBC(0, 1, 3, 1.0, 1.0));
        }
        return this.retrievePanel;
    }

    protected void setPreviousVersionInfo(AddOnCollection prevInfo) {
        this.prevInfo = prevInfo;
    }

    protected void setLatestVersionInfo(AddOnCollection latestInfo) {
        this.latestInfo = latestInfo;
        this.getCorePanel(true);
        if (latestInfo != null) {
            this.installedAddOnsModel.setAvailableAddOns(latestInfo);
            this.uninstalledAddOnsModel.setAddOnCollection(latestInfo);
            List<AddOn> addOnsNotInstalled = this.installedAddOnsModel.updateEntries();
            this.uninstalledAddOnsModel.setAddOns(addOnsNotInstalled, this.prevInfo);
        }
        this.getMarketPlaceScrollPane().setViewportView((Component)this.getUninstalledAddOnsTable());
    }

    private JXTable getInstalledAddOnsTable() {
        if (this.installedAddOnsTable == null) {
            this.installedAddOnsTable = new JXTable();
            this.installedAddOnsModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    ManageAddOnsDialog.this.getUpdateButton().setEnabled(ManageAddOnsDialog.this.installedAddOnsModel.canUpdateSelected());
                    ManageAddOnsDialog.this.getUpdateAllButton().setEnabled(ManageAddOnsDialog.this.installedAddOnsModel.getAllUpdates().size() > 0);
                    ManageAddOnsDialog.this.getUninstallButton().setEnabled(ManageAddOnsDialog.this.installedAddOnsModel.canUninstallSelected());
                }
            });
            this.installedAddOnsTable.setModel((TableModel)this.installedAddOnsModel);
            this.installedAddOnsTable.getColumnModel().getColumn(0).setMaxWidth(20);
            this.installedAddOnsTable.getColumnExt(0).setSortable(false);
            this.installedAddOnsTable.getColumnModel().getColumn(1).setPreferredWidth(200);
            this.installedAddOnsTable.getColumnModel().getColumn(2).setPreferredWidth(400);
            this.installedAddOnsTable.getColumnExt(2).setSortable(false);
            this.installedAddOnsTable.getColumnModel().getColumn(3).setPreferredWidth(60);
            this.installedAddOnsTable.getColumnExt(3).setSortable(false);
            this.installedAddOnsTable.getColumnModel().getColumn(4).setPreferredWidth(40);
            this.installedAddOnsTable.getColumnExt(4).setSortable(false);
            ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>(1);
            sortKeys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
            this.installedAddOnsTable.getRowSorter().setSortKeys(sortKeys);
            DefaultAddOnToolTipHighlighter toolTipHighlighter = new DefaultAddOnToolTipHighlighter(-1);
            for (int i = 1; i < this.installedAddOnsTable.getColumnCount(); ++i) {
                this.installedAddOnsTable.getColumnExt(i).addHighlighter((Highlighter)toolTipHighlighter);
            }
            this.installedAddOnsTable.getColumnExt(0).setCellRenderer((TableCellRenderer)new DefaultTableRenderer((StringValue)new MappedValue(StringValues.EMPTY, IconValues.NONE), 0));
            this.installedAddOnsTable.getColumnExt(0).setHighlighters(new Highlighter[]{new CompoundHighlighter(new Highlighter[]{new WarningRunningIssuesHighlighter(-1), new WarningRunningIssuesToolTipHighlighter(-1)})});
            this.installedAddOnsTable.getColumnExt(3).setHighlighters(new Highlighter[]{new CompoundHighlighter(new Highlighter[]{new WarningUpdateIssuesHighlighter(-1), new WarningUpdateIssuesToolTipHighlighter(-1)})});
            this.installedAddOnsTable.getColumnExt(4).addHighlighter((Highlighter)new DisableSelectionHighlighter(-1));
        }
        return this.installedAddOnsTable;
    }

    private JXTable getUninstalledAddOnsTable() {
        if (this.uninstalledAddOnsTable == null) {
            this.uninstalledAddOnsTable = new JXTable();
            this.uninstalledAddOnsModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    ManageAddOnsDialog.this.getInstallButton().setEnabled(ManageAddOnsDialog.this.uninstalledAddOnsModel.canIinstallSelected());
                }
            });
            this.uninstalledAddOnsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    AddOnWrapper ao;
                    ManageAddOnsDialog.this.getAddOnInfoButton().setEnabled(false);
                    if (DesktopUtils.canOpenUrlInBrowser() && ManageAddOnsDialog.this.getUninstalledAddOnsTable().getSelectedRowCount() == 1 && (ao = ManageAddOnsDialog.this.uninstalledAddOnsModel.getAddOnWrapper(ManageAddOnsDialog.this.getUninstalledAddOnsTable().convertRowIndexToModel(ManageAddOnsDialog.this.getUninstalledAddOnsTable().getSelectedRow()))) != null && ao.getAddOn().getInfo() != null) {
                        ManageAddOnsDialog.this.getAddOnInfoButton().setEnabled(true);
                    }
                }
            });
            this.uninstalledAddOnsTable.setModel((TableModel)this.uninstalledAddOnsModel);
            this.uninstalledAddOnsTable.getColumnModel().getColumn(0).setMaxWidth(20);
            this.uninstalledAddOnsTable.getColumnExt(0).setSortable(false);
            this.uninstalledAddOnsTable.getColumnModel().getColumn(1).setPreferredWidth(50);
            this.uninstalledAddOnsTable.getColumnModel().getColumn(2).setPreferredWidth(150);
            this.uninstalledAddOnsTable.getColumnModel().getColumn(3).setPreferredWidth(300);
            this.uninstalledAddOnsTable.getColumnExt(3).setSortable(false);
            this.uninstalledAddOnsTable.getColumnModel().getColumn(4).setPreferredWidth(60);
            this.uninstalledAddOnsTable.getColumnExt(4).setSortable(false);
            this.uninstalledAddOnsTable.getColumnModel().getColumn(5).setPreferredWidth(40);
            this.uninstalledAddOnsTable.getColumnExt(5).setSortable(false);
            ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>(2);
            sortKeys.add(new RowSorter.SortKey(1, SortOrder.DESCENDING));
            sortKeys.add(new RowSorter.SortKey(2, SortOrder.ASCENDING));
            this.uninstalledAddOnsTable.getRowSorter().setSortKeys(sortKeys);
            DefaultAddOnToolTipHighlighter toolTipHighlighter = new DefaultAddOnToolTipHighlighter(-1);
            for (int i = 1; i < this.uninstalledAddOnsTable.getColumnCount(); ++i) {
                this.uninstalledAddOnsTable.getColumnExt(i).addHighlighter((Highlighter)toolTipHighlighter);
            }
            this.uninstalledAddOnsTable.getColumnExt(0).setCellRenderer((TableCellRenderer)new DefaultTableRenderer((StringValue)new MappedValue(StringValues.EMPTY, IconValues.NONE), 0));
            this.uninstalledAddOnsTable.getColumnExt(0).setHighlighters(new Highlighter[]{new CompoundHighlighter(new Highlighter[]{new WarningRunningIssuesHighlighter(-1), new WarningRunningIssuesToolTipHighlighter(-1)})});
            this.uninstalledAddOnsTable.getColumnExt(5).addHighlighter((Highlighter)new DisableSelectionHighlighter(-1));
        }
        return this.uninstalledAddOnsTable;
    }

    private String addOnToHtml(AddOn ao) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<table>");
        sb.append("<tr><td><i>");
        sb.append(Constant.messages.getString("cfu.table.header.name"));
        sb.append("</i></td><td>");
        sb.append(ao.getName());
        sb.append("</td></tr>");
        sb.append("<tr><td><i>");
        sb.append(Constant.messages.getString("cfu.table.header.status"));
        sb.append("</i></td><td>");
        sb.append(Constant.messages.getString("cfu.status." + ao.getStatus().name()));
        sb.append("</td></tr>");
        sb.append("<tr><td><i>");
        sb.append(Constant.messages.getString("cfu.table.header.id"));
        sb.append("</i></td><td>");
        sb.append(ao.getId());
        sb.append("</td></tr>");
        sb.append("<tr><td><i>");
        sb.append(Constant.messages.getString("cfu.table.header.desc"));
        sb.append("</i></td><td>");
        sb.append(ao.getDescription());
        sb.append("</td></tr>");
        sb.append("<tr><td><i>");
        sb.append(Constant.messages.getString("cfu.table.header.author"));
        sb.append("</i></td><td>");
        sb.append(ao.getAuthor());
        sb.append("</td></tr>");
        sb.append("<tr><td><i>");
        sb.append(Constant.messages.getString("cfu.table.header.changes"));
        sb.append("</i></td><td>");
        sb.append(ao.getChanges());
        sb.append("</td></tr>");
        sb.append("<tr><td><i>");
        sb.append(Constant.messages.getString("cfu.table.header.version"));
        sb.append("</i></td><td>");
        sb.append(ao.getFileVersion());
        sb.append("</td></tr>");
        sb.append("<tr><td><i>");
        sb.append(Constant.messages.getString("cfu.table.header.notbefore"));
        sb.append("</i></td><td>");
        sb.append(ao.getNotBeforeVersion());
        sb.append("</td></tr>");
        sb.append("<tr><td><i>");
        sb.append(Constant.messages.getString("cfu.table.header.notfrom"));
        sb.append("</i></td><td>");
        sb.append(ao.getNotFromVersion());
        sb.append("</td></tr>");
        if (!ao.getIdsAddOnDependencies().isEmpty()) {
            sb.append("<tr><td><i>");
            sb.append(Constant.messages.getString("cfu.table.header.dependencies"));
            sb.append("</i></td><td>");
            for (String addOnId : ao.getIdsAddOnDependencies()) {
                AddOn dep = this.installedAddOns.getAddOn(addOnId);
                if (dep == null && this.latestInfo != null) {
                    dep = this.latestInfo.getAddOn(addOnId);
                }
                if (dep != null) {
                    sb.append(dep.getName());
                } else {
                    sb.append(addOnId);
                }
                sb.append("<br>");
            }
            sb.append("</td></tr>");
        }
        sb.append("</table>");
        sb.append("</html>");
        return sb.toString();
    }

    private JLabel getUpdatesMessage() {
        if (this.updatesMessage == null) {
            this.updatesMessage = new JLabel(" ");
        }
        return this.updatesMessage;
    }

    private JButton getCoreNotesButton() {
        if (this.coreNotesButton == null) {
            this.coreNotesButton = new JButton();
            this.coreNotesButton.setIcon(new ImageIcon(ManageAddOnsDialog.class.getResource("/resource/icon/16/022.png")));
            this.coreNotesButton.setToolTipText(Constant.messages.getString("cfu.button.zap.relnotes"));
            final ManageAddOnsDialog dialog = this;
            this.coreNotesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[] strs;
                    URL url = ManageAddOnsDialog.this.latestInfo.getZapRelease().getReleaseNotesUrl();
                    if (url != null && DesktopUtils.canOpenUrlInBrowser() && DesktopUtils.openUrlInBrowser(url.toString())) {
                        return;
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("<html>");
                    sb.append(MessageFormat.format(Constant.messages.getString("cfu.title.relnotes"), ManageAddOnsDialog.this.latestInfo.getZapRelease().getVersion()));
                    for (String s : strs = ManageAddOnsDialog.this.latestInfo.getZapRelease().getReleaseNotes().split("\n")) {
                        sb.append(s.replace("&lt;", "<").trim());
                    }
                    sb.append("</html>");
                    View.getSingleton().showMessageDialog(dialog, sb.toString());
                }
            });
        }
        return this.coreNotesButton;
    }

    private JButton getClose1Button() {
        if (this.close1Button == null) {
            this.close1Button = new JButton();
            this.close1Button.setText(Constant.messages.getString("all.button.close"));
            this.close1Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManageAddOnsDialog.this.dispose();
                }
            });
        }
        return this.close1Button;
    }

    private JButton getClose2Button() {
        if (this.close2Button == null) {
            this.close2Button = new JButton();
            this.close2Button.setText(Constant.messages.getString("all.button.close"));
            this.close2Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManageAddOnsDialog.this.dispose();
                }
            });
        }
        return this.close2Button;
    }

    private JLabel getDownloadProgress() {
        if (this.downloadProgress == null) {
            this.downloadProgress = new JLabel("");
        }
        return this.downloadProgress;
    }

    private JButton getCheckForUpdatesButton() {
        if (this.checkForUpdatesButton == null) {
            this.checkForUpdatesButton = new JButton();
            this.checkForUpdatesButton.setText(Constant.messages.getString("cfu.button.checkForUpdates"));
            this.checkForUpdatesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManageAddOnsDialog.this.checkForUpdates();
                }
            });
        }
        return this.checkForUpdatesButton;
    }

    protected void checkForUpdates() {
        this.setCursor(new Cursor(3));
        this.extension.getLatestVersionInfo(this);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private JButton getDownloadZapButton() {
        if (this.downloadZapButton == null) {
            this.downloadZapButton = new JButton();
            if (Constant.isKali()) {
                this.getDownloadZapButton().setText(Constant.messages.getString("cfu.button.zap.options"));
            } else {
                this.downloadZapButton.setText(Constant.messages.getString("cfu.button.zap.download"));
            }
            this.downloadZapButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ManageAddOnsDialog.this.extension.downloadLatestRelease()) {
                        ManageAddOnsDialog.this.setDownloadingZap();
                    }
                }
            });
        }
        return this.downloadZapButton;
    }

    protected void setDownloadingZap() {
        this.downloadZapButton.setEnabled(false);
        this.getUpdateButton().setEnabled(false);
        this.getUpdateAllButton().setEnabled(false);
        this.state = State.DOWNLOADING_ZAP;
        this.getUpdatesMessage().setText(Constant.messages.getString("cfu.check.zap.downloading"));
    }

    protected void setDownloadingUpdates() {
        if (EventQueue.isDispatchThread()) {
            this.getDownloadZapButton().setEnabled(false);
            this.getUpdateButton().setEnabled(false);
            this.getUpdateAllButton().setEnabled(false);
            this.state = State.DOWNLOADING_UPDATES;
            this.getUpdatesMessage().setText(Constant.messages.getString("cfu.check.upd.downloading"));
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ManageAddOnsDialog.this.setDownloadingUpdates();
                }
            });
        }
    }

    public void notifyAddOnDownloading(AddOn addOn) {
        if (this.installedAddOnsModel.notifyAddOnDownloading(addOn)) {
            return;
        }
        this.uninstalledAddOnsModel.notifyAddOnDownloading(addOn);
    }

    public void notifyAddOnDownloadFailed(String url) {
        if (this.installedAddOnsModel.notifyAddOnDownloadFailed(url)) {
            return;
        }
        this.uninstalledAddOnsModel.notifyAddOnDownloadFailed(url);
    }

    public void notifyAddOnInstalled(final AddOn addOn) {
        if (EventQueue.isDispatchThread()) {
            if (this.latestInfo != null && this.latestInfo.getAddOn(addOn.getId()) != null) {
                this.uninstalledAddOnsModel.removeAddOn(addOn);
            }
            this.installedAddOnsModel.addOrRefreshAddOn(addOn);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ManageAddOnsDialog.this.notifyAddOnInstalled(addOn);
                }
            });
        }
    }

    public void notifyAddOnFailedUninstallation(final AddOn addOn) {
        if (EventQueue.isDispatchThread()) {
            this.installedAddOnsModel.notifyAddOnFailedUninstallation(addOn);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ManageAddOnsDialog.this.notifyAddOnFailedUninstallation(addOn);
                }
            });
        }
    }

    public void notifyAddOnUninstalled(final AddOn addOn) {
        if (EventQueue.isDispatchThread()) {
            AddOn availableAddOn;
            this.installedAddOnsModel.removeAddOn(addOn);
            if (this.latestInfo != null && (availableAddOn = this.latestInfo.getAddOn(addOn.getId())) != null) {
                this.uninstalledAddOnsModel.addAddOn(this.latestInfo.getAddOn(addOn.getId()));
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ManageAddOnsDialog.this.notifyAddOnUninstalled(addOn);
                }
            });
        }
    }

    private JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton();
            this.updateButton.setText(Constant.messages.getString("cfu.button.addons.update"));
            this.updateButton.setEnabled(false);
            this.updateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManageAddOnsDialog.this.processUpdates(ManageAddOnsDialog.this.installedAddOnsModel.getSelectedUpdates());
                }
            });
        }
        return this.updateButton;
    }

    private JButton getUpdateAllButton() {
        if (this.updateAllButton == null) {
            this.updateAllButton = new JButton();
            this.updateAllButton.setText(Constant.messages.getString("cfu.button.addons.updateAll"));
            this.updateAllButton.setEnabled(false);
            this.updateAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManageAddOnsDialog.this.processUpdates(ManageAddOnsDialog.this.installedAddOnsModel.getAllUpdates());
                }
            });
        }
        return this.updateAllButton;
    }

    private void processUpdates(Set<AddOn> updatedAddOns) {
        if (updatedAddOns.isEmpty()) {
            return;
        }
        AddOnDependencyChecker calc = new AddOnDependencyChecker(this.installedAddOns, this.latestInfo);
        AddOnDependencyChecker.AddOnChangesResult result = calc.calculateUpdateChanges(updatedAddOns);
        if (!calc.confirmUpdateChanges(this, result)) {
            return;
        }
        this.extension.processAddOnChanges(this, result);
    }

    private JButton getUninstallButton() {
        if (this.uninstallButton == null) {
            this.uninstallButton = new JButton();
            this.uninstallButton.setText(Constant.messages.getString("cfu.button.addons.uninstall"));
            this.uninstallButton.setEnabled(false);
            this.uninstallButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Set<AddOn> selectedAddOns = ManageAddOnsDialog.this.installedAddOnsModel.getSelectedAddOns();
                    if (selectedAddOns.isEmpty()) {
                        return;
                    }
                    Set<AddOn> addOnsBeingDownloaded = ManageAddOnsDialog.this.installedAddOnsModel.getDownloadingAddOns();
                    addOnsBeingDownloaded.addAll(ManageAddOnsDialog.this.uninstalledAddOnsModel.getDownloadingAddOns());
                    AddOnDependencyChecker calc = new AddOnDependencyChecker(ManageAddOnsDialog.this.installedAddOns, ManageAddOnsDialog.this.latestInfo);
                    AddOnDependencyChecker.UninstallationResult changes = calc.calculateUninstallChanges(selectedAddOns);
                    if (!calc.confirmUninstallChanges(ManageAddOnsDialog.this, changes, addOnsBeingDownloaded)) {
                        return;
                    }
                    Set<AddOn> addOns = changes.getUninstallations();
                    Set<Extension> extensions = changes.getExtensions();
                    if (!ManageAddOnsDialog.this.extension.warnUnsavedResourcesOrActiveActions(ManageAddOnsDialog.this, addOns, extensions, false)) {
                        return;
                    }
                    ManageAddOnsDialog.this.extension.uninstallAddOnsWithView(ManageAddOnsDialog.this, addOns, false, new HashSet<AddOn>());
                }
            });
        }
        return this.uninstallButton;
    }

    private JButton getInstallButton() {
        if (this.installButton == null) {
            this.installButton = new JButton();
            this.installButton.setText(Constant.messages.getString("cfu.button.addons.install"));
            this.installButton.setEnabled(false);
            this.installButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddOnDependencyChecker.AddOnChangesResult changes;
                    Set<AddOn> selectedAddOns = ManageAddOnsDialog.this.uninstalledAddOnsModel.getSelectedAddOns();
                    if (selectedAddOns.isEmpty()) {
                        return;
                    }
                    AddOnDependencyChecker calc = new AddOnDependencyChecker(ManageAddOnsDialog.this.installedAddOns, ManageAddOnsDialog.this.latestInfo);
                    if (!calc.confirmInstallChanges(ManageAddOnsDialog.this, changes = calc.calculateInstallChanges(selectedAddOns))) {
                        return;
                    }
                    ManageAddOnsDialog.this.extension.processAddOnChanges(ManageAddOnsDialog.this, changes);
                }
            });
        }
        return this.installButton;
    }

    private JButton getAddOnInfoButton() {
        if (this.addOnInfoButton == null) {
            this.addOnInfoButton = new JButton();
            this.addOnInfoButton.setText(Constant.messages.getString("cfu.button.addons.info"));
            this.addOnInfoButton.setEnabled(false);
            this.addOnInfoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddOnWrapper ao;
                    if (ManageAddOnsDialog.this.getUninstalledAddOnsTable().getSelectedRow() >= 0 && (ao = ManageAddOnsDialog.this.uninstalledAddOnsModel.getAddOnWrapper(ManageAddOnsDialog.this.getUninstalledAddOnsTable().convertRowIndexToModel(ManageAddOnsDialog.this.getUninstalledAddOnsTable().getSelectedRow()))) != null && ao.getAddOn().getInfo() != null) {
                        DesktopUtils.openUrlInBrowser(ao.getAddOn().getInfo().toString());
                    }
                }
            });
        }
        return this.addOnInfoButton;
    }

    public void showProgress() {
        if (this.state.equals((Object)State.DOWNLOADING_UPDATES)) {
            this.installedAddOnsModel.updateDownloadsProgresses(this.extension);
            this.uninstalledAddOnsModel.updateDownloadsProgresses(this.extension);
            if (this.extension.getCurrentDownloadCount() == 0) {
                this.state = State.DOWNLOADED_UPDATES;
                this.getDownloadZapButton().setEnabled(true);
                this.getUpdatesMessage().setText(Constant.messages.getString("cfu.check.upd.downloaded"));
            }
        } else if (this.state.equals((Object)State.DOWNLOADING_ZAP)) {
            try {
                int progress = this.extension.getDownloadProgressPercent(this.latestInfo.getZapRelease().getUrl());
                if (progress > 0) {
                    this.getDownloadProgress().setText(progress + "%");
                    if (progress >= 100) {
                        this.zapDownloadComplete();
                    }
                }
            }
            catch (Exception e) {
                logger.debug((Object)("Error on " + this.latestInfo.getZapRelease().getUrl()), (Throwable)e);
                this.getDownloadProgress().setText(Constant.messages.getString("cfu.table.label.failed"));
            }
        }
    }

    private void zapDownloadComplete() {
        if (this.state.equals((Object)State.DOWNLOADED_ZAP)) {
            return;
        }
        this.state = State.DOWNLOADED_ZAP;
        File f = new File(Constant.FOLDER_LOCAL_PLUGIN, this.latestInfo.getZapRelease().getFileName());
        if (Desktop.isDesktopSupported()) {
            this.extension.promptToLaunchReleaseAndClose(this.latestInfo.getZapRelease().getVersion(), f);
        } else {
            View.getSingleton().showWarningDialog(this, MessageFormat.format(Constant.messages.getString("cfu.warn.nolaunch"), this.latestInfo.getZapRelease().getVersion(), f.getAbsolutePath()));
        }
        this.getUpdateButton().setEnabled(true);
        this.getUpdateAllButton().setEnabled(true);
        this.getUpdatesMessage().setText(MessageFormat.format(Constant.messages.getString("cfu.check.zap.downloaded"), f.getAbsolutePath()));
    }

    @Override
    public void gotLatestData(AddOnCollection aoc) {
        logger.debug((Object)("gotLatestData(AddOnCollection " + aoc));
        if (aoc != null) {
            this.setLatestVersionInfo(aoc);
        } else {
            View.getSingleton().showWarningDialog(this, Constant.messages.getString("cfu.check.failed"));
        }
    }

    @Override
    public void insecureUrl(String url, Exception cause) {
        logger.error((Object)("Failed to get check for updates on " + url), (Throwable)cause);
        View.getSingleton().showWarningDialog(this, Constant.messages.getString("cfu.warn.badurl"));
    }

    private class WarningUpdateIssuesToolTipHighlighter
    extends DefaultAddOnToolTipHighlighter {
        public WarningUpdateIssuesToolTipHighlighter(int column) {
            super(column);
        }

        @Override
        protected String getToolTip(AddOnWrapper aow) {
            if (aow.hasUpdateIssues()) {
                return aow.getUpdateIssues();
            }
            return super.getToolTip(aow);
        }
    }

    private class WarningRunningIssuesToolTipHighlighter
    extends DefaultAddOnToolTipHighlighter {
        public WarningRunningIssuesToolTipHighlighter(int column) {
            super(column);
        }

        @Override
        protected String getToolTip(AddOnWrapper aow) {
            if (aow.hasRunningIssues()) {
                return aow.getRunningIssues();
            }
            return super.getToolTip(aow);
        }
    }

    private class DefaultAddOnToolTipHighlighter
    extends AbstractHighlighter {
        private final int column;

        public DefaultAddOnToolTipHighlighter(int column) {
            this.column = column;
        }

        protected Component doHighlight(Component component, ComponentAdapter adapter) {
            ((JComponent)component).setToolTipText(this.getToolTip((AddOnWrapper)adapter.getValue(this.column)));
            return component;
        }

        protected String getToolTip(AddOnWrapper aow) {
            if (AddOn.InstallationStatus.UNINSTALLATION_FAILED == aow.getInstallationStatus() || AddOn.InstallationStatus.SOFT_UNINSTALLATION_FAILED == aow.getInstallationStatus()) {
                return ManageAddOnsDialog.this.addOnToHtml(aow.getAddOn());
            }
            AddOn addOn = aow.getAddOnUpdate() != null ? aow.getAddOnUpdate() : aow.getAddOn();
            return ManageAddOnsDialog.this.addOnToHtml(addOn);
        }
    }

    private static class WarningUpdateIssuesHighlighter
    extends IconHighlighter {
        private final int columnIndex;

        public WarningUpdateIssuesHighlighter(int columnIndex) {
            this.columnIndex = columnIndex;
            this.setHighlightPredicate(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    AddOnWrapper aow = (AddOnWrapper)adapter.getValue(WarningUpdateIssuesHighlighter.this.columnIndex);
                    if (AddOnWrapper.Status.newVersion == aow.getStatus()) {
                        return aow.hasUpdateIssues();
                    }
                    return false;
                }
            });
        }

        public Icon getIcon(ComponentAdapter adapter) {
            AddOnWrapper aow = (AddOnWrapper)adapter.getValue(this.columnIndex);
            if (aow.isAddOnUpdateIssues()) {
                return ICON_ADD_ON_ISSUES;
            }
            return ICON_ADD_ON_EXTENSION_ISSUES;
        }

        protected Component doHighlight(Component component, ComponentAdapter adapter) {
            if (component instanceof IconAware) {
                ((IconAware)component).setIcon(this.getIcon(adapter));
            } else if (component instanceof JLabel) {
                ((JLabel)component).setIcon(this.getIcon(adapter));
            }
            return component;
        }
    }

    private static class WarningRunningIssuesHighlighter
    extends IconHighlighter {
        private final int columnIndex;

        public WarningRunningIssuesHighlighter(int columnIndex) {
            this.columnIndex = columnIndex;
            this.setHighlightPredicate((HighlightPredicate)new HighlightPredicate.EqualsHighlightPredicate((Object)Boolean.TRUE));
        }

        public Icon getIcon(ComponentAdapter adapter) {
            AddOnWrapper aow = (AddOnWrapper)adapter.getValue(this.columnIndex);
            if (aow.isAddOnRunningIssues()) {
                return ICON_ADD_ON_ISSUES;
            }
            return ICON_ADD_ON_EXTENSION_ISSUES;
        }

        protected Component doHighlight(Component component, ComponentAdapter adapter) {
            if (component instanceof IconAware) {
                ((IconAware)component).setIcon(this.getIcon(adapter));
            } else if (component instanceof JLabel) {
                ((JLabel)component).setIcon(this.getIcon(adapter));
            }
            return component;
        }
    }

    private static class DisableSelectionHighlighter
    extends AbstractHighlighter {
        public DisableSelectionHighlighter(final int columnIndex) {
            this.setHighlightPredicate(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    AddOn.InstallationStatus status = ((AddOnWrapper)adapter.getValue(columnIndex)).getInstallationStatus();
                    return AddOn.InstallationStatus.UNINSTALLATION_FAILED == status || AddOn.InstallationStatus.SOFT_UNINSTALLATION_FAILED == status || AddOn.InstallationStatus.DOWNLOADING == status;
                }
            });
        }

        protected Component doHighlight(Component renderer, ComponentAdapter adapter) {
            renderer.setEnabled(false);
            return renderer;
        }
    }

    protected static enum State {
        IDLE,
        DOWNLOADING_ZAP,
        DOWNLOADED_ZAP,
        DOWNLOADING_UPDATES,
        DOWNLOADED_UPDATES;

    }
}

