/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.autoupdate.ExtensionAutoUpdate;

public class AutoUpdateAPI
extends ApiImplementor {
    private static Logger log = Logger.getLogger(AutoUpdateAPI.class);
    private static final String PREFIX = "autoupdate";
    private static final String DOWNLOAD_LATEST_RELEASE = "downloadLatestRelease";
    private static final String VIEW_LATEST_VERSION_NUMBER = "latestVersionNumber";
    private static final String VIEW_IS_LATEST_VERSION = "isLatestVersion";
    private ExtensionAutoUpdate extension;

    public AutoUpdateAPI(ExtensionAutoUpdate extension) {
        this.extension = extension;
        this.addApiAction(new ApiAction(DOWNLOAD_LATEST_RELEASE));
        this.addApiView(new ApiView(VIEW_LATEST_VERSION_NUMBER));
        this.addApiView(new ApiView(VIEW_IS_LATEST_VERSION));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        log.debug((Object)("handleApiAction " + name + " " + params.toString()));
        if (DOWNLOAD_LATEST_RELEASE.equals(name)) {
            if (this.downloadLatestRelease()) {
                return ApiResponseElement.OK;
            }
            return ApiResponseElement.FAIL;
        }
        throw new ApiException(ApiException.Type.BAD_ACTION);
    }

    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        ApiResponseElement result;
        if (VIEW_LATEST_VERSION_NUMBER.equals(name)) {
            result = new ApiResponseElement(name, this.getLatestVersionNumber());
        } else if (VIEW_IS_LATEST_VERSION.equals(name)) {
            result = new ApiResponseElement(name, Boolean.toString(this.isLatestVersion()));
        } else {
            throw new ApiException(ApiException.Type.BAD_VIEW);
        }
        return result;
    }

    public String getLatestVersionNumber() {
        return this.extension.getLatestVersionNumber();
    }

    public boolean isLatestVersion() {
        return this.extension.isLatestVersion();
    }

    public boolean downloadLatestRelease() {
        return this.extension.downloadLatestRelease();
    }
}

