/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SortOrder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.core.scanner.ScannerParamFilter;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.ascan.ExcludedParameterAddDialog;
import org.zaproxy.zap.extension.ascan.ExcludedParameterModifyDialog;
import org.zaproxy.zap.extension.ascan.ExcludedParameterTableModel;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.view.AbstractMultipleOptionsBaseTablePanel;
import org.zaproxy.zap.view.LayoutHelper;

public class OptionsVariantPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private JPanel panelVariant = null;
    private JCheckBox chkInjectableQueryString = null;
    private JCheckBox chkInjectableUrlPath = null;
    private JCheckBox chkInjectablePostData = null;
    private JCheckBox chkInjectableHeaders = null;
    private JCheckBox chkInjectableHeadersAllRequests;
    private JCheckBox chkInjectableCookie = null;
    private JCheckBox chkRPCMultipart = null;
    private JCheckBox chkRPCXML = null;
    private JCheckBox chkRPCJSON = null;
    private JCheckBox chkRPCGWT = null;
    private JCheckBox chkRPCoData = null;
    private JCheckBox chkRPCDWR = null;
    private JCheckBox chkRPCCustom = null;
    private ExcludedParameterPanel excludedParamPanel;
    private ExcludedParameterTableModel excludedParamModel = null;

    public OptionsVariantPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("variant.options.title"));
        this.add((Component)this.getPanelScanner(), this.getPanelScanner().getName());
    }

    private JPanel getPanelScanner() {
        if (this.panelVariant == null) {
            this.panelVariant = new JPanel();
            this.panelVariant.setLayout(new GridBagLayout());
            this.panelVariant.setName("");
            JPanel panelInjectable = new JPanel();
            panelInjectable.setLayout(new GridBagLayout());
            panelInjectable.add((Component)this.getChkInjectableQueryString(), LayoutHelper.getGBC(0, 1, 1, 1.0, 0.0, 2, new Insets(2, 8, 2, 2)));
            panelInjectable.add((Component)this.getChkInjectablePostData(), LayoutHelper.getGBC(0, 2, 1, 1.0, 0.0, 2, new Insets(2, 8, 2, 2)));
            panelInjectable.add((Component)this.getChkInjectableUrlPath(), LayoutHelper.getGBC(0, 3, 1, 1.0, 0.0, 2, new Insets(2, 8, 2, 2)));
            panelInjectable.add((Component)this.getChkInjectableHeaders(), LayoutHelper.getGBC(0, 4, 1, 1.0, 0.0, 2, new Insets(2, 8, 2, 2)));
            panelInjectable.add((Component)this.getChkInjectableHeadersAllRequests(), LayoutHelper.getGBC(0, 5, 1, 1.0, 0.0, 2, new Insets(2, 32, 2, 2)));
            panelInjectable.add((Component)this.getChkInjectableCookie(), LayoutHelper.getGBC(0, 6, 1, 1.0, 0.0, 2, new Insets(2, 8, 2, 2)));
            this.panelVariant.add((Component)new JLabel(Constant.messages.getString("variant.options.injectable.label")), LayoutHelper.getGBC(0, 0, 1, 1.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelVariant.add((Component)panelInjectable, LayoutHelper.getGBC(0, 1, 1, 1.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            JPanel panelRPC = new JPanel();
            panelRPC.setLayout(new GridBagLayout());
            panelRPC.add((Component)this.getChkRPCMultipart(), LayoutHelper.getGBC(0, 1, 1, 1.0, 0.0, 2, new Insets(2, 8, 2, 2)));
            panelRPC.add((Component)this.getChkRPCXML(), LayoutHelper.getGBC(0, 2, 1, 1.0, 0.0, 2, new Insets(2, 8, 2, 2)));
            panelRPC.add((Component)this.getChkRPCJSON(), LayoutHelper.getGBC(0, 3, 1, 1.0, 0.0, 2, new Insets(2, 8, 2, 2)));
            panelRPC.add((Component)this.getChkRPCGWT(), LayoutHelper.getGBC(0, 4, 1, 1.0, 0.0, 2, new Insets(2, 8, 2, 2)));
            panelRPC.add((Component)this.getChkRPCoData(), LayoutHelper.getGBC(0, 5, 1, 1.0, 0.0, 2, new Insets(2, 8, 2, 2)));
            panelRPC.add((Component)this.getChkRPCDWR(), LayoutHelper.getGBC(0, 6, 1, 1.0, 0.0, 2, new Insets(2, 8, 2, 2)));
            this.panelVariant.add((Component)new JLabel(Constant.messages.getString("variant.options.rpc.label")), LayoutHelper.getGBC(1, 0, 1, 1.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelVariant.add((Component)panelRPC, LayoutHelper.getGBC(1, 1, 1, 1.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelVariant.add((Component)this.getChkRPCCustom(), LayoutHelper.getGBC(0, 2, 2, 1.0, 0.0, 2, new Insets(16, 2, 2, 2)));
            this.panelVariant.add((Component)new JLabel(Constant.messages.getString("variant.options.excludedparam.label.tokens")), LayoutHelper.getGBC(0, 3, 2, 1.0, 0.0, 2, new Insets(16, 2, 2, 2)));
            this.excludedParamPanel = new ExcludedParameterPanel(this.getExcludedParameterModel());
            this.panelVariant.add((Component)this.excludedParamPanel, LayoutHelper.getGBC(0, 4, 2, 1.0, 1.0, 1, new Insets(2, 2, 2, 2)));
        }
        return this.panelVariant;
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam options = (OptionsParam)obj;
        ScannerParam param = options.getParamSet(ScannerParam.class);
        this.initParam(param);
    }

    public void initParam(ScannerParam param) {
        int targets = param.getTargetParamsInjectable();
        this.getChkInjectableQueryString().setSelected((targets & 1) != 0);
        this.getChkInjectableUrlPath().setSelected((targets & 0x10) != 0);
        this.getChkInjectablePostData().setSelected((targets & 2) != 0);
        this.getChkInjectableHeaders().setSelected((targets & 8) != 0);
        this.getChkInjectableHeadersAllRequests().setSelected(param.isScanHeadersAllRequests());
        this.getChkInjectableHeadersAllRequests().setEnabled(this.getChkInjectableHeaders().isSelected());
        this.getChkInjectableCookie().setSelected((targets & 4) != 0);
        int rpcEnabled = param.getTargetParamsEnabledRPC();
        this.getChkRPCMultipart().setSelected((rpcEnabled & 1) != 0);
        this.getChkRPCXML().setSelected((rpcEnabled & 2) != 0);
        this.getChkRPCJSON().setSelected((rpcEnabled & 4) != 0);
        this.getChkRPCGWT().setSelected((rpcEnabled & 8) != 0);
        this.getChkRPCoData().setSelected((rpcEnabled & 0x10) != 0);
        this.getChkRPCDWR().setSelected((rpcEnabled & 0x20) != 0);
        this.getChkRPCCustom().setSelected((rpcEnabled & 0x80) != 0);
        ExtensionScript extension = (ExtensionScript)Control.getSingleton().getExtensionLoader().getExtension("ExtensionScript");
        this.getChkRPCCustom().setEnabled(extension != null);
        this.getExcludedParameterModel().setTokens(param.getExcludedParamList());
    }

    @Override
    public void validateParam(Object obj) {
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam options = (OptionsParam)obj;
        ScannerParam param = options.getParamSet(ScannerParam.class);
        this.saveParam(param);
    }

    public void saveParam(ScannerParam param) {
        int targets = 0;
        if (this.getChkInjectableQueryString().isSelected()) {
            targets |= 1;
        }
        if (this.getChkInjectableUrlPath().isSelected()) {
            targets |= 0x10;
        }
        if (this.getChkInjectablePostData().isSelected()) {
            targets |= 2;
        }
        if (this.getChkInjectableHeaders().isSelected()) {
            targets |= 8;
        }
        param.setScanHeadersAllRequests(this.getChkInjectableHeadersAllRequests().isSelected());
        if (this.getChkInjectableCookie().isSelected()) {
            targets |= 4;
        }
        param.setTargetParamsInjectable(targets);
        int enabledRpc = 0;
        if (this.getChkRPCMultipart().isSelected()) {
            enabledRpc |= 1;
        }
        if (this.getChkRPCXML().isSelected()) {
            enabledRpc |= 2;
        }
        if (this.getChkRPCJSON().isSelected()) {
            enabledRpc |= 4;
        }
        if (this.getChkRPCGWT().isSelected()) {
            enabledRpc |= 8;
        }
        if (this.getChkRPCoData().isSelected()) {
            enabledRpc |= 0x10;
        }
        if (this.getChkRPCDWR().isSelected()) {
            enabledRpc |= 0x20;
        }
        if (this.getChkRPCCustom().isSelected()) {
            enabledRpc |= 0x80;
        }
        param.setTargetParamsEnabledRPC(enabledRpc);
        param.setExcludedParamList(this.getExcludedParameterModel().getElements());
    }

    public void setAllInjectableAndRPC(boolean enabled) {
        this.getChkInjectableQueryString().setEnabled(enabled);
        this.getChkInjectableUrlPath().setEnabled(enabled);
        this.getChkInjectablePostData().setEnabled(enabled);
        this.getChkInjectableHeaders().setEnabled(enabled);
        this.getChkInjectableHeadersAllRequests().setEnabled(enabled && this.getChkInjectableHeaders().isSelected());
        this.getChkInjectableCookie().setEnabled(enabled);
        this.getChkRPCMultipart().setEnabled(enabled);
        this.getChkRPCXML().setEnabled(enabled);
        this.getChkRPCJSON().setEnabled(enabled);
        this.getChkRPCGWT().setEnabled(enabled);
        this.getChkRPCoData().setEnabled(enabled);
        this.getChkRPCDWR().setEnabled(enabled);
        this.getChkRPCCustom().setEnabled(enabled);
    }

    private ExcludedParameterTableModel getExcludedParameterModel() {
        if (this.excludedParamModel == null) {
            this.excludedParamModel = new ExcludedParameterTableModel();
        }
        return this.excludedParamModel;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.ascaninput";
    }

    private JCheckBox getChkInjectableQueryString() {
        if (this.chkInjectableQueryString == null) {
            this.chkInjectableQueryString = new JCheckBox();
            this.chkInjectableQueryString.setText(Constant.messages.getString("variant.options.injectable.querystring.label"));
        }
        return this.chkInjectableQueryString;
    }

    private JCheckBox getChkInjectableUrlPath() {
        if (this.chkInjectableUrlPath == null) {
            this.chkInjectableUrlPath = new JCheckBox();
            this.chkInjectableUrlPath.setText(Constant.messages.getString("variant.options.injectable.urlpath.label"));
        }
        return this.chkInjectableUrlPath;
    }

    private JCheckBox getChkInjectablePostData() {
        if (this.chkInjectablePostData == null) {
            this.chkInjectablePostData = new JCheckBox();
            this.chkInjectablePostData.setText(Constant.messages.getString("variant.options.injectable.postdata.label"));
        }
        return this.chkInjectablePostData;
    }

    private JCheckBox getChkInjectableHeaders() {
        if (this.chkInjectableHeaders == null) {
            this.chkInjectableHeaders = new JCheckBox();
            this.chkInjectableHeaders.setText(Constant.messages.getString("variant.options.injectable.headers.label"));
            this.chkInjectableHeaders.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    OptionsVariantPanel.this.getChkInjectableHeadersAllRequests().setEnabled(e.getStateChange() == 1);
                }
            });
        }
        return this.chkInjectableHeaders;
    }

    private JCheckBox getChkInjectableHeadersAllRequests() {
        if (this.chkInjectableHeadersAllRequests == null) {
            this.chkInjectableHeadersAllRequests = new JCheckBox();
            this.chkInjectableHeadersAllRequests.setText(Constant.messages.getString("variant.options.injectable.headersAllRequests.label"));
            this.chkInjectableHeadersAllRequests.setToolTipText(Constant.messages.getString("variant.options.injectable.headersAllRequests.toolTip"));
        }
        return this.chkInjectableHeadersAllRequests;
    }

    private JCheckBox getChkInjectableCookie() {
        if (this.chkInjectableCookie == null) {
            this.chkInjectableCookie = new JCheckBox();
            this.chkInjectableCookie.setText(Constant.messages.getString("variant.options.injectable.cookie.label"));
        }
        return this.chkInjectableCookie;
    }

    private JCheckBox getChkRPCMultipart() {
        if (this.chkRPCMultipart == null) {
            this.chkRPCMultipart = new JCheckBox();
            this.chkRPCMultipart.setText(Constant.messages.getString("variant.options.rpc.multipart.label"));
        }
        return this.chkRPCMultipart;
    }

    private JCheckBox getChkRPCXML() {
        if (this.chkRPCXML == null) {
            this.chkRPCXML = new JCheckBox();
            this.chkRPCXML.setText(Constant.messages.getString("variant.options.rpc.xml.label"));
        }
        return this.chkRPCXML;
    }

    private JCheckBox getChkRPCJSON() {
        if (this.chkRPCJSON == null) {
            this.chkRPCJSON = new JCheckBox();
            this.chkRPCJSON.setText(Constant.messages.getString("variant.options.rpc.json.label"));
        }
        return this.chkRPCJSON;
    }

    private JCheckBox getChkRPCGWT() {
        if (this.chkRPCGWT == null) {
            this.chkRPCGWT = new JCheckBox();
            this.chkRPCGWT.setText(Constant.messages.getString("variant.options.rpc.gwt.label"));
        }
        return this.chkRPCGWT;
    }

    private JCheckBox getChkRPCoData() {
        if (this.chkRPCoData == null) {
            this.chkRPCoData = new JCheckBox();
            this.chkRPCoData.setText(Constant.messages.getString("variant.options.rpc.odata.label"));
        }
        return this.chkRPCoData;
    }

    private JCheckBox getChkRPCDWR() {
        if (this.chkRPCDWR == null) {
            this.chkRPCDWR = new JCheckBox();
            this.chkRPCDWR.setText(Constant.messages.getString("variant.options.rpc.dwr.label"));
        }
        return this.chkRPCDWR;
    }

    private JCheckBox getChkRPCCustom() {
        if (this.chkRPCCustom == null) {
            this.chkRPCCustom = new JCheckBox();
            this.chkRPCCustom.setText(Constant.messages.getString("variant.options.rpc.custom.label"));
        }
        return this.chkRPCCustom;
    }

    private static class ExcludedParameterPanel
    extends AbstractMultipleOptionsBaseTablePanel<ScannerParamFilter> {
        private static final long serialVersionUID = 1L;
        private static final String REMOVE_DIALOG_TITLE = Constant.messages.getString("variant.options.excludedparam.dialog.token.remove.title");
        private static final String REMOVE_DIALOG_TEXT = Constant.messages.getString("variant.options.excludedparam.dialog.token.remove.text");
        private static final String REMOVE_DIALOG_CONFIRM_BUTTON_LABEL = Constant.messages.getString("variant.options.excludedparam.dialog.token.remove.button.confirm");
        private static final String REMOVE_DIALOG_CANCEL_BUTTON_LABEL = Constant.messages.getString("variant.options.excludedparam.dialog.token.remove.button.cancel");
        private static final String REMOVE_DIALOG_CHECKBOX_LABEL = Constant.messages.getString("variant.options.excludedparam.dialog.token.remove.checkbox.label");
        private ExcludedParameterAddDialog addDialog = null;
        private ExcludedParameterModifyDialog modifyDialog = null;

        public ExcludedParameterPanel(ExcludedParameterTableModel model) {
            super(model);
            this.getTable().setSortOrder(0, SortOrder.ASCENDING);
            this.getTable().getColumnModel().getColumn(0).setPreferredWidth(100);
            this.getTable().getColumnModel().getColumn(1).setPreferredWidth(50);
            this.getTable().getColumnModel().getColumn(2).setPreferredWidth(200);
        }

        @Override
        public ScannerParamFilter showAddDialogue() {
            if (this.addDialog == null) {
                this.addDialog = new ExcludedParameterAddDialog(View.getSingleton().getOptionsDialog(null));
                this.addDialog.pack();
            }
            this.addDialog.setTokens(this.model.getElements());
            this.addDialog.setVisible(true);
            ScannerParamFilter filter = this.addDialog.getToken();
            this.addDialog.clear();
            return filter;
        }

        @Override
        public ScannerParamFilter showModifyDialogue(ScannerParamFilter e) {
            if (this.modifyDialog == null) {
                this.modifyDialog = new ExcludedParameterModifyDialog(View.getSingleton().getOptionsDialog(null));
                this.modifyDialog.pack();
            }
            this.modifyDialog.setTokens(this.model.getElements());
            this.modifyDialog.setToken(e);
            this.modifyDialog.setVisible(true);
            ScannerParamFilter token = this.modifyDialog.getToken();
            this.modifyDialog.clear();
            if (!token.equals(e)) {
                return token;
            }
            return null;
        }

        @Override
        public boolean showRemoveDialogue(ScannerParamFilter e) {
            JCheckBox removeWithoutConfirmationCB = new JCheckBox(REMOVE_DIALOG_CHECKBOX_LABEL);
            Object[] messages = new Object[]{REMOVE_DIALOG_TEXT, " ", removeWithoutConfirmationCB};
            int option = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), messages, REMOVE_DIALOG_TITLE, 2, 3, null, new String[]{REMOVE_DIALOG_CONFIRM_BUTTON_LABEL, REMOVE_DIALOG_CANCEL_BUTTON_LABEL}, null);
            return option == 0;
        }
    }
}

