/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.ascan.ChallengeCallbackPlugin;

public abstract class ChallengeCallbackAPI
extends ApiImplementor {
    private static final String API_RESPONSE_KO = "ko";
    private static final String API_RESPONSE_OK = "ok";
    private static final long CALLBACK_EXPIRE_TIME = 120000L;
    private static final Logger logger = Logger.getLogger(ChallengeCallbackAPI.class);
    private final Map<String, RegisteredCallback> regCallbacks = Collections.synchronizedMap(new TreeMap());

    public ChallengeCallbackAPI() {
        this.addApiShortcut(this.getPrefix());
    }

    @Override
    public abstract String getPrefix();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanExpiredCallbacks() {
        long now = System.currentTimeMillis();
        Map<String, RegisteredCallback> map = this.regCallbacks;
        synchronized (map) {
            Iterator<Map.Entry<String, RegisteredCallback>> it = this.regCallbacks.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, RegisteredCallback> entry = it.next();
                if (now - entry.getValue().getTimestamp() <= 120000L) continue;
                it.remove();
            }
        }
    }

    public String getCallbackUrl(String challenge) {
        String callbackUrl = "http://" + Model.getSingleton().getOptionsParam().getProxyParam().getProxyIp() + ":" + Model.getSingleton().getOptionsParam().getProxyParam().getProxyPort() + "/" + this.getPrefix() + "/" + challenge;
        return callbackUrl;
    }

    @Override
    public HttpMessage handleShortcut(HttpMessage msg) throws ApiException {
        try {
            String response;
            RegisteredCallback rcback;
            String path = msg.getRequestHeader().getURI().getPath();
            String challenge = path.substring(path.indexOf(this.getPrefix()) + this.getPrefix().length() + 1);
            if (challenge.charAt(challenge.length() - 1) == '/') {
                challenge = challenge.substring(0, challenge.length() - 1);
            }
            if ((rcback = this.regCallbacks.get(challenge)) != null) {
                rcback.getPlugin().notifyCallback(challenge, rcback.getAttackMessage());
                response = API_RESPONSE_OK;
                this.regCallbacks.remove(challenge);
            } else {
                response = API_RESPONSE_KO;
                this.cleanExpiredCallbacks();
            }
            msg.setResponseHeader("HTTP/1.1 200 OK\r\nPragma: no-cache\r\nCache-Control: no-cache\r\nAccess-Control-Allow-Origin: *\r\nAccess-Control-Allow-Methods: GET,POST,OPTIONS\r\nAccess-Control-Allow-Headers: ZAP-Header\r\nContent-Length: " + response.length() + "\r\nContent-Type: text/html;");
            msg.setResponseBody(response);
        }
        catch (URIException | HttpMalformedHeaderException e) {
            logger.warn((Object)e.getMessage(), e);
        }
        return msg;
    }

    public void registerCallback(String challenge, ChallengeCallbackPlugin plugin, HttpMessage attack) {
        this.cleanExpiredCallbacks();
        this.regCallbacks.put(challenge, new RegisteredCallback(plugin, attack));
    }

    private static class RegisteredCallback {
        private final ChallengeCallbackPlugin plugin;
        private HistoryReference hRef;
        private long timeStamp;

        public RegisteredCallback(ChallengeCallbackPlugin plugin, HttpMessage msg) {
            this.plugin = plugin;
            this.timeStamp = System.currentTimeMillis();
            try {
                this.hRef = new HistoryReference(Model.getSingleton().getSession(), 0, msg);
            }
            catch (DatabaseException | HttpMalformedHeaderException exception) {
                // empty catch block
            }
        }

        public ChallengeCallbackPlugin getPlugin() {
            return this.plugin;
        }

        public HttpMessage getAttackMessage() {
            try {
                if (this.hRef != null) {
                    return this.hRef.getHttpMessage();
                }
            }
            catch (DatabaseException | HttpMalformedHeaderException exception) {
                // empty catch block
            }
            return null;
        }

        public long getTimestamp() {
            return this.timeStamp;
        }
    }
}

