/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiGeneratorUtils;
import org.zaproxy.zap.extension.api.ApiImplementor;

public class NodeJSAPIGenerator {
    private File dir;
    private boolean optional = false;
    private final String HEADER = "/* Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright 2016 the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n";
    private final String OPTIONAL_MASSAGE = "This component is optional and therefore the API will only work if it is installed";
    private ResourceBundle msgs = ResourceBundle.getBundle("lang.Messages", Locale.ENGLISH, ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES));
    private static final Map<String, String> nameMap;

    public NodeJSAPIGenerator() {
        this.dir = new File("nodejs/api/zapv2");
    }

    public NodeJSAPIGenerator(String path, boolean optional) {
        this.dir = new File(path);
        this.optional = optional;
    }

    public void generateNodeJSFiles(List<ApiImplementor> implementors) throws IOException {
        for (ApiImplementor imp : implementors) {
            this.generateNodeJSComponent(imp);
        }
    }

    private void generateNodeJSElement(ApiElement element, String component, String type, Writer out) throws IOException {
        boolean hasParams;
        String className;
        block27: {
            className = NodeJSAPIGenerator.createClassName(component);
            hasParams = false;
            String descTag = element.getDescriptionTag();
            if (descTag == null) {
                descTag = component + ".api." + type + "." + element.getName();
            }
            try {
                String desc = this.msgs.getString(descTag);
                out.write("/**\n");
                out.write(" * " + desc + "\n");
                if (this.optional) {
                    out.write(" * This component is optional and therefore the API will only work if it is installed\n");
                }
                out.write(" **/\n");
            }
            catch (Exception e) {
                System.out.println("No i18n for: " + descTag);
                if (!this.optional) break block27;
                out.write("/**\n");
                out.write(" * This component is optional and therefore the API will only work if it is installed\n");
                out.write(" **/\n");
            }
        }
        out.write(className + ".prototype." + NodeJSAPIGenerator.createMethodName(element.getName()) + " = function (");
        if (element.getMandatoryParamNames() != null) {
            for (String param : element.getMandatoryParamNames()) {
                if (!hasParams) {
                    hasParams = true;
                } else {
                    out.write(", ");
                }
                out.write(NodeJSAPIGenerator.safeName(param.toLowerCase()));
            }
        }
        if (element.getOptionalParamNames() != null) {
            for (String param : element.getOptionalParamNames()) {
                if (!hasParams) {
                    hasParams = true;
                } else {
                    out.write(", ");
                }
                out.write(NodeJSAPIGenerator.safeName(param.toLowerCase()));
            }
        }
        if (type.equals("action") || type.equals("other")) {
            if (hasParams) {
                out.write(", ");
            }
            hasParams = true;
            out.write(API.API_KEY_PARAM);
        }
        if (hasParams) {
            out.write(", ");
        }
        out.write("callback) {\n");
        if (type.equals("action") || type.equals("other")) {
            out.write("  if (!callback && typeof(" + API.API_KEY_PARAM + ") === 'function') {\n");
            out.write("    callback = " + API.API_KEY_PARAM + ";\n");
            out.write("    " + API.API_KEY_PARAM + " = null;\n");
            out.write("  }\n");
        }
        StringBuilder reqParams = new StringBuilder();
        if (hasParams) {
            reqParams.append("{");
            boolean first = true;
            if (element.getMandatoryParamNames() != null) {
                for (String param : element.getMandatoryParamNames()) {
                    if (first) {
                        first = false;
                    } else {
                        reqParams.append(", ");
                    }
                    reqParams.append("'" + param + "' : " + NodeJSAPIGenerator.safeName(param.toLowerCase()));
                }
            }
            if (type.equals("action") || type.equals("other")) {
                if (!first) {
                    reqParams.append(", ");
                }
                reqParams.append("'" + API.API_KEY_PARAM + "' : " + API.API_KEY_PARAM);
            }
            reqParams.append("}");
            if (element.getOptionalParamNames() != null && !element.getOptionalParamNames().isEmpty()) {
                out.write("  var params = ");
                out.write(reqParams.toString());
                out.write(";\n");
                reqParams.replace(0, reqParams.length(), "params");
                for (String param : element.getOptionalParamNames()) {
                    out.write("  if (" + NodeJSAPIGenerator.safeName(param.toLowerCase()) + " && " + NodeJSAPIGenerator.safeName(param.toLowerCase()) + " !== null) {\n");
                    out.write("    params['" + param + "'] = " + NodeJSAPIGenerator.safeName(param.toLowerCase()) + ";\n");
                    out.write("  }\n");
                }
            }
        }
        String method = "request";
        if (type.equals("other")) {
            method = "requestOther";
        }
        out.write("  this.api." + method + "('/" + component + "/" + type + "/" + element.getName() + "/'");
        if (hasParams) {
            out.write(", ");
            out.write(reqParams.toString());
        }
        out.write(", callback);\n");
        out.write("};\n\n");
    }

    private static String safeName(String name) {
        if (nameMap.containsKey(name)) {
            return nameMap.get(name);
        }
        return name;
    }

    private static String createFileName(String name) {
        return NodeJSAPIGenerator.safeName(name) + ".js";
    }

    private static String createMethodName(String name) {
        return NodeJSAPIGenerator.removeAllFullStopCharacters(NodeJSAPIGenerator.safeName(name));
    }

    private static String createClassName(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private static String removeAllFullStopCharacters(String string) {
        return string.replaceAll("\\.", "");
    }

    private void generateNodeJSComponent(ApiImplementor imp) throws IOException {
        String className = NodeJSAPIGenerator.createClassName(imp.getPrefix());
        File f = new File(this.dir, NodeJSAPIGenerator.createFileName(imp.getPrefix()));
        System.out.println("Generating " + f.getAbsolutePath());
        FileWriter out = new FileWriter(f);
        out.write("/* Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright 2016 the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n");
        out.write("'use strict';\n\n");
        out.write("/**\n");
        out.write(" * This file was automatically generated.\n");
        out.write(" */\n");
        out.write("function " + className + "(clientApi) {\n");
        out.write("  this.api = clientApi;\n");
        out.write("}\n\n");
        for (ApiElement apiElement : imp.getApiViews()) {
            this.generateNodeJSElement(apiElement, imp.getPrefix(), "view", out);
        }
        for (ApiElement apiElement : imp.getApiActions()) {
            this.generateNodeJSElement(apiElement, imp.getPrefix(), "action", out);
        }
        for (ApiElement apiElement : imp.getApiOthers()) {
            this.generateNodeJSElement(apiElement, imp.getPrefix(), "other", out);
        }
        out.write("module.exports = " + className + ";\n");
        out.close();
    }

    public static void main(String[] args) throws Exception {
        NodeJSAPIGenerator wapi = new NodeJSAPIGenerator();
        wapi.generateNodeJSFiles(ApiGeneratorUtils.getAllImplementors());
    }

    static {
        HashMap<String, String> initMap = new HashMap<String, String>();
        initMap.put("break", "brk");
        initMap.put("boolean", "bool");
        nameMap = Collections.unmodifiableMap(initMap);
    }
}

