/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import javax.swing.JOptionPane;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ContextAPI;
import org.zaproxy.zap.extension.api.CoreAPI;
import org.zaproxy.zap.extension.api.OptionsApiPanel;
import org.zaproxy.zap.utils.DesktopUtils;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionAPI
extends ExtensionAdaptor
implements SessionChangedListener {
    public static final String NAME = "ExtensionAPI";
    public static final String API_URL = "http://zap/";
    private OptionsApiPanel optionsApiPanel = null;
    private ZapMenuItem menuAPI = null;
    private CoreAPI coreApi = null;

    public ExtensionAPI() {
        this.initialize();
    }

    public ExtensionAPI(String name) {
        super(name);
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(10);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addSessionListener(this);
        if (this.getView() != null) {
            extensionHook.getHookView().addOptionPanel(this.getOptionsAPIPanel());
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuAPI());
        }
        this.coreApi = new CoreAPI();
        this.coreApi.addApiOptions(extensionHook.getModel().getOptionsParam().getConnectionParam());
        API.getInstance().registerApiImplementor(this.coreApi);
        API.getInstance().registerApiImplementor(new ContextAPI());
    }

    private OptionsApiPanel getOptionsAPIPanel() {
        if (this.optionsApiPanel == null) {
            this.optionsApiPanel = new OptionsApiPanel();
        }
        return this.optionsApiPanel;
    }

    public static String generateApiKey() {
        SecureRandom random = new SecureRandom();
        return new BigInteger(130, random).toString(32);
    }

    private ZapMenuItem getMenuAPI() {
        if (this.menuAPI == null) {
            this.menuAPI = new ZapMenuItem("api.menu.tools.url");
            this.menuAPI.setEnabled(DesktopUtils.canOpenUrlInBrowser());
            this.menuAPI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!API.getInstance().isEnabled()) {
                        String title = Constant.messages.getString("api.dialogue.browseApiNotEnabled.title");
                        String message = Constant.messages.getString("api.dialogue.browseApiNotEnabled.message");
                        String confirmButtonLabel = Constant.messages.getString("api.dialogue.browseApiNotEnabled.button.confirm.label");
                        String cancelButtonLabel = Constant.messages.getString("api.dialogue.browseApiNotEnabled.button.cancel.label");
                        int option = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), message, title, 0, 3, null, new String[]{confirmButtonLabel, cancelButtonLabel}, null);
                        if (option != 0) {
                            return;
                        }
                        Model.getSingleton().getOptionsParam().getApiParam().setEnabled(true);
                    }
                    DesktopUtils.openUrlInBrowser(ExtensionAPI.API_URL);
                }
            });
        }
        return this.menuAPI;
    }

    @Override
    public void sessionChanged(Session session) {
    }

    @Override
    public void sessionAboutToChange(Session session) {
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("api.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    public CoreAPI getCoreAPI() {
        return this.coreApi;
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    @Override
    public boolean supportsLowMemory() {
        return true;
    }
}

