/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import edu.umass.cs.benchlab.har.HarEntries;
import edu.umass.cs.benchlab.har.HarLog;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.tree.TreeNode;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.proxy.ProxyParam;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordAlert;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.db.TableAlert;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.extension.report.ReportGenerator;
import org.parosproxy.paros.extension.report.ReportLastScan;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SessionListener;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.network.HttpStatusCode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiOther;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseConversionUtils;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.dynssl.ExtensionDynSSL;
import org.zaproxy.zap.model.SessionUtils;
import org.zaproxy.zap.utils.HarUtils;

public class CoreAPI
extends ApiImplementor
implements SessionListener {
    private static final Logger logger = Logger.getLogger(CoreAPI.class);
    private static final String PREFIX = "core";
    private static final String ACTION_LOAD_SESSION = "loadSession";
    private static final String ACTION_NEW_SESSION = "newSession";
    private static final String ACTION_SAVE_SESSION = "saveSession";
    private static final String ACTION_SNAPSHOT_SESSION = "snapshotSession";
    private static final String ACTION_ACCESS_URL = "accessUrl";
    private static final String ACTION_SHUTDOWN = "shutdown";
    private static final String ACTION_EXCLUDE_FROM_PROXY = "excludeFromProxy";
    private static final String ACTION_CLEAR_EXCLUDED_FROM_PROXY = "clearExcludedFromProxy";
    private static final String ACTION_SET_HOME_DIRECTORY = "setHomeDirectory";
    private static final String ACTION_GENERATE_ROOT_CA = "generateRootCA";
    private static final String ACTION_SEND_REQUEST = "sendRequest";
    private static final String ACTION_DELETE_ALL_ALERTS = "deleteAllAlerts";
    private static final String ACTION_COLLECT_GARBAGE = "runGarbageCollection";
    private static final String ACTION_SET_MODE = "setMode";
    private static final String ACTION_DELETE_SITE_NODE = "deleteSiteNode";
    private static final String VIEW_ALERT = "alert";
    private static final String VIEW_ALERTS = "alerts";
    private static final String VIEW_NUMBER_OF_ALERTS = "numberOfAlerts";
    private static final String VIEW_HOSTS = "hosts";
    private static final String VIEW_SITES = "sites";
    private static final String VIEW_URLS = "urls";
    private static final String VIEW_MESSAGE = "message";
    private static final String VIEW_MESSAGES = "messages";
    private static final String VIEW_MODE = "mode";
    private static final String VIEW_NUMBER_OF_MESSAGES = "numberOfMessages";
    private static final String VIEW_VERSION = "version";
    private static final String VIEW_EXCLUDED_FROM_PROXY = "excludedFromProxy";
    private static final String VIEW_HOME_DIRECTORY = "homeDirectory";
    private static final String OTHER_PROXY_PAC = "proxy.pac";
    private static final String OTHER_SET_PROXY = "setproxy";
    private static final String OTHER_ROOT_CERT = "rootcert";
    private static final String OTHER_XML_REPORT = "xmlreport";
    private static final String OTHER_HTML_REPORT = "htmlreport";
    private static final String OTHER_MESSAGE_HAR = "messageHar";
    private static final String OTHER_MESSAGES_HAR = "messagesHar";
    private static final String OTHER_SEND_HAR_REQUEST = "sendHarRequest";
    private static final String PARAM_BASE_URL = "baseurl";
    private static final String PARAM_COUNT = "count";
    private static final String PARAM_DIR = "dir";
    private static final String PARAM_SESSION = "name";
    private static final String PARAM_OVERWRITE_SESSION = "overwrite";
    private static final String PARAM_REGEX = "regex";
    private static final String PARAM_START = "start";
    private static final String PARAM_PROXY_DETAILS = "proxy";
    private static final String PARAM_ID = "id";
    private static final String PARAM_REQUEST = "request";
    private static final String PARAM_FOLLOW_REDIRECTS = "followRedirects";
    private static final String PARAM_MODE = "mode";
    private static final String PARAM_URL = "url";
    private static final String PARAM_METHOD = "method";
    private static final String PARAM_POST_DATA = "postData";
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private boolean savingSession = false;
    private static ExtensionHistory extHistory;

    public CoreAPI() {
        this.addApiAction(new ApiAction(ACTION_ACCESS_URL, new String[]{PARAM_URL}, new String[]{PARAM_FOLLOW_REDIRECTS}));
        this.addApiAction(new ApiAction(ACTION_SHUTDOWN));
        this.addApiAction(new ApiAction(ACTION_NEW_SESSION, null, new String[]{PARAM_SESSION, PARAM_OVERWRITE_SESSION}));
        this.addApiAction(new ApiAction(ACTION_LOAD_SESSION, new String[]{PARAM_SESSION}));
        this.addApiAction(new ApiAction(ACTION_SAVE_SESSION, new String[]{PARAM_SESSION}, new String[]{PARAM_OVERWRITE_SESSION}));
        this.addApiAction(new ApiAction(ACTION_SNAPSHOT_SESSION));
        this.addApiAction(new ApiAction(ACTION_CLEAR_EXCLUDED_FROM_PROXY));
        this.addApiAction(new ApiAction(ACTION_EXCLUDE_FROM_PROXY, new String[]{PARAM_REGEX}));
        this.addApiAction(new ApiAction(ACTION_SET_HOME_DIRECTORY, new String[]{PARAM_DIR}));
        this.addApiAction(new ApiAction(ACTION_SET_MODE, new String[]{"mode"}));
        this.addApiAction(new ApiAction(ACTION_GENERATE_ROOT_CA));
        this.addApiAction(new ApiAction(ACTION_SEND_REQUEST, new String[]{PARAM_REQUEST}, new String[]{PARAM_FOLLOW_REDIRECTS}));
        this.addApiAction(new ApiAction(ACTION_DELETE_ALL_ALERTS));
        this.addApiAction(new ApiAction(ACTION_COLLECT_GARBAGE));
        this.addApiAction(new ApiAction(ACTION_DELETE_SITE_NODE, new String[]{PARAM_URL}, new String[]{PARAM_METHOD, PARAM_POST_DATA}));
        this.addApiView(new ApiView(VIEW_ALERT, new String[]{PARAM_ID}));
        this.addApiView(new ApiView(VIEW_ALERTS, null, new String[]{PARAM_BASE_URL, PARAM_START, PARAM_COUNT}));
        this.addApiView(new ApiView(VIEW_NUMBER_OF_ALERTS, null, new String[]{PARAM_BASE_URL}));
        this.addApiView(new ApiView(VIEW_HOSTS));
        this.addApiView(new ApiView(VIEW_SITES));
        this.addApiView(new ApiView(VIEW_URLS));
        this.addApiView(new ApiView(VIEW_MESSAGE, new String[]{PARAM_ID}));
        this.addApiView(new ApiView(VIEW_MESSAGES, null, new String[]{PARAM_BASE_URL, PARAM_START, PARAM_COUNT}));
        this.addApiView(new ApiView(VIEW_NUMBER_OF_MESSAGES, null, new String[]{PARAM_BASE_URL}));
        this.addApiView(new ApiView("mode"));
        this.addApiView(new ApiView(VIEW_VERSION));
        this.addApiView(new ApiView(VIEW_EXCLUDED_FROM_PROXY));
        this.addApiView(new ApiView(VIEW_HOME_DIRECTORY));
        this.addApiOthers(new ApiOther(OTHER_PROXY_PAC, false));
        this.addApiOthers(new ApiOther(OTHER_ROOT_CERT, false));
        this.addApiOthers(new ApiOther(OTHER_SET_PROXY, new String[]{PARAM_PROXY_DETAILS}));
        this.addApiOthers(new ApiOther(OTHER_XML_REPORT));
        this.addApiOthers(new ApiOther(OTHER_HTML_REPORT));
        this.addApiOthers(new ApiOther(OTHER_MESSAGE_HAR, new String[]{PARAM_ID}));
        this.addApiOthers(new ApiOther(OTHER_MESSAGES_HAR, null, new String[]{PARAM_BASE_URL, PARAM_START, PARAM_COUNT}));
        this.addApiOthers(new ApiOther(OTHER_SEND_HAR_REQUEST, new String[]{PARAM_REQUEST}, new String[]{PARAM_FOLLOW_REDIRECTS}));
        this.addApiShortcut(OTHER_PROXY_PAC);
        this.addApiShortcut(OTHER_SET_PROXY);
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        Session session = Model.getSingleton().getSession();
        if (ACTION_ACCESS_URL.equals(name)) {
            URI uri;
            try {
                uri = new URI(params.getString(PARAM_URL), true);
            }
            catch (URIException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL, e);
            }
            try {
                HttpMessage request = new HttpMessage(new HttpRequestHeader("GET", uri, "HTTP/1.1", Model.getSingleton().getOptionsParam().getConnectionParam()));
                return this.sendHttpMessage(request, this.getParam(params, PARAM_FOLLOW_REDIRECTS, false), name);
            }
            catch (HttpMalformedHeaderException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL, e);
            }
        }
        if (ACTION_SHUTDOWN.equals(name)) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        1.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Control.getSingleton().shutdown(Model.getSingleton().getOptionsParam().getDatabaseParam().isCompactDatabase());
                    logger.info((Object)(Constant.PROGRAM_TITLE + " terminated."));
                    System.exit(0);
                }
            };
            thread.start();
            return ApiResponseElement.OK;
        }
        if (ACTION_SAVE_SESSION.equalsIgnoreCase(name)) {
            Path sessionPath = SessionUtils.getSessionPath(params.getString(PARAM_SESSION));
            String filename = sessionPath.toAbsolutePath().toString();
            boolean overwrite = this.getParam(params, PARAM_OVERWRITE_SESSION, false);
            boolean sameSession = false;
            if (!session.isNewState()) {
                try {
                    sameSession = Files.isSameFile(Paths.get(session.getFileName(), new String[0]), sessionPath);
                }
                catch (IOException e) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                }
            }
            if (Files.exists(sessionPath, new LinkOption[0]) && (!overwrite || sameSession)) {
                throw new ApiException(ApiException.Type.ALREADY_EXISTS, filename);
            }
            this.savingSession = true;
            try {
                Control.getSingleton().saveSession(filename, this);
            }
            catch (Exception e) {
                this.savingSession = false;
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
            }
            try {
                while (this.savingSession) {
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException e) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            logger.debug((Object)"Can now return after saving session");
            return ApiResponseElement.OK;
        }
        if (ACTION_SNAPSHOT_SESSION.equalsIgnoreCase(name)) {
            if (session.isNewState()) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
            }
            String fileName = session.getFileName();
            if (fileName.endsWith(".session")) {
                fileName = fileName.substring(0, fileName.length() - 8);
            }
            fileName = fileName + "-" + this.dateFormat.format(new Date()) + ".session";
            this.savingSession = true;
            try {
                Control.getSingleton().snapshotSession(fileName, this);
            }
            catch (Exception e) {
                this.savingSession = false;
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
            }
            try {
                while (this.savingSession) {
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException e) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            logger.debug((Object)"Can now return after saving session");
            return ApiResponseElement.OK;
        }
        if (ACTION_LOAD_SESSION.equalsIgnoreCase(name)) {
            Path sessionPath = SessionUtils.getSessionPath(params.getString(PARAM_SESSION));
            String filename = sessionPath.toAbsolutePath().toString();
            if (!Files.exists(sessionPath, new LinkOption[0])) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, filename);
            }
            try {
                Control.getSingleton().runCommandLineOpenSession(filename);
                return ApiResponseElement.OK;
            }
            catch (Exception e) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
            }
        }
        if (ACTION_NEW_SESSION.equalsIgnoreCase(name)) {
            String sessionName = null;
            try {
                sessionName = params.getString(PARAM_SESSION);
            }
            catch (Exception filename) {
                // empty catch block
            }
            if (sessionName == null || sessionName.length() == 0) {
                Control.getSingleton().discardSession();
                try {
                    Control.getSingleton().newSession();
                    return ApiResponseElement.OK;
                }
                catch (Exception e) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                }
            } else {
                Path sessionPath = SessionUtils.getSessionPath(sessionName);
                String filename = sessionPath.toAbsolutePath().toString();
                boolean overwrite = this.getParam(params, PARAM_OVERWRITE_SESSION, false);
                if (Files.exists(sessionPath, new LinkOption[0]) && !overwrite) {
                    throw new ApiException(ApiException.Type.ALREADY_EXISTS, filename);
                }
                try {
                    Control.getSingleton().runCommandLineNewSession(filename);
                    return ApiResponseElement.OK;
                }
                catch (Exception e) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                }
            }
        }
        if (ACTION_CLEAR_EXCLUDED_FROM_PROXY.equals(name)) {
            try {
                session.setExcludeFromProxyRegexs(new ArrayList<String>());
                return ApiResponseElement.OK;
            }
            catch (DatabaseException e) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
            }
        }
        if (ACTION_EXCLUDE_FROM_PROXY.equals(name)) {
            String regex = params.getString(PARAM_REGEX);
            try {
                session.addExcludeFromProxyRegex(regex);
                return ApiResponseElement.OK;
            }
            catch (DatabaseException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
            }
            catch (PatternSyntaxException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_REGEX);
            }
        }
        if (ACTION_SET_HOME_DIRECTORY.equals(name)) {
            File f = new File(params.getString(PARAM_DIR));
            if (!f.exists() || !f.isDirectory()) throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_DIR);
            Model.getSingleton().getOptionsParam().setUserDirectory(f);
            return ApiResponseElement.OK;
        }
        if (ACTION_SET_MODE.equals(name)) {
            try {
                Control.Mode mode = Control.Mode.valueOf(params.getString("mode").toLowerCase());
                if (View.isInitialised()) {
                    View.getSingleton().getMainFrame().getMainToolbarPanel().setMode(mode);
                    return ApiResponseElement.OK;
                }
                Control.getSingleton().setMode(mode);
                return ApiResponseElement.OK;
            }
            catch (Exception e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "mode");
            }
        }
        if (ACTION_GENERATE_ROOT_CA.equals(name)) {
            ExtensionDynSSL extDyn = (ExtensionDynSSL)Control.getSingleton().getExtensionLoader().getExtension("ExtensionDynSSL");
            if (extDyn == null) return ApiResponseElement.OK;
            try {
                extDyn.createNewRootCa();
                return ApiResponseElement.OK;
            }
            catch (Exception e) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
            }
        }
        if (ACTION_SEND_REQUEST.equals(name)) {
            try {
                HttpMessage request = CoreAPI.createRequest(params.getString(PARAM_REQUEST));
                return this.sendHttpMessage(request, this.getParam(params, PARAM_FOLLOW_REDIRECTS, false), name);
            }
            catch (HttpMalformedHeaderException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_REQUEST, e);
            }
        }
        if (ACTION_DELETE_ALL_ALERTS.equals(name)) {
            ExtensionAlert extAlert = (ExtensionAlert)Control.getSingleton().getExtensionLoader().getExtension("ExtensionAlert");
            if (extAlert != null) {
                extAlert.deleteAllAlerts();
                return ApiResponseElement.OK;
            }
            try {
                Model.getSingleton().getDb().getTableAlert().deleteAllAlerts();
            }
            catch (DatabaseException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            SiteNode rootNode = (SiteNode)Model.getSingleton().getSession().getSiteTree().getRoot();
            rootNode.deleteAllAlerts();
            CoreAPI.removeHistoryReferenceAlerts(rootNode);
            return ApiResponseElement.OK;
        }
        if (ACTION_COLLECT_GARBAGE.equals(name)) {
            System.gc();
            return ApiResponseElement.OK;
        }
        if (!ACTION_DELETE_SITE_NODE.equals(name)) throw new ApiException(ApiException.Type.BAD_ACTION);
        try {
            String url = params.getString(PARAM_URL);
            String method = this.getParam(params, PARAM_METHOD, "GET");
            String postData = this.getParam(params, PARAM_POST_DATA, "");
            URI uri = new URI(url, true);
            SiteMap siteMap = session.getSiteTree();
            SiteNode siteNode = siteMap.findNode(uri, method, postData);
            if (siteNode == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_URL);
            }
            if (CoreAPI.getExtHistory() == null) return ApiResponseElement.OK;
            CoreAPI.getExtHistory().purge(siteMap, siteNode);
            return ApiResponseElement.OK;
        }
        catch (URIException e) {
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL, e);
        }
    }

    private ApiResponse sendHttpMessage(HttpMessage request, boolean followRedirects, String apiResponseName) throws ApiException {
        final ApiResponseList resultList = new ApiResponseList(apiResponseName);
        try {
            CoreAPI.sendRequest(request, followRedirects, new Processor<HttpMessage>(){

                @Override
                public void process(HttpMessage msg) {
                    int id = msg.getHistoryRef() != null ? msg.getHistoryRef().getHistoryId() : -1;
                    resultList.addItem(ApiResponseConversionUtils.httpMessageToSet(id, msg));
                }
            });
            return resultList;
        }
        catch (Exception e) {
            throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
        }
    }

    private static ExtensionHistory getExtHistory() {
        if (extHistory == null) {
            extHistory = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class);
        }
        return extHistory;
    }

    private static HttpMessage createRequest(String request) throws HttpMalformedHeaderException {
        HttpMessage requestMsg = new HttpMessage();
        String[] parts = request.split(Pattern.quote("\r\n\r\n"), 2);
        requestMsg.setRequestHeader(parts[0]);
        if (parts.length > 1) {
            requestMsg.setRequestBody(parts[1]);
        } else {
            requestMsg.setRequestBody("");
        }
        return requestMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendRequest(HttpMessage request, boolean followRedirects, Processor<HttpMessage> processor) throws IOException {
        HttpSender sender = null;
        try {
            sender = CoreAPI.createHttpSender();
            sender.sendAndReceive(request);
            CoreAPI.persistMessage(request);
            processor.process(request);
            if (followRedirects) {
                HttpMessage tempReq = request;
                for (int i = 0; i < 10 && HttpStatusCode.isRedirection(tempReq.getResponseHeader().getStatusCode()); ++i) {
                    tempReq = tempReq.cloneAll();
                    String location = tempReq.getResponseHeader().getHeader("Location");
                    URI baseUri = tempReq.getRequestHeader().getURI();
                    URI newLocation = new URI(baseUri, location, false);
                    tempReq.getRequestHeader().setURI(newLocation);
                    tempReq.getRequestHeader().setMethod("GET");
                    tempReq.getRequestHeader().setHeader("Content-Length", null);
                    sender.sendAndReceive(tempReq);
                    CoreAPI.persistMessage(tempReq);
                    processor.process(tempReq);
                }
            }
        }
        finally {
            if (sender != null) {
                sender.shutdown();
            }
        }
    }

    private static HttpSender createHttpSender() {
        return new HttpSender(Model.getSingleton().getOptionsParam().getConnectionParam(), true, 6);
    }

    private static void persistMessage(final HttpMessage message) {
        HistoryReference historyRef;
        try {
            historyRef = new HistoryReference(Model.getSingleton().getSession(), 15, message);
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return;
        }
        if (CoreAPI.getExtHistory() != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CoreAPI.getExtHistory().addHistory(historyRef);
                    Model.getSingleton().getSession().getSiteTree().addPath(historyRef, message);
                }
            });
        }
    }

    private static void removeHistoryReferenceAlerts(SiteNode siteNode) {
        for (int i = 0; i < siteNode.getChildCount(); ++i) {
            CoreAPI.removeHistoryReferenceAlerts((SiteNode)siteNode.getChildAt(i));
        }
        if (siteNode.getHistoryReference() != null) {
            siteNode.getHistoryReference().deleteAllAlerts();
        }
        for (HistoryReference hRef : siteNode.getPastHistoryReference()) {
            hRef.deleteAllAlerts();
        }
    }

    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        ApiResponse result = null;
        Session session = Model.getSingleton().getSession();
        if (VIEW_HOSTS.equals(name)) {
            result = new ApiResponseList(name);
            SiteNode root = (SiteNode)session.getSiteTree().getRoot();
            Enumeration<TreeNode> en = root.children();
            while (en.hasMoreElements()) {
                String site = ((SiteNode)en.nextElement()).getNodeName();
                if (site.indexOf("//") >= 0) {
                    site = site.substring(site.indexOf("//") + 2);
                }
                if (site.indexOf(":") >= 0) {
                    site = site.substring(0, site.indexOf(":"));
                }
                ((ApiResponseList)result).addItem(new ApiResponseElement("host", site));
            }
        } else if (VIEW_SITES.equals(name)) {
            result = new ApiResponseList(name);
            SiteNode root = (SiteNode)session.getSiteTree().getRoot();
            Enumeration<TreeNode> en = root.children();
            while (en.hasMoreElements()) {
                ((ApiResponseList)result).addItem(new ApiResponseElement("site", ((SiteNode)en.nextElement()).getNodeName()));
            }
        } else if (VIEW_URLS.equals(name)) {
            result = new ApiResponseList(name);
            SiteNode root = (SiteNode)session.getSiteTree().getRoot();
            this.getURLs(root, (ApiResponseList)result);
        } else if (VIEW_ALERT.equals(name)) {
            RecordAlert recordAlert;
            TableAlert tableAlert = Model.getSingleton().getDb().getTableAlert();
            try {
                recordAlert = tableAlert.read(this.getParam(params, PARAM_ID, -1));
            }
            catch (DatabaseException e) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR);
            }
            if (recordAlert == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
            }
            result = new ApiResponseElement(this.alertToSet(new Alert(recordAlert)));
        } else if (VIEW_ALERTS.equals(name)) {
            final ApiResponseList resultList = new ApiResponseList(name);
            this.processAlerts(this.getParam(params, PARAM_BASE_URL, null), this.getParam(params, PARAM_START, -1), this.getParam(params, PARAM_COUNT, -1), new Processor<Alert>(){

                @Override
                public void process(Alert alert) {
                    resultList.addItem(CoreAPI.this.alertToSet(alert));
                }
            });
            result = resultList;
        } else if (VIEW_NUMBER_OF_ALERTS.equals(name)) {
            CounterProcessor<Alert> counter = new CounterProcessor<Alert>();
            this.processAlerts(this.getParam(params, PARAM_BASE_URL, null), this.getParam(params, PARAM_START, -1), this.getParam(params, PARAM_COUNT, -1), counter);
            result = new ApiResponseElement(name, Integer.toString(counter.getCount()));
        } else if (VIEW_MESSAGE.equals(name)) {
            RecordHistory recordHistory;
            TableHistory tableHistory = Model.getSingleton().getDb().getTableHistory();
            try {
                recordHistory = tableHistory.read(this.getParam(params, PARAM_ID, -1));
            }
            catch (DatabaseException | HttpMalformedHeaderException e) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR);
            }
            if (recordHistory == null || recordHistory.getHistoryType() == 0) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
            }
            result = new ApiResponseElement(ApiResponseConversionUtils.httpMessageToSet(recordHistory.getHistoryId(), recordHistory.getHttpMessage()));
        } else if (VIEW_MESSAGES.equals(name)) {
            final ApiResponseList resultList = new ApiResponseList(name);
            this.processHttpMessages(this.getParam(params, PARAM_BASE_URL, null), this.getParam(params, PARAM_START, -1), this.getParam(params, PARAM_COUNT, -1), new Processor<RecordHistory>(){

                @Override
                public void process(RecordHistory recordHistory) {
                    resultList.addItem(ApiResponseConversionUtils.httpMessageToSet(recordHistory.getHistoryId(), recordHistory.getHttpMessage()));
                }
            });
            result = resultList;
        } else if (VIEW_NUMBER_OF_MESSAGES.equals(name)) {
            CounterProcessor<RecordHistory> counter = new CounterProcessor<RecordHistory>();
            this.processHttpMessages(this.getParam(params, PARAM_BASE_URL, null), this.getParam(params, PARAM_START, -1), this.getParam(params, PARAM_COUNT, -1), counter);
            result = new ApiResponseElement(name, Integer.toString(counter.getCount()));
        } else if ("mode".equals(name)) {
            result = new ApiResponseElement(name, Control.getSingleton().getMode().name());
        } else if (VIEW_VERSION.equals(name)) {
            result = new ApiResponseElement(name, Constant.PROGRAM_VERSION);
        } else if (VIEW_EXCLUDED_FROM_PROXY.equals(name)) {
            result = new ApiResponseList(name);
            List<String> regexs = session.getExcludeFromProxyRegexs();
            for (String regex : regexs) {
                ((ApiResponseList)result).addItem(new ApiResponseElement(PARAM_REGEX, regex));
            }
        } else if (VIEW_HOME_DIRECTORY.equals(name)) {
            result = new ApiResponseElement(name, Model.getSingleton().getOptionsParam().getUserDirectory().getAbsolutePath());
        } else {
            throw new ApiException(ApiException.Type.BAD_VIEW);
        }
        return result;
    }

    @Override
    public HttpMessage handleApiOther(HttpMessage msg, String name, JSONObject params) throws ApiException {
        if (OTHER_PROXY_PAC.equals(name)) {
            ProxyParam proxyParam = Model.getSingleton().getOptionsParam().getProxyParam();
            int port = proxyParam.getProxyPort();
            try {
                String localDomain;
                String domain = null;
                if (proxyParam.isProxyIpAnyLocalAddress() && !API.API_DOMAIN.equals(localDomain = msg.getRequestHeader().getHostName())) {
                    domain = localDomain;
                }
                if (domain == null) {
                    domain = proxyParam.getProxyIp();
                }
                String response = this.getPacFile(domain, port);
                msg.setResponseHeader(API.getDefaultResponseHeader("text/html", response.length()));
                msg.setResponseBody(response);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return msg;
        }
        if (OTHER_SET_PROXY.equals(name)) {
            String proxyDetails = params.getString(PARAM_PROXY_DETAILS);
            String response = "OK";
            try {
                try {
                    JSONObject json = JSONObject.fromObject((Object)proxyDetails);
                    if (json.getInt("type") == 1) {
                        JSONObject httpJson = JSONObject.fromObject((Object)json.get("http"));
                        String proxyHost = httpJson.getString("host");
                        int proxyPort = httpJson.getInt("port");
                        if (proxyHost != null && proxyHost.length() > 0 && proxyPort > 0) {
                            Model.getSingleton().getOptionsParam().getConnectionParam().setProxyChainName(proxyHost);
                            Model.getSingleton().getOptionsParam().getConnectionParam().setProxyChainPort(proxyPort);
                        }
                    }
                }
                catch (JSONException e) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_PROXY_DETAILS);
                }
                msg.setResponseHeader(API.getDefaultResponseHeader("text/html", response.length()));
                msg.setResponseBody(response);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return msg;
        }
        if (OTHER_ROOT_CERT.equals(name)) {
            ExtensionDynSSL extDynSSL = (ExtensionDynSSL)Control.getSingleton().getExtensionLoader().getExtension("ExtensionDynSSL");
            if (extDynSSL != null) {
                try {
                    Certificate rootCA = extDynSSL.getRootCA();
                    if (rootCA == null) {
                        throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
                    }
                    StringWriter sw = new StringWriter();
                    try (PemWriter pw = new PemWriter((Writer)sw);){
                        pw.writeObject((PemObjectGenerator)new JcaMiscPEMGenerator((Object)rootCA));
                        pw.flush();
                    }
                    String response = sw.toString();
                    msg.setResponseHeader(API.getDefaultResponseHeader("application/pkix-cert;", response.length()));
                    msg.setResponseBody(response);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR);
                }
            }
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
            return msg;
        }
        if (OTHER_XML_REPORT.equals(name)) {
            try {
                CoreAPI.writeReportLastScanTo(msg, ScanReportType.XML);
                return msg;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new ApiException(ApiException.Type.INTERNAL_ERROR);
            }
        }
        if (OTHER_HTML_REPORT.equals(name)) {
            try {
                CoreAPI.writeReportLastScanTo(msg, ScanReportType.HTML);
                return msg;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new ApiException(ApiException.Type.INTERNAL_ERROR);
            }
        }
        if (OTHER_MESSAGE_HAR.equals(name)) {
            byte[] responseBody;
            try {
                RecordHistory recordHistory;
                HarEntries entries = new HarEntries();
                TableHistory tableHistory = Model.getSingleton().getDb().getTableHistory();
                try {
                    recordHistory = tableHistory.read(this.getParam(params, PARAM_ID, -1));
                }
                catch (DatabaseException | HttpMalformedHeaderException e) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR);
                }
                if (recordHistory == null || recordHistory.getHistoryType() == 0) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
                }
                entries.addEntry(HarUtils.createHarEntry(recordHistory.getHttpMessage()));
                HarLog harLog = HarUtils.createZapHarLog();
                harLog.setEntries(entries);
                responseBody = HarUtils.harLogToByteArray(harLog);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                ApiException apiException = new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                responseBody = apiException.toString(API.Format.JSON, this.incErrorDetails()).getBytes(StandardCharsets.UTF_8);
            }
            try {
                msg.setResponseHeader(API.getDefaultResponseHeader("application/json; charset=UTF-8", responseBody.length));
            }
            catch (HttpMalformedHeaderException e) {
                logger.error((Object)("Failed to create response header: " + e.getMessage()), (Throwable)e);
            }
            msg.setResponseBody(responseBody);
            return msg;
        }
        if (OTHER_MESSAGES_HAR.equals(name)) {
            byte[] responseBody;
            try {
                final HarEntries entries = new HarEntries();
                this.processHttpMessages(this.getParam(params, PARAM_BASE_URL, null), this.getParam(params, PARAM_START, -1), this.getParam(params, PARAM_COUNT, -1), new Processor<RecordHistory>(){

                    @Override
                    public void process(RecordHistory recordHistory) {
                        entries.addEntry(HarUtils.createHarEntry(recordHistory.getHttpMessage()));
                    }
                });
                HarLog harLog = HarUtils.createZapHarLog();
                harLog.setEntries(entries);
                responseBody = HarUtils.harLogToByteArray(harLog);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                ApiException apiException = new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                responseBody = apiException.toString(API.Format.JSON, this.incErrorDetails()).getBytes(StandardCharsets.UTF_8);
            }
            try {
                msg.setResponseHeader(API.getDefaultResponseHeader("application/json; charset=UTF-8", responseBody.length));
            }
            catch (HttpMalformedHeaderException e) {
                logger.error((Object)("Failed to create response header: " + e.getMessage()), (Throwable)e);
            }
            msg.setResponseBody(responseBody);
            return msg;
        }
        if (OTHER_SEND_HAR_REQUEST.equals(name)) {
            byte[] responseBody = new byte[]{};
            HttpMessage request = null;
            try {
                request = HarUtils.createHttpMessage(params.getString(PARAM_REQUEST));
            }
            catch (IOException e) {
                ApiException apiException = new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_REQUEST, e);
                responseBody = apiException.toString(API.Format.JSON, this.incErrorDetails()).getBytes(StandardCharsets.UTF_8);
                msg.setResponseBody(responseBody);
            }
            if (request != null) {
                boolean followRedirects = this.getParam(params, PARAM_FOLLOW_REDIRECTS, false);
                try {
                    final HarEntries entries = new HarEntries();
                    CoreAPI.sendRequest(request, followRedirects, new Processor<HttpMessage>(){

                        @Override
                        public void process(HttpMessage msg) {
                            entries.addEntry(HarUtils.createHarEntry(msg));
                        }
                    });
                    HarLog harLog = HarUtils.createZapHarLog();
                    harLog.setEntries(entries);
                    responseBody = HarUtils.harLogToByteArray(harLog);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    ApiException apiException = new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                    responseBody = apiException.toString(API.Format.JSON, this.incErrorDetails()).getBytes(StandardCharsets.UTF_8);
                }
            }
            try {
                msg.setResponseHeader(API.getDefaultResponseHeader("application/json; charset=UTF-8", responseBody.length));
            }
            catch (HttpMalformedHeaderException e) {
                logger.error((Object)("Failed to create response header: " + e.getMessage()), (Throwable)e);
            }
            msg.setResponseBody(responseBody);
            return msg;
        }
        throw new ApiException(ApiException.Type.BAD_OTHER);
    }

    private boolean incErrorDetails() {
        return Model.getSingleton().getOptionsParam().getApiParam().isIncErrorDetails();
    }

    private static void writeReportLastScanTo(HttpMessage msg, ScanReportType reportType) throws Exception {
        String response;
        ReportLastScan rls = new ReportLastScan();
        StringBuilder report = new StringBuilder();
        rls.generate(report, Model.getSingleton());
        if (ScanReportType.XML == reportType) {
            msg.setResponseHeader(API.getDefaultResponseHeader("text/xml; charset=UTF-8"));
            response = report.toString();
        } else {
            msg.setResponseHeader(API.getDefaultResponseHeader("text/html; charset=UTF-8"));
            response = ReportGenerator.stringToHtml(report.toString(), Paths.get(Constant.getZapInstall(), "xml/report.html.xsl").toString());
        }
        msg.setResponseBody(response);
        msg.getResponseHeader().setContentLength(msg.getResponseBody().length());
    }

    @Override
    public HttpMessage handleShortcut(HttpMessage msg) throws ApiException {
        try {
            if (msg.getRequestHeader().getURI().getPath().startsWith("/proxy.pac")) {
                return this.handleApiOther(msg, OTHER_PROXY_PAC, null);
            }
            if (msg.getRequestHeader().getURI().getPath().startsWith("/setproxy")) {
                JSONObject params = new JSONObject();
                params.put((Object)PARAM_PROXY_DETAILS, (Object)msg.getRequestBody());
                return this.handleApiOther(msg, OTHER_SET_PROXY, params);
            }
        }
        catch (URIException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ApiException(ApiException.Type.INTERNAL_ERROR);
        }
        throw new ApiException(ApiException.Type.URL_NOT_FOUND, msg.getRequestHeader().getURI().toString());
    }

    private String getPacFile(String host, int port) {
        StringBuilder sb = new StringBuilder(100);
        sb.append("function FindProxyForURL(url, host) {\n");
        sb.append("  return \"PROXY ").append(host).append(':').append(port).append("\";\n");
        sb.append("} // End of function\n");
        return sb.toString();
    }

    private void getURLs(SiteNode parent, ApiResponseList list) {
        Enumeration<TreeNode> en = parent.children();
        while (en.hasMoreElements()) {
            SiteNode child = (SiteNode)en.nextElement();
            String site = child.getNodeName();
            if (site.indexOf("//") >= 0) {
                site = site.substring(site.indexOf("//") + 2);
            }
            try {
                list.addItem(new ApiResponseElement(PARAM_URL, child.getHistoryReference().getURI().toString()));
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            this.getURLs(child, list);
        }
    }

    private ApiResponseSet alertToSet(Alert alert) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PARAM_ID, String.valueOf(alert.getAlertId()));
        map.put("pluginId", String.valueOf(alert.getPluginId()));
        map.put(VIEW_ALERT, alert.getName());
        map.put(PARAM_SESSION, alert.getName());
        map.put("description", alert.getDescription());
        map.put("risk", Alert.MSG_RISK[alert.getRisk()]);
        map.put("confidence", Alert.MSG_CONFIDENCE[alert.getConfidence()]);
        map.put(PARAM_URL, alert.getUri());
        map.put("other", alert.getOtherInfo());
        map.put("param", alert.getParam());
        map.put("attack", alert.getAttack());
        map.put("evidence", alert.getEvidence());
        map.put("reference", alert.getReference());
        map.put("cweid", String.valueOf(alert.getCweId()));
        map.put("wascid", String.valueOf(alert.getWascId()));
        map.put("solution", alert.getSolution());
        if (alert.getHistoryRef() != null) {
            map.put("messageId", String.valueOf(alert.getHistoryRef().getHistoryId()));
        }
        return new ApiResponseSet(VIEW_ALERT, map);
    }

    private void processAlerts(String baseUrl, int start, int count, Processor<Alert> processor) throws ApiException {
        ArrayList<Alert> alerts = new ArrayList<Alert>();
        try {
            TableAlert tableAlert = Model.getSingleton().getDb().getTableAlert();
            Vector<Integer> v = tableAlert.getAlertList();
            PaginationConstraintsChecker pcc = new PaginationConstraintsChecker(start, count);
            for (int i = 0; i < v.size(); ++i) {
                int alertId = v.get(i);
                RecordAlert recAlert = tableAlert.read(alertId);
                Alert alert = new Alert(recAlert);
                if (alert.getConfidence() == 0 || alerts.contains(alert) || baseUrl != null && !alert.getUri().startsWith(baseUrl)) continue;
                pcc.recordProcessed();
                alerts.add(alert);
                if (!pcc.hasPageStarted()) continue;
                processor.process(alert);
                if (!pcc.hasPageEnded()) {
                    continue;
                }
                break;
            }
        }
        catch (DatabaseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ApiException(ApiException.Type.INTERNAL_ERROR);
        }
    }

    private void processHttpMessages(String baseUrl, int start, int count, Processor<RecordHistory> processor) throws ApiException {
        try {
            TableHistory tableHistory = Model.getSingleton().getDb().getTableHistory();
            List<Integer> historyIds = tableHistory.getHistoryIdsExceptOfHistType(Model.getSingleton().getSession().getSessionId(), 0);
            PaginationConstraintsChecker pcc = new PaginationConstraintsChecker(start, count);
            for (Integer id : historyIds) {
                RecordHistory recHistory = tableHistory.read(id);
                HttpMessage msg = recHistory.getHttpMessage();
                if (msg.getRequestHeader().isImage() || msg.getResponseHeader().isImage() || baseUrl != null && !msg.getRequestHeader().getURI().toString().startsWith(baseUrl)) continue;
                pcc.recordProcessed();
                if (!pcc.hasPageStarted()) continue;
                processor.process(recHistory);
                if (!pcc.hasPageEnded()) continue;
                break;
            }
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ApiException(ApiException.Type.INTERNAL_ERROR);
        }
    }

    @Override
    public void sessionOpened(File file, Exception e) {
    }

    @Override
    public void sessionSaved(Exception e) {
        logger.debug((Object)"Saved session notification");
        this.savingSession = false;
    }

    @Override
    public void sessionSnapshot(Exception e) {
        logger.debug((Object)"Snaphot session notification");
        this.savingSession = false;
    }

    private static class PaginationConstraintsChecker {
        private boolean pageStarted;
        private boolean pageEnded;
        private final int startRecord;
        private final boolean hasEnd;
        private final int finalRecord;
        private int recordsProcessed = 0;

        public PaginationConstraintsChecker(int start, int count) {
            if (start > 0) {
                this.pageStarted = false;
                this.startRecord = start;
            } else {
                this.pageStarted = true;
                this.startRecord = 0;
            }
            if (count > 0) {
                this.hasEnd = true;
                this.finalRecord = !this.pageStarted ? start + count - 1 : count;
            } else {
                this.hasEnd = false;
                this.finalRecord = 0;
            }
            this.pageEnded = false;
        }

        public void recordProcessed() {
            ++this.recordsProcessed;
            if (!this.pageStarted) {
                boolean bl = this.pageStarted = this.recordsProcessed >= this.startRecord;
            }
            if (this.hasEnd && !this.pageEnded) {
                this.pageEnded = this.recordsProcessed >= this.finalRecord;
            }
        }

        public boolean hasPageStarted() {
            return this.pageStarted;
        }

        public boolean hasPageEnded() {
            return this.pageEnded;
        }
    }

    private static class CounterProcessor<T>
    implements Processor<T> {
        private int count = 0;

        @Override
        public void process(T object) {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }

    private static interface Processor<T> {
        public void process(T var1);
    }

    private static enum ScanReportType {
        HTML,
        XML;

    }
}

