/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.authentication.AuthenticationMethod;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.authorization.AuthorizationDetectionMethod;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.Tech;
import org.zaproxy.zap.model.TechSet;
import org.zaproxy.zap.utils.ApiUtils;

public class ContextAPI
extends ApiImplementor {
    private static final Logger log = Logger.getLogger(ContextAPI.class);
    private static final String PREFIX = "context";
    private static final String TECH_NAME = "technologyName";
    private static final String EXCLUDE_FROM_CONTEXT_REGEX = "excludeFromContext";
    private static final String INCLUDE_IN_CONTEXT_REGEX = "includeInContext";
    private static final String ACTION_NEW_CONTEXT = "newContext";
    private static final String ACTION_REMOVE_CONTEXT = "removeContext";
    private static final String ACTION_SET_CONTEXT_IN_SCOPE = "setContextInScope";
    private static final String ACTION_EXPORT_CONTEXT = "exportContext";
    private static final String ACTION_IMPORT_CONTEXT = "importContext";
    private static final String ACTION_INCLUDE_TECHS = "includeContextTechnologies";
    private static final String ACTION_INCLUDE_ALL_TECHS = "includeAllContextTechnologies";
    private static final String ACTION_EXCLUDE_TECHS = "excludeContextTechnologies";
    private static final String ACTION_EXCLUDE_ALL_TECHS = "excludeAllContextTechnologies";
    private static final String VIEW_EXCLUDE_REGEXS = "excludeRegexs";
    private static final String VIEW_INCLUDE_REGEXS = "includeRegexs";
    private static final String VIEW_CONTEXT_LIST = "contextList";
    private static final String VIEW_CONTEXT = "context";
    private static final String VIEW_ALL_TECHS = "technologyList";
    private static final String VIEW_INCLUDED_TECHS = "includedTechnologyList";
    private static final String VIEW_EXCLUDED_TECHS = "excludedTechnologyList";
    private static final String REGEX_PARAM = "regex";
    private static final String CONTEXT_NAME = "contextName";
    private static final String IN_SCOPE = "booleanInScope";
    private static final String CONTEXT_FILE_PARAM = "contextFile";
    private static final String CONTEXT_ID = "contextId";
    private static final String PARAM_TECH_NAMES = "technologyNames";

    public ContextAPI() {
        ArrayList<String> contextNameAndRegexParam = new ArrayList<String>(2);
        contextNameAndRegexParam.add(CONTEXT_NAME);
        contextNameAndRegexParam.add(REGEX_PARAM);
        ArrayList<String> contextNameOnlyParam = new ArrayList<String>(1);
        contextNameOnlyParam.add(CONTEXT_NAME);
        String[] contextNameAndTechNames = new String[]{CONTEXT_NAME, PARAM_TECH_NAMES};
        this.addApiAction(new ApiAction(EXCLUDE_FROM_CONTEXT_REGEX, contextNameAndRegexParam));
        this.addApiAction(new ApiAction(INCLUDE_IN_CONTEXT_REGEX, contextNameAndRegexParam));
        this.addApiAction(new ApiAction(ACTION_NEW_CONTEXT, contextNameOnlyParam));
        this.addApiAction(new ApiAction(ACTION_REMOVE_CONTEXT, contextNameOnlyParam));
        this.addApiAction(new ApiAction(ACTION_EXPORT_CONTEXT, new String[]{CONTEXT_NAME, CONTEXT_FILE_PARAM}, null));
        this.addApiAction(new ApiAction(ACTION_IMPORT_CONTEXT, new String[]{CONTEXT_FILE_PARAM}, null));
        this.addApiAction(new ApiAction(ACTION_INCLUDE_TECHS, contextNameAndTechNames));
        this.addApiAction(new ApiAction(ACTION_INCLUDE_ALL_TECHS, contextNameOnlyParam));
        this.addApiAction(new ApiAction(ACTION_EXCLUDE_TECHS, contextNameAndTechNames));
        this.addApiAction(new ApiAction(ACTION_EXCLUDE_ALL_TECHS, contextNameOnlyParam));
        ArrayList<String> contextInScopeParams = new ArrayList<String>(2);
        contextInScopeParams.add(CONTEXT_NAME);
        contextInScopeParams.add(IN_SCOPE);
        this.addApiAction(new ApiAction(ACTION_SET_CONTEXT_IN_SCOPE, contextInScopeParams));
        this.addApiView(new ApiView(VIEW_CONTEXT_LIST));
        this.addApiView(new ApiView(VIEW_EXCLUDE_REGEXS, contextNameOnlyParam));
        this.addApiView(new ApiView(VIEW_INCLUDE_REGEXS, contextNameOnlyParam));
        this.addApiView(new ApiView("context", contextNameOnlyParam));
        this.addApiView(new ApiView(VIEW_ALL_TECHS));
        this.addApiView(new ApiView(VIEW_INCLUDED_TECHS, contextNameOnlyParam));
        this.addApiView(new ApiView(VIEW_EXCLUDED_TECHS, contextNameOnlyParam));
    }

    @Override
    public String getPrefix() {
        return "context";
    }

    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        log.debug((Object)("handleApiAction " + name + " " + params.toString()));
        switch (name) {
            case "excludeFromContext": {
                try {
                    this.addExcludeToContext(this.getContext(params), params.getString(REGEX_PARAM));
                    break;
                }
                catch (Exception e) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                }
            }
            case "includeInContext": {
                this.addIncludeToContext(this.getContext(params), params.getString(REGEX_PARAM));
                break;
            }
            case "newContext": {
                Context context = Model.getSingleton().getSession().getNewContext(params.getString(CONTEXT_NAME));
                Model.getSingleton().getSession().saveContext(context);
                return new ApiResponseElement(CONTEXT_ID, String.valueOf(context.getIndex()));
            }
            case "removeContext": {
                Context context = this.getContext(params);
                Model.getSingleton().getSession().deleteContext(context);
                break;
            }
            case "setContextInScope": {
                Context context = this.getContext(params);
                context.setInScope(params.getBoolean(IN_SCOPE));
                Model.getSingleton().getSession().saveContext(context);
                break;
            }
            case "importContext": {
                Context context;
                String filename = params.getString(CONTEXT_FILE_PARAM);
                File f = new File(filename);
                if (!f.exists()) {
                    f = new File(Constant.getContextsDir(), filename);
                }
                if (!f.exists()) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, f.getAbsolutePath());
                }
                try {
                    context = Model.getSingleton().getSession().importContext(f);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                }
                return new ApiResponseElement(CONTEXT_ID, String.valueOf(context.getIndex()));
            }
            case "exportContext": {
                String filename = params.getString(CONTEXT_FILE_PARAM);
                Context context = this.getContext(params);
                File f = new File(filename);
                if (!f.getAbsolutePath().equals(filename)) {
                    f = new File(Constant.getContextsDir(), filename);
                }
                if (!f.getParentFile().canWrite()) {
                    throw new ApiException(ApiException.Type.NO_ACCESS, f.getAbsolutePath());
                }
                try {
                    Model.getSingleton().getSession().exportContext(context, f);
                    break;
                }
                catch (Exception e) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                }
            }
            case "includeContextTechnologies": {
                String[] techNames;
                Context context = this.getContext(params);
                TechSet techSet = context.getTechSet();
                for (String techName : techNames = this.getParam(params, PARAM_TECH_NAMES, "").split(",")) {
                    techSet.include(this.getTech(techName));
                }
                context.save();
                break;
            }
            case "includeAllContextTechnologies": {
                Context context = this.getContext(params);
                TechSet techSet = new TechSet(Tech.builtInTech);
                context.setTechSet(techSet);
                context.save();
                break;
            }
            case "excludeContextTechnologies": {
                String[] techNames;
                Context context = this.getContext(params);
                TechSet techSet = context.getTechSet();
                for (String techName : techNames = this.getParam(params, PARAM_TECH_NAMES, "").split(",")) {
                    techSet.exclude(this.getTech(techName));
                }
                context.save();
                break;
            }
            case "excludeAllContextTechnologies": {
                Context context = this.getContext(params);
                TechSet techSet = context.getTechSet();
                for (Tech tech : Tech.builtInTech) {
                    techSet.exclude(tech);
                }
                context.save();
                break;
            }
            default: {
                throw new ApiException(ApiException.Type.BAD_ACTION);
            }
        }
        return ApiResponseElement.OK;
    }

    private void addExcludeToContext(Context context, String regex) throws Exception {
        ArrayList<String> incRegexes = new ArrayList<String>(context.getIncludeInContextRegexs());
        if (incRegexes.remove(regex)) {
            context.setIncludeInContextRegexs(incRegexes);
        } else {
            context.addExcludeFromContextRegex(regex);
        }
        Model.getSingleton().getSession().saveContext(context);
    }

    private void addIncludeToContext(Context context, String regex) {
        context.addIncludeInContextRegex(regex);
        Model.getSingleton().getSession().saveContext(context);
    }

    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        ApiResponse result;
        log.debug((Object)("handleApiView " + name + " " + params.toString()));
        switch (name) {
            case "excludeRegexs": {
                result = new ApiResponseElement(name, this.getContext(params).getExcludeFromContextRegexs().toString());
                break;
            }
            case "includeRegexs": {
                result = new ApiResponseElement(name, this.getContext(params).getIncludeInContextRegexs().toString());
                break;
            }
            case "contextList": {
                ArrayList<String> contextNames = new ArrayList<String>();
                List<Context> contexts = Model.getSingleton().getSession().getContexts();
                for (Context context : contexts) {
                    contextNames.add(context.getName());
                }
                result = new ApiResponseElement(name, ((Object)contextNames).toString());
                break;
            }
            case "context": {
                result = new ApiResponseElement(this.buildResponseFromContext(this.getContext(params)));
                break;
            }
            case "technologyList": {
                ApiResponseList resultList = new ApiResponseList(name);
                for (Tech tech : Tech.builtInTech) {
                    resultList.addItem(new ApiResponseElement(TECH_NAME, tech.toString()));
                }
                result = resultList;
                break;
            }
            case "includedTechnologyList": {
                ApiResponseList resultList = new ApiResponseList(name);
                TechSet techSet = this.getContext(params).getTechSet();
                for (Tech tech : techSet.getIncludeTech()) {
                    resultList.addItem(new ApiResponseElement(TECH_NAME, tech.toString()));
                }
                result = resultList;
                break;
            }
            case "excludedTechnologyList": {
                ApiResponseList resultList = new ApiResponseList(name);
                TechSet techSet = this.getContext(params).getTechSet();
                for (Tech tech : techSet.getExcludeTech()) {
                    resultList.addItem(new ApiResponseElement(TECH_NAME, tech.toString()));
                }
                result = resultList;
                break;
            }
            default: {
                throw new ApiException(ApiException.Type.BAD_VIEW);
            }
        }
        return result;
    }

    private Context getContext(JSONObject params) throws ApiException {
        return ApiUtils.getContextByName(params, CONTEXT_NAME);
    }

    private ApiResponse buildResponseFromContext(Context c) {
        AuthorizationDetectionMethod authorizationDetectionMethod;
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("name", c.getName());
        fields.put("id", Integer.toString(c.getIndex()));
        fields.put("description", c.getDescription());
        fields.put("inScope", Boolean.toString(c.isInScope()));
        fields.put(VIEW_EXCLUDE_REGEXS, c.getExcludeFromContextRegexs().toString());
        fields.put(VIEW_INCLUDE_REGEXS, c.getIncludeInContextRegexs().toString());
        AuthenticationMethod authenticationMethod = c.getAuthenticationMethod();
        if (authenticationMethod != null) {
            Pattern pattern = authenticationMethod.getLoggedInIndicatorPattern();
            fields.put("loggedInPattern", pattern == null ? "" : pattern.toString());
            pattern = authenticationMethod.getLoggedOutIndicatorPattern();
            fields.put("loggedOutPattern", pattern == null ? "" : pattern.toString());
            AuthenticationMethodType type = authenticationMethod.getType();
            fields.put("authType", type == null ? "" : type.getName());
        }
        if ((authorizationDetectionMethod = c.getAuthorizationDetectionMethod()) != null) {
            fields.put("authenticationDetectionMethodId", String.valueOf(authorizationDetectionMethod.getMethodUniqueIdentifier()));
        }
        fields.put("urlParameterParserClass", c.getUrlParamParser().getClass().getCanonicalName());
        fields.put("urlParameterParserConfig", c.getUrlParamParser().getConfig());
        fields.put("postParameterParserClass", c.getPostParamParser().getClass().getCanonicalName());
        fields.put("postParameterParserConfig", c.getPostParamParser().getConfig());
        return new ApiResponseSet("context", fields);
    }

    private Tech getTech(String techName) throws ApiException {
        for (Tech tech : Tech.builtInTech) {
            if (!tech.toString().equalsIgnoreCase(techName)) continue;
            return tech;
        }
        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "The tech " + techName + " does not exist");
    }
}

