/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.utils.XMLStringUtil;

public class ApiResponseSet
extends ApiResponse {
    private Map<String, ?> values = null;

    public ApiResponseSet(String name, Map<String, ?> values) {
        super(name);
        this.values = values;
    }

    @Override
    public JSON toJSON() {
        if (this.values == null) {
            return null;
        }
        JSONObject jo = new JSONObject();
        for (Map.Entry<String, ?> val : this.values.entrySet()) {
            jo.put((Object)val.getKey(), val.getValue());
        }
        return jo;
    }

    @Override
    public void toXML(Document doc, Element parent) {
        parent.setAttribute("type", "set");
        for (Map.Entry<String, ?> val : this.values.entrySet()) {
            Element el = doc.createElement(val.getKey());
            Text text = val.getValue() instanceof String ? doc.createTextNode(XMLStringUtil.escapeControlChrs((String)val.getValue())) : doc.createTextNode("" + val.getValue());
            el.appendChild(text);
            parent.appendChild(el);
        }
    }

    @Override
    public void toHTML(StringBuilder sb) {
        sb.append("<h2>" + StringEscapeUtils.escapeHtml((String)this.getName()) + "</h2>\n");
        sb.append("<table border=\"1\">\n");
        for (Map.Entry<String, ?> val : this.values.entrySet()) {
            sb.append("<tr><td>\n");
            sb.append(StringEscapeUtils.escapeHtml((String)val.getKey()));
            sb.append("</td><td>\n");
            if (val.getValue() instanceof String) {
                sb.append(StringEscapeUtils.escapeHtml((String)((String)val.getValue())));
            } else {
                sb.append(val.getValue());
            }
            sb.append("</td></tr>\n");
        }
        sb.append("</table>\n");
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append("\t");
        }
        sb.append("ApiResponseSet ");
        sb.append(this.getName());
        sb.append(" : [\n");
        for (Map.Entry<String, ?> val : this.values.entrySet()) {
            for (int i = 0; i < indent + 1; ++i) {
                sb.append("\t");
            }
            sb.append(val.getKey());
            sb.append(" = ");
            sb.append(val.getValue());
            sb.append("\n");
        }
        for (int i = 0; i < indent; ++i) {
            sb.append("\t");
        }
        sb.append("]\n");
        return sb.toString();
    }

    Map<String, ?> getValues() {
        return this.values;
    }
}

