/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.proxy.ProxyParam;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpInputStream;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpOutputStream;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.view.View;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiOther;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.api.OptionsParamApi;
import org.zaproxy.zap.extension.api.WebUI;

public class API {
    public static String API_DOMAIN = "zap";
    public static String API_URL = "http://" + API_DOMAIN + "/";
    public static String API_URL_S = "https://" + API_DOMAIN + "/";
    public static String API_KEY_PARAM = "apikey";
    private static Pattern patternParam = Pattern.compile("&", 2);
    private static final String CALL_BACK_URL = "/zapCallBackUrl/";
    private static final String STATUS_OK = "200 OK";
    private static final String STATUS_BAD_REQUEST = "400 Bad Request";
    private static final String STATUS_INTERNAL_SERVER_ERROR = "500 Internal Server Error";
    private Map<String, ApiImplementor> implementors = new HashMap<String, ApiImplementor>();
    private static API api = null;
    private WebUI webUI = new WebUI(this);
    private Map<String, ApiImplementor> callBacks = new HashMap<String, ApiImplementor>();
    private Map<String, ApiImplementor> shortcuts = new HashMap<String, ApiImplementor>();
    private Random random = new Random();
    private static final Logger logger = Logger.getLogger(API.class);

    private static synchronized API newInstance() {
        if (api == null) {
            api = new API();
        }
        return api;
    }

    public static API getInstance() {
        if (api == null) {
            API.newInstance();
        }
        return api;
    }

    public void registerApiImplementor(ApiImplementor impl) {
        if (this.implementors.get(impl.getPrefix()) != null) {
            logger.error((Object)("Second attempt to register API implementor with prefix of " + impl.getPrefix()));
            return;
        }
        this.implementors.put(impl.getPrefix(), impl);
        for (String shortcut : impl.getApiShortcuts()) {
            logger.debug((Object)("Registering API shortcut: " + shortcut));
            if (this.shortcuts.containsKey(shortcut)) {
                logger.error((Object)("Duplicate API shortcut: " + shortcut));
            }
            this.shortcuts.put("/" + shortcut, impl);
        }
    }

    public void removeApiImplementor(ApiImplementor impl) {
        if (!this.implementors.containsKey(impl.getPrefix())) {
            logger.warn((Object)("Attempting to remove an API implementor not registered, with prefix: " + impl.getPrefix()));
            return;
        }
        this.implementors.remove(impl.getPrefix());
        for (String shortcut : impl.getApiShortcuts()) {
            String key = "/" + shortcut;
            if (!this.shortcuts.containsKey(key)) continue;
            logger.debug((Object)("Removing registered API shortcut: " + shortcut));
            this.shortcuts.remove(key);
        }
    }

    public boolean isEnabled() {
        return !View.isInitialised() || API.getOptionsParamApi().isEnabled();
    }

    private static OptionsParamApi getOptionsParamApi() {
        return Model.getSingleton().getOptionsParam().getApiParam();
    }

    public boolean handleApiRequest(HttpRequestHeader requestHeader, HttpInputStream httpIn, HttpOutputStream httpOut) throws IOException {
        return this.handleApiRequest(requestHeader, httpIn, httpOut, false);
    }

    public boolean handleApiRequest(HttpRequestHeader requestHeader, HttpInputStream httpIn, HttpOutputStream httpOut, boolean force) throws IOException {
        String path;
        String url = requestHeader.getURI().toString();
        Format format = Format.OTHER;
        ApiImplementor callbackImpl = null;
        ApiImplementor shortcutImpl = null;
        if (url.contains(CALL_BACK_URL)) {
            logger.debug((Object)("handleApiRequest Callback: " + url));
            for (Map.Entry<String, ApiImplementor> callback : this.callBacks.entrySet()) {
                if (!url.startsWith((String)callback.getKey())) continue;
                callbackImpl = (ApiImplementor)callback.getValue();
                break;
            }
        }
        if ((path = requestHeader.getURI().getPath()) != null) {
            for (Map.Entry<String, ApiImplementor> shortcut : this.shortcuts.entrySet()) {
                if (!path.startsWith(shortcut.getKey())) continue;
                shortcutImpl = shortcut.getValue();
                break;
            }
        }
        if (!(shortcutImpl != null || callbackImpl != null || url.startsWith(API_URL) || url.startsWith(API_URL_S) || force)) {
            return false;
        }
        if (API.getOptionsParamApi().isSecureOnly() && !requestHeader.isSecure()) {
            logger.debug((Object)"handleApiRequest rejecting insecure request");
            return true;
        }
        logger.debug((Object)("handleApiRequest " + url));
        HttpMessage msg = new HttpMessage();
        msg.setRequestHeader(requestHeader);
        String component = null;
        ApiImplementor impl = null;
        RequestType reqType = null;
        String contentType = "text/plain; charset=UTF-8";
        String response = "";
        String name = null;
        boolean error = false;
        try {
            JSONObject params = API.getParams(requestHeader.getURI().getEscapedQuery());
            if (shortcutImpl != null) {
                msg = shortcutImpl.handleShortcut(msg);
            } else if (callbackImpl != null) {
                response = callbackImpl.handleCallBack(msg);
            } else {
                String[] elements = url.split("/");
                if (elements.length > 3 && elements[3].equalsIgnoreCase("favicon.ico")) {
                    InputStream is = API.class.getResourceAsStream("/resource/zap.ico");
                    byte[] icon = new byte[is.available()];
                    is.read(icon);
                    is.close();
                    msg.setResponseHeader(API.getDefaultResponseHeader(contentType));
                    msg.getResponseHeader().setContentLength(icon.length);
                    httpOut.write(msg.getResponseHeader());
                    httpOut.write(icon);
                    httpOut.flush();
                    httpOut.close();
                    httpIn.close();
                    return true;
                }
                if (elements.length > 3) {
                    try {
                        format = Format.valueOf(elements[3].toUpperCase());
                        switch (format) {
                            case JSON: {
                                contentType = "application/json; charset=UTF-8";
                                break;
                            }
                            case JSONP: {
                                contentType = "application/javascript; charset=UTF-8";
                                break;
                            }
                            case XML: {
                                contentType = "text/xml; charset=UTF-8";
                                break;
                            }
                            case HTML: {
                                contentType = "text/html; charset=UTF-8";
                                break;
                            }
                            case UI: {
                                contentType = "text/html; charset=UTF-8";
                                break;
                            }
                        }
                    }
                    catch (IllegalArgumentException e) {
                        format = Format.HTML;
                        throw new ApiException(ApiException.Type.BAD_FORMAT);
                    }
                }
                if (elements.length > 4 && (impl = this.implementors.get(component = elements[4])) == null) {
                    throw new ApiException(ApiException.Type.NO_IMPLEMENTOR);
                }
                if (elements.length > 5) {
                    try {
                        reqType = RequestType.valueOf(elements[5]);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ApiException(ApiException.Type.BAD_TYPE);
                    }
                }
                if (elements.length > 6 && (name = elements[6]) != null && name.indexOf("?") > 0) {
                    name = name.substring(0, name.indexOf("?"));
                }
                if (format.equals((Object)Format.UI)) {
                    if (!this.isEnabled()) {
                        throw new ApiException(ApiException.Type.DISABLED);
                    }
                    response = this.webUI.handleRequest(component, impl, reqType, name);
                    contentType = "text/html; charset=UTF-8";
                } else if (name != null) {
                    if (!this.isEnabled()) {
                        throw new ApiException(ApiException.Type.DISABLED);
                    }
                    String key = this.getApiKey();
                    if (format.equals((Object)Format.JSONP)) {
                        if (!API.getOptionsParamApi().isEnableJSONP()) {
                            throw new ApiException(ApiException.Type.DISABLED);
                        }
                        if (!(key == null || key.length() <= 0 || params.has(API_KEY_PARAM) && key.equals(params.getString(API_KEY_PARAM)))) {
                            throw new ApiException(ApiException.Type.BAD_API_KEY);
                        }
                    }
                    block10 : switch (reqType) {
                        case action: {
                            ApiResponse res;
                            List<String> mandatoryParams;
                            if (!(key == null || key.length() <= 0 || params.has(API_KEY_PARAM) && key.equals(params.getString(API_KEY_PARAM)))) {
                                throw new ApiException(ApiException.Type.BAD_API_KEY);
                            }
                            ApiAction action = impl.getApiAction(name);
                            if (action != null && (mandatoryParams = action.getMandatoryParamNames()) != null) {
                                for (String param : mandatoryParams) {
                                    if (params.has(param) && params.getString(param).length() != 0) continue;
                                    throw new ApiException(ApiException.Type.MISSING_PARAMETER, param);
                                }
                            }
                            if ((res = impl.handleApiOptionAction(name, params)) == null) {
                                res = impl.handleApiAction(name, params);
                            }
                            switch (format) {
                                case JSON: {
                                    response = res.toJSON().toString();
                                    break block10;
                                }
                                case JSONP: {
                                    response = this.getJsonpWrapper(res.toJSON().toString());
                                    break block10;
                                }
                                case XML: {
                                    response = this.responseToXml(name, res);
                                    break block10;
                                }
                                case HTML: {
                                    response = this.responseToHtml(name, res);
                                    break block10;
                                }
                            }
                            break;
                        }
                        case view: {
                            ApiResponse res;
                            List<String> mandatoryParams;
                            ApiView view = impl.getApiView(name);
                            if (view != null && (mandatoryParams = view.getMandatoryParamNames()) != null) {
                                for (String param : mandatoryParams) {
                                    if (params.has(param) && params.getString(param).length() != 0) continue;
                                    throw new ApiException(ApiException.Type.MISSING_PARAMETER, param);
                                }
                            }
                            if ((res = impl.handleApiOptionView(name, params)) == null) {
                                res = impl.handleApiView(name, params);
                            }
                            switch (format) {
                                case JSON: {
                                    response = res.toJSON().toString();
                                    break block10;
                                }
                                case JSONP: {
                                    response = this.getJsonpWrapper(res.toJSON().toString());
                                    break block10;
                                }
                                case XML: {
                                    response = this.responseToXml(name, res);
                                    break block10;
                                }
                                case HTML: {
                                    response = this.responseToHtml(name, res);
                                    break block10;
                                }
                            }
                            break;
                        }
                        case other: {
                            ApiOther other = impl.getApiOther(name);
                            if (other != null) {
                                if (!(key == null || key.length() <= 0 || !other.isRequiresApiKey() || params.has(API_KEY_PARAM) && key.equals(params.getString(API_KEY_PARAM)))) {
                                    throw new ApiException(ApiException.Type.BAD_API_KEY);
                                }
                                List<String> mandatoryParams = other.getMandatoryParamNames();
                                if (mandatoryParams != null) {
                                    for (String param : mandatoryParams) {
                                        if (params.has(param) && params.getString(param).length() != 0) continue;
                                        throw new ApiException(ApiException.Type.MISSING_PARAMETER, param);
                                    }
                                }
                            }
                            msg = impl.handleApiOther(msg, name, params);
                        }
                    }
                } else {
                    response = this.webUI.handleRequest(requestHeader.getURI(), this.isEnabled());
                    format = Format.UI;
                    contentType = "text/html; charset=UTF-8";
                }
            }
            logger.debug((Object)("handleApiRequest returning: " + response));
        }
        catch (Exception e) {
            API.handleException(msg, format, contentType, e);
            error = true;
        }
        if (!error && !format.equals((Object)Format.OTHER) && shortcutImpl == null) {
            msg.setResponseHeader(API.getDefaultResponseHeader(contentType));
            msg.setResponseBody(response);
            msg.getResponseHeader().setContentLength(msg.getResponseBody().length());
        }
        if (impl != null) {
            impl.addCustomHeaders(name, reqType, msg);
        }
        httpOut.write(msg.getResponseHeader());
        httpOut.write(msg.getResponseBody().getBytes());
        httpOut.flush();
        httpOut.close();
        httpIn.close();
        return true;
    }

    public String getBaseURL(Format format, String prefix, RequestType type, String name, boolean proxy) {
        String key = this.getApiKey();
        String base = API_URL;
        if (API.getOptionsParamApi().isSecureOnly()) {
            base = API_URL_S;
        }
        if (!proxy) {
            ProxyParam proxyParam = Model.getSingleton().getOptionsParam().getProxyParam();
            base = API.getOptionsParamApi().isSecureOnly() ? "https://" + proxyParam.getProxyIp() + ":" + proxyParam.getProxyPort() + "/" : "http://" + proxyParam.getProxyIp() + ":" + proxyParam.getProxyPort() + "/";
        }
        if (!RequestType.view.equals((Object)type) && key.length() > 0) {
            return base + format.name() + "/" + prefix + "/" + type.name() + "/" + name + "/?" + API_KEY_PARAM + "=" + key + "&";
        }
        return base + format.name() + "/" + prefix + "/" + type.name() + "/" + name + "/?";
    }

    private String responseToHtml(String name, ApiResponse res) {
        StringBuilder sb = new StringBuilder();
        sb.append("<head>\n");
        sb.append("</head>\n");
        sb.append("<body>\n");
        res.toHTML(sb);
        sb.append("</body>\n");
        return sb.toString();
    }

    private String responseToXml(String name, ApiResponse res) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement(name);
            doc.appendChild(rootElement);
            res.toXML(doc, rootElement);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            transformer.transform(source, result);
            return sw.toString();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static JSONObject getParams(String params) throws ApiException {
        JSONObject jp = new JSONObject();
        if (params == null || params.length() == 0) {
            return jp;
        }
        String[] keyValue = patternParam.split(params);
        String key = null;
        String value = null;
        int pos = 0;
        for (int i = 0; i < keyValue.length; ++i) {
            key = null;
            pos = keyValue[i].indexOf(61);
            if (pos > 0) {
                try {
                    key = URLDecoder.decode(keyValue[i].substring(0, pos), "UTF-8");
                    value = URLDecoder.decode(keyValue[i].substring(pos + 1), "UTF-8");
                    jp.put((Object)key, (Object)value);
                }
                catch (UnsupportedEncodingException | IllegalArgumentException e) {
                    ApiException apiException = new ApiException(ApiException.Type.ILLEGAL_PARAMETER, params, e);
                    logger.error((Object)apiException.getMessage(), (Throwable)apiException);
                }
                continue;
            }
            ApiException e = new ApiException(ApiException.Type.ILLEGAL_PARAMETER, params);
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return jp;
    }

    private String getJsonpWrapper(String json) {
        return "zapJsonpResult (" + json + " )";
    }

    public Map<String, ApiImplementor> getImplementors() {
        return Collections.unmodifiableMap(this.implementors);
    }

    public String getCallBackUrl(ApiImplementor impl, String site) {
        String url = site + CALL_BACK_URL + this.random.nextLong();
        this.callBacks.put(url, impl);
        return url;
    }

    public String getApiKey() {
        return API.getOptionsParamApi().getKey();
    }

    public static String getDefaultResponseHeader(String contentType) {
        return API.getDefaultResponseHeader(contentType, 0);
    }

    public static String getDefaultResponseHeader(String contentType, int contentLength) {
        return API.getDefaultResponseHeader(STATUS_OK, contentType, contentLength);
    }

    public static String getDefaultResponseHeader(String responseStatus, String contentType, int contentLength) {
        StringBuilder sb = new StringBuilder(250);
        sb.append("HTTP/1.1 ").append(responseStatus).append("\r\n");
        sb.append("Pragma: no-cache\r\n");
        sb.append("Cache-Control: no-cache\r\n");
        sb.append("Access-Control-Allow-Methods: GET,POST,OPTIONS\r\n");
        sb.append("Access-Control-Allow-Headers: ZAP-Header\r\n");
        sb.append("X-Clacks-Overhead: GNU Terry Pratchett\r\n");
        sb.append("Content-Length: ").append(contentLength).append("\r\n");
        sb.append("Content-Type: ").append(contentType).append("\r\n");
        return sb.toString();
    }

    private static void handleException(HttpMessage msg, Format format, String contentType, Exception cause) {
        String responseStatus = STATUS_INTERNAL_SERVER_ERROR;
        if (format == Format.OTHER) {
            boolean logError = true;
            if (cause instanceof ApiException) {
                switch (((ApiException)cause).getType()) {
                    case DISABLED: {
                        responseStatus = STATUS_BAD_REQUEST;
                        logger.warn((Object)"ApiException while handling API request:", (Throwable)cause);
                        logError = false;
                        break;
                    }
                    case BAD_TYPE: 
                    case NO_IMPLEMENTOR: 
                    case BAD_API_KEY: 
                    case MISSING_PARAMETER: 
                    case BAD_ACTION: 
                    case BAD_VIEW: 
                    case BAD_OTHER: {
                        responseStatus = STATUS_BAD_REQUEST;
                        logger.warn((Object)"API 'other' malformed request:", (Throwable)cause);
                        logError = false;
                        break;
                    }
                }
            }
            if (logError) {
                logger.error((Object)"API 'other' endpoint didn't handle exception:", (Throwable)cause);
            }
        } else {
            ApiException exception;
            if (cause instanceof ApiException) {
                exception = (ApiException)cause;
                if (!ApiException.Type.INTERNAL_ERROR.equals((Object)exception.getType())) {
                    responseStatus = STATUS_BAD_REQUEST;
                    logger.warn((Object)"ApiException while handling API request:", (Throwable)cause);
                }
            } else {
                exception = new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)cause);
                logger.error((Object)"Exception while handling API request:", (Throwable)cause);
            }
            String response = exception.toString(format, API.getOptionsParamApi().isIncErrorDetails());
            msg.getResponseBody().setCharset(API.getCharset(contentType));
            msg.getResponseBody().setBody(response);
        }
        try {
            msg.setResponseHeader(API.getDefaultResponseHeader(responseStatus, contentType, msg.getResponseBody().length()));
        }
        catch (HttpMalformedHeaderException e) {
            logger.warn((Object)"Failed to build API error response:", (Throwable)e);
        }
    }

    private static String getCharset(String contentType) {
        int idx = contentType.indexOf("charset=");
        if (idx == -1) {
            return "UTF-8";
        }
        return contentType.substring(idx + 8);
    }

    public static enum RequestType {
        action,
        view,
        other;

    }

    public static enum Format {
        XML,
        HTML,
        JSON,
        JSONP,
        UI,
        OTHER;

    }
}

