/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.model.HistoryReference;
import org.zaproxy.zap.extension.alert.PopupMenuShowAlert;
import org.zaproxy.zap.view.messagecontainer.http.HttpMessageContainer;
import org.zaproxy.zap.view.popup.ExtensionPopupMenuComponent;
import org.zaproxy.zap.view.popup.PopupMenuHistoryReferenceContainer;
import org.zaproxy.zap.view.popup.PopupMenuHttpMessageContainer;

public class PopupMenuShowAlerts
extends PopupMenuHistoryReferenceContainer {
    private static final long serialVersionUID = 1L;

    public PopupMenuShowAlerts(String label) {
        super(label);
        this.setProcessExtensionPopupChildren(false);
    }

    @Override
    public boolean isEnableForInvoker(PopupMenuHttpMessageContainer.Invoker invoker, HttpMessageContainer httpMessageContainer) {
        switch (invoker) {
            case SITES_PANEL: 
            case SPIDER_PANEL: 
            case HISTORY_PANEL: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isButtonEnabledForHistoryReference(HistoryReference href) {
        List<Alert> alerts = href.getAlerts();
        if (href.getSiteNode() != null) {
            alerts = href.getSiteNode().getAlerts();
        }
        URI hrefURI = href.getURI();
        ArrayList<PopupMenuShowAlert> alertList = new ArrayList<PopupMenuShowAlert>(alerts.size());
        for (Alert alert : alerts) {
            if (hrefURI != null && !alert.getUri().equals(hrefURI.toString())) continue;
            PopupMenuShowAlert menuItem = new PopupMenuShowAlert(alert.getName(), alert);
            menuItem.setIcon(new ImageIcon(alert.getIconUrl()));
            alertList.add(menuItem);
        }
        Collections.sort(alertList);
        for (PopupMenuShowAlert pmsa : alertList) {
            this.add(pmsa);
        }
        return alertList.size() > 0;
    }

    @Override
    public void dismissed(ExtensionPopupMenuComponent selectedMenuComponent) {
        if (this.getMenuComponentCount() > 0) {
            this.removeAll();
        }
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

