/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.awt.EventQueue;
import java.util.Comparator;
import javax.swing.tree.DefaultTreeModel;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.alert.AlertNode;

class AlertTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 1L;
    private static final Comparator<AlertNode> GROUP_ALERT_CHILD_COMPARATOR = new GroupAlertChildNodeComparator();
    private static final Comparator<AlertNode> ALERT_CHILD_COMPARATOR = new AlertChildNodeComparator();
    private static Logger logger = Logger.getLogger(AlertTreeModel.class);

    AlertTreeModel() {
        super(new AlertNode(-1, Constant.messages.getString("alerts.tree.title"), GROUP_ALERT_CHILD_COMPARATOR));
    }

    private String getRiskString(Alert alert) {
        return "<html><img src=\"" + alert.getIconUrl() + "\">&nbsp;" + alert.getName() + "<html>";
    }

    void addPath(final Alert alert) {
        if (!View.isInitialised() || EventQueue.isDispatchThread()) {
            this.addPathEventHandler(alert);
        } else {
            try {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AlertTreeModel.this.addPathEventHandler(alert);
                    }
                });
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private synchronized void addPathEventHandler(Alert alert) {
        AlertNode parent = (AlertNode)this.getRoot();
        String alertNodeName = this.getRiskString(alert);
        parent = this.findAndAddChild(parent, alertNodeName, alert);
        String method = "";
        if (alert.getMethod() != null) {
            method = alert.getMethod() + ": ";
        }
        this.addLeaf(parent, method + alert.getUri(), alert);
    }

    private AlertNode findLeafNodeForAlert(AlertNode parent, Alert alert) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            AlertNode child = parent.getChildAt(i);
            if (child.getChildCount() == 0) {
                if (child.getUserObject() == null || child.getUserObject().getAlertId() != alert.getAlertId()) continue;
                return child;
            }
            AlertNode node = this.findLeafNodeForAlert(child, alert);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    void updatePath(final Alert originalAlert, final Alert alert) {
        if (!View.isInitialised() || EventQueue.isDispatchThread()) {
            this.updatePathEventHandler(originalAlert, alert);
        } else {
            try {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AlertTreeModel.this.updatePathEventHandler(originalAlert, alert);
                    }
                });
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private synchronized void updatePathEventHandler(Alert originalAlert, Alert alert) {
        AlertNode node = this.findLeafNodeForAlert((AlertNode)this.getRoot(), alert);
        if (node != null) {
            AlertNode parent = node.getParent();
            this.removeNodeFromParent(node);
            this.nodeStructureChanged(parent);
            if (parent.getChildCount() == 0) {
                this.removeNodeFromParent(parent);
                this.nodeStructureChanged((AlertNode)this.getRoot());
            }
        }
        this.addPath(alert);
    }

    private AlertNode findAndAddChild(AlertNode parent, String nodeName, Alert alert) {
        int idx;
        int risk = alert.getRisk();
        if (alert.getConfidence() == 0) {
            risk = -1;
        }
        if ((idx = parent.findIndex(new AlertNode(risk, nodeName))) < 0) {
            idx = -(idx + 1);
            AlertNode node = new AlertNode(risk, nodeName, ALERT_CHILD_COMPARATOR);
            node.setUserObject(alert);
            parent.insert(node, idx);
            this.nodesWereInserted(parent, new int[]{idx});
            this.nodeChanged(parent);
            return node;
        }
        return parent.getChildAt(idx);
    }

    private void addLeaf(AlertNode parent, String nodeName, Alert alert) {
        int risk = alert.getRisk();
        if (alert.getConfidence() == 0) {
            risk = -1;
        }
        AlertNode needle = new AlertNode(risk, nodeName);
        needle.setUserObject(alert);
        int idx = parent.findIndex(needle);
        if (idx < 0) {
            idx = -(idx + 1);
            parent.insert(needle, idx);
            this.nodesWereInserted(parent, new int[]{idx});
            this.nodeChanged(parent);
        }
    }

    public synchronized void deletePath(Alert alert) {
        AlertNode node = this.findLeafNodeForAlert((AlertNode)this.getRoot(), alert);
        if (node != null) {
            AlertNode parent = node.getParent();
            if (parent.getChildCount() == 1) {
                parent.remove(0);
                AlertNode grandParent = parent.getParent();
                this.removeNodeFromParent(parent);
                this.nodeChanged(grandParent);
                return;
            }
            this.removeNodeFromParent(node);
            if (parent.getUserObject() == node.getUserObject()) {
                parent.setUserObject(parent.getChildAt(0).getUserObject());
            }
            this.nodeChanged(parent);
        }
    }

    private static class AlertChildNodeComparator
    implements Comparator<AlertNode> {
        private AlertChildNodeComparator() {
        }

        @Override
        public int compare(AlertNode alertNode, AlertNode anotherAlertNode) {
            return alertNode.getUserObject().compareTo(anotherAlertNode.getUserObject());
        }
    }

    private static class GroupAlertChildNodeComparator
    implements Comparator<AlertNode> {
        private GroupAlertChildNodeComparator() {
        }

        @Override
        public int compare(AlertNode alertNode, AlertNode anotherAlertNode) {
            if (alertNode.getRisk() < anotherAlertNode.getRisk()) {
                return 1;
            }
            if (alertNode.getRisk() > anotherAlertNode.getRisk()) {
                return -1;
            }
            return alertNode.getNodeName().compareTo(anotherAlertNode.getNodeName());
        }
    }
}

