/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.alert.AlertNode;
import org.zaproxy.zap.extension.alert.AlertTreeModel;
import org.zaproxy.zap.extension.alert.AlertViewPanel;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.httppanel.HttpPanelRequest;
import org.zaproxy.zap.extension.httppanel.HttpPanelResponse;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.DeselectableButtonGroup;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.ZapToggleButton;
import org.zaproxy.zap.view.messagecontainer.http.DefaultSelectableHistoryReferencesContainer;

public class AlertPanel
extends AbstractPanel {
    public static final String ALERT_TREE_PANEL_NAME = "treeAlert";
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(AlertPanel.class);
    private ViewDelegate view = null;
    private JTree treeAlert = null;
    private JScrollPane paneScroll = null;
    private JPanel panelCommand = null;
    private JToolBar panelToolbar = null;
    private JSplitPane splitPane = null;
    private AlertViewPanel alertViewPanel = null;
    private ZapToggleButton scopeButton = null;
    private AlertTreeModel linkWithSitesTreeModel;
    private LinkWithSitesTreeSelectionListener linkWithSitesTreeSelectionListener;
    private ZapToggleButton linkWithSitesTreeButton;
    private DeselectableButtonGroup alertsTreeFiltersButtonGroup;
    private ExtensionAlert extension = null;
    private ExtensionHistory extHist = null;

    public AlertPanel(ExtensionAlert extension) {
        this.extension = extension;
        this.alertsTreeFiltersButtonGroup = new DeselectableButtonGroup();
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setSize(274, 251);
        this.setName(Constant.messages.getString("alerts.panel.title"));
        this.setIcon(new ImageIcon(AlertPanel.class.getResource("/resource/icon/16/071.png")));
        this.add((Component)this.getPanelCommand(), this.getPanelCommand().getName());
        this.setDefaultAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1, false));
        this.setMnemonic(Constant.messages.getChar("alerts.panel.mnemonic"));
        this.setShowByDefault(true);
    }

    private JPanel getPanelCommand() {
        if (this.panelCommand == null) {
            this.panelCommand = new JPanel();
            this.panelCommand.setLayout(new GridBagLayout());
            this.panelCommand.setName("AlertPanel");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.anchor = 18;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.anchor = 18;
            this.panelCommand.add((Component)this.getSplitPane(), gridBagConstraints2);
        }
        return this.panelCommand;
    }

    private JToolBar getPanelToolbar() {
        if (this.panelToolbar == null) {
            this.panelToolbar = new JToolBar();
            this.panelToolbar.setLayout(new GridBagLayout());
            this.panelToolbar.setEnabled(true);
            this.panelToolbar.setFloatable(false);
            this.panelToolbar.setRollover(true);
            this.panelToolbar.setPreferredSize(new Dimension(800, 30));
            this.panelToolbar.setName("AlertToolbar");
            this.panelToolbar.add((Component)this.getScopeButton(), LayoutHelper.getGBC(0, 0, 1, 0.0));
            this.panelToolbar.add((Component)this.getLinkWithSitesTreeButton(), LayoutHelper.getGBC(1, 0, 1, 0.0));
            this.panelToolbar.add((Component)new JLabel(), LayoutHelper.getGBC(20, 0, 1, 1.0));
        }
        return this.panelToolbar;
    }

    private JSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane();
            this.splitPane.setName("AlertPanels");
            this.splitPane.setDividerSize(3);
            this.splitPane.setDividerLocation(400);
            this.splitPane.setOrientation(1);
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            panel.add((Component)this.getPanelToolbar(), LayoutHelper.getGBC(0, 0, 1, 0.0));
            panel.add((Component)this.getPaneScroll(), LayoutHelper.getGBC(0, 1, 1, 1.0, 1.0));
            this.splitPane.setLeftComponent(panel);
            this.splitPane.setRightComponent(this.getAlertViewPanel());
            this.splitPane.setPreferredSize(new Dimension(100, 200));
        }
        return this.splitPane;
    }

    public AlertViewPanel getAlertViewPanel() {
        if (this.alertViewPanel == null) {
            this.alertViewPanel = new AlertViewPanel();
        }
        return this.alertViewPanel;
    }

    private JToggleButton getScopeButton() {
        if (this.scopeButton == null) {
            this.scopeButton = new ZapToggleButton();
            this.scopeButton.setIcon(new ImageIcon(AlertPanel.class.getResource("/resource/icon/fugue/target-grey.png")));
            this.scopeButton.setToolTipText(Constant.messages.getString("history.scope.button.unselected"));
            this.scopeButton.setSelectedIcon(new ImageIcon(AlertPanel.class.getResource("/resource/icon/fugue/target.png")));
            this.scopeButton.setSelectedToolTipText(Constant.messages.getString("history.scope.button.selected"));
            DisplayUtils.scaleIcon(this.scopeButton);
            this.scopeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlertPanel.this.extension.setShowJustInScope(AlertPanel.this.scopeButton.isSelected());
                }
            });
            this.alertsTreeFiltersButtonGroup.add(this.scopeButton);
        }
        return this.scopeButton;
    }

    private JToggleButton getLinkWithSitesTreeButton() {
        if (this.linkWithSitesTreeButton == null) {
            this.linkWithSitesTreeButton = new ZapToggleButton();
            this.linkWithSitesTreeButton.setIcon(new ImageIcon(AlertPanel.class.getResource("/resource/icon/16/earth-grey.png")));
            this.linkWithSitesTreeButton.setToolTipText(Constant.messages.getString("alerts.panel.linkWithSitesSelection.unselected.button.tooltip"));
            this.linkWithSitesTreeButton.setSelectedIcon(new ImageIcon(AlertPanel.class.getResource("/resource/icon/16/094.png")));
            this.linkWithSitesTreeButton.setSelectedToolTipText(Constant.messages.getString("alerts.panel.linkWithSitesSelection.selected.button.tooltip"));
            DisplayUtils.scaleIcon(this.linkWithSitesTreeButton);
            this.linkWithSitesTreeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlertPanel.this.setLinkWithSitesTreeSelection(AlertPanel.this.linkWithSitesTreeButton.isSelected());
                }
            });
            this.alertsTreeFiltersButtonGroup.add(this.linkWithSitesTreeButton);
        }
        return this.linkWithSitesTreeButton;
    }

    public void setLinkWithSitesTreeSelection(boolean enabled) {
        this.linkWithSitesTreeButton.setSelected(enabled);
        if (enabled) {
            this.extension.setShowJustInScope(false);
            JTree sitesTree = this.view.getSiteTreePanel().getTreeSite();
            TreePath selectionPath = sitesTree.getSelectionPath();
            this.getTreeAlert().setModel(this.getLinkWithSitesTreeModel());
            if (selectionPath != null) {
                this.recreateLinkWithSitesTreeModel((SiteNode)selectionPath.getLastPathComponent());
            }
            sitesTree.addTreeSelectionListener(this.getLinkWithSitesTreeSelectionListener());
        } else {
            this.extension.setMainTreeModel();
            ((AlertNode)this.getLinkWithSitesTreeModel().getRoot()).removeAllChildren();
            this.view.getSiteTreePanel().getTreeSite().removeTreeSelectionListener(this.getLinkWithSitesTreeSelectionListener());
        }
    }

    private AlertTreeModel getLinkWithSitesTreeModel() {
        if (this.linkWithSitesTreeModel == null) {
            this.linkWithSitesTreeModel = new AlertTreeModel();
        }
        return this.linkWithSitesTreeModel;
    }

    private void recreateLinkWithSitesTreeModel(SiteNode siteNode) {
        if (siteNode == null) {
            throw new IllegalArgumentException("Parameter siteNode must not be null.");
        }
        ((AlertNode)this.getLinkWithSitesTreeModel().getRoot()).removeAllChildren();
        if (siteNode.isRoot()) {
            this.getLinkWithSitesTreeModel().reload();
            this.extension.recalcAlerts();
            return;
        }
        String uri = null;
        HistoryReference historyReference = siteNode.getHistoryReference();
        if (historyReference != null) {
            uri = historyReference.getURI().toString();
        }
        for (Alert alert : siteNode.getAlerts()) {
            if (uri != null && !alert.getUri().equals(uri)) continue;
            this.getLinkWithSitesTreeModel().addPath(alert);
        }
        this.getLinkWithSitesTreeModel().reload();
        this.expandRootChildNodes();
        this.extension.recalcAlerts();
    }

    private LinkWithSitesTreeSelectionListener getLinkWithSitesTreeSelectionListener() {
        if (this.linkWithSitesTreeSelectionListener == null) {
            this.linkWithSitesTreeSelectionListener = new LinkWithSitesTreeSelectionListener();
        }
        return this.linkWithSitesTreeSelectionListener;
    }

    JTree getTreeAlert() {
        if (this.treeAlert == null) {
            this.treeAlert = new JTree();
            this.treeAlert.setName(ALERT_TREE_PANEL_NAME);
            this.treeAlert.setShowsRootHandles(true);
            this.treeAlert.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.treeAlert.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.showPopupMenuIfTriggered(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.showPopupMenuIfTriggered(e);
                }

                private void showPopupMenuIfTriggered(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        AlertPanel.this.showPopupMenu(e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    Object obj;
                    DefaultMutableTreeNode node;
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1 && (node = (DefaultMutableTreeNode)AlertPanel.this.treeAlert.getLastSelectedPathComponent()) != null && node.getUserObject() != null && (obj = node.getUserObject()) instanceof Alert) {
                        Alert alert = (Alert)obj;
                        if (AlertPanel.this.extHist == null) {
                            AlertPanel.this.extHist = (ExtensionHistory)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHistory");
                        }
                        if (AlertPanel.this.extHist != null) {
                            AlertPanel.this.extHist.showAlertAddDialog(alert);
                        }
                    }
                }
            });
            this.treeAlert.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)AlertPanel.this.treeAlert.getLastSelectedPathComponent();
                    if (node != null && node.getUserObject() != null) {
                        Object obj = node.getUserObject();
                        if (obj instanceof Alert) {
                            Alert alert = (Alert)obj;
                            AlertPanel.this.setMessage(alert.getMessage(), alert.getEvidence());
                            AlertPanel.this.treeAlert.requestFocusInWindow();
                            AlertPanel.this.getAlertViewPanel().displayAlert(alert);
                        } else {
                            AlertPanel.this.getAlertViewPanel().clearAlert();
                        }
                    } else {
                        AlertPanel.this.getAlertViewPanel().clearAlert();
                    }
                }
            });
            this.treeAlert.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 525) {
                        Rectangle rec = AlertPanel.this.treeAlert.getUI().getPathBounds(AlertPanel.this.treeAlert, AlertPanel.this.treeAlert.getSelectionPath());
                        AlertPanel.this.showPopupMenu(rec.x, rec.y);
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }
            });
        }
        return this.treeAlert;
    }

    private void showPopupMenu(int x, int y) {
        TreePath tp = this.treeAlert.getPathForLocation(x, y);
        if (tp != null) {
            boolean select = true;
            if (this.treeAlert.getSelectionPaths() != null) {
                for (TreePath t : this.treeAlert.getSelectionPaths()) {
                    if (!t.equals(tp)) continue;
                    select = false;
                    break;
                }
            }
            if (select) {
                this.treeAlert.getSelectionModel().setSelectionPath(tp);
            }
        }
        int countSelectedNodes = this.treeAlert.getSelectionCount();
        ArrayList<HistoryReference> uniqueHistoryReferences = new ArrayList<HistoryReference>(countSelectedNodes);
        if (countSelectedNodes > 0) {
            TreeSet<Integer> historyReferenceIdsAdded = new TreeSet<Integer>();
            for (TreePath path : this.treeAlert.getSelectionPaths()) {
                HistoryReference historyReference;
                AlertNode node = (AlertNode)path.getLastPathComponent();
                Alert userObject = node.getUserObject();
                if (!(userObject instanceof Alert) || (historyReference = userObject.getHistoryRef()) == null || historyReferenceIdsAdded.contains(historyReference.getHistoryId())) continue;
                historyReferenceIdsAdded.add(historyReference.getHistoryId());
                uniqueHistoryReferences.add(historyReference);
            }
            uniqueHistoryReferences.trimToSize();
        }
        DefaultSelectableHistoryReferencesContainer messageContainer = new DefaultSelectableHistoryReferencesContainer(this.treeAlert.getName(), this.treeAlert, Collections.emptyList(), uniqueHistoryReferences);
        this.view.getPopupMenu().show(messageContainer, x, y);
    }

    private JScrollPane getPaneScroll() {
        if (this.paneScroll == null) {
            this.paneScroll = new JScrollPane();
            this.paneScroll.setName("paneScroll");
            this.paneScroll.setViewportView(this.getTreeAlert());
        }
        return this.paneScroll;
    }

    void setView(ViewDelegate view) {
        this.view = view;
    }

    private ViewDelegate getView() {
        return this.view;
    }

    public void expandRoot() {
        if (EventQueue.isDispatchThread()) {
            this.getTreeAlert().expandPath(new TreePath(this.getTreeAlert().getModel().getRoot()));
            return;
        }
        try {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AlertPanel.this.expandRoot();
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void expandRootChildNodes() {
        TreeNode root = (TreeNode)this.getTreeAlert().getModel().getRoot();
        if (root == null) {
            return;
        }
        TreePath basePath = new TreePath(root);
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.getTreeAlert().expandPath(basePath.pathByAddingChild(root.getChildAt(i)));
        }
    }

    private void setMessage(HttpMessage msg, String highlight) {
        this.getView().displayMessage(msg);
        if (msg == null) {
            return;
        }
        if (!msg.getResponseHeader().isEmpty()) {
            HttpPanelRequest requestPanel = this.getView().getRequestPanel();
            HttpPanelResponse responsePanel = this.getView().getResponsePanel();
            SearchMatch sm = null;
            if (highlight != null && highlight.length() != 0) {
                int start = msg.getResponseHeader().toString().indexOf(highlight);
                if (start >= 0) {
                    sm = new SearchMatch(msg, SearchMatch.Location.RESPONSE_HEAD, start, start + highlight.length());
                    responsePanel.highlightHeader(sm);
                    responsePanel.setTabFocus();
                } else {
                    start = msg.getResponseBody().toString().indexOf(highlight);
                    if (start >= 0) {
                        sm = new SearchMatch(msg, SearchMatch.Location.RESPONSE_BODY, start, start + highlight.length());
                        responsePanel.highlightBody(sm);
                        responsePanel.setTabFocus();
                    } else {
                        start = msg.getRequestHeader().toString().indexOf(highlight);
                        if (start >= 0) {
                            sm = new SearchMatch(msg, SearchMatch.Location.REQUEST_HEAD, start, start + highlight.length());
                            requestPanel.highlightHeader(sm);
                            requestPanel.setTabFocus();
                        } else {
                            start = msg.getRequestBody().toString().indexOf(highlight);
                            if (start >= 0) {
                                sm = new SearchMatch(msg, SearchMatch.Location.REQUEST_BODY, start, start + highlight.length());
                                requestPanel.highlightBody(sm);
                                requestPanel.setTabFocus();
                            }
                        }
                    }
                }
            }
        }
    }

    private class LinkWithSitesTreeSelectionListener
    implements TreeSelectionListener {
        private LinkWithSitesTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            AlertPanel.this.recreateLinkWithSitesTreeModel((SiteNode)e.getPath().getLastPathComponent());
        }
    }
}

