/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.core.scanner.PluginFactory;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionLoader;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnClassLoader;
import org.zaproxy.zap.control.AddOnLoaderUtils;
import org.zaproxy.zap.control.AddOnUninstallationProgressCallback;
import org.zaproxy.zap.control.ExtensionFactory;
import org.zaproxy.zap.extension.pscan.ExtensionPassiveScan;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;

public final class AddOnInstaller {
    private static final Logger logger = Logger.getLogger(AddOnInstaller.class);

    private AddOnInstaller() {
    }

    public static void install(AddOnClassLoader addOnClassLoader, AddOn addOn) {
        AddOnInstaller.installAddOnFiles(addOnClassLoader, addOn, true);
        List<Extension> listExts = AddOnInstaller.installAddOnExtensions(addOn);
        AddOnInstaller.installAddOnActiveScanRules(addOn, addOnClassLoader);
        AddOnInstaller.installAddOnPassiveScanRules(addOn, addOnClassLoader);
        for (Extension ext : listExts) {
            try {
                ext.postInstall();
            }
            catch (Exception e) {
                logger.error((Object)("Post install method failed for add-on " + addOn.getId() + " extension " + ext.getName()));
            }
        }
    }

    public static boolean uninstall(AddOn addOn, AddOnUninstallationProgressCallback callback) {
        Validate.notNull((Object)addOn, (String)"Parameter addOn must not be null.");
        AddOnInstaller.validateCallbackNotNull(callback);
        try {
            boolean uninstalledWithoutErrors = true;
            uninstalledWithoutErrors &= AddOnInstaller.uninstallAddOnPassiveScanRules(addOn, callback);
            uninstalledWithoutErrors &= AddOnInstaller.uninstallAddOnActiveScanRules(addOn, callback);
            uninstalledWithoutErrors &= AddOnInstaller.uninstallAddOnExtensions(addOn, callback);
            return uninstalledWithoutErrors &= AddOnInstaller.uninstallAddOnFiles(addOn, callback);
        }
        catch (Throwable e) {
            logger.error((Object)("An error occurred while uninstalling the add-on: " + addOn.getId()), e);
            return false;
        }
    }

    public static boolean softUninstall(AddOn addOn, AddOnUninstallationProgressCallback callback) {
        Validate.notNull((Object)addOn, (String)"Parameter addOn must not be null.");
        AddOnInstaller.validateCallbackNotNull(callback);
        try {
            boolean uninstalledWithoutErrors = true;
            uninstalledWithoutErrors &= AddOnInstaller.uninstallAddOnPassiveScanRules(addOn, callback);
            uninstalledWithoutErrors &= AddOnInstaller.uninstallAddOnActiveScanRules(addOn, callback);
            return uninstalledWithoutErrors &= AddOnInstaller.uninstallAddOnExtensions(addOn, callback);
        }
        catch (Throwable e) {
            logger.error((Object)("An error occurred while uninstalling the add-on: " + addOn.getId()), e);
            return false;
        }
    }

    private static List<Extension> installAddOnExtensions(AddOn addOn) {
        ExtensionLoader extensionLoader = Control.getSingleton().getExtensionLoader();
        List<Extension> listExts = ExtensionFactory.loadAddOnExtensions(extensionLoader, (Configuration)Model.getSingleton().getOptionsParam().getConfig(), addOn);
        for (Extension ext : listExts) {
            AddOnInstaller.installAddOnExtensionImpl(addOn, ext, extensionLoader);
        }
        return listExts;
    }

    public static void installAddOnExtension(AddOn addOn, Extension ext) {
        ExtensionLoader extensionLoader = Control.getSingleton().getExtensionLoader();
        ExtensionFactory.addAddOnExtension(extensionLoader, (Configuration)Model.getSingleton().getOptionsParam().getConfig(), ext);
        AddOnInstaller.installAddOnExtensionImpl(addOn, ext, extensionLoader);
    }

    private static void installAddOnExtensionImpl(AddOn addOn, Extension ext, ExtensionLoader extensionLoader) {
        if (ext.isEnabled()) {
            logger.debug((Object)("Starting extension " + ext.getName()));
            try {
                extensionLoader.startLifeCycle(ext);
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred while installing the add-on: " + addOn.getId()), (Throwable)e);
            }
        }
    }

    private static boolean uninstallAddOnExtensions(AddOn addOn, AddOnUninstallationProgressCallback callback) {
        boolean uninstalledWithoutErrors = true;
        callback.extensionsWillBeRemoved(addOn.getLoadedExtensions().size());
        ArrayList<Extension> extensions = new ArrayList<Extension>(addOn.getLoadedExtensions());
        Collections.reverse(extensions);
        for (Extension ext : extensions) {
            uninstalledWithoutErrors &= AddOnInstaller.uninstallAddOnExtension(addOn, ext, callback);
        }
        return uninstalledWithoutErrors;
    }

    protected static boolean uninstallAddOnExtension(AddOn addOn, Extension extension, AddOnUninstallationProgressCallback callback) {
        boolean uninstalledWithoutErrors = true;
        if (extension.isEnabled()) {
            String extUiName = extension.getUIName();
            if (extension.canUnload()) {
                logger.debug((Object)("Unloading ext: " + extension.getName()));
                try {
                    extension.unload();
                    ExtensionFactory.unloadAddOnExtension(extension);
                }
                catch (Exception e) {
                    logger.error((Object)("An error occurred while uninstalling the extension \"" + extension.getName() + "\" bundled in the add-on \"" + addOn.getId() + "\":"), (Throwable)e);
                    uninstalledWithoutErrors = false;
                }
            } else {
                logger.debug((Object)("Cant dynamically unload ext: " + extension.getName()));
                uninstalledWithoutErrors = false;
            }
            callback.extensionRemoved(extUiName);
        }
        addOn.removeLoadedExtension(extension);
        return uninstalledWithoutErrors;
    }

    private static void installAddOnActiveScanRules(AddOn addOn, AddOnClassLoader addOnClassLoader) {
        List<AbstractPlugin> ascanrules = AddOnLoaderUtils.getActiveScanRules(addOn, addOnClassLoader);
        if (!ascanrules.isEmpty()) {
            for (AbstractPlugin ascanrule : ascanrules) {
                String name = ascanrule.getClass().getCanonicalName();
                logger.debug((Object)("Install ascanrule: " + name));
                PluginFactory.loadedPlugin(ascanrule);
                if (PluginFactory.isPluginLoaded(ascanrule)) continue;
                logger.error((Object)("Failed to install ascanrule: " + name));
            }
        }
    }

    private static boolean uninstallAddOnActiveScanRules(AddOn addOn, AddOnUninstallationProgressCallback callback) {
        boolean uninstalledWithoutErrors = true;
        List<AbstractPlugin> loadedAscanrules = addOn.getLoadedAscanrules();
        if (!loadedAscanrules.isEmpty()) {
            logger.debug((Object)("Uninstall ascanrules: " + addOn.getAscanrules()));
            callback.activeScanRulesWillBeRemoved(loadedAscanrules.size());
            for (AbstractPlugin ascanrule : loadedAscanrules) {
                String name = ascanrule.getClass().getCanonicalName();
                logger.debug((Object)("Uninstall ascanrule: " + name));
                PluginFactory.unloadedPlugin(ascanrule);
                if (PluginFactory.isPluginLoaded(ascanrule)) {
                    logger.error((Object)("Failed to uninstall ascanrule: " + name));
                    uninstalledWithoutErrors = false;
                }
                callback.activeScanRuleRemoved(name);
            }
            addOn.setLoadedAscanrules(Collections.emptyList());
            addOn.setLoadedAscanrulesSet(false);
        }
        return uninstalledWithoutErrors;
    }

    private static void installAddOnPassiveScanRules(AddOn addOn, AddOnClassLoader addOnClassLoader) {
        List<PluginPassiveScanner> pscanrules = AddOnLoaderUtils.getPassiveScanRules(addOn, addOnClassLoader);
        ExtensionPassiveScan extPscan = (ExtensionPassiveScan)Control.getSingleton().getExtensionLoader().getExtension("ExtensionPassiveScan");
        if (!pscanrules.isEmpty() && extPscan != null) {
            for (PluginPassiveScanner pscanrule : pscanrules) {
                String name = pscanrule.getClass().getCanonicalName();
                logger.debug((Object)("Install pscanrule: " + name));
                if (extPscan.addPassiveScanner(pscanrule)) continue;
                logger.error((Object)("Failed to install pscanrule: " + name));
            }
        }
    }

    private static boolean uninstallAddOnPassiveScanRules(AddOn addOn, AddOnUninstallationProgressCallback callback) {
        boolean uninstalledWithoutErrors = true;
        List<PluginPassiveScanner> loadedPscanrules = addOn.getLoadedPscanrules();
        ExtensionPassiveScan extPscan = (ExtensionPassiveScan)Control.getSingleton().getExtensionLoader().getExtension("ExtensionPassiveScan");
        if (!loadedPscanrules.isEmpty()) {
            logger.debug((Object)("Uninstall pscanrules: " + addOn.getPscanrules()));
            callback.passiveScanRulesWillBeRemoved(loadedPscanrules.size());
            for (PluginPassiveScanner pscanrule : loadedPscanrules) {
                String name = pscanrule.getClass().getCanonicalName();
                logger.debug((Object)("Uninstall pscanrule: " + name));
                if (!extPscan.removePassiveScanner(pscanrule)) {
                    logger.error((Object)("Failed to uninstall pscanrule: " + name));
                    uninstalledWithoutErrors = false;
                }
                callback.passiveScanRuleRemoved(name);
            }
            addOn.setLoadedPscanrules(Collections.emptyList());
            addOn.setLoadedPscanrulesSet(false);
        }
        return uninstalledWithoutErrors;
    }

    public static void installMissingAddOnFiles(AddOnClassLoader addOnClassLoader, AddOn addOn) {
        AddOnInstaller.installAddOnFiles(addOnClassLoader, addOn, false);
    }

    private static void installAddOnFiles(AddOnClassLoader addOnClassLoader, AddOn addOn, boolean overwrite) {
        List<String> fileNames = addOn.getFiles();
        if (fileNames == null || fileNames.isEmpty()) {
            return;
        }
        for (String name : fileNames) {
            File outfile = new File(Constant.getZapHome(), name);
            if (!overwrite && outfile.exists()) continue;
            if (!outfile.getParentFile().exists() && !outfile.getParentFile().mkdirs()) {
                logger.error((Object)("Failed to create directories for: " + outfile.getAbsolutePath()));
                continue;
            }
            logger.debug((Object)("Installing file: " + name));
            URL fileURL = addOnClassLoader.findResource(name);
            if (fileURL == null) {
                logger.error((Object)("File not found on add-on package: " + name));
                continue;
            }
            try {
                InputStream in = fileURL.openStream();
                Throwable throwable = null;
                try {
                    FileOutputStream out = new FileOutputStream(outfile);
                    Throwable throwable2 = null;
                    try {
                        int bytesRead;
                        byte[] buffer = new byte[1024];
                        while ((bytesRead = in.read(buffer)) != -1) {
                            ((OutputStream)out).write(buffer, 0, bytesRead);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((OutputStream)out).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)("Failed to install file " + outfile.getAbsolutePath()), (Throwable)e);
            }
        }
        Control.getSingleton().getExtensionLoader().addonFilesAdded();
    }

    private static void validateCallbackNotNull(AddOnUninstallationProgressCallback callback) {
        Validate.notNull((Object)callback, (String)"Parameter callback must not be null.");
    }

    public static boolean uninstallAddOnFiles(AddOn addOn, AddOnUninstallationProgressCallback callback) {
        Validate.notNull((Object)addOn, (String)"Parameter addOn must not be null.");
        AddOnInstaller.validateCallbackNotNull(callback);
        List<String> fileNames = addOn.getFiles();
        if (fileNames == null || fileNames.isEmpty()) {
            return true;
        }
        callback.filesWillBeRemoved(fileNames.size());
        boolean uninstalledWithoutErrors = true;
        for (String name : fileNames) {
            if (name == null) continue;
            logger.debug((Object)("Uninstall file: " + name));
            File file = new File(Constant.getZapHome(), name);
            try {
                File parent = file.getParentFile();
                if (!file.delete()) {
                    logger.error((Object)("Failed to delete: " + file.getAbsolutePath()));
                    uninstalledWithoutErrors = false;
                }
                callback.fileRemoved();
                if (parent.isDirectory() && parent.list().length == 0) {
                    logger.debug((Object)("Deleting: " + parent.getAbsolutePath()));
                    if (!parent.delete()) {
                        logger.debug((Object)("Failed to delete: " + parent.getAbsolutePath()));
                    }
                }
                AddOnInstaller.deleteEmptyDirsCreatedForAddOnFiles(file);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to uninstall file " + file.getAbsolutePath()), (Throwable)e);
            }
        }
        Control.getSingleton().getExtensionLoader().addonFilesRemoved();
        return uninstalledWithoutErrors;
    }

    private static void deleteEmptyDirsCreatedForAddOnFiles(File file) {
        File currentFile;
        if (file == null) {
            return;
        }
        for (currentFile = file; currentFile != null && !currentFile.exists(); currentFile = currentFile.getParentFile()) {
        }
        String root = new File(Constant.getZapHome()).getAbsolutePath();
        while (currentFile != null && currentFile.exists() && currentFile.getAbsolutePath().startsWith(root) && currentFile.getAbsolutePath().length() > root.length()) {
            AddOnInstaller.deleteEmptyDirs(currentFile);
            currentFile = currentFile.getParentFile();
        }
    }

    private static void deleteEmptyDirs(File dir) {
        logger.debug((Object)("Deleting dir " + dir.getAbsolutePath()));
        for (File d : dir.listFiles()) {
            if (!d.isDirectory()) continue;
            AddOnInstaller.deleteEmptyDirs(d);
        }
        if (!dir.delete()) {
            logger.debug((Object)("Failed to delete: " + dir.getAbsolutePath()));
        }
    }
}

