/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnRunIssuesUtils;
import org.zaproxy.zap.control.ZapRelease;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public class AddOnCollection {
    private static final Logger logger = Logger.getLogger(AddOnCollection.class);
    private ZapRelease zapRelease = null;
    private List<AddOn> addOns = new ArrayList<AddOn>();
    private File downloadDir = new File(Constant.FOLDER_LOCAL_PLUGIN);
    private Platform platform;

    public AddOnCollection(ZapXmlConfiguration config, Platform platform) {
        this(config, platform, true);
    }

    public AddOnCollection(ZapXmlConfiguration config, Platform platform, boolean allowAddOnsWithDependencyIssues) {
        this.platform = platform;
        this.load(config);
        if (!allowAddOnsWithDependencyIssues) {
            ArrayList<AddOn> checkedAddOns = new ArrayList<AddOn>(this.addOns);
            ArrayList<AddOn> runnableAddOns = new ArrayList<AddOn>(this.addOns.size());
            while (!checkedAddOns.isEmpty()) {
                AddOn addOn = (AddOn)checkedAddOns.remove(0);
                AddOn.AddOnRunRequirements requirements = addOn.calculateRunRequirements(this.addOns);
                if (requirements.hasDependencyIssue()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Ignoring add-on  " + addOn.getName() + " because of dependency issue: " + AddOnRunIssuesUtils.getDependencyIssue(requirements)));
                    }
                    if (AddOn.BaseRunRequirements.DependencyIssue.CYCLIC != requirements.getDependencyIssue()) continue;
                    Set cyclicChain = (Set)requirements.getDependencyIssueDetails().get(0);
                    checkedAddOns.removeAll(cyclicChain);
                    continue;
                }
                if (requirements.hasExtensionsWithRunningIssues()) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Ignoring add-on  " + addOn.getName() + " because of dependency issue in an extension: " + AddOnRunIssuesUtils.getDependencyIssue(requirements)));
                    continue;
                }
                runnableAddOns.add(addOn);
            }
            this.addOns = runnableAddOns;
        }
    }

    private void load(ZapXmlConfiguration config) {
        config.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        try {
            String version = config.getString("core/version");
            if (Platform.daily.equals((Object)this.platform)) {
                version = config.getString("core/daily-version", version);
            } else if (Constant.isKali()) {
                version = config.getString("core/kali-version", version);
            }
            if (version != null && version.length() > 0) {
                String relUrlStr = config.getString("core/relnotes-url", null);
                URL relUrl = null;
                if (relUrlStr != null) {
                    relUrl = new URL(relUrlStr);
                }
                this.zapRelease = new ZapRelease(version, new URL(config.getString("core/" + this.platform.name() + "/url")), config.getString("core/" + this.platform.name() + "/file"), config.getLong("core/" + this.platform.name() + "/size"), config.getString("core/relnotes"), relUrl, config.getString("core/" + this.platform.name() + "/hash"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            String[] addOnIds;
            for (String id : addOnIds = config.getStringArray("addon")) {
                AddOn ao;
                logger.debug((Object)("Found addon " + id));
                try {
                    ao = new AddOn(id, this.downloadDir, config.configurationAt("addon_" + id));
                    ao.setInstallationStatus(AddOn.InstallationStatus.AVAILABLE);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to create add-on for " + id), (Throwable)e);
                    continue;
                }
                if (ao.canLoadInCurrentVersion()) {
                    this.addOns.add(ao);
                    continue;
                }
                logger.debug((Object)("Ignoring addon " + ao.getName() + " cant load in this version"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public AddOnCollection(File[] dirs) {
        if (dirs != null) {
            for (File dir : dirs) {
                try {
                    this.addDirectory(dir);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void addDirectory(File dir) throws Exception {
        File[] listFile;
        if (dir == null) {
            logger.error((Object)"Null directory supplied");
            return;
        }
        if (!dir.exists()) {
            logger.error((Object)("No such directory: " + dir.getAbsolutePath()));
        }
        if (!dir.isDirectory()) {
            logger.error((Object)("Not a directory: " + dir.getAbsolutePath()));
        }
        if ((listFile = dir.listFiles()) != null) {
            for (File addOnFile : listFile) {
                AddOn ao;
                if (!AddOn.isAddOn(addOnFile) || (ao = AddOnCollection.createAddOn(addOnFile)) == null) continue;
                boolean add = true;
                for (AddOn addOn : this.addOns) {
                    if (!ao.isSameAddOn(addOn)) continue;
                    if (ao.isUpdateTo(addOn)) {
                        if (ao.canLoadInCurrentVersion()) {
                            logger.debug((Object)("Addon " + addOn.getId() + " version " + addOn.getFileVersion() + " superceeded by " + ao.getFileVersion()));
                            this.addOns.remove(addOn);
                            break;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Ignoring newer addon " + ao.getId() + " version " + ao.getFileVersion() + " because of ZAP version constraints; Not before=" + ao.getNotBeforeVersion() + " Not from=" + ao.getNotFromVersion() + " Current Version=" + Constant.PROGRAM_VERSION));
                        }
                        add = false;
                        break;
                    }
                    logger.debug((Object)("Addon " + ao.getId() + " version " + ao.getFileVersion() + " not latest."));
                    add = false;
                    break;
                }
                if (!add) continue;
                logger.debug((Object)("Found addon " + ao.getId() + " version " + ao.getFileVersion()));
                this.addOns.add(ao);
            }
        }
    }

    private static AddOn createAddOn(File addOnFile) {
        try {
            return new AddOn(addOnFile);
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to create add-on for: " + addOnFile.toString()), (Throwable)e);
            return null;
        }
    }

    public List<AddOn> getAddOns() {
        return this.addOns;
    }

    public List<AddOn> getInstalledAddOns() {
        ArrayList<AddOn> installedAddOns = new ArrayList<AddOn>(this.addOns.size());
        for (AddOn addOn : this.addOns) {
            if (AddOn.InstallationStatus.INSTALLED != addOn.getInstallationStatus()) continue;
            installedAddOns.add(addOn);
        }
        return installedAddOns;
    }

    public AddOn getAddOn(String id) {
        for (AddOn addOn : this.addOns) {
            if (!addOn.getId().equals(id)) continue;
            return addOn;
        }
        return null;
    }

    public List<AddOn> getUpdatedAddOns(AddOnCollection aoc) {
        ArrayList<AddOn> updatedAddOns = new ArrayList<AddOn>();
        for (AddOn ao : aoc.getAddOns()) {
            for (AddOn addOn : this.addOns) {
                try {
                    if (!ao.isSameAddOn(addOn) || !ao.isUpdateTo(addOn)) continue;
                    updatedAddOns.add(ao);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return updatedAddOns;
    }

    public List<AddOn> getNewAddOns(AddOnCollection aoc) {
        ArrayList<AddOn> newAddOns = new ArrayList<AddOn>();
        for (AddOn ao : aoc.getAddOns()) {
            boolean isNew = true;
            for (AddOn addOn : this.addOns) {
                try {
                    if (!ao.isSameAddOn(addOn)) continue;
                    isNew = false;
                    break;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (!isNew) continue;
            newAddOns.add(ao);
        }
        return newAddOns;
    }

    public ZapRelease getZapRelease() {
        return this.zapRelease;
    }

    public boolean includesAddOn(String id) {
        boolean inc = false;
        for (AddOn addOn : this.addOns) {
            if (!addOn.getId().equals(id)) continue;
            return true;
        }
        return inc;
    }

    public boolean addAddOn(AddOn ao) {
        if (this.includesAddOn(ao.getId())) {
            return false;
        }
        this.addOns.add(ao);
        return true;
    }

    public boolean removeAddOn(AddOn ao) {
        for (AddOn addOn : this.addOns) {
            if (!addOn.getId().equals(ao.getId())) continue;
            this.addOns.remove(addOn);
            return true;
        }
        return false;
    }

    public static enum Platform {
        daily,
        windows,
        linux,
        mac;

    }
}

