/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap;

import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.DefaultFileSystem;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.control.ControlOverrides;

abstract class ZapBootstrap {
    private final CommandLine args;
    private final ControlOverrides controlOverrides;

    public ZapBootstrap(CommandLine args) {
        this.args = args;
        this.controlOverrides = new ControlOverrides();
        this.controlOverrides.setProxyPort(this.getArgs().getPort());
        this.controlOverrides.setProxyHost(this.getArgs().getHost());
        this.controlOverrides.setConfigs(this.getArgs().getConfigs());
        this.controlOverrides.setExperimentalDb(this.getArgs().isExperimentalDb());
    }

    public int start() {
        NullAppender na = new NullAppender();
        Logger.getRootLogger().addAppender((Appender)na);
        Logger.getRootLogger().setLevel(Level.OFF);
        Logger.getLogger(ConfigurationUtils.class).addAppender((Appender)na);
        Logger.getLogger(DefaultFileSystem.class).addAppender((Appender)na);
        try {
            Constant.getInstance();
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            return 1;
        }
        Constant.setLowMemoryOption(this.getArgs().isLowMem());
        return 0;
    }

    protected void initModel() throws Exception {
        Model.getSingleton().init(this.getControlOverrides());
        Model.getSingleton().getOptionsParam().setGUI(this.getArgs().isGUI());
    }

    protected CommandLine getArgs() {
        return this.args;
    }

    protected ControlOverrides getControlOverrides() {
        return this.controlOverrides;
    }

    protected static String getStartingMessage() {
        return "OWASP ZAP " + Constant.PROGRAM_VERSION + " started.";
    }
}

