/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.util.regex.Pattern;
import org.zaproxy.zap.utils.Enableable;

public class ProxyExcludedDomainMatcher
extends Enableable {
    private final Pattern pattern;
    private final String domain;
    private final boolean regex;

    public ProxyExcludedDomainMatcher(Pattern pattern) {
        super(true);
        if (pattern == null) {
            throw new IllegalArgumentException("Parameter pattern must not be null.");
        }
        this.pattern = pattern;
        this.regex = true;
        this.domain = null;
    }

    public ProxyExcludedDomainMatcher(String domain) {
        super(true);
        if (domain == null || domain.isEmpty()) {
            throw new IllegalArgumentException("Parameter domain must not be null or empty.");
        }
        this.domain = domain;
        this.regex = false;
        this.pattern = null;
    }

    public ProxyExcludedDomainMatcher(ProxyExcludedDomainMatcher other) {
        super(other.isEnabled());
        this.domain = other.domain;
        this.regex = other.regex;
        this.pattern = other.pattern;
    }

    public String getValue() {
        if (this.isRegex()) {
            return this.pattern.pattern();
        }
        return this.domain;
    }

    public boolean isRegex() {
        return this.regex;
    }

    public boolean matches(String domain) {
        if (this.pattern != null) {
            return this.pattern.matcher(domain).matches();
        }
        return this.domain.equals(domain);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.pattern().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ProxyExcludedDomainMatcher other = (ProxyExcludedDomainMatcher)object;
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        return !(this.pattern == null ? other.pattern != null : !this.pattern.pattern().equals(other.pattern.pattern()));
    }

    public static Pattern createPattern(String regex) {
        return Pattern.compile(regex, 2);
    }
}

