/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class HttpBody {
    private static final Logger log = Logger.getLogger(HttpBody.class);
    public static final String DEFAULT_CHARSET = StandardCharsets.ISO_8859_1.name();
    public static final int LIMIT_INITIAL_CAPACITY = 128000;
    private byte[] body;
    private int pos;
    private String cachedString;
    private Charset charset;

    public HttpBody() {
        this(0);
    }

    public HttpBody(int capacity) {
        this.body = new byte[Math.max(Math.min(capacity, 128000), 0)];
    }

    public HttpBody(byte[] contents) {
        if (contents != null) {
            this.setBody(contents);
        } else {
            this.body = new byte[0];
        }
    }

    public HttpBody(String contents) {
        if (contents != null) {
            this.setBody(contents);
        } else {
            this.body = new byte[0];
        }
    }

    public void setBody(byte[] contents) {
        if (contents == null) {
            return;
        }
        this.cachedString = null;
        this.body = new byte[contents.length];
        System.arraycopy(contents, 0, this.body, 0, contents.length);
        this.pos = this.body.length;
    }

    public void setBody(String contents) {
        if (contents == null) {
            return;
        }
        this.cachedString = null;
        this.body = contents.getBytes(this.getCharsetImpl());
        this.pos = this.body.length;
    }

    private Charset getCharsetImpl() {
        if (this.charset != null) {
            return this.charset;
        }
        return StandardCharsets.ISO_8859_1;
    }

    public void append(byte[] contents, int length) {
        if (contents == null || length <= 0) {
            return;
        }
        int len = Math.min(contents.length, length);
        if (this.pos + len > this.body.length) {
            byte[] newBody = new byte[this.pos + len];
            System.arraycopy(this.body, 0, newBody, 0, this.pos);
            this.body = newBody;
        }
        System.arraycopy(contents, 0, this.body, this.pos, len);
        this.pos += len;
        this.cachedString = null;
    }

    public void append(byte[] contents) {
        if (contents == null) {
            return;
        }
        this.append(contents, contents.length);
    }

    public void append(String contents) {
        if (contents == null) {
            return;
        }
        this.append(contents.getBytes(this.getCharsetImpl()));
    }

    public String toString() {
        if (this.cachedString != null) {
            return this.cachedString;
        }
        this.cachedString = this.createString(this.charset);
        return this.cachedString;
    }

    protected String createString(Charset charset) {
        return new String(this.getBytes(), 0, this.getPos(), charset != null ? charset : this.getCharsetImpl());
    }

    protected final int getPos() {
        return this.pos;
    }

    public byte[] getBytes() {
        return this.body;
    }

    public int length() {
        return this.body.length;
    }

    public void setLength(int length) {
        if (length < 0 || this.body.length == length) {
            return;
        }
        int oldPos = this.pos;
        this.pos = Math.min(this.pos, length);
        byte[] newBody = new byte[length];
        System.arraycopy(this.body, 0, newBody, 0, this.pos);
        this.body = newBody;
        if (oldPos > this.pos) {
            this.cachedString = null;
        }
    }

    public String getCharset() {
        if (this.charset != null) {
            return this.charset.name();
        }
        return DEFAULT_CHARSET;
    }

    public void setCharset(String charsetName) {
        if (StringUtils.isEmpty((String)charsetName)) {
            this.setCharsetImpl(null);
            return;
        }
        Charset newCharset = null;
        try {
            newCharset = Charset.forName(charsetName);
            if (newCharset != this.charset) {
                this.setCharsetImpl(newCharset);
            }
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            log.error((Object)("Failed to set charset: " + charsetName), (Throwable)e);
        }
    }

    private void setCharsetImpl(Charset newCharset) {
        this.charset = newCharset;
        this.cachedString = null;
    }

    public int hashCode() {
        return 31 + Arrays.hashCode(this.body);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HttpBody otherBody = (HttpBody)object;
        return Arrays.equals(this.body, otherBody.body);
    }
}

