/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import java.awt.EventQueue;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteMapEventPublisher;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.eventBus.Event;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.view.SiteTreeFilter;

public class SiteMap
extends DefaultTreeModel {
    private static final long serialVersionUID = 2311091007687218751L;
    private static Map<Integer, SiteNode> hrefMap = new HashMap<Integer, SiteNode>();
    private Model model = null;
    private SiteTreeFilter filter = null;
    private static Logger log = Logger.getLogger(SiteMap.class);

    public static SiteMap createTree(Model model) {
        SiteMap siteMap = new SiteMap(null, model);
        SiteNode root = new SiteNode(siteMap, -1, Constant.messages.getString("tab.sites"));
        siteMap.setRoot(root);
        hrefMap = new HashMap<Integer, SiteNode>();
        return siteMap;
    }

    public SiteMap(SiteNode root, Model model) {
        super(root);
        this.model = model;
    }

    public synchronized HttpMessage pollPath(HttpMessage msg) {
        SiteNode resultNode = null;
        URI uri = msg.getRequestHeader().getURI();
        SiteNode parent = (SiteNode)this.getRoot();
        try {
            String host = this.getHostName(uri);
            parent = this.findChild(parent, host);
            if (parent == null) {
                return null;
            }
            List<String> path = this.model.getSession().getTreePath(uri);
            if (path.size() == 0) {
                resultNode = parent;
            }
            for (int i = 0; i < path.size(); ++i) {
                String folder = path.get(i);
                if (folder == null || folder.equals("")) continue;
                if (i == path.size() - 1) {
                    String leafName = this.getLeafName(folder, msg);
                    resultNode = this.findChild(parent, leafName);
                    continue;
                }
                if ((parent = this.findChild(parent, folder)) != null) continue;
                return null;
            }
        }
        catch (URIException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (resultNode == null || resultNode.getHistoryReference() == null) {
            return null;
        }
        HttpMessage nodeMsg = null;
        try {
            nodeMsg = resultNode.getHistoryReference().getHttpMessage();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return nodeMsg;
    }

    public SiteNode findNode(HttpMessage msg) {
        return this.findNode(msg, false);
    }

    public synchronized SiteNode findNode(HttpMessage msg, boolean matchStructural) {
        if (Constant.isLowMemoryOptionSet()) {
            throw new InvalidParameterException("SiteMap should not be accessed when the low memory option is set");
        }
        if (msg == null || msg.getRequestHeader() == null) {
            return null;
        }
        SiteNode resultNode = null;
        URI uri = msg.getRequestHeader().getURI();
        SiteNode parent = (SiteNode)this.getRoot();
        String folder = "";
        try {
            String host = this.getHostName(uri);
            parent = this.findChild(parent, host);
            if (parent == null) {
                return null;
            }
            List<String> path = this.model.getSession().getTreePath(msg);
            if (path.size() == 0) {
                resultNode = parent;
            }
            for (int i = 0; i < path.size(); ++i) {
                folder = path.get(i);
                if (folder == null || folder.equals("")) continue;
                if (i == path.size() - 1) {
                    if (matchStructural) {
                        resultNode = this.findChild(parent, folder);
                        continue;
                    }
                    String leafName = this.getLeafName(folder, msg);
                    resultNode = this.findChild(parent, leafName);
                    continue;
                }
                if ((parent = this.findChild(parent, folder)) != null) continue;
                return null;
            }
        }
        catch (URIException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return resultNode;
    }

    public synchronized SiteNode findNode(URI uri) {
        SiteNode node = this.findNode(uri, null, null);
        if (node != null) {
            return node;
        }
        return this.findNode(uri, "GET", null);
    }

    public synchronized SiteNode findNode(URI uri, String method, String postData) {
        if (Constant.isLowMemoryOptionSet()) {
            throw new InvalidParameterException("SiteMap should not be accessed when the low memory option is set");
        }
        SiteNode resultNode = null;
        String folder = "";
        try {
            String host = this.getHostName(uri);
            resultNode = this.findChild((SiteNode)this.getRoot(), host);
            if (resultNode == null) {
                return null;
            }
            List<String> path = this.model.getSession().getTreePath(uri);
            for (int i = 0; i < path.size(); ++i) {
                folder = path.get(i);
                if (folder == null || folder.equals("")) continue;
                if (i == path.size() - 1) {
                    String leafName = this.getLeafName(folder, uri, method, postData);
                    resultNode = this.findChild(resultNode, leafName);
                    continue;
                }
                if ((resultNode = this.findChild(resultNode, folder)) != null) continue;
                return null;
            }
        }
        catch (URIException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return resultNode;
    }

    public synchronized SiteNode findClosestParent(HttpMessage msg) {
        if (msg == null || msg.getRequestHeader() == null) {
            return null;
        }
        return this.findClosestParent(msg.getRequestHeader().getURI());
    }

    public synchronized SiteNode findClosestParent(URI uri) {
        if (uri == null) {
            return null;
        }
        SiteNode lastParent = null;
        SiteNode parent = (SiteNode)this.getRoot();
        String folder = "";
        try {
            String host = this.getHostName(uri);
            parent = this.findChild(parent, host);
            if (parent == null) {
                return null;
            }
            lastParent = parent;
            List<String> path = this.model.getSession().getTreePath(uri);
            for (int i = 0; i < path.size(); ++i) {
                folder = path.get(i);
                if (folder == null || folder.equals("")) continue;
                if (i == path.size() - 1) {
                    lastParent = parent;
                    continue;
                }
                if ((parent = this.findChild(parent, folder)) != null) {
                    lastParent = parent;
                    continue;
                }
                break;
            }
        }
        catch (URIException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return lastParent;
    }

    public synchronized SiteNode addPath(HistoryReference ref) {
        if (Constant.isLowMemoryOptionSet()) {
            throw new InvalidParameterException("SiteMap should not be accessed when the low memory option is set");
        }
        HttpMessage msg = null;
        try {
            msg = ref.getHttpMessage();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return this.addPath(ref, msg);
    }

    public SiteNode addPath(HistoryReference ref, HttpMessage msg) {
        if (Constant.isLowMemoryOptionSet()) {
            throw new InvalidParameterException("SiteMap should not be accessed when the low memory option is set");
        }
        if (View.isInitialised() && Constant.isDevBuild() && !EventQueue.isDispatchThread()) {
            log.error((Object)("SiteMap.addPath not on EDT " + Thread.currentThread().getName()), (Throwable)new Exception());
        }
        URI uri = msg.getRequestHeader().getURI();
        log.debug((Object)("addPath " + uri.toString()));
        SiteNode parent = (SiteNode)this.getRoot();
        SiteNode leaf = null;
        String folder = "";
        try {
            String host = this.getHostName(uri);
            parent = this.findAndAddChild(parent, host, ref, msg);
            List<String> path = this.model.getSession().getTreePath(msg);
            for (int i = 0; i < path.size(); ++i) {
                folder = path.get(i);
                if (folder == null || folder.equals("")) continue;
                if (i == path.size() - 1) {
                    leaf = this.findAndAddLeaf(parent, folder, ref, msg);
                    ref.setSiteNode(leaf);
                    continue;
                }
                parent = this.findAndAddChild(parent, folder, ref, msg);
            }
            if (leaf == null) {
                parent.setHistoryReference(ref);
                leaf = parent;
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception adding " + uri.toString() + " " + e.getMessage()), (Throwable)e);
        }
        if (hrefMap.get(ref.getHistoryId()) == null) {
            hrefMap.put(ref.getHistoryId(), leaf);
        }
        return leaf;
    }

    private SiteNode findAndAddChild(SiteNode parent, String nodeName, HistoryReference baseRef, HttpMessage baseMsg) throws URIException, HttpMalformedHeaderException, NullPointerException, DatabaseException {
        log.debug((Object)("findAndAddChild " + parent.getNodeName() + " / " + nodeName));
        SiteNode result = this.findChild(parent, nodeName);
        if (result == null) {
            SiteNode newNode = null;
            if (!baseRef.getCustomIcons().isEmpty()) {
                newNode = new SiteNode(this, baseRef.getHistoryType(), nodeName);
                newNode.setCustomIcons(baseRef.getCustomIcons(), baseRef.getClearIfManual());
            } else {
                newNode = new SiteNode(this, baseRef.getHistoryType(), nodeName);
            }
            int pos = parent.getChildCount();
            for (int i = 0; i < parent.getChildCount(); ++i) {
                if (!((SiteNode)parent.getChildAt(i)).isParentOf(nodeName)) continue;
                pos = i;
                break;
            }
            this.insertNodeInto(newNode, parent, pos);
            result = newNode;
            result.setHistoryReference(this.createReference(result, baseRef, baseMsg));
            newNode.setIncludedInScope(this.model.getSession().isIncludedInScope(newNode), true);
            newNode.setExcludedFromScope(this.model.getSession().isExcludedFromScope(newNode), true);
            hrefMap.put(result.getHistoryReference().getHistoryId(), result);
            this.applyFilter(newNode);
            this.handleEvent(parent, result, EventType.ADD);
        }
        if (baseRef.getSiteNode() == null) {
            baseRef.setSiteNode(result);
        }
        return result;
    }

    private SiteNode findChild(SiteNode parent, String nodeName) {
        log.debug((Object)("findChild " + parent.getNodeName() + " / " + nodeName));
        for (int i = 0; i < parent.getChildCount(); ++i) {
            SiteNode child = (SiteNode)parent.getChildAt(i);
            if (!child.getNodeName().equals(nodeName)) continue;
            return child;
        }
        return null;
    }

    private SiteNode findAndAddLeaf(SiteNode parent, String nodeName, HistoryReference ref, HttpMessage msg) {
        log.debug((Object)("findAndAddLeaf " + parent.getNodeName() + " / " + nodeName));
        String leafName = this.getLeafName(nodeName, msg);
        SiteNode node = this.findChild(parent, leafName);
        if (node == null) {
            if (!ref.getCustomIcons().isEmpty()) {
                node = new SiteNode(this, ref.getHistoryType(), leafName);
                node.setCustomIcons(ref.getCustomIcons(), ref.getClearIfManual());
            } else {
                node = new SiteNode(this, ref.getHistoryType(), leafName);
            }
            node.setHistoryReference(ref);
            hrefMap.put(ref.getHistoryId(), node);
            int pos = parent.getChildCount();
            for (int i = 0; i < parent.getChildCount(); ++i) {
                if (!((SiteNode)parent.getChildAt(i)).isParentOf(nodeName)) continue;
                pos = i;
                break;
            }
            if (ref.getSiteNode() == null) {
                ref.setSiteNode(node);
            }
            this.insertNodeInto(node, parent, pos);
            node.setIncludedInScope(this.model.getSession().isIncludedInScope(node), true);
            node.setExcludedFromScope(this.model.getSession().isExcludedFromScope(node), true);
            this.applyFilter(node);
            this.handleEvent(parent, node, EventType.ADD);
        } else {
            if (msg.getResponseHeader().getStatusCode() == 200) {
                node.setHistoryReference(ref);
                ref.setSiteNode(node);
            } else {
                node.getPastHistoryReference().add(ref);
                ref.setSiteNode(node);
            }
            hrefMap.put(ref.getHistoryId(), node);
        }
        return node;
    }

    private String getLeafName(String nodeName, HttpMessage msg) {
        String leafName = msg.getRequestHeader().getMethod() + ":" + nodeName;
        leafName = leafName + this.getQueryParamString(msg.getParamNameSet(HtmlParameter.Type.url));
        if (msg.getRequestHeader().getMethod().equalsIgnoreCase("POST")) {
            String contentType = msg.getRequestHeader().getHeader("Content-Type");
            leafName = contentType != null && contentType.startsWith("multipart/form-data") ? leafName + "(multipart/form-data)" : leafName + this.getQueryParamString(msg.getParamNameSet(HtmlParameter.Type.form));
        }
        return leafName;
    }

    private String getLeafName(String nodeName, URI uri, String method, String postData) {
        String leafName = method != null && !method.isEmpty() ? method + ":" + nodeName : nodeName;
        try {
            leafName = leafName + this.getQueryParamString(this.model.getSession().getUrlParams(uri));
            if (method != null && method.equalsIgnoreCase("POST")) {
                leafName = leafName + this.getQueryParamString(this.model.getSession().getFormParams(uri, postData));
            }
        }
        catch (URIException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return leafName;
    }

    private String getQueryParamString(Map<String, String> map) {
        TreeSet<String> set = new TreeSet<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            set.add(entry.getKey());
        }
        return this.getQueryParamString(set);
    }

    private String getQueryParamString(SortedSet<String> querySet) {
        StringBuilder sb = new StringBuilder();
        Iterator iterator = querySet.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (name != null) {
                if (i > 0) {
                    sb.append(',');
                }
                if (name.length() > 40) {
                    name = name.substring(0, 40);
                }
                sb.append(name);
            }
            ++i;
        }
        String result = "";
        if (sb.length() > 0) {
            result = sb.insert(0, '(').append(')').toString();
        }
        return result;
    }

    private HistoryReference createReference(SiteNode node, HistoryReference baseRef, HttpMessage base) throws HttpMalformedHeaderException, DatabaseException, URIException, NullPointerException {
        TreeNode[] path = node.getPath();
        StringBuilder sb = new StringBuilder();
        String uriPath = baseRef.getURI().getPath();
        if (uriPath == null) {
            uriPath = "";
        }
        String[] origPath = uriPath.split("/");
        for (int i = 1; i < path.length; ++i) {
            String nodeName = ((SiteNode)path[i]).getNodeName();
            if (((SiteNode)path[i]).isDataDriven()) {
                if (origPath.length > i - 1) {
                    log.debug((Object)("Replace Data Driven element " + nodeName + " with " + origPath[i - 1]));
                    sb.append(origPath[i - 1]);
                } else {
                    log.error((Object)("Failed to determine original node name for element " + i + nodeName + " original request: " + baseRef.getURI().toString()));
                    sb.append(nodeName);
                }
            } else {
                sb.append(nodeName);
            }
            if (i >= path.length - 1) continue;
            sb.append('/');
        }
        HttpMessage newMsg = base.cloneRequest();
        URI uri = new URI(sb.toString(), false);
        newMsg.getRequestHeader().setURI(uri);
        newMsg.getRequestHeader().setMethod("GET");
        newMsg.getRequestBody().setBody("");
        newMsg.getRequestHeader().setHeader("Content-Type", null);
        newMsg.getRequestHeader().setHeader("Content-Length", null);
        HistoryReference historyRef = new HistoryReference(this.model.getSession(), 0, newMsg);
        return historyRef;
    }

    public SiteNode getSiteNode(int href) {
        return hrefMap.get(href);
    }

    public void removeHistoryReference(int historyId) {
        hrefMap.remove(historyId);
    }

    private String getHostName(URI uri) throws URIException {
        StringBuilder host = new StringBuilder();
        String scheme = uri.getScheme();
        scheme = scheme == null ? "http" : scheme.toLowerCase();
        host.append(scheme).append("://").append(uri.getHost());
        int port = uri.getPort();
        if (port != -1 && (port == 80 && !"http".equals(scheme) || port == 443 && !"https".equals(scheme) || port != 80 && port != 443)) {
            host.append(":").append(port);
        }
        return host.toString();
    }

    public void setFilter(SiteTreeFilter filter) {
        this.filter = filter;
        SiteNode root = (SiteNode)this.getRoot();
        this.setFilter(filter, root);
        root.setFiltered(false);
    }

    private boolean setFilter(SiteTreeFilter filter, SiteNode node) {
        boolean filtered = !filter.matches(node);
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (this.setFilter(filter, (SiteNode)node.getChildAt(i))) continue;
            filtered = false;
        }
        node.setFiltered(filtered);
        return filtered;
    }

    public void clearFilter() {
        this.filter = null;
        this.clearFilter((SiteNode)this.getRoot());
    }

    private void clearFilter(SiteNode node) {
        node.setFiltered(false);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.clearFilter((SiteNode)node.getChildAt(i));
        }
    }

    protected void applyFilter(SiteNode node) {
        if (this.filter != null) {
            boolean filtered = this.setFilter(this.filter, node);
            SiteNode parent = node.getParent();
            if (parent != null && !filtered && parent.isFiltered()) {
                this.clearParentFilter(parent);
            }
        } else {
            node.setFiltered(false);
        }
    }

    private void clearParentFilter(SiteNode parent) {
        if (parent != null) {
            parent.setFiltered(false);
            this.clearParentFilter(parent.getParent());
        }
    }

    @Override
    public void removeNodeFromParent(MutableTreeNode node) {
        SiteNode parent = (SiteNode)node.getParent();
        super.removeNodeFromParent(node);
        this.handleEvent(parent, (SiteNode)node, EventType.REMOVE);
    }

    private void handleEvent(SiteNode parent, SiteNode node, EventType eventType) {
        switch (eventType) {
            case ADD: {
                SiteMap.publishEvent("siteNode.added", node);
                if (parent != this.getRoot()) break;
                SiteMap.publishEvent("site.added", node);
                break;
            }
            case REMOVE: {
                SiteMap.publishEvent("siteNode.removed", node);
                if (parent != this.getRoot()) break;
                SiteMap.publishEvent("site.removed", node);
            }
        }
    }

    private static void publishEvent(String event, SiteNode node) {
        ZAP.getEventBus().publishSyncEvent(SiteMapEventPublisher.getPublisher(), new Event(SiteMapEventPublisher.getPublisher(), event, new Target(node)));
    }

    private static enum EventType {
        ADD,
        REMOVE;

    }
}

