/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.option;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.option.DatabaseParam;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.utils.ZapSizeNumberSpinner;
import org.zaproxy.zap.view.LayoutHelper;

public class OptionsDatabasePanel
extends AbstractParamPanel {
    private static final long serialVersionUID = -7541236934312940852L;
    private static final String NAME = Constant.messages.getString("database.optionspanel.name");
    private static final String COMPACT_DATABASE_LABEL = Constant.messages.getString("database.optionspanel.option.compact.label");
    private static final String REQUEST_BODY_SIZE_DATABASE_LABEL = Constant.messages.getString("database.optionspanel.option.request.body.size.label");
    private static final String RESPONSE_BODY_SIZE_DATABASE_LABEL = Constant.messages.getString("database.optionspanel.option.response.body.size.label");
    private static final String RECOVERY_LOG_LABEL = Constant.messages.getString("database.optionspanel.option.recoveryLog.label");
    private static final String RECOVERY_LOG_TOOL_TIP = Constant.messages.getString("database.optionspanel.option.recoveryLog.tooltip");
    private JCheckBox checkBoxCompactDatabase = null;
    private ZapSizeNumberSpinner spinnerRequestBodySize = null;
    private ZapSizeNumberSpinner spinnerResponseBodySize = null;
    private JCheckBox checkBoxNewSessionPrompt = null;
    private JComboBox<String> comboNewSessionOption = null;
    private JCheckBox checkBoxRecoveryLog = null;

    public OptionsDatabasePanel() {
        this.setName(NAME);
        this.setLayout(new FlowLayout(3, 0, 0));
        GridBagConstraints gridBagConstraintsLabelRequestBodySize = new GridBagConstraints();
        gridBagConstraintsLabelRequestBodySize.gridx = 0;
        gridBagConstraintsLabelRequestBodySize.gridy = 2;
        gridBagConstraintsLabelRequestBodySize.insets = new Insets(2, 2, 2, 2);
        gridBagConstraintsLabelRequestBodySize.anchor = 17;
        gridBagConstraintsLabelRequestBodySize.fill = 2;
        gridBagConstraintsLabelRequestBodySize.weightx = 0.5;
        GridBagConstraints gridBagConstraintsRequestBodySize = new GridBagConstraints();
        gridBagConstraintsRequestBodySize.gridx = 1;
        gridBagConstraintsRequestBodySize.gridy = 2;
        gridBagConstraintsRequestBodySize.weightx = 0.5;
        gridBagConstraintsRequestBodySize.fill = 2;
        gridBagConstraintsRequestBodySize.insets = new Insets(2, 2, 2, 2);
        gridBagConstraintsRequestBodySize.anchor = 17;
        gridBagConstraintsRequestBodySize.ipadx = 50;
        GridBagConstraints gridBagConstraintsLabelResponseBodySize = new GridBagConstraints();
        gridBagConstraintsLabelResponseBodySize.gridx = 0;
        gridBagConstraintsLabelResponseBodySize.gridy = 3;
        gridBagConstraintsLabelResponseBodySize.insets = new Insets(2, 2, 2, 2);
        gridBagConstraintsLabelResponseBodySize.anchor = 17;
        gridBagConstraintsLabelResponseBodySize.fill = 2;
        gridBagConstraintsLabelResponseBodySize.weightx = 0.5;
        GridBagConstraints gridBagConstraintsResponseBodySize = new GridBagConstraints();
        gridBagConstraintsResponseBodySize.gridx = 1;
        gridBagConstraintsResponseBodySize.gridy = 3;
        gridBagConstraintsResponseBodySize.weightx = 0.5;
        gridBagConstraintsResponseBodySize.fill = 2;
        gridBagConstraintsResponseBodySize.insets = new Insets(2, 2, 2, 2);
        gridBagConstraintsResponseBodySize.anchor = 17;
        gridBagConstraintsResponseBodySize.ipadx = 50;
        JLabel jLabelRequestBodySize = new JLabel();
        JLabel jLabelResponseBodySize = new JLabel();
        jLabelRequestBodySize.setText(REQUEST_BODY_SIZE_DATABASE_LABEL);
        jLabelResponseBodySize.setText(RESPONSE_BODY_SIZE_DATABASE_LABEL);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new EmptyBorder(2, 2, 2, 2));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        panel.add((Component)this.getCheckBoxCompactDatabase(), gbc);
        panel.add((Component)this.getCheckRecoveryLog(), LayoutHelper.getGBC(0, 1, 1, 1.0, new Insets(2, 2, 2, 2)));
        panel.add((Component)jLabelRequestBodySize, gridBagConstraintsLabelRequestBodySize);
        panel.add((Component)this.getRequestBodySize(), gridBagConstraintsRequestBodySize);
        panel.add((Component)jLabelResponseBodySize, gridBagConstraintsLabelResponseBodySize);
        panel.add((Component)this.getResponseBodySize(), gridBagConstraintsResponseBodySize);
        panel.add((Component)this.getCheckBoxNewSessionPrompt(), LayoutHelper.getGBC(0, 4, 2, 1.0, new Insets(2, 2, 2, 2)));
        panel.add((Component)new JLabel(Constant.messages.getString("database.optionspanel.option.newsessionopt.label")), LayoutHelper.getGBC(0, 5, 1, 0.5, new Insets(2, 2, 2, 2)));
        panel.add(this.comboNewSessionOption(), LayoutHelper.getGBC(1, 5, 1, 1.0, new Insets(2, 2, 2, 2)));
        this.add(panel);
    }

    private JCheckBox getCheckBoxCompactDatabase() {
        if (this.checkBoxCompactDatabase == null) {
            this.checkBoxCompactDatabase = new JCheckBox(COMPACT_DATABASE_LABEL);
        }
        return this.checkBoxCompactDatabase;
    }

    private JCheckBox getCheckRecoveryLog() {
        if (this.checkBoxRecoveryLog == null) {
            this.checkBoxRecoveryLog = new JCheckBox(RECOVERY_LOG_LABEL);
            this.checkBoxRecoveryLog.setToolTipText(RECOVERY_LOG_TOOL_TIP);
        }
        return this.checkBoxRecoveryLog;
    }

    private ZapSizeNumberSpinner getRequestBodySize() {
        if (this.spinnerRequestBodySize == null) {
            this.spinnerRequestBodySize = new ZapSizeNumberSpinner(0x1000000);
        }
        return this.spinnerRequestBodySize;
    }

    private JCheckBox getCheckBoxNewSessionPrompt() {
        if (this.checkBoxNewSessionPrompt == null) {
            this.checkBoxNewSessionPrompt = new JCheckBox(Constant.messages.getString("database.optionspanel.option.newsessionprompt.label"));
        }
        return this.checkBoxNewSessionPrompt;
    }

    private JComboBox<String> comboNewSessionOption() {
        if (this.comboNewSessionOption == null) {
            this.comboNewSessionOption = new JComboBox();
            this.comboNewSessionOption.addItem(Constant.messages.getString("database.optionspanel.option.newsessionopt.unspecified"));
            this.comboNewSessionOption.addItem(Constant.messages.getString("database.optionspanel.option.newsessionopt.timestamped"));
            this.comboNewSessionOption.addItem(Constant.messages.getString("database.optionspanel.option.newsessionopt.userspec"));
            this.comboNewSessionOption.addItem(Constant.messages.getString("database.optionspanel.option.newsessionopt.temporary"));
        }
        return this.comboNewSessionOption;
    }

    private ZapSizeNumberSpinner getResponseBodySize() {
        if (this.spinnerResponseBodySize == null) {
            this.spinnerResponseBodySize = new ZapSizeNumberSpinner(0x1000000);
        }
        return this.spinnerResponseBodySize;
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam options = (OptionsParam)obj;
        DatabaseParam param = options.getDatabaseParam();
        this.checkBoxCompactDatabase.setSelected(param.isCompactDatabase());
        this.spinnerRequestBodySize.setValue(param.getRequestBodySize());
        this.spinnerResponseBodySize.setValue(param.getResponseBodySize());
        this.checkBoxNewSessionPrompt.setSelected(param.isNewSessionPrompt());
        this.comboNewSessionOption.setSelectedIndex(param.getNewSessionOption());
        this.checkBoxRecoveryLog.setSelected(param.isRecoveryLogEnabled());
    }

    @Override
    public void validateParam(Object obj) throws Exception {
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam options = (OptionsParam)obj;
        DatabaseParam param = options.getDatabaseParam();
        param.setCompactDatabase(this.checkBoxCompactDatabase.isSelected());
        param.setRequestBodySize(this.spinnerRequestBodySize.getValue());
        param.setResponseBodySize(this.spinnerResponseBodySize.getValue());
        param.setNewSessionPrompt(this.checkBoxNewSessionPrompt.isSelected());
        param.setNewSessionOption(this.comboNewSessionOption.getSelectedIndex());
        param.setRecoveryLogEnabled(this.checkBoxRecoveryLog.isSelected());
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.database";
    }
}

