/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.model.HistoryReference;

public class HistoryFilter {
    public static final String NOTES_IGNORE = Constant.messages.getString("history.filter.notes.ignore");
    public static final String NOTES_PRESENT = Constant.messages.getString("history.filter.notes.present");
    public static final String NOTES_ABSENT = Constant.messages.getString("history.filter.notes.absent");
    public static final String[] NOTES_OPTIONS = new String[]{NOTES_IGNORE, NOTES_PRESENT, NOTES_ABSENT};
    private List<String> methodList = new ArrayList<String>();
    private List<Integer> codeList = new ArrayList<Integer>();
    private List<String> riskList = new ArrayList<String>();
    private List<String> confidenceList = new ArrayList<String>();
    private List<String> tagList = new ArrayList<String>();
    private String note = null;
    private List<Pattern> urlIncPatternList = new ArrayList<Pattern>();
    private List<Pattern> urlExcPatternList = new ArrayList<Pattern>();
    private Logger logger = Logger.getLogger(HistoryFilter.class);

    public void setMethods(List<String> methods) {
        this.methodList.clear();
        this.methodList.addAll(methods);
    }

    public void setCodes(List<Integer> codes) {
        this.codeList.clear();
        this.codeList.addAll(codes);
    }

    public void setTags(List<String> tags) {
        this.tagList.clear();
        this.tagList.addAll(tags);
    }

    public void setRisks(List<String> risks) {
        this.riskList.clear();
        this.riskList.addAll(risks);
    }

    public void setReliabilities(List<String> reliabilities) {
        this.confidenceList.clear();
        this.confidenceList.addAll(reliabilities);
    }

    public void reset() {
        this.methodList.clear();
        this.codeList.clear();
        this.tagList.clear();
        this.riskList.clear();
        this.confidenceList.clear();
        this.note = null;
    }

    public boolean matches(HistoryReference historyRef) {
        try {
            if (this.methodList.size() > 0 && !this.methodList.contains(historyRef.getMethod())) {
                return false;
            }
            if (this.codeList.size() > 0 && !this.codeList.contains(historyRef.getStatusCode())) {
                return false;
            }
            boolean foundTag = false;
            List<String> historyTags = historyRef.getTags();
            if (this.tagList.size() > 0) {
                for (String tag : historyTags) {
                    if (!this.tagList.contains(tag)) continue;
                    foundTag = true;
                }
                if (!foundTag) {
                    return false;
                }
            }
            boolean foundAlert = false;
            List<Alert> historyAlerts = historyRef.getAlerts();
            if (this.riskList.size() > 0 || this.confidenceList.size() > 0) {
                for (Alert alert : historyAlerts) {
                    if (this.riskList.size() != 0 && !this.riskList.contains(Alert.MSG_RISK[alert.getRisk()]) || this.confidenceList.size() != 0 && !this.confidenceList.contains(Alert.MSG_CONFIDENCE[alert.getConfidence()])) continue;
                    foundAlert = true;
                }
                if (!foundAlert) {
                    return false;
                }
            }
            if (this.note != null && !this.note.equals(NOTES_IGNORE)) {
                boolean notePresent;
                String noteStr = historyRef.getHttpMessage().getNote();
                boolean bl = notePresent = noteStr != null && noteStr.length() > 0;
                if (this.note.equals(NOTES_PRESENT) != notePresent) {
                    return false;
                }
            }
            String url = historyRef.getURI().toString();
            if (this.urlExcPatternList != null && this.urlExcPatternList.size() > 0) {
                for (Pattern p : this.urlExcPatternList) {
                    if (!p.matcher(url).matches()) continue;
                    return false;
                }
            }
            if (this.urlIncPatternList != null && this.urlIncPatternList.size() > 0) {
                boolean matched = false;
                for (Pattern p : this.urlIncPatternList) {
                    if (!p.matcher(url).matches()) continue;
                    matched = true;
                    break;
                }
                if (!matched) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public String toShortString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Constant.messages.getString("history.filter.label.filter"));
        sb.append(" ");
        boolean empty = true;
        if (this.methodList.size() > 0) {
            if (empty) {
                sb.append(Constant.messages.getString("history.filter.label.on"));
                sb.append(' ');
            }
            empty = false;
            sb.append(Constant.messages.getString("history.filter.label.methods"));
        }
        if (this.codeList.size() > 0) {
            if (empty) {
                sb.append(Constant.messages.getString("history.filter.label.on"));
                sb.append(' ');
            } else {
                sb.append(", ");
            }
            empty = false;
            sb.append(Constant.messages.getString("history.filter.label.codes"));
        }
        if (this.tagList.size() > 0) {
            if (empty) {
                sb.append(Constant.messages.getString("history.filter.label.on"));
                sb.append(' ');
            } else {
                sb.append(", ");
            }
            empty = false;
            sb.append(Constant.messages.getString("history.filter.label.tags"));
        }
        if (this.riskList.size() > 0 || this.confidenceList.size() > 0) {
            if (empty) {
                sb.append(Constant.messages.getString("history.filter.label.on"));
                sb.append(' ');
            } else {
                sb.append(", ");
            }
            empty = false;
            sb.append(Constant.messages.getString("history.filter.label.alerts"));
        }
        if (this.note != null && !this.note.equals(NOTES_IGNORE)) {
            if (empty) {
                sb.append(Constant.messages.getString("history.filter.label.on"));
                sb.append(' ');
            } else {
                sb.append(", ");
            }
            empty = false;
            sb.append(Constant.messages.getString("history.filter.label.notes"));
        }
        if (this.urlIncPatternList != null && this.urlIncPatternList.size() > 0) {
            if (empty) {
                sb.append(Constant.messages.getString("history.filter.label.on"));
                sb.append(' ');
            } else {
                sb.append(", ");
            }
            empty = false;
            sb.append(Constant.messages.getString("history.filter.label.urlincregex"));
        }
        if (this.urlExcPatternList != null && this.urlExcPatternList.size() > 0) {
            if (empty) {
                sb.append(Constant.messages.getString("history.filter.label.on"));
                sb.append(' ');
            } else {
                sb.append(", ");
            }
            empty = false;
            sb.append(Constant.messages.getString("history.filter.label.urlexcregex"));
        }
        if (empty) {
            sb.append(Constant.messages.getString("history.filter.label.off"));
        }
        return sb.toString();
    }

    public String toLongString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Constant.messages.getString("history.filter.label.filter"));
        sb.append(' ');
        boolean empty = true;
        if (this.methodList.size() > 0) {
            empty = false;
            sb.append(Constant.messages.getString("history.filter.label.methods"));
            sb.append(": ");
            for (String method : this.methodList) {
                sb.append(method);
                sb.append(' ');
            }
        }
        if (this.codeList.size() > 0) {
            empty = false;
            sb.append(Constant.messages.getString("history.filter.label.codes"));
            sb.append(": ");
            Integer lastCode = null;
            boolean inBlock = false;
            for (Integer code : this.codeList) {
                if (lastCode == null) {
                    sb.append(code);
                } else if (code == lastCode + 1) {
                    inBlock = true;
                } else if (inBlock) {
                    sb.append('-');
                    sb.append(lastCode);
                    sb.append(' ');
                    sb.append(code);
                    inBlock = false;
                } else {
                    sb.append(' ');
                    sb.append(code);
                }
                lastCode = code;
            }
            if (inBlock) {
                sb.append('-');
                sb.append(lastCode);
                sb.append(' ');
            }
        }
        if (this.tagList.size() > 0) {
            empty = false;
            sb.append(Constant.messages.getString("history.filter.label.tags"));
            sb.append(": ");
            for (String tag : this.tagList) {
                sb.append(tag);
                sb.append(' ');
            }
        }
        if (this.riskList.size() > 0 || this.confidenceList.size() > 0) {
            empty = false;
            sb.append(Constant.messages.getString("history.filter.label.alerts"));
            sb.append(": ");
            for (String risk : this.riskList) {
                sb.append(risk);
                sb.append(' ');
            }
            for (String rel : this.confidenceList) {
                sb.append(rel);
                sb.append(' ');
            }
        }
        if (this.note != null && !this.note.equals(NOTES_IGNORE)) {
            empty = false;
            sb.append(Constant.messages.getString("history.filter.label.notes"));
            sb.append(": ");
            sb.append(this.note);
        }
        if (empty) {
            sb.append(Constant.messages.getString("history.filter.label.off"));
        }
        return sb.toString();
    }

    public void setNote(Object selectedItem) {
        this.note = selectedItem == null ? null : selectedItem.toString();
    }

    public List<Pattern> getUrlIncPatternList() {
        return this.urlIncPatternList;
    }

    public void setUrlIncPatternList(List<Pattern> urlIncPatternList) {
        this.urlIncPatternList = urlIncPatternList;
    }

    public List<Pattern> getUrlExcPatternList() {
        return this.urlExcPatternList;
    }

    public void setUrlExcPatternList(List<Pattern> urlExcPatternList) {
        this.urlExcPatternList = urlExcPatternList;
    }
}

