/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.filter;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.extension.filter.Filter;
import org.parosproxy.paros.extension.filter.FilterDialog;
import org.parosproxy.paros.extension.filter.FilterFactory;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionFilter
extends ExtensionAdaptor
implements ProxyListener,
Runnable {
    private static final Logger log = Logger.getLogger(ExtensionFilter.class);
    public static final String NAME = "ExtensionFilter";
    public static final int PROXY_LISTENER_ORDER = 0;
    private ZapMenuItem menuToolsFilter = null;
    private FilterFactory filterFactory = new FilterFactory();
    private boolean isStop = false;

    public ExtensionFilter() {
        this.setOrder(8);
    }

    @Override
    public void init() {
        this.setName(NAME);
        this.filterFactory.loadAllFilter();
        Thread t = new Thread((Runnable)this, "ZAP-ExtensionFilter");
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void initModel(Model model) {
        super.initModel(model);
        Filter filter = null;
        List<Filter> filters = this.filterFactory.getAllFilter();
        for (int i = 0; i < filters.size(); ++i) {
            filter = filters.get(i);
            try {
                filter.init(model);
                continue;
            }
            catch (Exception ignore) {
                log.warn((Object)"Error initializing filter. Continuing.", (Throwable)ignore);
            }
        }
    }

    @Override
    public void initView(ViewDelegate view) {
        super.initView(view);
        Filter filter = null;
        for (int i = 0; i < this.filterFactory.getAllFilter().size(); ++i) {
            filter = this.filterFactory.getAllFilter().get(i);
            try {
                filter.initView(view);
                continue;
            }
            catch (Exception ignore) {
                log.warn((Object)"Error initializing view for filter. Continuing.", (Throwable)ignore);
            }
        }
    }

    private ZapMenuItem getMenuToolsFilter() {
        if (this.menuToolsFilter == null) {
            this.menuToolsFilter = new ZapMenuItem("menu.tools.filter");
            this.menuToolsFilter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FilterDialog dialog = new FilterDialog(ExtensionFilter.this.getView().getMainFrame());
                    dialog.setAllFilters(ExtensionFilter.this.filterFactory.getAllFilter());
                    dialog.showDialog(false);
                }
            });
        }
        return this.menuToolsFilter;
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuToolsFilter());
        }
        extensionHook.addProxyListener(this);
    }

    @Override
    public int getArrangeableListenerOrder() {
        return 0;
    }

    @Override
    public boolean onHttpRequestSend(HttpMessage httpMessage) {
        Filter filter = null;
        switch (Control.getSingleton().getMode()) {
            case safe: {
                return true;
            }
            case protect: {
                if (httpMessage.isInScope()) break;
                return true;
            }
        }
        for (int i = 0; i < this.filterFactory.getAllFilter().size(); ++i) {
            filter = this.filterFactory.getAllFilter().get(i);
            try {
                if (!filter.isEnabled()) continue;
                filter.onHttpRequestSend(httpMessage);
                continue;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    @Override
    public boolean onHttpResponseReceive(HttpMessage httpMessage) {
        Filter filter = null;
        switch (Control.getSingleton().getMode()) {
            case safe: {
                return true;
            }
            case protect: {
                if (httpMessage.isInScope()) break;
                return true;
            }
        }
        for (int i = 0; i < this.filterFactory.getAllFilter().size(); ++i) {
            filter = this.filterFactory.getAllFilter().get(i);
            try {
                if (!filter.isEnabled()) continue;
                filter.onHttpResponseReceive(httpMessage);
                continue;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    @Override
    public void destroy() {
        this.isStop = true;
        Filter filter = null;
        for (int i = 0; i < this.filterFactory.getAllFilter().size(); ++i) {
            filter = this.filterFactory.getAllFilter().get(i);
            try {
                filter.destroy();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void run() {
        Filter filter = null;
        while (!this.isStop) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            for (int i = 0; i < this.filterFactory.getAllFilter().size(); ++i) {
                filter = this.filterFactory.getAllFilter().get(i);
                try {
                    if (!filter.isEnabled()) continue;
                    filter.timer();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public String getAuthor() {
        return "Chinotec Technologies";
    }

    public void addFilter(Filter filter) {
        List<Filter> filters = this.filterFactory.getAllFilter();
        int index = this.searchFilterIndex(filters, filter.getId(), 0, filters.size());
        if (index == -1) {
            filters.add(filter);
        } else {
            filters.add(index, filter);
        }
    }

    public void removeFilter(Filter filter) {
        List<Filter> filters = this.filterFactory.getAllFilter();
        filters.remove(filter);
    }

    private int searchFilterIndex(List<Filter> filters, int targetId, int min, int max) {
        if (max <= min) {
            return -1;
        }
        int mid = (min + max) / 2;
        int id = filters.get(mid).getId();
        if (id > targetId) {
            return this.searchFilterIndex(filters, targetId, min, mid - 1);
        }
        if (id < targetId) {
            return this.searchFilterIndex(filters, targetId, mid + 1, max);
        }
        return mid + 1;
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }
}

