/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension;

import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.control.Proxy;
import org.parosproxy.paros.core.proxy.ConnectRequestProxyListener;
import org.parosproxy.paros.core.proxy.OverrideMessageProxyListener;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.core.scanner.Scanner;
import org.parosproxy.paros.core.scanner.ScannerHook;
import org.parosproxy.paros.db.Database;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DatabaseUnsupportedException;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.extension.CommandLineArgument;
import org.parosproxy.paros.extension.CommandLineListener;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionHookMenu;
import org.parosproxy.paros.extension.ExtensionHookView;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.extension.OptionsChangedListener;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.AbstractParamDialog;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.MainMenuBar;
import org.parosproxy.paros.view.SiteMapPanel;
import org.parosproxy.paros.view.View;
import org.parosproxy.paros.view.WorkbenchPanel;
import org.zaproxy.zap.PersistentConnectionListener;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.extension.AddOnInstallationStatusListener;
import org.zaproxy.zap.extension.AddonFilesChangedListener;
import org.zaproxy.zap.model.ContextDataFactory;
import org.zaproxy.zap.view.ContextPanelFactory;
import org.zaproxy.zap.view.SiteMapListener;

public class ExtensionLoader {
    private final List<Extension> extensionList = new ArrayList<Extension>();
    private final Map<Class<? extends Extension>, Extension> extensionsMap = new HashMap<Class<? extends Extension>, Extension>();
    private final Map<Extension, ExtensionHook> extensionHooks = new HashMap<Extension, ExtensionHook>();
    private Model model = null;
    private View view = null;
    private static final Logger logger = Logger.getLogger(ExtensionLoader.class);

    public ExtensionLoader(Model model, View view) {
        this.model = model;
        this.view = view;
    }

    public void addExtension(Extension extension) {
        this.extensionList.add(extension);
        this.extensionsMap.put(extension.getClass(), extension);
    }

    public void destroyAllExtension() {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            try {
                this.getExtension(i).destroy();
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public Extension getExtension(int i) {
        return this.extensionList.get(i);
    }

    public Extension getExtension(String name) {
        if (name != null) {
            for (int i = 0; i < this.extensionList.size(); ++i) {
                Extension p = this.getExtension(i);
                if (!p.getName().equalsIgnoreCase(name)) continue;
                return p;
            }
        }
        return null;
    }

    public Extension getExtensionByClassName(String name) {
        if (name != null) {
            for (int i = 0; i < this.extensionList.size(); ++i) {
                Extension p = this.getExtension(i);
                if (!p.getClass().getName().equals(name)) continue;
                return p;
            }
        }
        return null;
    }

    public <T extends Extension> T getExtension(Class<T> clazz) {
        Extension extension;
        if (clazz != null && (extension = this.extensionsMap.get(clazz)) != null) {
            return (T)((Extension)clazz.cast(extension));
        }
        return null;
    }

    public boolean isExtensionEnabled(String extensionName) {
        if (extensionName == null) {
            throw new IllegalArgumentException("Parameter extensionName must not be null.");
        }
        Extension extension = this.getExtension(extensionName);
        if (extension == null) {
            return false;
        }
        return extension.isEnabled();
    }

    public int getExtensionCount() {
        return this.extensionList.size();
    }

    public void hookProxyListener(Proxy proxy) {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            ExtensionLoader.hookProxyListeners(proxy, hook.getProxyListenerList());
        }
    }

    private static void hookProxyListeners(Proxy proxy, List<ProxyListener> listeners) {
        for (ProxyListener listener : listeners) {
            try {
                if (listener == null) continue;
                proxy.addProxyListener(listener);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void removeProxyListener(ExtensionHook hook) {
        Proxy proxy = Control.getSingleton().getProxy();
        Vector<ProxyListener> listenerList = hook.getProxyListenerList();
        for (ProxyListener listener : listenerList) {
            try {
                if (listener == null) continue;
                proxy.removeProxyListener(listener);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void hookOverrideMessageProxyListener(Proxy proxy) {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            List<OverrideMessageProxyListener> listenerList = hook.getOverrideMessageProxyListenerList();
            for (OverrideMessageProxyListener listener : listenerList) {
                try {
                    if (listener == null) continue;
                    proxy.addOverrideMessageProxyListener(listener);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void removeOverrideMessageProxyListener(ExtensionHook hook) {
        Proxy proxy = Control.getSingleton().getProxy();
        List<OverrideMessageProxyListener> listenerList = hook.getOverrideMessageProxyListenerList();
        for (OverrideMessageProxyListener listener : listenerList) {
            try {
                if (listener == null) continue;
                proxy.removeOverrideMessageProxyListener(listener);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void hookConnectRequestProxyListeners(Proxy proxy) {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            ExtensionLoader.hookConnectRequestProxyListeners(proxy, hook.getConnectRequestProxyListeners());
        }
    }

    private static void hookConnectRequestProxyListeners(Proxy proxy, List<ConnectRequestProxyListener> listeners) {
        for (ConnectRequestProxyListener listener : listeners) {
            proxy.addConnectRequestProxyListener(listener);
        }
    }

    private void removeConnectRequestProxyListener(ExtensionHook hook) {
        Proxy proxy = Control.getSingleton().getProxy();
        for (ConnectRequestProxyListener listener : hook.getConnectRequestProxyListeners()) {
            proxy.removeConnectRequestProxyListener(listener);
        }
    }

    public void hookPersistentConnectionListener(Proxy proxy) {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            ExtensionLoader.hookPersistentConnectionListeners(proxy, hook.getPersistentConnectionListener());
        }
    }

    private static void hookPersistentConnectionListeners(Proxy proxy, List<PersistentConnectionListener> listeners) {
        for (PersistentConnectionListener listener : listeners) {
            try {
                if (listener == null) continue;
                proxy.addPersistentConnectionListener(listener);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void removePersistentConnectionListener(ExtensionHook hook) {
        Proxy proxy = Control.getSingleton().getProxy();
        Vector<PersistentConnectionListener> listenerList = hook.getPersistentConnectionListener();
        for (PersistentConnectionListener listener : listenerList) {
            try {
                if (listener == null) continue;
                proxy.removePersistentConnectionListener(listener);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void hookSiteMapListener(SiteMapPanel siteMapPanel) {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            ExtensionLoader.hookSiteMapListeners(siteMapPanel, hook.getSiteMapListenerList());
        }
    }

    private static void hookSiteMapListeners(SiteMapPanel siteMapPanel, List<SiteMapListener> listeners) {
        for (SiteMapListener listener : listeners) {
            try {
                if (listener == null) continue;
                siteMapPanel.addSiteMapListener(listener);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void removeSiteMapListener(ExtensionHook hook) {
        if (this.view != null) {
            SiteMapPanel siteMapPanel = this.view.getSiteTreePanel();
            Vector<SiteMapListener> listenerList = hook.getSiteMapListenerList();
            for (SiteMapListener listener : listenerList) {
                try {
                    if (listener == null) continue;
                    siteMapPanel.removeSiteMapListener(listener);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void hookScannerHook(Scanner scan) {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            Vector<ScannerHook> scannerHookList = hook.getScannerHookList();
            for (ScannerHook scannerHook : scannerHookList) {
                try {
                    if (hook == null) continue;
                    scan.addScannerHook(scannerHook);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void optionsChangedAllPlugin(OptionsParam options) {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            Vector<OptionsChangedListener> listenerList = hook.getOptionsChangedListenerList();
            for (OptionsChangedListener listener : listenerList) {
                try {
                    if (listener == null) continue;
                    listener.optionsChanged(options);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void runCommandLine() {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            Extension ext = this.getExtension(i);
            if (!(ext instanceof CommandLineListener)) continue;
            CommandLineListener listener = (CommandLineListener)((Object)ext);
            listener.execute(this.extensionHooks.get(ext).getCommandLineArgument());
        }
    }

    public void sessionChangedAllPlugin(Session session) {
        logger.debug((Object)"sessionChangedAllPlugin");
        for (ExtensionHook hook : this.extensionHooks.values()) {
            Vector<SessionChangedListener> listenerList = hook.getSessionListenerList();
            for (SessionChangedListener listener : listenerList) {
                try {
                    if (listener == null) continue;
                    listener.sessionChanged(session);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void databaseOpen(Database db) {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            Extension ext = this.getExtension(i);
            try {
                ext.databaseOpen(db);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void sessionAboutToChangeAllPlugin(Session session) {
        logger.debug((Object)"sessionAboutToChangeAllPlugin");
        for (ExtensionHook hook : this.extensionHooks.values()) {
            Vector<SessionChangedListener> listenerList = hook.getSessionListenerList();
            for (SessionChangedListener listener : listenerList) {
                try {
                    if (listener == null) continue;
                    listener.sessionAboutToChange(session);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void sessionScopeChangedAllPlugin(Session session) {
        logger.debug((Object)"sessionScopeChangedAllPlugin");
        for (ExtensionHook hook : this.extensionHooks.values()) {
            Vector<SessionChangedListener> listenerList = hook.getSessionListenerList();
            for (SessionChangedListener listener : listenerList) {
                try {
                    if (listener == null) continue;
                    listener.sessionScopeChanged(session);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void sessionModeChangedAllPlugin(Control.Mode mode) {
        logger.debug((Object)"sessionModeChangedAllPlugin");
        for (ExtensionHook hook : this.extensionHooks.values()) {
            Vector<SessionChangedListener> listenerList = hook.getSessionListenerList();
            for (SessionChangedListener listener : listenerList) {
                try {
                    if (listener == null) continue;
                    listener.sessionModeChanged(mode);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void addonFilesAdded() {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            List<AddonFilesChangedListener> listenerList = hook.getAddonFilesChangedListener();
            for (AddonFilesChangedListener listener : listenerList) {
                try {
                    listener.filesAdded();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void addonFilesRemoved() {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            List<AddonFilesChangedListener> listenerList = hook.getAddonFilesChangedListener();
            for (AddonFilesChangedListener listener : listenerList) {
                try {
                    listener.filesRemoved();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void addOnInstalled(AddOn addOn) {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            for (AddOnInstallationStatusListener listener : hook.getAddOnInstallationStatusListeners()) {
                try {
                    listener.addOnInstalled(addOn);
                }
                catch (Exception e) {
                    logger.error((Object)("An error occurred while notifying: " + listener.getClass().getCanonicalName()), (Throwable)e);
                }
            }
        }
    }

    public void addOnSoftUninstalled(AddOn addOn, boolean successfully) {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            for (AddOnInstallationStatusListener listener : hook.getAddOnInstallationStatusListeners()) {
                try {
                    listener.addOnSoftUninstalled(addOn, successfully);
                }
                catch (Exception e) {
                    logger.error((Object)("An error occurred while notifying: " + listener.getClass().getCanonicalName()), (Throwable)e);
                }
            }
        }
    }

    public void addOnUninstalled(AddOn addOn, boolean successfully) {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            for (AddOnInstallationStatusListener listener : hook.getAddOnInstallationStatusListeners()) {
                try {
                    listener.addOnUninstalled(addOn, successfully);
                }
                catch (Exception e) {
                    logger.error((Object)("An error occurred while notifying: " + listener.getClass().getCanonicalName()), (Throwable)e);
                }
            }
        }
    }

    public void startAllExtension(double progressFactor) {
        double factorPerc = progressFactor / (double)this.getExtensionCount();
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            try {
                this.getExtension(i).start();
                if (this.view == null) continue;
                this.view.addSplashScreenLoadingCompletion(factorPerc);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void startLifeCycle() {
        if (this.view != null) {
            this.view.setSplashScreenLoadingCompletion(0.0);
        }
        this.initAllExtension(5.0);
        this.initModelAllExtension(this.model, 0.0);
        this.initXMLAllExtension(this.model.getSession(), this.model.getOptionsParam(), 0.0);
        this.initViewAllExtension(this.view, 10.0);
        this.hookAllExtension(75.0);
        this.startAllExtension(10.0);
    }

    public void startLifeCycle(Extension ext) throws DatabaseException, DatabaseUnsupportedException {
        ext.init();
        ext.databaseOpen(this.model.getDb());
        ext.initModel(this.model);
        ext.initXML(this.model.getSession(), this.model.getOptionsParam());
        ext.initView(this.view);
        ExtensionHook extHook = new ExtensionHook(this.model, this.view);
        try {
            ext.hook(extHook);
            this.extensionHooks.put(ext, extHook);
            this.hookContextDataFactories(ext, extHook);
            if (this.view != null) {
                this.hookView(ext, this.view, extHook);
                this.hookMenu(this.view, extHook);
            }
            this.hookOptions(extHook);
            ext.optionsLoaded();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        ext.start();
        Proxy proxy = Control.getSingleton().getProxy();
        ExtensionLoader.hookProxyListeners(proxy, extHook.getProxyListenerList());
        ExtensionLoader.hookPersistentConnectionListeners(proxy, extHook.getPersistentConnectionListener());
        ExtensionLoader.hookConnectRequestProxyListeners(proxy, extHook.getConnectRequestProxyListeners());
        if (this.view != null) {
            ExtensionLoader.hookSiteMapListeners(this.view.getSiteTreePanel(), extHook.getSiteMapListenerList());
        }
    }

    public void stopAllExtension() {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            try {
                this.getExtension(i).stop();
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void addParamPanel(List<AbstractParamPanel> panelList, AbstractParamDialog dialog) {
        String[] ROOT = new String[]{};
        for (AbstractParamPanel panel : panelList) {
            try {
                dialog.addParamPanel(ROOT, panel, true);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void removeParamPanel(List<AbstractParamPanel> panelList, AbstractParamDialog dialog) {
        for (AbstractParamPanel panel : panelList) {
            try {
                dialog.removeParamPanel(panel);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        dialog.revalidate();
    }

    private void hookAllExtension(double progressFactor) {
        int i;
        final double factorPerc = progressFactor / (double)this.getExtensionCount();
        for (i = 0; i < this.getExtensionCount(); ++i) {
            try {
                final Extension ext = this.getExtension(i);
                logger.info((Object)("Initializing " + ext.getDescription()));
                final ExtensionHook extHook = new ExtensionHook(this.model, this.view);
                ext.hook(extHook);
                this.extensionHooks.put(ext, extHook);
                this.hookContextDataFactories(ext, extHook);
                if (this.view != null) {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ExtensionLoader.this.hookView(ext, ExtensionLoader.this.view, extHook);
                            ExtensionLoader.this.hookMenu(ExtensionLoader.this.view, extHook);
                            ExtensionLoader.this.view.addSplashScreenLoadingCompletion(factorPerc);
                        }
                    });
                }
                this.hookOptions(extHook);
                ext.optionsLoaded();
                continue;
            }
            catch (Throwable e) {
                logger.error((Object)e.getMessage(), e);
            }
        }
        for (i = 0; i < this.getExtensionCount(); ++i) {
            try {
                this.getExtension(i).postInit();
                continue;
            }
            catch (Throwable e) {
                logger.error((Object)e.getMessage(), e);
            }
        }
        if (this.view != null) {
            this.view.getMainFrame().getMainMenuBar().validate();
            this.view.getMainFrame().validate();
        }
    }

    private void hookContextDataFactories(Extension extension, ExtensionHook extHook) {
        for (ContextDataFactory contextDataFactory : extHook.getContextDataFactories()) {
            try {
                this.model.addContextDataFactory(contextDataFactory);
            }
            catch (Exception e) {
                logger.error((Object)("Error while adding a ContextDataFactory from " + extension.getClass().getCanonicalName()), (Throwable)e);
            }
        }
    }

    public void hookCommandLineListener(CommandLine cmdLine) throws Exception {
        ArrayList<CommandLineArgument[]> allCommandLineList = new ArrayList<CommandLineArgument[]>();
        HashMap<String, CommandLineListener> extMap = new HashMap<String, CommandLineListener>();
        for (Map.Entry<Extension, ExtensionHook> entry : this.extensionHooks.entrySet()) {
            CommandLineListener cli;
            List<String> exts;
            Extension extension;
            ExtensionHook hook = entry.getValue();
            CommandLineArgument[] arg = hook.getCommandLineArgument();
            if (arg.length > 0) {
                allCommandLineList.add(arg);
            }
            if (!((extension = entry.getKey()) instanceof CommandLineListener) || (exts = (cli = (CommandLineListener)((Object)extension)).getHandledExtensions()) == null) continue;
            for (String ext : exts) {
                extMap.put(ext, cli);
            }
        }
        cmdLine.parse(allCommandLineList, extMap);
    }

    private void hookMenu(View view, ExtensionHook hook) {
        if (view == null) {
            return;
        }
        ExtensionHookMenu hookMenu = hook.getHookMenu();
        if (hookMenu == null) {
            return;
        }
        MainMenuBar menuBar = view.getMainFrame().getMainMenuBar();
        this.addMenuHelper(menuBar, hookMenu.getNewMenus(), 2);
        this.addMenuHelper(menuBar.getMenuFile(), hookMenu.getFile(), 2);
        this.addMenuHelper(menuBar.getMenuTools(), hookMenu.getTools(), 2);
        this.addMenuHelper(menuBar.getMenuEdit(), hookMenu.getEdit());
        this.addMenuHelper(menuBar.getMenuView(), hookMenu.getView());
        this.addMenuHelper(menuBar.getMenuAnalyse(), hookMenu.getAnalyse());
        this.addMenuHelper(menuBar.getMenuHelp(), hookMenu.getHelpMenus());
        this.addMenuHelper(menuBar.getMenuReport(), hookMenu.getReportMenus());
        this.addMenuHelper(menuBar.getMenuOnline(), hookMenu.getOnlineMenus());
        this.addMenuHelper(view.getPopupList(), hookMenu.getPopupMenus());
    }

    private void addMenuHelper(JMenu menu, List<JMenuItem> items) {
        this.addMenuHelper(menu, items, 0);
    }

    private void addMenuHelper(JMenuBar menuBar, List<JMenuItem> items, int existingCount) {
        for (JMenuItem item : items) {
            if (item == null) continue;
            menuBar.add((Component)item, menuBar.getMenuCount() - existingCount);
        }
        menuBar.revalidate();
    }

    private void addMenuHelper(JMenu menu, List<JMenuItem> items, int existingCount) {
        for (JMenuItem item : items) {
            if (item == null) continue;
            if (item == ExtensionHookMenu.MENU_SEPARATOR) {
                menu.addSeparator();
                continue;
            }
            menu.add((Component)item, menu.getItemCount() - existingCount);
        }
        menu.revalidate();
    }

    private void addMenuHelper(List<JMenuItem> menuList, List<JMenuItem> items) {
        for (JMenuItem item : items) {
            if (item == null) continue;
            menuList.add(item);
        }
    }

    private void removeMenu(View view, ExtensionHook hook) {
        if (view == null) {
            return;
        }
        ExtensionHookMenu hookMenu = hook.getHookMenu();
        if (hookMenu == null) {
            return;
        }
        MainMenuBar menuBar = view.getMainFrame().getMainMenuBar();
        this.removeMenuHelper(menuBar, hookMenu.getNewMenus());
        this.removeMenuHelper(menuBar.getMenuFile(), hookMenu.getFile());
        this.removeMenuHelper(menuBar.getMenuTools(), hookMenu.getTools());
        this.removeMenuHelper(menuBar.getMenuEdit(), hookMenu.getEdit());
        this.removeMenuHelper(menuBar.getMenuView(), hookMenu.getView());
        this.removeMenuHelper(menuBar.getMenuAnalyse(), hookMenu.getAnalyse());
        this.removeMenuHelper(menuBar.getMenuHelp(), hookMenu.getHelpMenus());
        this.removeMenuHelper(menuBar.getMenuReport(), hookMenu.getReportMenus());
        this.removeMenuHelper(menuBar.getMenuOnline(), hookMenu.getOnlineMenus());
        this.removeMenuHelper(view.getPopupList(), hookMenu.getPopupMenus());
        view.refreshTabViewMenus();
    }

    private void removeMenuHelper(JMenuBar menuBar, List<JMenuItem> items) {
        for (JMenuItem item : items) {
            if (item == null) continue;
            menuBar.remove(item);
        }
        menuBar.revalidate();
    }

    private void removeMenuHelper(JMenu menu, List<JMenuItem> items) {
        for (JMenuItem item : items) {
            if (item == null) continue;
            menu.remove(item);
        }
        menu.revalidate();
    }

    private void removeMenuHelper(List<JMenuItem> menuList, List<JMenuItem> items) {
        for (JMenuItem item : items) {
            if (item == null) continue;
            menuList.remove(item);
        }
    }

    private void hookOptions(ExtensionHook hook) {
        Vector<AbstractParam> list = hook.getOptionsParamSetList();
        for (AbstractParam paramSet : list) {
            try {
                this.model.getOptionsParam().addParamSet(paramSet);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void unloadOptions(ExtensionHook hook) {
        Vector<AbstractParam> list = hook.getOptionsParamSetList();
        for (AbstractParam paramSet : list) {
            try {
                this.model.getOptionsParam().removeParamSet(paramSet);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void hookView(Extension extension, View view, ExtensionHook hook) {
        if (view == null) {
            return;
        }
        ExtensionHookView pv = hook.getHookView();
        if (pv == null) {
            return;
        }
        for (ContextPanelFactory contextPanelFactory : pv.getContextPanelFactories()) {
            try {
                view.addContextPanelFactory(contextPanelFactory);
            }
            catch (Exception e) {
                logger.error((Object)("Error while adding a ContextPanelFactory from " + extension.getClass().getCanonicalName()), (Throwable)e);
            }
        }
        view.getWorkbench().addPanels(pv.getSelectPanel(), WorkbenchPanel.PanelType.SELECT);
        view.getWorkbench().addPanels(pv.getWorkPanel(), WorkbenchPanel.PanelType.WORK);
        view.getWorkbench().addPanels(pv.getStatusPanel(), WorkbenchPanel.PanelType.STATUS);
        this.addParamPanel(pv.getSessionPanel(), view.getSessionDialog());
        this.addParamPanel(pv.getOptionsPanel(), view.getOptionsDialog(""));
    }

    private void removeView(Extension extension, View view, ExtensionHook hook) {
        if (view == null) {
            return;
        }
        ExtensionHookView pv = hook.getHookView();
        if (pv == null) {
            return;
        }
        for (ContextPanelFactory contextPanelFactory : pv.getContextPanelFactories()) {
            try {
                view.removeContextPanelFactory(contextPanelFactory);
            }
            catch (Exception e) {
                logger.error((Object)("Error while removing a ContextPanelFactory from " + extension.getClass().getCanonicalName()), (Throwable)e);
            }
        }
        view.getWorkbench().removePanels(pv.getSelectPanel(), WorkbenchPanel.PanelType.SELECT);
        view.getWorkbench().removePanels(pv.getWorkPanel(), WorkbenchPanel.PanelType.WORK);
        view.getWorkbench().removePanels(pv.getStatusPanel(), WorkbenchPanel.PanelType.STATUS);
        this.removeParamPanel(pv.getSessionPanel(), view.getSessionDialog());
        this.removeParamPanel(pv.getOptionsPanel(), view.getOptionsDialog(""));
    }

    public void removeStatusPanel(AbstractPanel panel) {
        if (!View.isInitialised()) {
            return;
        }
        View.getSingleton().getWorkbench().removePanel(panel, WorkbenchPanel.PanelType.STATUS);
    }

    public void removeOptionsPanel(AbstractParamPanel panel) {
        if (!View.isInitialised()) {
            return;
        }
        View.getSingleton().getOptionsDialog("").removeParamPanel(panel);
    }

    public void removeOptionsParamSet(AbstractParam params) {
        this.model.getOptionsParam().removeParamSet(params);
    }

    public void removeWorkPanel(AbstractPanel panel) {
        if (!View.isInitialised()) {
            return;
        }
        View.getSingleton().getWorkbench().removePanel(panel, WorkbenchPanel.PanelType.WORK);
    }

    public void removePopupMenuItem(ExtensionPopupMenuItem popupMenuItem) {
        if (!View.isInitialised()) {
            return;
        }
        View.getSingleton().getPopupList().remove(popupMenuItem);
    }

    public void removeFileMenuItem(JMenuItem menuItem) {
        if (!View.isInitialised()) {
            return;
        }
        View.getSingleton().getMainFrame().getMainMenuBar().getMenuFile().remove(menuItem);
    }

    public void removeEditMenuItem(JMenuItem menuItem) {
        if (!View.isInitialised()) {
            return;
        }
        View.getSingleton().getMainFrame().getMainMenuBar().getMenuEdit().remove(menuItem);
    }

    public void removeViewMenuItem(JMenuItem menuItem) {
        if (!View.isInitialised()) {
            return;
        }
        View.getSingleton().getMainFrame().getMainMenuBar().getMenuView().remove(menuItem);
    }

    public void removeToolsMenuItem(JMenuItem menuItem) {
        if (!View.isInitialised()) {
            return;
        }
        View.getSingleton().getMainFrame().getMainMenuBar().getMenuTools().remove(menuItem);
    }

    public void removeHelpMenuItem(JMenuItem menuItem) {
        if (!View.isInitialised()) {
            return;
        }
        View.getSingleton().getMainFrame().getMainMenuBar().getMenuHelp().remove(menuItem);
    }

    public void removeReportMenuItem(JMenuItem menuItem) {
        if (!View.isInitialised()) {
            return;
        }
        View.getSingleton().getMainFrame().getMainMenuBar().getMenuReport().remove(menuItem);
    }

    private void initAllExtension(double progressFactor) {
        double factorPerc = progressFactor / (double)this.getExtensionCount();
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            try {
                this.getExtension(i).init();
                this.getExtension(i).databaseOpen(Model.getSingleton().getDb());
                if (this.view == null) continue;
                this.view.addSplashScreenLoadingCompletion(factorPerc);
                continue;
            }
            catch (Throwable e) {
                logger.error((Object)e.getMessage(), e);
            }
        }
    }

    private void initModelAllExtension(Model model, double progressFactor) {
        double factorPerc = progressFactor / (double)this.getExtensionCount();
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            try {
                this.getExtension(i).initModel(model);
                if (this.view == null) continue;
                this.view.addSplashScreenLoadingCompletion(factorPerc);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void initViewAllExtension(final View view, double progressFactor) {
        if (view == null) {
            return;
        }
        final double factorPerc = progressFactor / (double)this.getExtensionCount();
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            try {
                final Extension extension = this.getExtension(i);
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        extension.initView(view);
                        view.addSplashScreenLoadingCompletion(factorPerc);
                    }
                });
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void initXMLAllExtension(Session session, OptionsParam options, double progressFactor) {
        double factorPerc = progressFactor / (double)this.getExtensionCount();
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            try {
                this.getExtension(i).initXML(session, options);
                if (this.view == null) continue;
                this.view.addSplashScreenLoadingCompletion(factorPerc);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void removeExtension(Extension extension, ExtensionHook hook) {
        this.extensionList.remove(extension);
        this.extensionsMap.remove(extension.getClass());
        if (hook == null) {
            logger.info((Object)("ExtensionHook is null for \"" + extension.getClass().getCanonicalName() + "\" the hooked objects will not be automatically removed."));
            return;
        }
        this.extensionHooks.values().remove(hook);
        this.unloadOptions(hook);
        this.removePersistentConnectionListener(hook);
        this.removeProxyListener(hook);
        this.removeOverrideMessageProxyListener(hook);
        this.removeConnectRequestProxyListener(hook);
        this.removeSiteMapListener(hook);
        for (ContextDataFactory contextDataFactory : hook.getContextDataFactories()) {
            try {
                this.model.removeContextDataFactory(contextDataFactory);
            }
            catch (Exception e) {
                logger.error((Object)("Error while removing a ContextDataFactory from " + extension.getClass().getCanonicalName()), (Throwable)e);
            }
        }
        this.removeViewInEDT(extension, hook);
    }

    private void removeViewInEDT(final Extension extension, final ExtensionHook hook) {
        if (this.view == null) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.removeView(extension, this.view, hook);
            this.removeMenu(this.view, hook);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtensionLoader.this.removeViewInEDT(extension, hook);
                }
            });
        }
    }

    public List<String> getUnsavedResources() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            List<String> l = this.getExtension(i).getUnsavedResources();
            if (l == null) continue;
            list.addAll(l);
        }
        return list;
    }

    public List<String> getActiveActions() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            List<String> l = this.getExtension(i).getActiveActions();
            if (l == null) continue;
            list.addAll(l);
        }
        return list;
    }
}

