/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.network.HttpMessage;

public class ScannerParamFilter
implements Cloneable {
    private String wildcardedUrl;
    private String paramNameRegex;
    private int paramType;
    private Pattern paramNamePattern;
    private Pattern urlPattern;
    private static final Map<Integer, String> typeMap = new HashMap<Integer, String>();

    public ScannerParamFilter() {
        this.wildcardedUrl = "*";
        this.paramType = -1;
        this.paramNamePattern = null;
        this.urlPattern = null;
    }

    public ScannerParamFilter(String paramName, int paramType, String urlPattern) {
        this.paramType = paramType;
        this.setParamName(paramName);
        this.setWildcardedUrl(urlPattern);
    }

    public int getType() {
        return this.paramType;
    }

    public void setType(int paramType) {
        this.paramType = paramType;
    }

    public String getParamName() {
        return this.paramNameRegex;
    }

    public final void setParamName(String paramNameRegex) {
        this.paramNameRegex = paramNameRegex;
        this.paramNamePattern = Pattern.compile(paramNameRegex);
    }

    public static boolean isValidParamNameRegex(String paramNameRegex) {
        try {
            Pattern.compile(paramNameRegex);
            return true;
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    public String getWildcardedUrl() {
        return this.wildcardedUrl;
    }

    public final void setWildcardedUrl(String wildcardedUrl) {
        this.wildcardedUrl = wildcardedUrl;
        if (wildcardedUrl == null || wildcardedUrl.equals("*")) {
            this.urlPattern = null;
        } else {
            String wname = wildcardedUrl.toUpperCase(Locale.ROOT);
            wname = Pattern.quote(wname);
            wname = wname.replaceAll("\\?", "\\\\E.\\\\Q");
            wname = wname.replaceAll("\\*", "\\\\E.*\\\\Q");
            wname = wname.replaceAll("\\\\Q\\\\E", "");
            this.urlPattern = Pattern.compile(wname);
        }
    }

    public boolean isToExclude(HttpMessage msg, NameValuePair param) {
        return !(this.paramType != -1 && param.getType() != this.paramType || this.urlPattern != null && !this.urlPattern.matcher(msg.getRequestHeader().getURI().toString().toUpperCase(Locale.ROOT)).matches() || !this.paramNamePattern.matcher(param.getName()).matches());
    }

    public ScannerParamFilter clone() {
        return new ScannerParamFilter(this.paramNameRegex, this.paramType, this.wildcardedUrl);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.paramNameRegex == null ? 0 : this.paramNameRegex.hashCode());
        result = 31 * result + this.paramType;
        result = 31 * result + (this.wildcardedUrl == null ? 0 : this.wildcardedUrl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ScannerParamFilter) {
            ScannerParamFilter p = (ScannerParamFilter)obj;
            return p.getType() == this.getType() && p.getWildcardedUrl().equals(this.getWildcardedUrl()) && p.getParamName().equals(this.getParamName());
        }
        return false;
    }

    public String getTypeString() {
        return typeMap.get(this.paramType);
    }

    public void setType(String value) {
        int type = -1;
        for (Map.Entry<Integer, String> entry : typeMap.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(value)) continue;
            type = entry.getKey();
            break;
        }
        this.setType(type);
    }

    public static final Collection<String> getListTypes() {
        return typeMap.values();
    }

    public static final String getStringType(int paramType) {
        return typeMap.get(paramType);
    }

    static {
        typeMap.put(-1, Constant.messages.getString("variant.param.type.all"));
        typeMap.put(1, Constant.messages.getString("variant.param.type.query"));
        typeMap.put(2, Constant.messages.getString("variant.param.type.postdata"));
        typeMap.put(16, Constant.messages.getString("variant.param.type.path"));
        typeMap.put(8, Constant.messages.getString("variant.param.type.header"));
        typeMap.put(4, Constant.messages.getString("variant.param.type.cookie"));
    }
}

