/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.ThreadPool;
import org.parosproxy.paros.core.scanner.AbstractAppPlugin;
import org.parosproxy.paros.core.scanner.AbstractHostPlugin;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.Analyser;
import org.parosproxy.paros.core.scanner.Kb;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.core.scanner.PluginFactory;
import org.parosproxy.paros.core.scanner.Scanner;
import org.parosproxy.paros.core.scanner.ScannerHook;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.core.scanner.Util;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.zaproxy.zap.extension.ascan.ScanPolicy;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.TechSet;
import org.zaproxy.zap.users.User;

public class HostProcess
implements Runnable {
    private static final Logger log = Logger.getLogger(HostProcess.class);
    private static final DecimalFormat decimalFormat = new DecimalFormat("###0.###");
    private List<StructuralNode> startNodes = null;
    private boolean isStop = false;
    private PluginFactory pluginFactory;
    private ScannerParam scannerParam = null;
    private HttpSender httpSender = null;
    private ThreadPool threadPool = null;
    private Scanner parentScanner = null;
    private String hostAndPort = "";
    private Analyser analyser = null;
    private Kb kb = null;
    private User user = null;
    private TechSet techSet = null;
    private final Map<Integer, PluginStats> mapPluginStats = new HashMap<Integer, PluginStats>();
    private final Set<Integer> listPluginIdSkipped = new HashSet<Integer>();
    private long hostProcessStartTime = 0L;
    private int nodeInScopeCount = 0;
    private int percentage = 0;

    public HostProcess(String hostAndPort, Scanner parentScanner, ScannerParam scannerParam, ConnectionParam connectionParam, ScanPolicy scanPolicy) {
        this.hostAndPort = hostAndPort;
        this.parentScanner = parentScanner;
        this.scannerParam = scannerParam;
        this.pluginFactory = scanPolicy.getPluginFactory().clone();
        this.httpSender = new HttpSender(connectionParam, true, 2);
        this.httpSender.setUser(this.user);
        this.httpSender.setRemoveUserDefinedAuthHeaders(true);
        int maxNumberOfThreads = scannerParam.getHandleAntiCSRFTokens() ? 1 : scannerParam.getThreadPerHost();
        this.threadPool = new ThreadPool(maxNumberOfThreads, "ZAP-ActiveScanner-");
    }

    public void setStartNode(StructuralNode startNode) {
        this.startNodes = new ArrayList<StructuralNode>();
        this.startNodes.add(startNode);
    }

    public void addStartNode(StructuralNode startNode) {
        if (this.startNodes == null) {
            this.startNodes = new ArrayList<StructuralNode>();
        }
        this.startNodes.add(startNode);
    }

    public void stop() {
        this.isStop = true;
        this.getAnalyser().stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.debug((Object)"HostProcess.run");
        try {
            TraverseCounter counter = new TraverseCounter();
            this.hostProcessStartTime = System.currentTimeMillis();
            for (StructuralNode node : this.startNodes) {
                this.traverse(node, true, counter);
                this.getAnalyser().start(node);
            }
            this.nodeInScopeCount = counter.getCount();
            log.info((Object)("Scanning " + this.nodeInScopeCount + " node(s) from " + this.hostAndPort));
            while (!this.isStop() && this.pluginFactory.existPluginToRun()) {
                Plugin plugin = this.pluginFactory.nextPlugin();
                if (plugin != null) {
                    plugin.setDelayInMs(this.scannerParam.getDelayInMs());
                    plugin.setTechSet(this.techSet);
                    this.processPlugin(plugin);
                    continue;
                }
                Util.sleep(1000);
            }
            this.threadPool.waitAllThreadComplete(300000);
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while active scanning:", (Throwable)e);
            this.stop();
        }
        finally {
            this.notifyHostProgress(null);
            this.notifyHostComplete();
            this.getHttpSender().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPlugin(final Plugin plugin) {
        Map<Integer, PluginStats> map = this.mapPluginStats;
        synchronized (map) {
            this.mapPluginStats.put(plugin.getId(), new PluginStats());
        }
        if (this.techSet != null && !plugin.targets(this.techSet)) {
            this.listPluginIdSkipped.add(plugin.getId());
            this.pluginCompleted(plugin);
            return;
        }
        log.info((Object)("start host " + this.hostAndPort + " | " + plugin.getCodeName() + " strength " + (Object)((Object)plugin.getAttackStrength()) + " threshold " + (Object)((Object)plugin.getAlertThreshold())));
        for (StructuralNode startNode : this.startNodes) {
            if (plugin instanceof AbstractHostPlugin) {
                if (this.scanSingleNode(plugin, startNode)) continue;
                this.pluginCompleted(plugin);
                continue;
            }
            if (!(plugin instanceof AbstractAppPlugin)) continue;
            try {
                this.traverse(startNode, true, new TraverseAction(){

                    @Override
                    public void apply(StructuralNode node) {
                        log.debug((Object)("traverse: plugin=" + plugin.getName() + " url=" + node.getName()));
                        HostProcess.this.scanSingleNode(plugin, node);
                    }

                    @Override
                    public boolean isStopTraversing() {
                        return HostProcess.this.isSkipped(plugin);
                    }
                });
                this.threadPool.waitAllThreadComplete(600000);
            }
            finally {
                this.pluginCompleted(plugin);
            }
        }
    }

    private void traverse(StructuralNode node, TraverseAction action) {
        this.traverse(node, false, action);
    }

    private void traverse(StructuralNode node, boolean incRelatedSiblings, TraverseAction action) {
        if (node == null || this.isStop()) {
            return;
        }
        HashSet<StructuralNode> parentNodes = new HashSet<StructuralNode>();
        parentNodes.add(node);
        action.apply(node);
        if (!action.isStopTraversing() && this.parentScanner.scanChildren()) {
            if (incRelatedSiblings) {
                try {
                    Iterator<StructuralNode> iter = node.getParent().getChildIterator();
                    String nodeName = SessionStructure.getCleanRelativeName(node, false);
                    while (iter.hasNext()) {
                        StructuralNode sibling = iter.next();
                        if (node.isSameAs(sibling) || !nodeName.equals(SessionStructure.getCleanRelativeName(sibling, false))) continue;
                        log.debug((Object)("traverse: including related sibling " + sibling.getName()));
                        parentNodes.add(sibling);
                    }
                }
                catch (DatabaseException databaseException) {
                    // empty catch block
                }
            }
            for (StructuralNode pNode : parentNodes) {
                Iterator<StructuralNode> iter = pNode.getChildIterator();
                while (iter.hasNext() && !this.isStop() && !action.isStopTraversing()) {
                    StructuralNode child = iter.next();
                    while (this.parentScanner.isPaused() && !this.isStop()) {
                        Util.sleep(500);
                    }
                    try {
                        this.traverse(child, action);
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    protected boolean nodeInScope(String nodeName) {
        return this.parentScanner.isInScope(nodeName);
    }

    private boolean scanSingleNode(Plugin plugin, StructuralNode node) {
        Thread thread;
        Plugin test;
        log.debug((Object)("scanSingleNode node plugin=" + plugin.getName() + " node=" + node.getName()));
        try {
            if (node == null || node.getHistoryReference() == null) {
                log.debug((Object)("scanSingleNode node or href null, returning: node=" + node));
                return false;
            }
            if (3 == node.getHistoryReference().getHistoryType()) {
                log.debug((Object)"Ignoring \"scanner\" type href");
                return false;
            }
            if (!this.nodeInScope(node.getName())) {
                log.debug((Object)"scanSingleNode node not in scope");
                return false;
            }
            HttpMessage msg = node.getHistoryReference().getHttpMessage();
            if (msg == null) {
                log.debug((Object)"scanSingleNode msg null");
                return false;
            }
            test = (Plugin)plugin.getClass().newInstance();
            test.setConfig(plugin.getConfig());
            test.setDelayInMs(plugin.getDelayInMs());
            test.setDefaultAlertThreshold(plugin.getAlertThreshold());
            test.setDefaultAttackStrength(plugin.getAttackStrength());
            test.setTechSet(this.getTechSet());
            test.init(msg, this);
            this.notifyHostProgress(plugin.getName() + ": " + msg.getRequestHeader().getURI().toString());
        }
        catch (Exception e) {
            log.error((Object)(e.getMessage() + " " + node.getName()), (Throwable)e);
            return false;
        }
        do {
            if (this.isStop()) {
                return false;
            }
            thread = this.threadPool.getFreeThreadAndRun(test);
            if (thread != null) continue;
            Util.sleep(200);
        } while (thread == null);
        this.mapPluginStats.get(plugin.getId()).incProgress();
        return true;
    }

    public int getTestTotalCount() {
        return this.nodeInScopeCount;
    }

    public int getTestCurrentCount(Plugin plugin) {
        PluginStats pluginStats = this.mapPluginStats.get(plugin.getId());
        if (pluginStats == null) {
            return 0;
        }
        return pluginStats.getProgress();
    }

    @Deprecated
    public void setTestCurrentCount(Plugin plugin, int value) {
    }

    public HttpSender getHttpSender() {
        return this.httpSender;
    }

    public boolean isStop() {
        return this.isStop || this.parentScanner.isStop();
    }

    public boolean isPaused() {
        return this.parentScanner.isPaused();
    }

    public int getPercentageComplete() {
        return this.percentage;
    }

    private void notifyHostProgress(String msg) {
        if (this.pluginFactory.totalPluginToRun() == 0) {
            this.percentage = 100;
        } else {
            int numberRunning = 0;
            double progressRunning = 0.0;
            for (Plugin plugin : this.pluginFactory.getRunning()) {
                int scannedNodes = this.getTestCurrentCount(plugin);
                double pluginPercentage = (double)scannedNodes * 100.0 / (double)this.getTestTotalCount();
                if (pluginPercentage >= 100.0) {
                    this.nodeInScopeCount = scannedNodes;
                    pluginPercentage = 99.0;
                }
                progressRunning += pluginPercentage;
                ++numberRunning;
            }
            int avgRunning = (int)(progressRunning / (double)numberRunning);
            this.percentage = (100 * this.pluginFactory.totalPluginCompleted() + avgRunning) / this.pluginFactory.totalPluginToRun();
        }
        this.parentScanner.notifyHostProgress(this.hostAndPort, msg, this.percentage);
    }

    private void notifyHostComplete() {
        long diffTimeMillis = System.currentTimeMillis() - this.hostProcessStartTime;
        String diffTimeString = decimalFormat.format((double)diffTimeMillis / 1000.0) + "s";
        log.info((Object)("completed host " + this.hostAndPort + " in " + diffTimeString));
        this.parentScanner.notifyHostComplete(this.hostAndPort);
    }

    public void notifyNewMessage(HttpMessage msg) {
        this.parentScanner.notifyNewMessage(msg);
    }

    public void notifyNewMessage(Plugin plugin, HttpMessage message) {
        this.parentScanner.notifyNewMessage(message);
        this.notifyNewMessage(plugin);
    }

    public void notifyNewMessage(Plugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Parameter plugin must not be null.");
        }
        PluginStats pluginStats = this.mapPluginStats.get(plugin.getId());
        if (pluginStats != null) {
            pluginStats.incMessageCount();
        }
    }

    public void alertFound(Alert alert) {
        this.parentScanner.notifyAlertFound(alert);
    }

    public Analyser getAnalyser() {
        if (this.analyser == null) {
            this.analyser = new Analyser(this.getHttpSender(), this);
        }
        return this.analyser;
    }

    public boolean handleAntiCsrfTokens() {
        return this.scannerParam.getHandleAntiCSRFTokens();
    }

    public void pluginSkipped(Plugin plugin) {
        if (this.pluginFactory.isRunning(plugin)) {
            this.listPluginIdSkipped.add(plugin.getId());
        }
    }

    public boolean isSkipped(Plugin plugin) {
        return !this.listPluginIdSkipped.isEmpty() && this.listPluginIdSkipped.contains(plugin.getId());
    }

    void pluginCompleted(Plugin plugin) {
        PluginStats pluginStats = this.mapPluginStats.get(plugin.getId());
        if (pluginStats == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (this.isStop()) {
            sb.append("stopped host/plugin ");
        } else if (this.isSkipped(plugin)) {
            sb.append("skipped plugin ");
        } else {
            sb.append("completed host/plugin ");
        }
        sb.append(this.hostAndPort).append(" | ").append(plugin.getCodeName());
        long startTimeMillis = pluginStats.getStartTime();
        long diffTimeMillis = System.currentTimeMillis() - startTimeMillis;
        String diffTimeString = decimalFormat.format((double)diffTimeMillis / 1000.0) + "s";
        sb.append(" in ").append(diffTimeString);
        log.info((Object)sb.toString());
        this.pluginFactory.setRunningPluginCompleted(plugin);
        this.notifyHostProgress(null);
        pluginStats.setProgress(this.nodeInScopeCount);
    }

    Kb getKb() {
        if (this.kb == null) {
            this.kb = new Kb();
        }
        return this.kb;
    }

    protected ScannerParam getScannerParam() {
        return this.scannerParam;
    }

    public List<Plugin> getPending() {
        return this.pluginFactory.getPending();
    }

    public List<Plugin> getRunning() {
        return this.pluginFactory.getRunning();
    }

    public List<Plugin> getCompleted() {
        return this.pluginFactory.getCompleted();
    }

    public void setUser(User user) {
        this.user = user;
        if (this.httpSender != null) {
            this.httpSender.setUser(user);
        }
    }

    public TechSet getTechSet() {
        return this.techSet;
    }

    public void setTechSet(TechSet techSet) {
        this.techSet = techSet;
    }

    protected synchronized void performScannerHookBeforeScan(HttpMessage msg, AbstractPlugin plugin) {
        for (ScannerHook hook : this.parentScanner.getScannerHooks()) {
            if (hook == null) continue;
            try {
                hook.beforeScan(msg, plugin, this.parentScanner);
            }
            catch (Exception e) {
                log.info((Object)("An exception occurred while trying to call beforeScan(msg, plugin) for one of the ScannerHooks: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected synchronized void performScannerHookAfterScan(HttpMessage msg, AbstractPlugin plugin) {
        for (ScannerHook hook : this.parentScanner.getScannerHooks()) {
            if (hook == null) continue;
            try {
                hook.afterScan(msg, plugin, this.parentScanner);
            }
            catch (Exception e) {
                log.info((Object)("An exception occurred while trying to call afterScan(msg, plugin) for one of the ScannerHooks: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public String getHostAndPort() {
        return this.hostAndPort;
    }

    @Deprecated
    public void setPluginRequestCount(int pluginId, int reqCount) {
    }

    public int getPluginRequestCount(int pluginId) {
        PluginStats pluginStats = this.mapPluginStats.get(pluginId);
        if (pluginStats != null) {
            return pluginStats.getMessageCount();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRequestCount() {
        Map<Integer, PluginStats> map = this.mapPluginStats;
        synchronized (map) {
            int count = this.getAnalyser().getRequestCount();
            for (PluginStats stats : this.mapPluginStats.values()) {
                count += stats.getMessageCount();
            }
            return count;
        }
    }

    private static class PluginStats {
        private final long startTime = System.currentTimeMillis();
        private int messageCount;
        private int progress;

        public long getStartTime() {
            return this.startTime;
        }

        public int getMessageCount() {
            return this.messageCount;
        }

        public void incMessageCount() {
            ++this.messageCount;
        }

        public int getProgress() {
            return this.progress;
        }

        public void incProgress() {
            ++this.progress;
        }

        public void setProgress(int progress) {
            this.progress = progress;
        }
    }

    private static class TraverseCounter
    implements TraverseAction {
        private int count;

        private TraverseCounter() {
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public void apply(StructuralNode node) {
            ++this.count;
        }

        @Override
        public boolean isStopTraversing() {
            return false;
        }
    }

    private static interface TraverseAction {
        public void apply(StructuralNode var1);

        public boolean isStopTraversing();
    }
}

