/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.AbstractAppPlugin;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.ScannerParamFilter;
import org.parosproxy.paros.core.scanner.Util;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.core.scanner.VariantCookie;
import org.parosproxy.paros.core.scanner.VariantCustom;
import org.parosproxy.paros.core.scanner.VariantDirectWebRemotingQuery;
import org.parosproxy.paros.core.scanner.VariantFormQuery;
import org.parosproxy.paros.core.scanner.VariantGWTQuery;
import org.parosproxy.paros.core.scanner.VariantHeader;
import org.parosproxy.paros.core.scanner.VariantJSONQuery;
import org.parosproxy.paros.core.scanner.VariantMultipartFormQuery;
import org.parosproxy.paros.core.scanner.VariantODataFilterQuery;
import org.parosproxy.paros.core.scanner.VariantODataIdQuery;
import org.parosproxy.paros.core.scanner.VariantURLPath;
import org.parosproxy.paros.core.scanner.VariantURLQuery;
import org.parosproxy.paros.core.scanner.VariantUserDefined;
import org.parosproxy.paros.core.scanner.VariantXMLQuery;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptWrapper;

public abstract class AbstractAppParamPlugin
extends AbstractAppPlugin {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final ArrayList<Variant> listVariant = new ArrayList();
    private NameValuePair originalPair = null;
    private Variant variant = null;
    private ExtensionScript extension;

    @Override
    public void scan() {
        int targets = this.getParent().getScannerParam().getTargetParamsInjectable();
        int enabledRPC = this.getParent().getScannerParam().getTargetParamsEnabledRPC();
        if ((targets & 1) != 0) {
            this.listVariant.add(new VariantURLQuery());
            if ((enabledRPC & 0x10) != 0) {
                this.listVariant.add(new VariantODataIdQuery());
                this.listVariant.add(new VariantODataFilterQuery());
            }
        }
        if ((targets & 2) != 0) {
            this.listVariant.add(new VariantFormQuery());
            if ((enabledRPC & 1) != 0) {
                this.listVariant.add(new VariantMultipartFormQuery());
            }
            if ((enabledRPC & 2) != 0) {
                this.listVariant.add(new VariantXMLQuery());
            }
            if ((enabledRPC & 4) != 0) {
                this.listVariant.add(new VariantJSONQuery());
            }
            if ((enabledRPC & 8) != 0) {
                this.listVariant.add(new VariantGWTQuery());
            }
            if ((enabledRPC & 0x20) != 0) {
                this.listVariant.add(new VariantDirectWebRemotingQuery());
            }
        }
        if ((targets & 8) != 0) {
            this.listVariant.add(new VariantHeader());
        }
        if ((targets & 0x10) != 0) {
            this.listVariant.add(new VariantURLPath());
        }
        if ((targets & 4) != 0) {
            this.listVariant.add(new VariantCookie());
        }
        if ((enabledRPC & 0x80) != 0 && this.getExtension() != null) {
            List<ScriptWrapper> scripts = this.getExtension().getScripts("variant");
            for (ScriptWrapper script : scripts) {
                if (!script.isEnabled()) continue;
                this.listVariant.add(new VariantCustom(script, this.getExtension()));
            }
        }
        if ((enabledRPC & 0x100) != 0) {
            this.listVariant.add(new VariantUserDefined());
        }
        for (int i = 0; i < this.listVariant.size() && !this.isStop(); ++i) {
            HttpMessage msg = this.getNewMsg();
            this.variant = this.listVariant.get(i);
            try {
                this.variant.setMessage(msg);
                this.scanVariant();
            }
            catch (Exception e) {
                this.logger.error((Object)("Error occurred while scanning with variant " + this.variant.getClass().getCanonicalName()), (Throwable)e);
            }
            while (this.getParent().isPaused() && !this.isStop()) {
                Util.sleep(500);
            }
        }
    }

    private void scanVariant() {
        for (int i = 0; i < this.variant.getParamList().size() && !this.isStop(); ++i) {
            this.originalPair = this.variant.getParamList().get(i);
            if (this.isToExclude(this.originalPair)) continue;
            HttpMessage msg = this.getNewMsg();
            try {
                this.scan(msg, this.originalPair);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)"Error occurred while scanning a message:", (Throwable)e);
            }
        }
    }

    private boolean isToExclude(NameValuePair param) {
        List<ScannerParamFilter> excludedParameters = this.getParameterExclusionFilters(param);
        HttpMessage msg = this.getBaseMsg();
        for (ScannerParamFilter filter : excludedParameters) {
            if (!filter.isToExclude(msg, param)) continue;
            return true;
        }
        return false;
    }

    private List<ScannerParamFilter> getParameterExclusionFilters(NameValuePair parameter) {
        List<ScannerParamFilter> globalExclusionFilters = this.getParent().getScannerParam().getExcludedParamList(-1);
        List<ScannerParamFilter> exclusionFilters = this.getParent().getScannerParam().getExcludedParamList(parameter.getType());
        if (globalExclusionFilters == null) {
            if (exclusionFilters != null) {
                return exclusionFilters;
            }
            return Collections.emptyList();
        }
        if (exclusionFilters == null) {
            return globalExclusionFilters;
        }
        ArrayList<ScannerParamFilter> allFilters = new ArrayList<ScannerParamFilter>(globalExclusionFilters.size() + exclusionFilters.size());
        allFilters.addAll(globalExclusionFilters);
        allFilters.addAll(exclusionFilters);
        return allFilters;
    }

    public abstract void scan(HttpMessage var1, String var2, String var3);

    public void scan(HttpMessage msg, NameValuePair originalParam) {
        this.scan(msg, originalParam.getName(), originalParam.getValue());
    }

    protected String setParameter(HttpMessage msg, String param, String value) {
        return this.variant.setParameter(msg, this.originalPair, param, value);
    }

    protected String setEscapedParameter(HttpMessage msg, String param, String value) {
        return this.variant.setEscapedParameter(msg, this.originalPair, param, value);
    }

    private ExtensionScript getExtension() {
        if (this.extension == null) {
            this.extension = (ExtensionScript)Control.getSingleton().getExtensionLoader().getExtension("ExtensionScript");
        }
        return this.extension;
    }
}

