/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.proxy;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.proxy.ArrangeableProxyListener;
import org.parosproxy.paros.core.proxy.CacheProcessingItem;
import org.parosproxy.paros.core.proxy.ConnectRequestProxyListener;
import org.parosproxy.paros.core.proxy.OverrideMessageProxyListener;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.core.proxy.ProxyParam;
import org.parosproxy.paros.core.proxy.ProxyThread;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpUtil;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.PersistentConnectionListener;

public class ProxyServer
implements Runnable {
    protected Thread thread = null;
    protected static final int PORT_TIME_OUT = 0;
    protected ServerSocket proxySocket = null;
    protected boolean isProxyRunning = false;
    protected ProxyParam proxyParam = new ProxyParam();
    protected ConnectionParam connectionParam = new ConnectionParam();
    protected Vector<ProxyListener> listenerList = new Vector();
    protected Vector<OverrideMessageProxyListener> overrideListeners = new Vector();
    protected Vector<PersistentConnectionListener> persistentConnectionListenerList = new Vector();
    private final List<ConnectRequestProxyListener> connectRequestProxyListeners;
    private static Comparator<ArrangeableProxyListener> listenersComparator;
    protected boolean serialize = false;
    protected boolean enableCacheProcessing = false;
    protected Vector<CacheProcessingItem> cacheProcessingList = new Vector();
    private List<Pattern> excludeUrls = null;
    private static Logger log;

    public boolean isEnableCacheProcessing() {
        return this.enableCacheProcessing;
    }

    public void setEnableCacheProcessing(boolean enableCacheProcessing) {
        this.enableCacheProcessing = enableCacheProcessing;
        if (!enableCacheProcessing) {
            this.cacheProcessingList.clear();
        }
    }

    public boolean isSerialize() {
        return this.serialize;
    }

    public ProxyServer() {
        this.connectRequestProxyListeners = new ArrayList<ConnectRequestProxyListener>(1);
    }

    public void setProxyParam(ProxyParam param) {
        this.proxyParam = param;
    }

    public ProxyParam getProxyParam() {
        return this.proxyParam;
    }

    public void setConnectionParam(ConnectionParam connection) {
        this.connectionParam = connection;
    }

    public ConnectionParam getConnectionParam() {
        return this.connectionParam;
    }

    public synchronized int startServer(String ip, int port, boolean isDynamicPort) {
        if (this.isProxyRunning) {
            this.stopServer();
        }
        this.isProxyRunning = false;
        this.thread = new Thread((Runnable)this, "ZAP-ProxyServer");
        this.thread.setDaemon(true);
        this.thread.setPriority(6);
        this.proxySocket = null;
        for (int i = 0; i < 20 && this.proxySocket == null; ++i) {
            try {
                this.proxySocket = this.createServerSocket(ip, port);
                this.proxySocket.setSoTimeout(0);
                this.isProxyRunning = true;
                continue;
            }
            catch (UnknownHostException e) {
                if (View.isInitialised()) {
                    View.getSingleton().showWarningDialog(Constant.messages.getString("proxy.error.host.unknow") + " " + ip);
                } else {
                    System.out.println(Constant.messages.getString("proxy.error.host.unknow") + " " + ip);
                }
                return -1;
            }
            catch (BindException e) {
                if ("Cannot assign requested address".equals(e.getMessage())) {
                    ProxyServer.showErrorMessage(Constant.messages.getString("proxy.error.address") + " " + ip);
                    return -1;
                }
                if ("Permission denied".equals(e.getMessage()) || "Address already in use".equals(e.getMessage())) {
                    if (!isDynamicPort) {
                        ProxyServer.showErrorMessage(Constant.messages.getString("proxy.error.port") + " " + ip + ":" + port);
                        return -1;
                    }
                    if (port >= 65535) continue;
                    ++port;
                    continue;
                }
                ProxyServer.handleUnknownException(e);
                return -1;
            }
            catch (IOException e) {
                ProxyServer.handleUnknownException(e);
                return -1;
            }
        }
        if (this.proxySocket == null) {
            return -1;
        }
        this.thread.start();
        return this.proxySocket.getLocalPort();
    }

    private static void showErrorMessage(String error) {
        if (View.isInitialised()) {
            View.getSingleton().showWarningDialog(error);
        } else {
            log.error((Object)error);
            System.out.println(error);
        }
    }

    private static void handleUnknownException(Exception e) {
        log.error((Object)"Failed to start the proxy server: ", (Throwable)e);
        ProxyServer.showErrorMessage(Constant.messages.getString("proxy.error.generic") + e.getLocalizedMessage());
    }

    public synchronized boolean stopServer() {
        if (!this.isProxyRunning) {
            return false;
        }
        this.isProxyRunning = false;
        HttpUtil.closeServerSocket(this.proxySocket);
        try {
            this.thread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.proxySocket = null;
        return true;
    }

    @Override
    public void run() {
        while (this.isProxyRunning) {
            try {
                Socket clientSocket = this.proxySocket.accept();
                ProxyThread process = this.createProxyProcess(clientSocket);
                process.start();
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (IOException e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected ServerSocket createServerSocket(String ip, int port) throws UnknownHostException, IOException {
        InetAddress addr = null;
        if (ip != null && !ip.isEmpty()) {
            addr = InetAddress.getByName(ip);
        }
        ServerSocket socket = new ServerSocket(port, 400, addr);
        return socket;
    }

    protected ProxyThread createProxyProcess(Socket clientSocket) {
        ProxyThread process = new ProxyThread(this, clientSocket);
        return process;
    }

    protected void writeOutput(String s) {
    }

    public void addProxyListener(ProxyListener listener) {
        this.listenerList.add(listener);
        Collections.sort(this.listenerList, this.getListenersComparator());
    }

    public void removeProxyListener(ProxyListener listener) {
        this.listenerList.remove(listener);
    }

    synchronized List<ProxyListener> getListenerList() {
        return this.listenerList;
    }

    public void addPersistentConnectionListener(PersistentConnectionListener listener) {
        this.persistentConnectionListenerList.add(listener);
        Collections.sort(this.persistentConnectionListenerList, this.getListenersComparator());
    }

    public void removePersistentConnectionListener(PersistentConnectionListener listener) {
        this.persistentConnectionListenerList.remove(listener);
    }

    synchronized List<PersistentConnectionListener> getPersistentConnectionListenerList() {
        return this.persistentConnectionListenerList;
    }

    public void addOverrideMessageProxyListener(OverrideMessageProxyListener listener) {
        this.overrideListeners.add(listener);
        Collections.sort(this.overrideListeners, this.getListenersComparator());
    }

    public void removeOverrideMessageProxyListener(OverrideMessageProxyListener listener) {
        this.overrideListeners.remove(listener);
    }

    List<OverrideMessageProxyListener> getOverrideMessageProxyListeners() {
        return this.overrideListeners;
    }

    public void addConnectRequestProxyListener(ConnectRequestProxyListener listener) {
        this.connectRequestProxyListeners.add(listener);
    }

    private static void validateListenerNotNull(Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Parameter listener must not be null.");
        }
    }

    public void removeConnectRequestProxyListener(ConnectRequestProxyListener listener) {
        ProxyServer.validateListenerNotNull(listener);
        this.connectRequestProxyListeners.remove(listener);
    }

    List<ConnectRequestProxyListener> getConnectRequestProxyListeners() {
        return Collections.unmodifiableList(this.connectRequestProxyListeners);
    }

    public boolean isAnyProxyThreadRunning() {
        return ProxyThread.isAnyProxyThreadRunning();
    }

    public void setSerialize(boolean serialize) {
        this.serialize = serialize;
    }

    public void addCacheProcessingList(CacheProcessingItem item) {
        this.cacheProcessingList.add(item);
    }

    Vector<CacheProcessingItem> getCacheProcessingList() {
        return this.cacheProcessingList;
    }

    public void setExcludeList(List<String> urls) {
        this.excludeUrls = new ArrayList<Pattern>(urls.size());
        for (String url : urls) {
            Pattern p = Pattern.compile(url, 2);
            this.excludeUrls.add(p);
        }
    }

    public boolean excludeUrl(URI uri) {
        boolean ignore = false;
        if (this.excludeUrls != null) {
            String uriString = uri.toString();
            for (Pattern p : this.excludeUrls) {
                if (!p.matcher(uriString).matches()) continue;
                ignore = true;
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("URL excluded: " + uriString + " Regex: " + p.pattern()));
                break;
            }
        }
        return ignore;
    }

    private Comparator<ArrangeableProxyListener> getListenersComparator() {
        if (listenersComparator == null) {
            this.createListenersComparator();
        }
        return listenersComparator;
    }

    private synchronized void createListenersComparator() {
        if (listenersComparator == null) {
            listenersComparator = new Comparator<ArrangeableProxyListener>(){

                @Override
                public int compare(ArrangeableProxyListener o1, ArrangeableProxyListener o2) {
                    int order2;
                    int order1 = o1.getArrangeableListenerOrder();
                    if (order1 < (order2 = o2.getArrangeableListenerOrder())) {
                        return -1;
                    }
                    if (order1 > order2) {
                        return 1;
                    }
                    return 0;
                }
            };
        }
    }

    static {
        log = Logger.getLogger(ProxyServer.class);
    }
}

