/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.control;

import java.awt.EventQueue;
import java.awt.Frame;
import java.io.File;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordSession;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SessionListener;
import org.parosproxy.paros.view.View;
import org.parosproxy.paros.view.WaitMessageDialog;
import org.zaproxy.zap.view.ContextExportDialog;
import org.zaproxy.zap.view.PersistSessionDialog;
import org.zaproxy.zap.view.SessionTableSelectDialog;

public class MenuFileControl
implements SessionListener {
    private static Logger log = Logger.getLogger(MenuFileControl.class);
    private View view = null;
    private Model model = null;
    private Control control = null;
    private WaitMessageDialog waitMessageDialog = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");

    public MenuFileControl(Model model, View view, Control control) {
        this.view = view;
        this.model = model;
        this.control = control;
    }

    public void exit() {
        this.control.exit(false, null);
    }

    public void newSession(boolean isPromptNewSession) throws ClassNotFoundException, Exception {
        if (isPromptNewSession) {
            if (this.model.getSession().isNewState()) {
                if (this.view.showConfirmDialog(Constant.messages.getString("menu.file.discardSession")) != 0) {
                    return;
                }
                this.control.discardSession();
            } else if (this.view.showConfirmDialog(Constant.messages.getString("menu.file.closeSession")) != 0) {
                return;
            }
        }
        int newSessionOption = this.model.getOptionsParam().getDatabaseParam().getNewSessionOption();
        if (this.model.getOptionsParam().getDatabaseParam().isNewSessionPrompt()) {
            PersistSessionDialog psd = new PersistSessionDialog(View.getSingleton().getMainFrame());
            switch (newSessionOption) {
                case 1: {
                    psd.setTimestampChosen();
                    break;
                }
                case 2: {
                    psd.setPersistChosen();
                    break;
                }
                case 3: {
                    psd.setTemporaryChosen();
                    break;
                }
            }
            psd.setVisible(true);
            newSessionOption = psd.isTimestampChosen() ? 1 : (psd.isPersistChosen() ? 2 : 3);
            this.model.getOptionsParam().getDatabaseParam().setNewSessionOption(newSessionOption);
            this.model.getOptionsParam().getDatabaseParam().setNewSessionPrompt(!psd.isDontAskAgain());
        }
        switch (newSessionOption) {
            case 1: {
                String filename = this.getTimestampFilename();
                if (filename != null) {
                    this.newSession(filename);
                    break;
                }
                this.control.newSession();
                break;
            }
            case 2: {
                this.control.newSession();
                this.saveAsSession();
                break;
            }
            default: {
                this.control.newSession();
            }
        }
    }

    private String getTimestampFilename() {
        File dir = new File(Constant.getZapHome(), "sessions");
        if (!dir.exists() && !dir.mkdirs()) {
            return null;
        }
        String timestamp = this.dateFormat.format(new Date());
        File tmpFile = new File(dir, timestamp + ".session");
        return tmpFile.getAbsolutePath();
    }

    public boolean newSession(String fileName) {
        final Object[] created = new Object[]{Boolean.TRUE};
        this.waitMessageDialog = this.view.getWaitMessageDialog(Constant.messages.getString("menu.file.newSession.wait.dialogue"));
        this.control.newSession(fileName, new SessionListener(){

            @Override
            public void sessionSnapshot(Exception e) {
            }

            @Override
            public void sessionSaved(final Exception e) {
                if (EventQueue.isDispatchThread()) {
                    if (e == null) {
                        MenuFileControl.this.setTitle();
                        MenuFileControl.this.view.getSiteTreePanel().getTreeSite().setModel(MenuFileControl.this.model.getSession().getSiteTree());
                    } else {
                        MenuFileControl.this.view.showWarningDialog(Constant.messages.getString("menu.file.newSession.error"));
                        log.error((Object)("Error creating session file " + MenuFileControl.this.model.getSession().getFileName()), (Throwable)e);
                        created[0] = Boolean.FALSE;
                    }
                    if (MenuFileControl.this.waitMessageDialog != null) {
                        MenuFileControl.this.waitMessageDialog.setVisible(false);
                        MenuFileControl.this.waitMessageDialog = null;
                    }
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.sessionSaved(e);
                        }
                    });
                }
            }

            @Override
            public void sessionOpened(File file, Exception e) {
            }
        });
        this.waitMessageDialog.setVisible(true);
        return created[0] == Boolean.TRUE;
    }

    public boolean openSession(String session) {
        final Object[] opened = new Object[]{Boolean.TRUE};
        File sessionFile = new File(session);
        this.waitMessageDialog = this.view.getWaitMessageDialog(Constant.messages.getString("menu.file.loadSession"));
        log.info((Object)("opening session file " + sessionFile.getAbsolutePath()));
        this.control.openSession(sessionFile, new SessionListener(){

            @Override
            public void sessionSnapshot(Exception e) {
            }

            @Override
            public void sessionSaved(Exception e) {
            }

            @Override
            public void sessionOpened(final File file, final Exception e) {
                if (EventQueue.isDispatchThread()) {
                    if (e != null) {
                        MenuFileControl.this.view.showWarningDialog(Constant.messages.getString("menu.file.openSession.error"));
                        log.error((Object)("error opening session file " + MenuFileControl.this.model.getSession().getFileName()), (Throwable)e);
                        opened[0] = Boolean.FALSE;
                    }
                    MenuFileControl.this.view.getSiteTreePanel().getTreeSite().setModel(MenuFileControl.this.model.getSession().getSiteTree());
                    MenuFileControl.this.setTitle();
                    if (MenuFileControl.this.waitMessageDialog != null) {
                        MenuFileControl.this.waitMessageDialog.setVisible(false);
                        MenuFileControl.this.waitMessageDialog = null;
                    }
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.sessionOpened(file, e);
                        }
                    });
                }
            }
        });
        this.waitMessageDialog.setVisible(true);
        return opened[0] == Boolean.TRUE;
    }

    public void openSession() {
        if ("hsqldb".equals(this.model.getDb().getType())) {
            this.openFileBasedSession();
        } else {
            this.openDbBasedSession();
        }
    }

    private void openFileBasedSession() {
        JFileChooser chooser = new JFileChooser(this.model.getOptionsParam().getUserDirectory());
        chooser.setFileHidingEnabled(false);
        File file = null;
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.isFile() && file.getName().endsWith(".session");
            }

            @Override
            public String getDescription() {
                return Constant.messages.getString("file.format.zap.session");
            }
        });
        int rc = chooser.showOpenDialog(this.view.getMainFrame());
        if (rc == 0) {
            try {
                file = chooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                this.model.getOptionsParam().setUserDirectory(chooser.getCurrentDirectory());
                log.info((Object)("opening session file " + file.getAbsolutePath()));
                this.waitMessageDialog = this.view.getWaitMessageDialog(Constant.messages.getString("menu.file.loadSession"));
                this.control.openSession(file, (SessionListener)this);
                this.waitMessageDialog.setVisible(true);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void openDbBasedSession() {
        try {
            ArrayList<String> sessionList = new ArrayList<String>();
            for (RecordSession rs : this.model.getDb().getTableSession().listSessions()) {
                sessionList.add("" + rs.getSessionId());
            }
            SessionTableSelectDialog ssd = new SessionTableSelectDialog((Frame)View.getSingleton().getMainFrame(), sessionList);
            ssd.setVisible(true);
            if (ssd.getSelectedSession() != null) {
                this.waitMessageDialog = this.view.getWaitMessageDialog(Constant.messages.getString("menu.file.loadSession"));
                this.control.openSession(ssd.getSelectedSession(), (SessionListener)this);
                this.waitMessageDialog.setVisible(true);
            }
        }
        catch (DatabaseException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void saveSession() {
        Session session = this.model.getSession();
        if (session.isNewState()) {
            this.view.showWarningDialog("Please use Save As...");
            return;
        }
        try {
            this.waitMessageDialog = this.view.getWaitMessageDialog(Constant.messages.getString("menu.file.savingSession"));
            this.control.saveSession(session.getFileName(), this);
            log.info((Object)("saving session file " + session.getFileName()));
            if (this.waitMessageDialog != null) {
                this.waitMessageDialog.setVisible(true);
            }
        }
        catch (Exception e) {
            this.view.showWarningDialog(Constant.messages.getString("menu.file.savingSession.error"));
            log.error((Object)("error saving session file " + session.getFileName()));
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void saveAsSession() {
        Session session = this.model.getSession();
        JFileChooser chooser = new JFileChooser(this.model.getOptionsParam().getUserDirectory());
        File fileproposal = new File(session.getSessionName());
        if (session.getFileName() != null && session.getFileName().trim().length() > 0) {
            fileproposal = new File(session.getFileName());
        }
        chooser.setSelectedFile(fileproposal);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.isFile() && file.getName().endsWith(".session");
            }

            @Override
            public String getDescription() {
                return Constant.messages.getString("file.format.zap.session");
            }
        });
        File file = null;
        int rc = chooser.showSaveDialog(this.view.getMainFrame());
        if (rc == 0) {
            file = chooser.getSelectedFile();
            if (file == null) {
                return;
            }
            this.model.getOptionsParam().setUserDirectory(chooser.getCurrentDirectory());
            String fileName = file.getAbsolutePath();
            if (!fileName.endsWith(".session")) {
                fileName = fileName + ".session";
            }
            try {
                this.waitMessageDialog = this.view.getWaitMessageDialog(Constant.messages.getString("menu.file.savingSession"));
                this.control.saveSession(fileName, this);
                log.info((Object)("save as session file " + session.getFileName()));
                this.waitMessageDialog.setVisible(true);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void saveSnapshot() {
        Session session = this.model.getSession();
        String fileName = session.getFileName();
        if (fileName.endsWith(".session")) {
            fileName = fileName.substring(0, fileName.length() - 8);
        }
        fileName = fileName + "-" + this.dateFormat.format(new Date()) + ".session";
        try {
            this.waitMessageDialog = this.view.getWaitMessageDialog(Constant.messages.getString("menu.file.savingSnapshot"));
            this.control.snapshotSession(fileName, this);
            log.info((Object)("snapshot as session file " + fileName));
            this.waitMessageDialog.setVisible(true);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void setTitle() {
        StringBuilder strBuilder = new StringBuilder(this.model.getSession().getSessionName());
        if (!this.model.getSession().isNewState()) {
            File file = new File(this.model.getSession().getFileName());
            strBuilder.append(" - ").append(file.getName().replaceAll(".session\\z", ""));
        }
        this.view.getMainFrame().setTitle(strBuilder.toString());
    }

    public void properties() {
        View.getSingleton().showSessionDialog(this.model.getSession(), null);
        this.setTitle();
    }

    @Override
    public void sessionOpened(File file, Exception e) {
        if (e == null) {
            this.setTitle();
        } else {
            this.view.showWarningDialog(Constant.messages.getString("menu.file.openSession.errorFile"));
            if (file != null) {
                log.error((Object)("Error opening session file " + file.getAbsolutePath()), (Throwable)e);
            } else {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (this.waitMessageDialog != null) {
            this.waitMessageDialog.setVisible(false);
            this.waitMessageDialog = null;
        }
    }

    @Override
    public void sessionSaved(Exception e) {
        if (e == null) {
            this.setTitle();
        } else {
            this.view.showWarningDialog(Constant.messages.getString("menu.file.savingSession.error"));
            log.error((Object)("error saving session file " + this.model.getSession().getFileName()), (Throwable)e);
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (this.waitMessageDialog != null) {
            this.waitMessageDialog.setVisible(false);
            this.waitMessageDialog = null;
        }
    }

    @Override
    public void sessionSnapshot(Exception e) {
        if (e != null) {
            this.view.showWarningDialog(Constant.messages.getString("menu.file.snapshotSession.error"));
            log.error((Object)("error saving snapshot file " + this.model.getSession().getFileName()), (Throwable)e);
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (this.waitMessageDialog != null) {
            this.waitMessageDialog.setVisible(false);
            this.waitMessageDialog = null;
        }
    }

    public void importContext() {
        JFileChooser chooser = new JFileChooser(Constant.getContextsDir());
        File file = null;
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.isFile() && file.getName().endsWith(".context");
            }

            @Override
            public String getDescription() {
                return Constant.messages.getString("file.format.zap.context");
            }
        });
        int rc = chooser.showOpenDialog(View.getSingleton().getMainFrame());
        if (rc == 0) {
            try {
                file = chooser.getSelectedFile();
                if (file == null || !file.exists()) {
                    return;
                }
                Model.getSingleton().getSession().importContext(file);
                View.getSingleton().showSessionDialog(Model.getSingleton().getSession(), Constant.messages.getString("context.list"), true);
            }
            catch (Exception e1) {
                log.debug((Object)e1.getMessage(), (Throwable)e1);
                View.getSingleton().showWarningDialog(MessageFormat.format(Constant.messages.getString("context.import.error"), e1.getMessage()));
            }
        }
    }

    public void exportContext() {
        ContextExportDialog exportDialog = new ContextExportDialog(View.getSingleton().getMainFrame());
        exportDialog.setVisible(true);
    }
}

