/*
 * Zed Attack Proxy (ZAP) and its related class files.
 * 
 * ZAP is an HTTP/HTTPS proxy for assessing web application security.
 * 
 * Copyright 2010 psiinon@gmail.com
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0 
 *   
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License. 
 */
package org.zaproxy.zap.model;

import java.util.List;

public class Vulnerability {

	private String id;
	private String alert;
	private String description;
	private String solution;
	private List<String> references;
	
	public Vulnerability(String id, String alert, String description, String solution, List<String> references) {
		super();
		this.id = id;
		this.alert = alert;
		this.description = description;
		this.solution = solution;
		this.references = references;
	}
	
	public String getAlert() {
		return alert;
	}
	public void setAlert(String alert) {
		this.alert = alert;
	}
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}
	public String getSolution() {
		return solution;
	}
	public void setSolution(String solution) {
		this.solution = solution;
	}
	public List<String> getReferences() {
		return references;
	}
	public void setReferences(List<String> references) {
		this.references = references;
	}

	protected String getId() {
		return id;
	}
	
	public int getWascId() {
		if (id.startsWith("wasc_")) {
			String str = id.substring(5);
			try {
				return Integer.parseInt(str);
			} catch (NumberFormatException e) {
				// Some have trailing alphabetic characters
				try {
					return Integer.parseInt(str.substring(0, str.length() -1));
				} catch (NumberFormatException e2) {
					// Ignore
				}
			}
		}
		return -1;
	}
	
}
