/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal.server.http.handlers;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.net.ssl.SSLException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.parosproxy.paros.network.HttpSender;
import org.zaproxy.addon.network.server.HttpMessageHandler;
import org.zaproxy.addon.network.server.HttpMessageHandlerContext;
import org.zaproxy.zap.network.HttpRequestConfig;

public class HttpSenderHandler
implements HttpMessageHandler {
    private static final Logger LOGGER = LogManager.getLogger(HttpSenderHandler.class);
    private static final String BAD_GATEWAY_REASON_PHRASE = "Bad Gateway";
    private static final String GATEWAY_TIMEOUT_REASON_PHRASE = "Gateway Timeout";
    private static final HttpRequestConfig EXCLUDED_REQ_CONFIG = HttpRequestConfig.builder().setNotifyListeners(false).build();
    private ConnectionParam connectionParam;
    private HttpSender httpSender;

    public HttpSenderHandler(ConnectionParam connectionParam, HttpSender httpSender) {
        this.connectionParam = Objects.requireNonNull(connectionParam);
        this.httpSender = Objects.requireNonNull(httpSender);
    }

    @Override
    public void handleMessage(HttpMessageHandlerContext ctx, HttpMessage msg) {
        if (!ctx.isFromClient() || !msg.getResponseHeader().isEmpty()) {
            return;
        }
        try {
            if (ctx.isExcluded()) {
                this.httpSender.sendAndReceive(msg, EXCLUDED_REQ_CONFIG);
                ctx.overridden();
            } else {
                this.httpSender.sendAndReceive(msg);
            }
        }
        catch (HttpException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ctx.close();
        }
        catch (SocketTimeoutException e) {
            String message = Constant.messages.getString("network.httpsender.error.readtimeout", new Object[]{msg.getRequestHeader().getURI(), this.connectionParam.getTimeoutInSecs()});
            LOGGER.warn(message);
            HttpSenderHandler.setErrorResponse(ctx, msg, 504, GATEWAY_TIMEOUT_REASON_PHRASE, message);
        }
        catch (IOException e) {
            this.setErrorResponse(ctx, msg, 502, BAD_GATEWAY_REASON_PHRASE, e);
        }
    }

    private void setErrorResponse(HttpMessageHandlerContext ctx, HttpMessage msg, int statusCode, String reasonPhrase, Exception cause) {
        StringBuilder strBuilder = new StringBuilder();
        if (cause instanceof SSLException) {
            strBuilder.append(Constant.messages.getString("network.httpsender.ssl.error.connect"));
            strBuilder.append(msg.getRequestHeader().getURI().toString()).append('\n');
            strBuilder.append(Constant.messages.getString("network.httpsender.ssl.error.exception")).append(cause.getMessage()).append('\n');
            strBuilder.append(Constant.messages.getString("network.httpsender.ssl.error.exception.rootcause")).append(ExceptionUtils.getRootCauseMessage((Throwable)cause)).append('\n');
            strBuilder.append(Constant.messages.getString("network.httpsender.ssl.error.help", new Object[]{Constant.messages.getString("network.httpsender.ssl.error.help.url")}));
            LOGGER.warn(strBuilder.toString());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)cause, (Throwable)cause);
                strBuilder.append("\n\nStack Trace:\n");
                for (String stackTraceFrame : ExceptionUtils.getRootCauseStackTrace((Throwable)cause)) {
                    strBuilder.append(stackTraceFrame).append('\n');
                }
            }
        } else {
            strBuilder.append("ZAP Error").append(" [").append(cause.getClass().getName()).append("]: ").append(cause.getLocalizedMessage()).append("\n");
            if (cause instanceof UnknownHostException && this.connectionParam.isUseProxyChain() && this.connectionParam.getProxyChainName().equalsIgnoreCase(cause.getMessage())) {
                strBuilder.append(Constant.messages.getString("network.httpsender.error.proxy"));
            }
            strBuilder.append("\n\nStack Trace:\n");
            for (String stackTraceFrame : ExceptionUtils.getRootCauseStackTrace((Throwable)cause)) {
                strBuilder.append(stackTraceFrame).append('\n');
            }
        }
        HttpSenderHandler.setErrorResponse(ctx, msg, statusCode, reasonPhrase, strBuilder.toString());
    }

    private static void setErrorResponse(HttpMessageHandlerContext ctx, HttpMessage msg, int statusCode, String reasonPhrase, String message) {
        HttpResponseHeader responseHeader = new HttpResponseHeader();
        responseHeader.setVersion("HTTP/1.1");
        responseHeader.setStatusCode(statusCode);
        responseHeader.setReasonPhrase(reasonPhrase);
        responseHeader.setHeader("Content-Type", "text/plain; charset=UTF-8");
        responseHeader.setHeader("Content-Length", Integer.toString(message.getBytes(StandardCharsets.UTF_8).length));
        msg.setResponseHeader(responseHeader);
        if (!"HEAD".equals(msg.getRequestHeader().getMethod())) {
            msg.setResponseBody(message);
        }
    }
}

