/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal.server.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.addon.network.internal.ChannelAttributes;
import org.zaproxy.addon.network.internal.server.http.DefaultHttpMessageHandlerContext;
import org.zaproxy.addon.network.server.HttpMessageHandler;

public class MainServerHandler
extends SimpleChannelInboundHandler<HttpMessage> {
    private static final Logger LOGGER = LogManager.getLogger(MainServerHandler.class);
    protected final List<HttpMessageHandler> pipeline;
    protected final DefaultHttpMessageHandlerContext handlerContext;

    public MainServerHandler(List<HttpMessageHandler> handlers) {
        this.pipeline = Objects.requireNonNull(handlers);
        this.handlerContext = new DefaultHttpMessageHandlerContext();
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpMessage msg) throws Exception {
        if (msg.getUserObject() instanceof Exception) {
            throw (Exception)msg.getUserObject();
        }
        ctx.channel().attr(ChannelAttributes.PROCESSING_MESSAGE).set((Object)Boolean.TRUE);
        try {
            this.process(ctx, msg);
        }
        finally {
            ctx.channel().attr(ChannelAttributes.PROCESSING_MESSAGE).set((Object)Boolean.FALSE);
        }
    }

    private void process(ChannelHandlerContext ctx, HttpMessage msg) throws Exception {
        this.handlerContext.reset();
        Channel channel = ctx.channel();
        this.handlerContext.setRecursive((Boolean)channel.attr(ChannelAttributes.RECURSIVE_MESSAGE).get());
        if (this.processMessage(msg) == HandlerResult.CLOSE) {
            MainServerHandler.close(ctx);
            return;
        }
        MainServerHandler.writeResponse(ctx, msg);
        if (this.postWriteResponse(ctx, msg)) {
            return;
        }
        if (MainServerHandler.isConnectionClose(msg)) {
            MainServerHandler.close(ctx);
        }
    }

    protected HandlerResult processMessage(HttpMessage msg) {
        HandlerResult result = this.notifyMessageHandlers(msg);
        if (result != HandlerResult.CONTINUE) {
            return result;
        }
        this.handlerContext.handlingResponse();
        result = this.notifyMessageHandlers(msg);
        if (result != HandlerResult.CONTINUE) {
            return result;
        }
        return HandlerResult.CONTINUE;
    }

    private HandlerResult notifyMessageHandlers(HttpMessage msg) {
        for (HttpMessageHandler handler : this.pipeline) {
            try {
                handler.handleMessage(this.handlerContext, msg);
            }
            catch (Throwable e) {
                LOGGER.error("An error occurred while notifying a handler:", e);
            }
            if (this.handlerContext.isClose()) {
                return HandlerResult.CLOSE;
            }
            if (!this.handlerContext.isOverridden()) continue;
            return HandlerResult.OVERRIDDEN;
        }
        return HandlerResult.CONTINUE;
    }

    protected boolean postWriteResponse(ChannelHandlerContext ctx, HttpMessage msg) {
        return false;
    }

    private static void writeResponse(ChannelHandlerContext ctx, HttpMessage msg) {
        ctx.writeAndFlush((Object)msg).addListener(e -> {
            if (!e.isSuccess()) {
                LOGGER.warn(() -> {
                    Throwable cause = e.cause();
                    StringBuilder strBuilder = new StringBuilder(200);
                    strBuilder.append("Failed to write/forward the HTTP response to the client: ");
                    strBuilder.append(cause.getClass().getName());
                    if (cause.getMessage() != null) {
                        strBuilder.append(": ").append(cause.getMessage());
                    }
                    return strBuilder;
                });
            }
        });
    }

    protected static void close(ChannelHandlerContext ctx) {
        ctx.close().addListener(e -> {
            if (!e.isSuccess()) {
                LOGGER.debug("An error occurred while closing the connection.", e.cause());
            }
        });
    }

    private static boolean isConnectionClose(HttpMessage msg) {
        if (msg.getResponseHeader().isEmpty()) {
            return true;
        }
        if (msg.getRequestHeader().isConnectionClose()) {
            return true;
        }
        if (msg.getResponseHeader().isConnectionClose()) {
            return true;
        }
        return msg.getResponseHeader().getContentLength() == -1 && msg.getResponseBody().length() > 0;
    }

    protected static enum HandlerResult {
        CONTINUE,
        OVERRIDDEN,
        CLOSE;

    }
}

