/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zaproxy.addon.network.internal.ChannelAttributes;
import org.zaproxy.addon.network.internal.handlers.ChannelGroupHandler;
import org.zaproxy.addon.network.server.Server;

public class BaseServer
implements Server {
    private static final Logger LOGGER = LogManager.getLogger(BaseServer.class);
    private final ServerBootstrap bootstrap;
    private Consumer<SocketChannel> channelInitialiser;
    private ChannelGroup allChannels;
    private Channel serverChannel;

    protected BaseServer(NioEventLoopGroup group) {
        Objects.requireNonNull(group);
        this.bootstrap = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializerImpl());
    }

    public BaseServer(NioEventLoopGroup group, Consumer<SocketChannel> channelInitialiser) {
        this(group);
        this.setChannelInitialiser(channelInitialiser);
    }

    protected void setChannelInitialiser(Consumer<SocketChannel> channelInitialiser) {
        this.channelInitialiser = Objects.requireNonNull(channelInitialiser);
    }

    @Override
    public int start(String address, int port) throws IOException {
        Server.validatePort(port);
        if (this.channelInitialiser == null) {
            throw new IOException("No channel initialiser set.");
        }
        this.stop();
        this.allChannels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE, true);
        try {
            this.serverChannel = this.bootstrap.bind(address, port).sync().channel();
            this.allChannels.add((Object)this.serverChannel);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while waiting for the server to start.", e);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw e;
            }
            throw new IOException(e);
        }
        return ((ServerSocketChannel)this.serverChannel).localAddress().getPort();
    }

    protected ChannelGroup getAllChannels() {
        return this.allChannels;
    }

    @Override
    public void stop() throws IOException {
        if (this.serverChannel == null) {
            return;
        }
        try {
            this.allChannels.close().sync();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while waiting for the server to stop.", e);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw e;
            }
            throw new IOException(e);
        }
        finally {
            this.serverChannel = null;
        }
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    private class ChannelInitializerImpl
    extends ChannelInitializer<SocketChannel> {
        private ChannelInitializerImpl() {
        }

        public void initChannel(SocketChannel ch) {
            ch.attr(ChannelAttributes.LOCAL_ADDRESS).set((Object)ch.localAddress());
            ch.attr(ChannelAttributes.REMOTE_ADDRESS).set((Object)ch.remoteAddress());
            ch.attr(ChannelAttributes.TLS_UPGRADED).set((Object)Boolean.FALSE);
            ch.attr(ChannelAttributes.PROCESSING_MESSAGE).set((Object)Boolean.FALSE);
            ch.attr(ChannelAttributes.RECURSIVE_MESSAGE).set((Object)Boolean.FALSE);
            ch.pipeline().addLast(new ChannelHandler[]{new ChannelGroupHandler(BaseServer.this.allChannels)});
            BaseServer.this.channelInitialiser.accept(ch);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            LOGGER.error("An error occurred while initializing the channel. Closing: {}", (Object)ctx.channel(), (Object)cause);
            ctx.close();
        }
    }
}

