/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.AppendableCharSequence;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.parosproxy.paros.network.HttpBody;
import org.parosproxy.paros.network.HttpHeader;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.parosproxy.paros.network.HttpStatusCode;

public abstract class HttpMessageDecoder
extends ByteToMessageDecoder {
    private static final HttpMalformedHeaderException MISSING_FULL_BODY = new HttpMalformedHeaderException("Connection closed before receiving full body.");
    private static final Exception MISSING_FULL_HEADER = new HttpMalformedHeaderException("Connection closed before receiving full header.");
    private static final int DEFAULT_INITIAL_BUFFER_SIZE = 128;
    private static final byte LF = 10;
    private static final byte CR = 13;
    static final int MAX_CHUNK_SIZE = 80;
    private final HeaderParser headerParser;
    private final LineParser lineParser;
    private final boolean decodingRequest;
    private final HeaderProvider headerProvider;
    private final Function<HttpMessage, HttpBody> bodyProvider;
    private HttpMessage message;
    private HttpHeader header;
    private HttpBody body;
    private byte[] chunkBuffer;
    private long chunkSize;
    private State currentState = State.READ_HEADER;

    protected HttpMessageDecoder(boolean decodingRequest, HeaderProvider headerProvider, Function<HttpMessage, HttpBody> bodyProvider) {
        AppendableCharSequence seq = new AppendableCharSequence(128);
        this.headerParser = new HeaderParser(seq);
        this.lineParser = new LineParser(seq);
        this.decodingRequest = decodingRequest;
        this.headerProvider = headerProvider;
        this.bodyProvider = bodyProvider;
        this.chunkBuffer = new byte[80];
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        switch (this.currentState) {
            case READ_HEADER: {
                AppendableCharSequence headerContent = this.headerParser.parse(buffer);
                if (headerContent == null) {
                    return;
                }
                this.headerParser.reset();
                try {
                    this.message = new HttpMessage();
                    this.header = this.headerProvider.get(ctx, this.message, headerContent.toString());
                    this.body = this.bodyProvider.apply(this.message);
                    this.body.setLength(0);
                    HttpMessage.setContentEncodings((HttpHeader)this.header, (HttpBody)this.body);
                    this.currentState = State.HANDLE_CONTENT;
                }
                catch (Exception e) {
                    out.add(this.invalidMessage(buffer, e));
                    return;
                }
            }
            case HANDLE_CONTENT: {
                if (this.isContentAlwaysEmpty(this.message)) {
                    out.add(this.message);
                    this.resetNow();
                    return;
                }
                if (this.isTransferEncodingChunked()) {
                    this.currentState = State.READ_CHUNK_SIZE;
                    return;
                }
                int contentLength = this.header.getContentLength();
                if (contentLength == 0) {
                    out.add(this.message);
                    this.resetNow();
                    return;
                }
                State state = this.currentState = contentLength > 0 ? State.READ_FIXED_LENGTH_CONTENT : State.READ_VARIABLE_LENGTH_CONTENT;
                if (this.currentState == State.READ_FIXED_LENGTH_CONTENT) {
                    this.chunkSize = contentLength;
                }
                return;
            }
            case READ_VARIABLE_LENGTH_CONTENT: {
                int toRead = Math.min(buffer.readableBytes(), 80);
                if (toRead > 0) {
                    this.appendToBody(buffer, toRead);
                }
                return;
            }
            case READ_FIXED_LENGTH_CONTENT: {
                int toRead = Math.min(buffer.readableBytes(), 80);
                if ((long)toRead > this.chunkSize) {
                    toRead = (int)this.chunkSize;
                }
                this.chunkSize -= (long)toRead;
                this.appendToBody(buffer, toRead);
                if (this.chunkSize == 0L) {
                    out.add(this.message);
                    this.resetNow();
                }
                return;
            }
            case READ_CHUNK_SIZE: {
                try {
                    AppendableCharSequence line = this.lineParser.parse(buffer);
                    if (line == null) {
                        return;
                    }
                    int chunkSize = HttpMessageDecoder.getChunkSize(line.toString());
                    if (chunkSize < 0) {
                        throw new NumberFormatException("Invalid chunk size: " + chunkSize);
                    }
                    this.chunkSize = chunkSize;
                    if (chunkSize == 0) {
                        this.currentState = State.READ_CHUNK_FOOTER;
                        return;
                    }
                    this.currentState = State.READ_CHUNKED_CONTENT;
                }
                catch (Exception e) {
                    out.add(this.invalidMessage(buffer, e));
                    return;
                }
            }
            case READ_CHUNKED_CONTENT: {
                int toRead = Math.min((int)this.chunkSize, 80);
                toRead = Math.min(toRead, buffer.readableBytes());
                if (toRead == 0) {
                    return;
                }
                this.chunkSize -= (long)toRead;
                this.appendToBody(buffer, toRead);
                if (this.chunkSize != 0L) {
                    return;
                }
                this.currentState = State.READ_CHUNK_DELIMITER;
            }
            case READ_CHUNK_DELIMITER: {
                int wIdx = buffer.writerIndex();
                int rIdx = buffer.readerIndex();
                while (wIdx > rIdx) {
                    byte next;
                    if ((next = buffer.getByte(rIdx++)) != 10) continue;
                    this.currentState = State.READ_CHUNK_SIZE;
                    break;
                }
                buffer.readerIndex(rIdx);
                return;
            }
            case READ_CHUNK_FOOTER: {
                try {
                    boolean done = this.readTrailingHeaders(buffer);
                    if (!done) {
                        return;
                    }
                    this.header.setHeader("Transfer-Encoding", null);
                    this.header.setContentLength(this.body.length());
                    out.add(this.message);
                    this.resetNow();
                    return;
                }
                catch (Exception e) {
                    out.add(this.invalidMessage(buffer, e));
                    return;
                }
            }
            case BAD_MESSAGE: {
                buffer.skipBytes(buffer.readableBytes());
                break;
            }
            case UPGRADED: {
                int readableBytes = buffer.readableBytes();
                if (readableBytes <= 0) break;
                out.add(buffer.readBytes(readableBytes));
                break;
            }
        }
    }

    private void appendToBody(ByteBuf buffer, int length) {
        buffer.readBytes(this.chunkBuffer, 0, length);
        this.body.append(this.chunkBuffer, length);
    }

    private boolean isTransferEncodingChunked() {
        for (String transferEncoding : this.header.getHeaderValues("Transfer-Encoding")) {
            if (!StringUtils.containsIgnoreCase((CharSequence)transferEncoding, (CharSequence)"Chunked")) continue;
            return true;
        }
        return false;
    }

    protected void decodeLast(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        boolean prematureClosure;
        super.decodeLast(ctx, in, out);
        if (this.message == null) {
            if (this.headerParser.getSize() != 0) {
                out.add(this.invalidMessage(Unpooled.EMPTY_BUFFER, MISSING_FULL_HEADER));
            }
            this.resetNow();
            return;
        }
        boolean chunked = this.isTransferEncodingChunked();
        if (this.currentState == State.READ_VARIABLE_LENGTH_CONTENT && !in.isReadable() && !chunked) {
            out.add(this.message);
            this.resetNow();
            return;
        }
        if (this.decodingRequest || chunked) {
            prematureClosure = true;
        } else {
            boolean bl = prematureClosure = this.header.getContentLength() > 0;
        }
        if (prematureClosure) {
            this.message.setUserObject((Object)MISSING_FULL_BODY);
        }
        out.add(this.message);
        this.resetNow();
    }

    protected boolean isContentAlwaysEmpty(HttpMessage msg) {
        if (this.decodingRequest) {
            return false;
        }
        int code = msg.getResponseHeader().getStatusCode();
        return HttpStatusCode.isInformational((int)code) || code == 204 || code == 304;
    }

    private void resetNow() {
        this.message = null;
        HttpHeader header = this.header;
        this.header = null;
        this.body = null;
        this.headerParser.reset();
        this.lineParser.reset();
        if (!this.decodingRequest && header != null && HttpMessageDecoder.isSwitchingToNonHttp1Protocol((HttpResponseHeader)header)) {
            this.currentState = State.UPGRADED;
            return;
        }
        this.currentState = State.READ_HEADER;
    }

    private static boolean isSwitchingToNonHttp1Protocol(HttpResponseHeader header) {
        if (header.getStatusCode() != 101) {
            return false;
        }
        String newProtocol = header.getHeader("Upgrade");
        return newProtocol != null && !newProtocol.contains("HTTP/1.0") && !newProtocol.contains("HTTP/1.1");
    }

    private HttpMessage invalidMessage(ByteBuf in, Exception cause) {
        this.currentState = State.BAD_MESSAGE;
        in.skipBytes(in.readableBytes());
        if (this.message == null) {
            this.message = new HttpMessage();
        }
        this.message.setUserObject((Object)cause);
        HttpMessage ret = this.message;
        this.message = null;
        return ret;
    }

    private boolean readTrailingHeaders(ByteBuf buffer) throws HttpMalformedHeaderException {
        AppendableCharSequence line = this.lineParser.parse(buffer);
        if (line == null) {
            return false;
        }
        if (line.length() == 0) {
            return true;
        }
        int pos = -1;
        while (line.length() > 0) {
            String headerField = line.toString();
            pos = headerField.indexOf(58);
            if (pos < 0) {
                throw new HttpMalformedHeaderException("Missing name/value separator in header field: " + headerField);
            }
            String name = headerField.substring(0, pos).trim();
            String value = headerField.substring(pos + 1).trim();
            this.header.addHeader(name, value);
            line = this.lineParser.parse(buffer);
            if (line != null) continue;
            return false;
        }
        return true;
    }

    private static int getChunkSize(String hex) {
        hex = hex.trim();
        for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            if (c != ';' && !Character.isWhitespace(c) && !Character.isISOControl(c)) continue;
            hex = hex.substring(0, i);
            break;
        }
        return Integer.parseInt(hex, 16);
    }

    protected static interface HeaderProvider {
        public HttpHeader get(ChannelHandlerContext var1, HttpMessage var2, String var3) throws HttpMalformedHeaderException;
    }

    private static class LineParser
    extends HeaderParser {
        LineParser(AppendableCharSequence seq) {
            super(seq);
        }

        @Override
        public boolean process(byte value) throws Exception {
            char nextByte = (char)(value & 0xFF);
            if (nextByte == '\n') {
                int len = this.seq.length();
                if (len >= 1 && this.seq.charAtUnsafe(len - 1) == '\r') {
                    this.seq.setLength(len - 1);
                }
                return false;
            }
            this.seq.append(nextByte);
            return true;
        }
    }

    private static class HeaderParser
    implements ByteProcessor {
        protected final AppendableCharSequence seq;
        private int size;

        HeaderParser(AppendableCharSequence seq) {
            this.seq = seq;
        }

        public AppendableCharSequence parse(ByteBuf buffer) {
            this.seq.reset();
            int i = buffer.forEachByte((ByteProcessor)this);
            if (i == -1) {
                return null;
            }
            buffer.readerIndex(i + 1);
            return this.seq;
        }

        public int getSize() {
            return this.size;
        }

        public void reset() {
            this.size = 0;
        }

        public boolean process(byte value) throws Exception {
            char currentByte = (char)(value & 0xFF);
            boolean headerEnd = this.isHeaderEnd(currentByte);
            this.seq.append(currentByte);
            ++this.size;
            return !headerEnd;
        }

        private boolean isHeaderEnd(char currentByte) {
            if (currentByte != '\n') {
                return false;
            }
            int len = this.seq.length();
            if (len < 1) {
                return false;
            }
            char lastChar = this.seq.charAtUnsafe(len - 1);
            if (lastChar == '\n') {
                return true;
            }
            if (lastChar != '\r' || len < 2) {
                return false;
            }
            char previousChar = this.seq.charAtUnsafe(len - 2);
            return previousChar == '\n';
        }
    }

    private static enum State {
        READ_HEADER,
        HANDLE_CONTENT,
        READ_VARIABLE_LENGTH_CONTENT,
        READ_FIXED_LENGTH_CONTENT,
        READ_CHUNK_SIZE,
        READ_CHUNKED_CONTENT,
        READ_CHUNK_DELIMITER,
        READ_CHUNK_FOOTER,
        BAD_MESSAGE,
        UPGRADED;

    }
}

