/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal.cert;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Duration;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.MiscPEMGenerator;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.parosproxy.paros.security.CertData;
import org.zaproxy.addon.network.internal.cert.CertConfig;
import org.zaproxy.addon.network.internal.cert.GenerationException;

public final class CertificateUtils {
    public static final String BEGIN_CERTIFICATE_TOKEN = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERTIFICATE_TOKEN = "-----END CERTIFICATE-----";
    public static final String BEGIN_PRIVATE_KEY_TOKEN = "-----BEGIN PRIVATE KEY-----";
    public static final String END_PRIVATE_KEY_TOKEN = "-----END PRIVATE KEY-----";
    private static final Logger LOGGER;
    private static final char[] PASSPHRASE;
    private static final String ZAPROXY_JKS_ALIAS = "owasp_zap_root_ca";
    private static final Duration SERVER_CERTIFICATE_START_ADJUSTMENT;

    private CertificateUtils() {
    }

    public static KeyStore createRootCaKeyStore(CertConfig config) {
        try {
            return CertificateUtils.createRootCaKeyStoreImpl(config);
        }
        catch (Exception e) {
            throw new GenerationException("An error occurred while generating the root CA certificate:", e);
        }
    }

    private static KeyStore createRootCaKeyStoreImpl(CertConfig config) throws Exception {
        Date startDate = Calendar.getInstance().getTime();
        Date expireDate = new Date(startDate.getTime() + config.getValidity().toMillis());
        KeyPair keyPair = CertificateUtils.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        X500NameBuilder nameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        nameBuilder.addRDN(BCStyle.CN, "OWASP Zed Attack Proxy Root CA");
        nameBuilder.addRDN(BCStyle.L, Integer.toHexString(System.getProperty("user.name").hashCode()) + Integer.toHexString(System.getProperty("user.home").hashCode()));
        nameBuilder.addRDN(BCStyle.O, "OWASP Root CA");
        nameBuilder.addRDN(BCStyle.OU, "OWASP ZAP Root CA");
        nameBuilder.addRDN(BCStyle.C, "xx");
        X500Name name = nameBuilder.build();
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(name, BigInteger.valueOf(new Random().nextInt()), startDate, expireDate, name, publicKey);
        try {
            certBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)new SubjectKeyIdentifier(publicKey.getEncoded()));
            certBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
            certBuilder.addExtension(Extension.keyUsage, false, (ASN1Encodable)new KeyUsage(182));
            KeyPurposeId[] eku = new KeyPurposeId[]{KeyPurposeId.id_kp_serverAuth, KeyPurposeId.id_kp_clientAuth, KeyPurposeId.anyExtendedKeyUsage};
            certBuilder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(eku));
            X509Certificate certificate = CertificateUtils.createCertificate(privateKey, (X509v3CertificateBuilder)certBuilder);
            return CertificateUtils.createKeyStore(privateKey, certificate);
        }
        catch (Exception e) {
            throw new GenerationException("Errors during assembling root CA.", e);
        }
    }

    private static X509Certificate createCertificate(PrivateKey privateKey, X509v3CertificateBuilder certificateBuilder) throws OperatorCreationException, CertificateException {
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider("BC").build(privateKey);
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateBuilder.build(contentSigner));
    }

    public static KeyStore createServerKeyStore(X509Certificate rootCaCert, PublicKey rootCaPublicKey, PrivateKey rootCaPrivateKey, CertData certData, long serial, CertConfig config) {
        try {
            return CertificateUtils.createServerCertificateImpl(rootCaCert, rootCaPublicKey, rootCaPrivateKey, certData, serial, config);
        }
        catch (Exception e) {
            throw new GenerationException("An error occurred while generating the server certificate:", e);
        }
    }

    private static KeyStore createServerCertificateImpl(X509Certificate rootCaCert, PublicKey rootCaPublicKey, PrivateKey rootCaPrivateKey, CertData certData, long serial, CertConfig config) throws Exception {
        CertData.Name[] certDataNames = certData.getSubjectAlternativeNames();
        GeneralName[] subjectAlternativeNames = new GeneralName[certDataNames.length];
        for (int i = 0; i < certDataNames.length; ++i) {
            CertData.Name certDataName = certDataNames[i];
            subjectAlternativeNames[i] = new GeneralName(certDataName.getType(), certDataName.getValue());
        }
        if (certData.getCommonName() == null && subjectAlternativeNames.length == 0) {
            throw new IllegalArgumentException("commonName is null and no subjectAlternativeNames are specified");
        }
        KeyPair keyPair = CertificateUtils.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        X500NameBuilder namebld = new X500NameBuilder(BCStyle.INSTANCE);
        if (certData.getCommonName() != null) {
            namebld.addRDN(BCStyle.CN, certData.getCommonName());
        }
        namebld.addRDN(BCStyle.OU, "Zed Attack Proxy Project");
        namebld.addRDN(BCStyle.O, "OWASP");
        namebld.addRDN(BCStyle.C, "xx");
        namebld.addRDN(BCStyle.EmailAddress, "zaproxy-develop@googlegroups.com");
        Duration validity = config.getValidity().minus(SERVER_CERTIFICATE_START_ADJUSTMENT);
        long currentTime = System.currentTimeMillis();
        JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(new X509CertificateHolder(rootCaCert.getEncoded()).getSubject(), BigInteger.valueOf(serial), new Date(currentTime - SERVER_CERTIFICATE_START_ADJUSTMENT.toMillis()), new Date(currentTime + validity.toMillis()), namebld.build(), publicKey);
        certGen.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)new SubjectKeyIdentifier(publicKey.getEncoded()));
        certGen.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false));
        certGen.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(new KeyPurposeId[]{KeyPurposeId.id_kp_serverAuth}));
        if (subjectAlternativeNames.length > 0) {
            certGen.addExtension(Extension.subjectAlternativeName, certData.isSubjectAlternativeNameIsCritical(), (ASN1Encodable)new GeneralNames(subjectAlternativeNames));
        }
        X509Certificate certificate = CertificateUtils.createCertificate(rootCaPrivateKey, (X509v3CertificateBuilder)certGen);
        certificate.checkValidity(new Date());
        certificate.verify(rootCaPublicKey);
        return CertificateUtils.createKeyStore(privateKey, certificate, rootCaCert);
    }

    private static KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(Long.toString(System.currentTimeMillis()).getBytes());
        KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance("RSA");
        keyGenerator.initialize(2048, random);
        return keyGenerator.generateKeyPair();
    }

    private static KeyStore createKeyStore(PrivateKey privateKey, Certificate ... certificate) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null);
        keyStore.setKeyEntry(ZAPROXY_JKS_ALIAS, privateKey, PASSPHRASE, certificate);
        return keyStore;
    }

    public static String keyStoreToString(KeyStore keyStore) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            keyStore.store(baos, PASSPHRASE);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return Base64.getUrlEncoder().encodeToString(baos.toByteArray());
    }

    public static KeyStore stringToKeystore(String str) throws IOException {
        if (str == null || str.isEmpty()) {
            return null;
        }
        try {
            byte[] bytes = Base64.getUrlDecoder().decode(str);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(new ByteArrayInputStream(bytes), PASSPHRASE);
            return keyStore;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static byte[] extractCertificate(String pem) {
        return CertificateUtils.parseDerFromPem(pem, BEGIN_CERTIFICATE_TOKEN, END_CERTIFICATE_TOKEN);
    }

    private static byte[] parseDerFromPem(String pem, String beginDelimiter, String endDelimiter) {
        if (!CertificateUtils.containsSection(pem, beginDelimiter, endDelimiter)) {
            return new byte[0];
        }
        String[] tokens = pem.split(beginDelimiter);
        tokens = tokens[1].split(endDelimiter);
        return Base64.getMimeDecoder().decode(tokens[0]);
    }

    public static byte[] extractPrivateKey(String pem) {
        return CertificateUtils.parseDerFromPem(pem, BEGIN_PRIVATE_KEY_TOKEN, END_PRIVATE_KEY_TOKEN);
    }

    private static boolean containsSection(String contents, String beginToken, String endToken) {
        int idxToken = contents.indexOf(beginToken);
        return idxToken != -1 && contents.indexOf(endToken) >= idxToken;
    }

    public static KeyStore pemToKeyStore(byte[] certBytes, byte[] keyBytes) throws IOException, GeneralSecurityException {
        X509Certificate certificate = CertificateUtils.generateCertificateFromDer(certBytes);
        RSAPrivateKey privateKey = CertificateUtils.generatePrivateKeyFromDer(keyBytes);
        return CertificateUtils.createKeyStore(privateKey, certificate);
    }

    private static RSAPrivateKey generatePrivateKeyFromDer(byte[] keyBytes) throws InvalidKeySpecException, NoSuchAlgorithmException {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return (RSAPrivateKey)factory.generatePrivate(spec);
    }

    private static X509Certificate generateCertificateFromDer(byte[] certBytes) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certBytes));
    }

    public static String keyStoreToCertificatePem(KeyStore keyStore) {
        StringWriter writer = new StringWriter();
        CertificateUtils.writeCertAsPem(keyStore, writer);
        return writer.toString();
    }

    private static void writeCertAsPem(KeyStore keyStore, Writer writer) {
        if (keyStore == null) {
            return;
        }
        X509Certificate cert = CertificateUtils.getCertificate(keyStore);
        if (cert == null) {
            return;
        }
        try (PemWriter pw = new PemWriter(writer);){
            pw.writeObject((PemObjectGenerator)new JcaMiscPEMGenerator((Object)cert));
            pw.flush();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while converting root CA certificate to PEM:", (Throwable)e);
        }
    }

    public static X509Certificate getCertificate(KeyStore keyStore) {
        if (keyStore == null) {
            return null;
        }
        try {
            return (X509Certificate)keyStore.getCertificate(ZAPROXY_JKS_ALIAS);
        }
        catch (KeyStoreException e) {
            LOGGER.error("An error occurred while getting the certificate from the KeyStore:", (Throwable)e);
            return null;
        }
    }

    public static void keyStoreToCertificatePem(KeyStore keyStore, Path file) {
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.US_ASCII, new OpenOption[0]);){
            CertificateUtils.writeCertAsPem(keyStore, writer);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while creating the writer:", (Throwable)e);
        }
    }

    public static void keyStoreToCertificateAndPrivateKeyPem(KeyStore keyStore, Path file) {
        CertificateUtils.keyStoreToCertificatePem(keyStore, file);
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.US_ASCII, StandardOpenOption.APPEND);
             PemWriter pw = new PemWriter((Writer)writer);){
            byte[] privateKeyEncoded = CertificateUtils.getPrivateKey(keyStore).getEncoded();
            pw.writeObject((PemObjectGenerator)new MiscPEMGenerator((Object)new PemObject("PRIVATE KEY", privateKeyEncoded)));
            pw.flush();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while writing the private key:", (Throwable)e);
        }
    }

    public static PrivateKey getPrivateKey(KeyStore keyStore) {
        if (keyStore == null) {
            return null;
        }
        try {
            return (PrivateKey)keyStore.getKey(ZAPROXY_JKS_ALIAS, PASSPHRASE);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while creating the writer:", (Throwable)e);
            return null;
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        LOGGER = LogManager.getLogger(CertificateUtils.class);
        PASSPHRASE = "0w45P.Z4p".toCharArray();
        SERVER_CERTIFICATE_START_ADJUSTMENT = Duration.ofDays(30L);
    }
}

